/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPartInternal;
import org.jooq.RenderContext;
import org.jooq.Row;
import org.jooq.RowN;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;

class RowSubqueryCondition
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private final Row left;
    private final Select<?> right;
    private final Comparator comparator;

    RowSubqueryCondition(Row left, Select<?> right, Comparator comparator) {
        this.left = left;
        this.right = right;
        this.comparator = comparator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.delegate(ctx).accept(ctx);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.delegate(ctx).clauses(ctx);
    }

    private final QueryPartInternal delegate(Context<?> ctx) {
        Condition condition;
        Configuration configuration = ctx.configuration();
        RenderContext render = ctx instanceof RenderContext ? (RenderContext)ctx : null;
        SQLDialect family = configuration.dialect().family();
        if (Arrays.asList(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES).contains((Object)family)) {
            return new Native();
        }
        if (Arrays.asList(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES).contains((Object)family) && Arrays.asList(Comparator.EQUALS, Comparator.NOT_EQUALS).contains((Object)this.comparator)) {
            return new Native();
        }
        if (Arrays.asList(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES).contains((Object)family) && Arrays.asList(Comparator.IN, Comparator.NOT_IN).contains((Object)this.comparator)) {
            return new Native();
        }
        String table = render == null ? "t" : render.nextAlias();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.left.size(); ++i) {
            names.add(table + "_" + i);
        }
        Field[] fields = new Field[names.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = DSL.fieldByName(table, (String)names.get(i));
        }
        switch (this.comparator) {
            case GREATER: {
                condition = ((RowN)this.left).gt(DSL.row(fields));
                break;
            }
            case GREATER_OR_EQUAL: {
                condition = ((RowN)this.left).ge(DSL.row(fields));
                break;
            }
            case LESS: {
                condition = ((RowN)this.left).lt(DSL.row(fields));
                break;
            }
            case LESS_OR_EQUAL: {
                condition = ((RowN)this.left).le(DSL.row(fields));
                break;
            }
            default: {
                condition = ((RowN)this.left).eq(DSL.row(fields));
            }
        }
        SelectConditionStep subselect = DSL.select(new Field[0]).from(this.right.asTable(table, names.toArray(new String[0]))).where(condition);
        switch (this.comparator) {
            case NOT_IN: 
            case NOT_EQUALS: {
                return (QueryPartInternal)((Object)DSL.notExists(subselect));
            }
        }
        return (QueryPartInternal)((Object)DSL.exists(subselect));
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -1552476981094856727L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            boolean extraParentheses = Arrays.asList(new Object[0]).contains((Object)ctx.configuration().dialect().family());
            boolean subquery = ctx.subquery();
            ctx.visit(RowSubqueryCondition.this.left).sql(" ").keyword(RowSubqueryCondition.this.comparator.toSQL()).sql(" (").sql(extraParentheses ? "(" : "");
            ctx.data("org.jooq.configuration.row-value-expression-subquery", true);
            ctx.subquery(true).visit(RowSubqueryCondition.this.right).subquery(subquery);
            ctx.data("org.jooq.configuration.row-value-expression-subquery", null);
            ctx.sql(extraParentheses ? ")" : "").sql(")");
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return CLAUSES;
        }
    }
}

