/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jooq.AttachableInternal;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordHandler;
import org.jooq.RecordMapper;
import org.jooq.RecordType;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.Table;
import org.jooq.exception.InvalidResultException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.RowImpl;
import org.jooq.impl.Utils;
import org.jooq.tools.Convert;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.MockResultSet;
import org.jooq.tools.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ResultImpl<R extends Record>
implements Result<R>,
AttachableInternal {
    private static final long serialVersionUID = 6416154375799578362L;
    private Configuration configuration;
    private final Fields<R> fields;
    private final List<R> records;

    ResultImpl(Configuration configuration, Collection<? extends Field<?>> fields) {
        this(configuration, new Fields(fields));
    }

    ResultImpl(Configuration configuration, Field<?> ... fields) {
        this(configuration, new Fields(fields));
    }

    ResultImpl(Configuration configuration, Fields<R> fields) {
        this.configuration = configuration;
        this.fields = fields;
        this.records = new ArrayList<R>();
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
        for (Record record : this.records) {
            if (record == null) continue;
            record.attach(c);
        }
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final RecordType<R> recordType() {
        return this.fields;
    }

    @Override
    public final Row fieldsRow() {
        return new RowImpl(this.fields);
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.fields.field(field);
    }

    @Override
    public final Field<?> field(String name) {
        return this.fields.field(name);
    }

    @Override
    public final Field<?> field(int index) {
        return this.fields.field(index);
    }

    @Override
    public final Field<?>[] fields() {
        return (Field[])this.fields.fields().clone();
    }

    @Override
    public final boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public final boolean isNotEmpty() {
        return !this.records.isEmpty();
    }

    @Override
    public final <T> T getValue(int index, Field<T> field) {
        return this.get(index).getValue(field);
    }

    @Override
    @Deprecated
    public final <T> T getValue(int index, Field<T> field, T defaultValue) {
        return this.get(index).getValue(field, defaultValue);
    }

    @Override
    public final Object getValue(int index, int fieldIndex) {
        return this.get(index).getValue(fieldIndex);
    }

    @Override
    @Deprecated
    public final Object getValue(int index, int fieldIndex, Object defaultValue) {
        return this.get(index).getValue(fieldIndex, defaultValue);
    }

    @Override
    public final Object getValue(int index, String fieldName) {
        return this.get(index).getValue(fieldName);
    }

    @Override
    @Deprecated
    public final Object getValue(int index, String fieldName, Object defaultValue) {
        return this.get(index).getValue(fieldName, defaultValue);
    }

    @Override
    public final <T> List<T> getValues(Field<T> field) {
        return this.getValues(Utils.indexOrFail(this.fieldsRow(), field));
    }

    @Override
    public final <T> List<T> getValues(Field<?> field, Class<? extends T> type) {
        return Convert.convert(this.getValues(field), type);
    }

    @Override
    public final <T, U> List<U> getValues(Field<T> field, Converter<? super T, U> converter) {
        return Convert.convert(this.getValues(field), converter);
    }

    @Override
    public final List<?> getValues(int fieldIndex) {
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        for (Record record : this) {
            result.add(record.getValue(fieldIndex));
        }
        return result;
    }

    @Override
    public final <T> List<T> getValues(int fieldIndex, Class<? extends T> type) {
        return Convert.convert(this.getValues(fieldIndex), type);
    }

    @Override
    public final <U> List<U> getValues(int fieldIndex, Converter<?, U> converter) {
        return Convert.convert(this.getValues(fieldIndex), converter);
    }

    @Override
    public final List<?> getValues(String fieldName) {
        return this.getValues(this.field(fieldName));
    }

    @Override
    public final <T> List<T> getValues(String fieldName, Class<? extends T> type) {
        return Convert.convert(this.getValues(fieldName), type);
    }

    @Override
    public final <U> List<U> getValues(String fieldName, Converter<?, U> converter) {
        return Convert.convert(this.getValues(fieldName), converter);
    }

    final void addRecord(R record) {
        this.records.add(record);
    }

    @Override
    public final String format() {
        return this.format(50);
    }

    @Override
    public final String format(int maxRecords) {
        int index;
        String value;
        int COL_MIN_WIDTH = 4;
        int COL_MAX_WIDTH = 50;
        int NUM_COL_MAX_WIDTH = 100;
        int MAX_RECORDS = Math.min(50, maxRecords);
        int[] decimalPlaces = new int[this.fields.fields.length];
        int[] widths = new int[this.fields.fields.length];
        for (int index2 = 0; index2 < this.fields.fields.length; ++index2) {
            if (!Number.class.isAssignableFrom(this.fields.fields[index2].getType())) continue;
            ArrayList<Integer> decimalPlacesList = new ArrayList<Integer>();
            decimalPlacesList.add(0);
            for (int i = 0; i < Math.min(MAX_RECORDS, this.size()); ++i) {
                String value2 = ResultImpl.format0(this.getValue(i, index2), this.get(i).changed(index2));
                decimalPlacesList.add(ResultImpl.getDecimalPlaces(value2));
            }
            decimalPlaces[index2] = (Integer)Collections.max(decimalPlacesList);
        }
        for (int index3 = 0; index3 < this.fields.fields.length; ++index3) {
            boolean isNumCol = Number.class.isAssignableFrom(this.fields.fields[index3].getType());
            int colMaxWidth = isNumCol ? 100 : 50;
            ArrayList<Integer> widthList = new ArrayList<Integer>();
            widthList.add(Math.min(colMaxWidth, Math.max(4, this.fields.fields[index3].getName().length())));
            for (int i = 0; i < Math.min(MAX_RECORDS, this.size()); ++i) {
                value = ResultImpl.format0(this.getValue(i, index3), this.get(i).changed(index3));
                if (isNumCol) {
                    value = ResultImpl.alignNumberValue(decimalPlaces[index3], value);
                }
                widthList.add(Math.min(colMaxWidth, value.length()));
            }
            widths[index3] = (Integer)Collections.max(widthList);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        for (index = 0; index < this.fields.fields.length; ++index) {
            sb.append(StringUtils.rightPad("", widths[index], "-"));
            sb.append("+");
        }
        sb.append("\n|");
        for (index = 0; index < this.fields.fields.length; ++index) {
            String padded = Number.class.isAssignableFrom(this.fields.fields[index].getType()) ? StringUtils.leftPad(this.fields.fields[index].getName(), widths[index]) : StringUtils.rightPad(this.fields.fields[index].getName(), widths[index]);
            sb.append(StringUtils.abbreviate(padded, widths[index]));
            sb.append("|");
        }
        sb.append("\n+");
        for (index = 0; index < this.fields.fields.length; ++index) {
            sb.append(StringUtils.rightPad("", widths[index], "-"));
            sb.append("+");
        }
        for (int i = 0; i < Math.min(maxRecords, this.size()); ++i) {
            sb.append("\n|");
            for (int index4 = 0; index4 < this.fields.fields.length; ++index4) {
                String padded;
                value = ResultImpl.format0(this.getValue(i, index4), this.get(i).changed(index4)).replace("\n", "{lf}").replace("\r", "{cr}");
                if (Number.class.isAssignableFrom(this.fields.fields[index4].getType())) {
                    value = ResultImpl.alignNumberValue(decimalPlaces[index4], value);
                    padded = StringUtils.leftPad(value, widths[index4]);
                } else {
                    padded = StringUtils.rightPad(value, widths[index4]);
                }
                sb.append(StringUtils.abbreviate(padded, widths[index4]));
                sb.append("|");
            }
        }
        if (this.size() > 0) {
            sb.append("\n+");
            for (index = 0; index < this.fields.fields.length; ++index) {
                sb.append(StringUtils.rightPad("", widths[index], "-"));
                sb.append("+");
            }
        }
        if (maxRecords < this.size()) {
            sb.append("\n|...");
            sb.append(this.size() - maxRecords);
            sb.append(" record(s) truncated...");
        }
        return sb.toString();
    }

    private static final String alignNumberValue(Integer columnDecimalPlaces, String value) {
        if (!"{null}".equals(value) && columnDecimalPlaces != 0) {
            int decimalPlaces = ResultImpl.getDecimalPlaces(value);
            int rightPadSize = value.length() + columnDecimalPlaces - decimalPlaces;
            value = decimalPlaces == 0 ? StringUtils.rightPad(value, rightPadSize + 1) : StringUtils.rightPad(value, rightPadSize);
        }
        return value;
    }

    private static final int getDecimalPlaces(String value) {
        int decimalPlaces = 0;
        int dotIndex = value.indexOf(".");
        if (dotIndex != -1) {
            decimalPlaces = value.length() - dotIndex - 1;
        }
        return decimalPlaces;
    }

    @Override
    public final String formatHTML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>");
        sb.append("<thead>");
        sb.append("<tr>");
        for (Field<?> field : this.fields.fields) {
            sb.append("<th>");
            sb.append(field.getName());
            sb.append("</th>");
        }
        sb.append("</tr>");
        sb.append("</thead>");
        sb.append("<tbody>");
        for (Record record : this) {
            sb.append("<tr>");
            for (int index = 0; index < this.fields.fields.length; ++index) {
                sb.append("<td>");
                sb.append(ResultImpl.format0(record.getValue(index), false));
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</tbody>");
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    public final String formatCSV() {
        return this.formatCSV(',', "");
    }

    @Override
    public final String formatCSV(char delimiter) {
        return this.formatCSV(delimiter, "");
    }

    @Override
    public final String formatCSV(char delimiter, String nullString) {
        StringBuilder sb = new StringBuilder();
        String sep1 = "";
        for (Field<?> field : this.fields.fields) {
            sb.append(sep1);
            sb.append(this.formatCSV0(field.getName(), ""));
            sep1 = Character.toString(delimiter);
        }
        sb.append("\n");
        for (Record record : this) {
            String sep2 = "";
            for (int index = 0; index < this.fields.fields.length; ++index) {
                sb.append(sep2);
                sb.append(this.formatCSV0(record.getValue(index), nullString));
                sep2 = Character.toString(delimiter);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private final String formatCSV0(Object value, String nullString) {
        if (value == null || "".equals(value)) {
            if (StringUtils.isEmpty(nullString)) {
                return "\"\"";
            }
            return nullString;
        }
        String result = ResultImpl.format0(value, false);
        if (StringUtils.containsAny(result, ',', ';', '\t', '\"', '\n', '\r', '\'', '\\')) {
            return "\"" + result.replace("\\", "\\\\").replace("\"", "\"\"") + "\"";
        }
        return result;
    }

    private static final String format0(Object value, boolean changed) {
        String formatted;
        String string = formatted = changed ? "*" : "";
        formatted = value == null ? formatted + "{null}" : (value.getClass() == byte[].class ? formatted + Arrays.toString((byte[])value) : (value.getClass().isArray() ? formatted + Arrays.toString((Object[])value) : (value instanceof EnumType ? formatted + ((EnumType)value).getLiteral() : formatted + value.toString())));
        return formatted;
    }

    @Override
    public final String formatJSON() {
        ArrayList f = new ArrayList();
        ArrayList r = new ArrayList();
        for (Field<?> field : this.fields.fields) {
            LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
            fieldMap.put("name", field.getName());
            fieldMap.put("type", field.getDataType().getTypeName().toUpperCase());
            f.add(fieldMap);
        }
        for (Record record : this) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int index = 0; index < this.fields.fields.length; ++index) {
                list.add(record.getValue(index));
            }
            r.add(list);
        }
        LinkedHashMap<String, ArrayList<Cloneable>> map = new LinkedHashMap<String, ArrayList<Cloneable>>();
        map.put("fields", f);
        map.put("records", r);
        return JSONObject.toJSONString(map);
    }

    @Override
    public final String formatXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<result xmlns=\"http://www.jooq.org/xsd/jooq-export-2.6.0.xsd\">");
        sb.append("<fields>");
        for (Field<?> field : this.fields.fields) {
            sb.append("<field name=\"");
            sb.append(this.escapeXML(field.getName()));
            sb.append("\" ");
            sb.append("type=\"");
            sb.append(field.getDataType().getTypeName().toUpperCase());
            sb.append("\"/>");
        }
        sb.append("</fields>");
        sb.append("<records>");
        for (Record record : this) {
            sb.append("<record>");
            for (int index = 0; index < this.fields.fields.length; ++index) {
                Object value = record.getValue(index);
                sb.append("<value field=\"");
                sb.append(this.escapeXML(this.fields.fields[index].getName()));
                sb.append("\"");
                if (value == null) {
                    sb.append("/>");
                    continue;
                }
                sb.append(">");
                sb.append(this.escapeXML(ResultImpl.format0(value, false)));
                sb.append("</value>");
            }
            sb.append("</record>");
        }
        sb.append("</records>");
        sb.append("</result>");
        return sb.toString();
    }

    @Override
    public final Document intoXML() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element eResult = document.createElement("result");
            eResult.setAttribute("xmlns", "http://www.jooq.org/xsd/jooq-export-2.6.0.xsd");
            document.appendChild(eResult);
            Element eFields = document.createElement("fields");
            eResult.appendChild(eFields);
            for (Field<?> field : this.fields.fields) {
                Element eField = document.createElement("field");
                eField.setAttribute("name", field.getName());
                eField.setAttribute("type", field.getDataType().getTypeName().toUpperCase());
                eFields.appendChild(eField);
            }
            Element eRecords = document.createElement("records");
            eResult.appendChild(eRecords);
            for (Record record : this) {
                Element eRecord = document.createElement("record");
                eRecords.appendChild(eRecord);
                for (int index = 0; index < this.fields.fields.length; ++index) {
                    Field<?> field = this.fields.fields[index];
                    Object value = record.getValue(index);
                    Element eValue = document.createElement("value");
                    eValue.setAttribute("field", field.getName());
                    eRecord.appendChild(eValue);
                    if (value == null) continue;
                    eValue.setTextContent(ResultImpl.format0(value, false));
                }
            }
            return document;
        }
        catch (ParserConfigurationException ignore) {
            throw new RuntimeException(ignore);
        }
    }

    @Override
    public final <H extends ContentHandler> H intoXML(H handler) throws SAXException {
        AttributesImpl empty = new AttributesImpl();
        handler.startDocument();
        handler.startPrefixMapping("", "http://www.jooq.org/xsd/jooq-export-2.6.0.xsd");
        handler.startElement("", "", "result", empty);
        handler.startElement("", "", "fields", empty);
        for (Field<?> field : this.fields.fields) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "", "name", "CDATA", field.getName());
            attrs.addAttribute("", "", "type", "CDATA", field.getDataType().getTypeName().toUpperCase());
            handler.startElement("", "", "field", attrs);
            handler.endElement("", "", "field");
        }
        handler.endElement("", "", "fields");
        handler.startElement("", "", "records", empty);
        for (Record record : this) {
            handler.startElement("", "", "record", empty);
            for (int index = 0; index < this.fields.fields.length; ++index) {
                Field<?> field;
                field = this.fields.fields[index];
                Object value = record.getValue(index);
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "", "field", "CDATA", field.getName());
                handler.startElement("", "", "value", attrs);
                if (value != null) {
                    char[] chars = ResultImpl.format0(value, false).toCharArray();
                    handler.characters(chars, 0, chars.length);
                }
                handler.endElement("", "", "value");
            }
            handler.endElement("", "", "record");
        }
        handler.endElement("", "", "records");
        handler.endPrefixMapping("");
        handler.endDocument();
        return handler;
    }

    private final String escapeXML(String string) {
        return StringUtils.replaceEach(string, new String[]{"\"", "'", "<", ">", "&"}, new String[]{"&quot;", "&apos;", "&lt;", "&gt;", "&amp;"});
    }

    @Override
    public final List<Map<String, Object>> intoMaps() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Record record : this) {
            list.add(record.intoMap());
        }
        return list;
    }

    @Override
    public final <K> Map<K, R> intoMap(Field<K> key) {
        int index = Utils.indexOrFail(this.fieldsRow(), key);
        LinkedHashMap<Object, Record> map = new LinkedHashMap<Object, Record>();
        for (Record record : this) {
            if (map.put(record.getValue(index), record) == null) continue;
            throw new InvalidResultException("Key " + key + " is not unique in Result for " + this);
        }
        return map;
    }

    @Override
    public final <K, V> Map<K, V> intoMap(Field<K> key, Field<V> value) {
        int kIndex = Utils.indexOrFail(this.fieldsRow(), key);
        int vIndex = Utils.indexOrFail(this.fieldsRow(), value);
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (Record record : this) {
            if (map.put(record.getValue(kIndex), record.getValue(vIndex)) == null) continue;
            throw new InvalidResultException("Key " + key + " is not unique in Result for " + this);
        }
        return map;
    }

    @Override
    public final Map<Record, R> intoMap(Field<?>[] keys) {
        if (keys == null) {
            keys = new Field[]{};
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Record record : this) {
            RecordImpl key = new RecordImpl(keys);
            for (Field<?> field : keys) {
                Utils.copyValue(key, field, record, field);
            }
            if (map.put(key, record) == null) continue;
            throw new InvalidResultException("Key list " + Arrays.asList(keys) + " is not unique in Result for " + this);
        }
        return map;
    }

    @Override
    public final <E> Map<List<?>, E> intoMap(Field<?>[] keys, Class<? extends E> type) {
        return this.intoMap(keys, Utils.configuration(this).recordMapperProvider().provide(this.fields, type));
    }

    @Override
    public final <E> Map<List<?>, E> intoMap(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        if (keys == null) {
            keys = new Field[]{};
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Record record : this) {
            ArrayList keyValueList = new ArrayList();
            for (Field<?> key : keys) {
                keyValueList.add(record.getValue(key));
            }
            if (map.put(keyValueList, mapper.map(record)) == null) continue;
            throw new InvalidResultException("Key list " + keyValueList + " is not unique in Result for " + this);
        }
        return map;
    }

    @Override
    public final <K, E> Map<K, E> intoMap(Field<K> key, Class<? extends E> type) {
        return this.intoMap(key, Utils.configuration(this).recordMapperProvider().provide(this.fields, type));
    }

    @Override
    public final <K, E> Map<K, E> intoMap(Field<K> key, RecordMapper<? super R, E> mapper) {
        int index = Utils.indexOrFail(this.fieldsRow(), key);
        LinkedHashMap<Object, E> map = new LinkedHashMap<Object, E>();
        for (Record record : this) {
            if (map.put(record.getValue(index), mapper.map(record)) == null) continue;
            throw new InvalidResultException("Key " + key + " is not unique in Result for " + this);
        }
        return map;
    }

    @Override
    public final <K> Map<K, Result<R>> intoGroups(Field<K> key) {
        int index = Utils.indexOrFail(this.fieldsRow(), key);
        LinkedHashMap<Object, ResultImpl<R>> map = new LinkedHashMap<Object, ResultImpl<R>>();
        for (Record record : this) {
            Object val = record.getValue(index);
            ResultImpl<R> result = (ResultImpl<R>)map.get(val);
            if (result == null) {
                result = new ResultImpl<R>(this.configuration, this.fields);
                map.put(val, result);
            }
            result.add(record);
        }
        return map;
    }

    @Override
    public final <K, V> Map<K, List<V>> intoGroups(Field<K> key, Field<V> value) {
        int kIndex = Utils.indexOrFail(this.fieldsRow(), key);
        int vIndex = Utils.indexOrFail(this.fieldsRow(), value);
        LinkedHashMap<Object, ArrayList<Object>> map = new LinkedHashMap<Object, ArrayList<Object>>();
        for (Record record : this) {
            Object k = record.getValue(kIndex);
            Object v = record.getValue(vIndex);
            ArrayList<Object> result = (ArrayList<Object>)map.get(k);
            if (result == null) {
                result = new ArrayList<Object>();
                map.put(k, result);
            }
            result.add(v);
        }
        return map;
    }

    @Override
    public final Map<Record, Result<R>> intoGroups(Field<?>[] keys) {
        if (keys == null) {
            keys = new Field[]{};
        }
        LinkedHashMap<Record, Result<R>> map = new LinkedHashMap<Record, Result<R>>();
        for (Record record : this) {
            RecordImpl key = new RecordImpl(keys);
            for (Field<?> field : keys) {
                Utils.copyValue(key, field, record, field);
            }
            ResultImpl<R> result = (ResultImpl<R>)map.get(key);
            if (result == null) {
                result = new ResultImpl<R>(this.configuration(), this.fields);
                map.put(key, result);
            }
            result.add(record);
        }
        return map;
    }

    @Override
    public final <K, E> Map<K, List<E>> intoGroups(Field<K> key, Class<? extends E> type) {
        return this.intoGroups(key, Utils.configuration(this).recordMapperProvider().provide(this.fields, type));
    }

    @Override
    public final <K, E> Map<K, List<E>> intoGroups(Field<K> key, RecordMapper<? super R, E> mapper) {
        int index = Utils.indexOrFail(this.fieldsRow(), key);
        LinkedHashMap<Object, ArrayList<E>> map = new LinkedHashMap<Object, ArrayList<E>>();
        for (Record record : this) {
            Object keyVal = record.getValue(index);
            ArrayList<E> list = (ArrayList<E>)map.get(keyVal);
            if (list == null) {
                list = new ArrayList<E>();
                map.put(keyVal, list);
            }
            list.add(mapper.map(record));
        }
        return map;
    }

    @Override
    public final <E> Map<Record, List<E>> intoGroups(Field<?>[] keys, Class<? extends E> type) {
        return this.intoGroups(keys, Utils.configuration(this).recordMapperProvider().provide(this.fields, type));
    }

    @Override
    public final <E> Map<Record, List<E>> intoGroups(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        if (keys == null) {
            keys = new Field[]{};
        }
        LinkedHashMap<Record, List<E>> map = new LinkedHashMap<Record, List<E>>();
        for (Record record : this) {
            RecordImpl key = new RecordImpl(keys);
            for (Field<?> field : keys) {
                Utils.copyValue(key, field, record, field);
            }
            ArrayList<E> list = (ArrayList<E>)map.get(key);
            if (list == null) {
                list = new ArrayList<E>();
                map.put(key, list);
            }
            list.add(mapper.map(record));
        }
        return map;
    }

    @Override
    public final Object[][] intoArray() {
        int size = this.size();
        Object[][] array = new Object[size][];
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i).intoArray();
        }
        return array;
    }

    @Override
    public final Object[] intoArray(int fieldIndex) {
        Class<?> type = this.fields.fields[fieldIndex].getType();
        List<?> list = this.getValues(fieldIndex);
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    @Override
    public final <T> T[] intoArray(int fieldIndex, Class<? extends T> type) {
        return Convert.convertArray(this.intoArray(fieldIndex), type);
    }

    @Override
    public final <U> U[] intoArray(int fieldIndex, Converter<?, U> converter) {
        return Convert.convertArray(this.intoArray(fieldIndex), converter);
    }

    @Override
    public final Object[] intoArray(String fieldName) {
        Class<?> type = this.field(fieldName).getType();
        List<?> list = this.getValues(fieldName);
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    @Override
    public final <T> T[] intoArray(String fieldName, Class<? extends T> type) {
        return Convert.convertArray(this.intoArray(fieldName), type);
    }

    @Override
    public final <U> U[] intoArray(String fieldName, Converter<?, U> converter) {
        return Convert.convertArray(this.intoArray(fieldName), converter);
    }

    @Override
    public final <T> T[] intoArray(Field<T> field) {
        return this.getValues(field).toArray((Object[])Array.newInstance(field.getType(), 0));
    }

    @Override
    public final <T> T[] intoArray(Field<?> field, Class<? extends T> type) {
        return Convert.convertArray((Object[])this.intoArray(field), type);
    }

    @Override
    public final <T, U> U[] intoArray(Field<T> field, Converter<? super T, U> converter) {
        return Convert.convertArray((Object[])this.intoArray(field), converter);
    }

    @Override
    public final <E> List<E> into(Class<? extends E> type) {
        ArrayList<E> list = new ArrayList<E>(this.size());
        RecordMapper<Record, E> mapper = Utils.configuration(this).recordMapperProvider().provide(this.fields, type);
        for (Record record : this) {
            list.add(mapper.map(record));
        }
        return list;
    }

    @Override
    public final <Z extends Record> Result<Z> into(Table<Z> table) {
        ResultImpl<R> list = new ResultImpl<R>(this.configuration(), table.fields());
        for (Record record : this) {
            list.add(record.into(table));
        }
        return list;
    }

    @Override
    public final <H extends RecordHandler<? super R>> H into(H handler) {
        for (Record record : this) {
            handler.next((Record)record);
        }
        return handler;
    }

    @Override
    public final ResultSet intoResultSet() {
        return new MockResultSet(this);
    }

    @Override
    public final <E> List<E> map(RecordMapper<? super R, E> mapper) {
        ArrayList<E> result = new ArrayList<E>();
        for (Record record : this) {
            result.add(mapper.map(record));
        }
        return result;
    }

    @Override
    public final <T extends Comparable<? super T>> Result<R> sortAsc(Field<T> field) {
        return this.sortAsc(field, new NaturalComparator());
    }

    @Override
    public final Result<R> sortAsc(int fieldIndex) {
        return this.sortAsc(fieldIndex, new NaturalComparator());
    }

    @Override
    public final Result<R> sortAsc(String fieldName) {
        return this.sortAsc(fieldName, new NaturalComparator());
    }

    @Override
    public final <T> Result<R> sortAsc(Field<T> field, Comparator<? super T> comparator) {
        return this.sortAsc(Utils.indexOrFail(this.fieldsRow(), field), comparator);
    }

    @Override
    public final Result<R> sortAsc(int fieldIndex, Comparator<?> comparator) {
        return this.sortAsc(new RecordComparator(fieldIndex, comparator));
    }

    @Override
    public final Result<R> sortAsc(String fieldName, Comparator<?> comparator) {
        return this.sortAsc(Utils.indexOrFail(this.fieldsRow(), fieldName), comparator);
    }

    @Override
    public final Result<R> sortAsc(Comparator<? super R> comparator) {
        Collections.sort(this, comparator);
        return this;
    }

    @Override
    public final <T extends Comparable<? super T>> Result<R> sortDesc(Field<T> field) {
        return this.sortAsc(field, Collections.reverseOrder(new NaturalComparator()));
    }

    @Override
    public final Result<R> sortDesc(int fieldIndex) {
        return this.sortAsc(fieldIndex, Collections.reverseOrder(new NaturalComparator()));
    }

    @Override
    public final Result<R> sortDesc(String fieldName) {
        return this.sortAsc(fieldName, Collections.reverseOrder(new NaturalComparator()));
    }

    @Override
    public final <T> Result<R> sortDesc(Field<T> field, Comparator<? super T> comparator) {
        return this.sortAsc(field, Collections.reverseOrder(comparator));
    }

    @Override
    public final Result<R> sortDesc(int fieldIndex, Comparator<?> comparator) {
        return this.sortAsc(fieldIndex, Collections.reverseOrder(comparator));
    }

    @Override
    public final Result<R> sortDesc(String fieldName, Comparator<?> comparator) {
        return this.sortAsc(fieldName, Collections.reverseOrder(comparator));
    }

    @Override
    public final Result<R> sortDesc(Comparator<? super R> comparator) {
        return this.sortAsc(Collections.reverseOrder(comparator));
    }

    @Override
    public final Result<R> intern(Field<?> ... f) {
        return this.intern(this.fields.indexesOf(f));
    }

    @Override
    public final Result<R> intern(int ... fieldIndexes) {
        for (int fieldIndex : fieldIndexes) {
            if (this.fields.fields[fieldIndex].getType() != String.class) continue;
            for (Record record : this) {
                ((AbstractRecord)record).intern0(fieldIndex);
            }
        }
        return this;
    }

    @Override
    public final Result<R> intern(String ... fieldNames) {
        return this.intern(this.fields.indexesOf(fieldNames));
    }

    public String toString() {
        return this.format();
    }

    @Override
    public int hashCode() {
        return this.records.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResultImpl) {
            ResultImpl other = (ResultImpl)obj;
            return this.records.equals(other.records);
        }
        return false;
    }

    @Override
    public final int size() {
        return this.records.size();
    }

    @Override
    public final boolean contains(Object o) {
        return this.records.contains(o);
    }

    @Override
    public final Object[] toArray() {
        return this.records.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.records.toArray(a);
    }

    @Override
    public final boolean add(R e) {
        return this.records.add(e);
    }

    @Override
    public final boolean remove(Object o) {
        return this.records.remove(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.records.containsAll(c);
    }

    @Override
    public final boolean addAll(Collection<? extends R> c) {
        return this.records.addAll(c);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends R> c) {
        return this.records.addAll(index, c);
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.records.removeAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.records.retainAll(c);
    }

    @Override
    public final void clear() {
        this.records.clear();
    }

    @Override
    public final R get(int index) {
        return (R)((Record)this.records.get(index));
    }

    @Override
    public final R set(int index, R element) {
        return (R)((Record)this.records.set(index, element));
    }

    @Override
    public final void add(int index, R element) {
        this.records.add(index, element);
    }

    @Override
    public final R remove(int index) {
        return (R)((Record)this.records.remove(index));
    }

    @Override
    public final int indexOf(Object o) {
        return this.records.indexOf(o);
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.records.lastIndexOf(o);
    }

    @Override
    public final Iterator<R> iterator() {
        return this.records.iterator();
    }

    @Override
    public final ListIterator<R> listIterator() {
        return this.records.listIterator();
    }

    @Override
    public final ListIterator<R> listIterator(int index) {
        return this.records.listIterator(index);
    }

    @Override
    public final List<R> subList(int fromIndex, int toIndex) {
        return this.records.subList(fromIndex, toIndex);
    }

    private static class NaturalComparator<T extends Comparable<? super T>>
    implements Comparator<T> {
        private NaturalComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    private static class RecordComparator<T, R extends Record>
    implements Comparator<R> {
        private final Comparator<? super T> comparator;
        private final int fieldIndex;

        RecordComparator(int fieldIndex, Comparator<? super T> comparator) {
            this.fieldIndex = fieldIndex;
            this.comparator = comparator;
        }

        @Override
        public int compare(R record1, R record2) {
            return this.comparator.compare(record1.getValue(this.fieldIndex), record2.getValue(this.fieldIndex));
        }
    }
}

