/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.ExecuteType;
import org.jooq.Record;
import org.jooq.RecordListener;
import org.jooq.RecordListenerProvider;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.DefaultRecordContext;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.Utils;

class RecordDelegate<R extends Record> {
    private final Configuration configuration;
    private final R record;
    private final RecordLifecycleType type;

    RecordDelegate(Configuration configuration, R record) {
        this(configuration, record, RecordLifecycleType.LOAD);
    }

    RecordDelegate(Configuration configuration, R record, RecordLifecycleType type) {
        this.configuration = configuration;
        this.record = record;
        this.type = type;
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record) {
        return new RecordDelegate<R>(configuration, record);
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record, RecordLifecycleType type) {
        return new RecordDelegate<R>(configuration, record, type);
    }

    final <E extends Exception> R operate(RecordOperation<R, E> operation) throws E {
        Exception exception;
        DefaultRecordContext ctx;
        RecordListener[] listeners;
        block29: {
            RecordListenerProvider[] providers = null;
            listeners = null;
            ctx = null;
            exception = null;
            if (this.configuration != null && (providers = this.configuration.recordListenerProviders()) != null) {
                listeners = new RecordListener[providers.length];
                ctx = new DefaultRecordContext(this.configuration, this.executeType(), new Record[]{this.record});
                for (int i = 0; i < providers.length; ++i) {
                    listeners[i] = providers[i].provide();
                }
            }
            if (listeners != null) {
                block19: for (RecordListener listener : listeners) {
                    switch (this.type) {
                        case LOAD: {
                            listener.loadStart(ctx);
                            continue block19;
                        }
                        case REFRESH: {
                            listener.refreshStart(ctx);
                            continue block19;
                        }
                        case STORE: {
                            listener.storeStart(ctx);
                            continue block19;
                        }
                        case INSERT: {
                            listener.insertStart(ctx);
                            continue block19;
                        }
                        case UPDATE: {
                            listener.updateStart(ctx);
                            continue block19;
                        }
                        case DELETE: {
                            listener.deleteStart(ctx);
                            continue block19;
                        }
                        default: {
                            throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
                        }
                    }
                }
            }
            if (operation != null) {
                try {
                    operation.operate(this.record);
                }
                catch (Exception e) {
                    exception = e;
                    if (e instanceof ControlFlowSignal) break block29;
                    if (ctx != null) {
                        ctx.exception = e;
                    }
                    if (listeners == null) break block29;
                    RecordListener[] recordListenerArray = listeners;
                    int n = recordListenerArray.length;
                    for (int listener = 0; listener < n; ++listener) {
                        RecordListener listener2 = recordListenerArray[listener];
                        listener2.exception(ctx);
                    }
                }
            }
        }
        if (Utils.attachRecords(this.configuration)) {
            this.record.attach(this.configuration);
        }
        if (listeners != null) {
            block21: for (RecordListener listener : listeners) {
                switch (this.type) {
                    case LOAD: {
                        listener.loadEnd(ctx);
                        continue block21;
                    }
                    case REFRESH: {
                        listener.refreshEnd(ctx);
                        continue block21;
                    }
                    case STORE: {
                        listener.storeEnd(ctx);
                        continue block21;
                    }
                    case INSERT: {
                        listener.insertEnd(ctx);
                        continue block21;
                    }
                    case UPDATE: {
                        listener.updateEnd(ctx);
                        continue block21;
                    }
                    case DELETE: {
                        listener.deleteEnd(ctx);
                        continue block21;
                    }
                    default: {
                        throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return this.record;
    }

    private final ExecuteType executeType() {
        return this.type == RecordLifecycleType.LOAD || this.type == RecordLifecycleType.REFRESH ? ExecuteType.READ : ExecuteType.WRITE;
    }

    static enum RecordLifecycleType {
        LOAD,
        REFRESH,
        STORE,
        INSERT,
        UPDATE,
        DELETE;

    }
}

