/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.Savepoint;
import java.util.Stack;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.TransactionContext;
import org.jooq.TransactionProvider;
import org.jooq.impl.DefaultConnectionProvider;

public class DefaultTransactionProvider
implements TransactionProvider {
    private final ConnectionProvider provider;
    private Connection connection;

    public DefaultTransactionProvider(ConnectionProvider provider) {
        this.provider = provider;
    }

    private final Stack<Savepoint> savepoints(Configuration configuration) {
        Stack savepoints = (Stack)configuration.data("org.jooq.configuration.default-transaction-provider-savepoints");
        if (savepoints == null) {
            savepoints = new Stack();
            configuration.data("org.jooq.configuration.default-transaction-provider-savepoints", savepoints);
        }
        return savepoints;
    }

    private final boolean autoCommit(Configuration configuration) {
        Boolean autoCommit = (Boolean)configuration.data("org.jooq.configuration.default-transaction-provider-autocommit");
        if (autoCommit == null) {
            autoCommit = this.connection(configuration).getAutoCommit();
            configuration.data("org.jooq.configuration.default-transaction-provider-autocommit", autoCommit);
        }
        return autoCommit;
    }

    private final DefaultConnectionProvider connection(Configuration configuration) {
        DefaultConnectionProvider connectionWrapper = (DefaultConnectionProvider)configuration.data("org.jooq.configuration.default-transaction-provider-connection-provider");
        if (connectionWrapper == null) {
            connectionWrapper = new DefaultConnectionProvider(this.connection);
            configuration.data("org.jooq.configuration.default-transaction-provider-connection-provider", connectionWrapper);
        }
        return connectionWrapper;
    }

    @Override
    public final void begin(TransactionContext ctx) {
        Stack<Savepoint> savepoints = this.savepoints(ctx.configuration());
        if (savepoints.isEmpty()) {
            this.brace(ctx.configuration(), true);
        }
        savepoints.push(this.connection(ctx.configuration()).setSavepoint());
    }

    @Override
    public final void commit(TransactionContext ctx) {
        Stack<Savepoint> savepoints = this.savepoints(ctx.configuration());
        Savepoint savepoint = savepoints.pop();
        if (savepoint != null) {
            this.connection(ctx.configuration()).releaseSavepoint(savepoint);
        }
        if (savepoints.isEmpty()) {
            this.connection(ctx.configuration()).commit();
            this.brace(ctx.configuration(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback(TransactionContext ctx) {
        Stack<Savepoint> savepoints = this.savepoints(ctx.configuration());
        Savepoint savepoint = savepoints.pop();
        try {
            this.connection(ctx.configuration()).rollback(savepoint);
        }
        finally {
            if (savepoints.isEmpty()) {
                this.brace(ctx.configuration(), false);
            }
        }
    }

    private void brace(Configuration configuration, boolean start) {
        boolean autoCommit;
        if (start) {
            this.connection = this.provider.acquire();
        }
        if (autoCommit = this.autoCommit(configuration)) {
            this.connection(configuration).setAutoCommit(!start);
        }
        if (!start) {
            this.provider.release(this.connection);
            this.connection = null;
            configuration.data().remove("org.jooq.configuration.default-transaction-provider-connection-provider");
        }
    }
}

