/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.Delete;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.Insert;
import org.jooq.Merge;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Routine;
import org.jooq.Truncate;
import org.jooq.Update;
import org.jooq.impl.ProviderEnabledConnection;
import org.jooq.impl.SettingsEnabledConnection;
import org.jooq.impl.Utils;
import org.jooq.tools.jdbc.JDBCUtils;

class DefaultExecuteContext
implements ExecuteContext {
    private final Configuration configuration;
    private final Map<Object, Object> data;
    private final Query query;
    private final Routine<?> routine;
    private String sql;
    private final Query[] batchQueries;
    private final String[] batchSQL;
    private final int[] batchRows;
    private transient ConnectionProvider connectionProvider;
    private transient Connection connection;
    private transient PreparedStatement statement;
    private transient ResultSet resultSet;
    private transient Record record;
    private transient Result<?> result;
    private transient int rows = -1;
    private transient RuntimeException exception;
    private transient SQLException sqlException;
    private transient SQLWarning sqlWarning;
    private static final ThreadLocal<List<Blob>> BLOBS = new ThreadLocal();
    private static final ThreadLocal<List<Clob>> CLOBS = new ThreadLocal();
    private static final ThreadLocal<Configuration> LOCAL_CONFIGURATION = new ThreadLocal();
    private static final ThreadLocal<Connection> LOCAL_CONNECTION = new ThreadLocal();

    static final void clean() {
        List<Blob> blobs = BLOBS.get();
        List<Clob> clobs = CLOBS.get();
        if (blobs != null) {
            for (Blob blob : blobs) {
                JDBCUtils.safeFree(blob);
            }
            BLOBS.remove();
        }
        if (clobs != null) {
            for (Clob clob : clobs) {
                JDBCUtils.safeFree(clob);
            }
            CLOBS.remove();
        }
        LOCAL_CONFIGURATION.remove();
        LOCAL_CONNECTION.remove();
    }

    static final void register(Blob blob) {
        BLOBS.get().add(blob);
    }

    static final void register(Clob clob) {
        CLOBS.get().add(clob);
    }

    static final Configuration localConfiguration() {
        return LOCAL_CONFIGURATION.get();
    }

    static final Connection localConnection() {
        return LOCAL_CONNECTION.get();
    }

    DefaultExecuteContext(Configuration configuration) {
        this(configuration, null, null, null);
    }

    DefaultExecuteContext(Configuration configuration, Query[] batchQueries) {
        this(configuration, null, batchQueries, null);
    }

    DefaultExecuteContext(Configuration configuration, Query query) {
        this(configuration, query, new Query[]{query}, null);
    }

    DefaultExecuteContext(Configuration configuration, Routine<?> routine) {
        this(configuration, null, null, routine);
    }

    private DefaultExecuteContext(Configuration configuration, Query query, Query[] batchQueries, Routine<?> routine) {
        this.configuration = configuration;
        this.data = new HashMap<Object, Object>();
        this.query = query;
        this.batchQueries = batchQueries == null ? new Query[]{} : batchQueries;
        this.routine = routine;
        if (this.batchQueries.length > 0) {
            this.batchSQL = new String[this.batchQueries.length];
            this.batchRows = new int[this.batchQueries.length];
            for (int i = 0; i < this.batchQueries.length; ++i) {
                this.batchRows[i] = -1;
            }
        } else if (routine != null) {
            this.batchSQL = new String[1];
            this.batchRows = new int[]{-1};
        } else {
            this.batchSQL = new String[0];
            this.batchRows = new int[0];
        }
        DefaultExecuteContext.clean();
        BLOBS.set(new ArrayList());
        CLOBS.set(new ArrayList());
        LOCAL_CONFIGURATION.set(configuration);
    }

    @Override
    public final Map<Object, Object> data() {
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    public final ExecuteType type() {
        if (this.routine != null) {
            return ExecuteType.ROUTINE;
        }
        if (this.batchQueries.length == 1 && this.query == null) {
            return ExecuteType.BATCH;
        }
        if (this.batchQueries.length > 1) {
            return ExecuteType.BATCH;
        }
        if (this.query != null) {
            if (this.query instanceof ResultQuery) {
                return ExecuteType.READ;
            }
            if (this.query instanceof Insert || this.query instanceof Update || this.query instanceof Delete || this.query instanceof Merge) {
                return ExecuteType.WRITE;
            }
            if (this.query instanceof Truncate) {
                return ExecuteType.DDL;
            }
            String s = this.query.getSQL().toLowerCase();
            if (s.matches("^(with\\b.*?\\bselect|select|explain)\\b.*?")) {
                return ExecuteType.READ;
            }
            if (s.matches("^(insert|update|delete|merge|replace|upsert|lock)\\b.*?")) {
                return ExecuteType.WRITE;
            }
            if (s.matches("^(create|alter|drop|truncate|grant|revoke|analyze|comment|flashback|enable|disable)\\b.*?")) {
                return ExecuteType.DDL;
            }
            if (s.matches("^\\s*\\{\\s*(\\?\\s*=\\s*)call.*?")) {
                return ExecuteType.ROUTINE;
            }
            if (s.matches("^(call|begin|declare)\\b.*?")) {
                return ExecuteType.ROUTINE;
            }
        } else if (this.resultSet != null) {
            return ExecuteType.READ;
        }
        return ExecuteType.OTHER;
    }

    @Override
    public final Query query() {
        return this.query;
    }

    @Override
    public final Query[] batchQueries() {
        return this.batchQueries;
    }

    @Override
    public final Routine<?> routine() {
        return this.routine;
    }

    @Override
    public final void sql(String s) {
        this.sql = s;
        if (this.batchSQL.length == 1) {
            this.batchSQL[0] = s;
        }
    }

    @Override
    public final String sql() {
        return this.sql;
    }

    @Override
    public final String[] batchSQL() {
        return this.batchSQL;
    }

    @Override
    public final void statement(PreparedStatement s) {
        this.statement = s;
    }

    @Override
    public final PreparedStatement statement() {
        return this.statement;
    }

    @Override
    public final void resultSet(ResultSet rs) {
        this.resultSet = rs;
    }

    @Override
    public final ResultSet resultSet() {
        return this.resultSet;
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final void connectionProvider(ConnectionProvider provider) {
        this.connectionProvider = provider;
    }

    @Override
    public final Connection connection() {
        ConnectionProvider provider;
        ConnectionProvider connectionProvider = provider = this.connectionProvider != null ? this.connectionProvider : this.configuration.connectionProvider();
        if (this.connection == null && provider != null) {
            this.connection(provider, provider.acquire());
        }
        return this.connection;
    }

    final void connection(ConnectionProvider provider, Connection c) {
        if (c != null) {
            LOCAL_CONNECTION.set(c);
            this.connection = new SettingsEnabledConnection(new ProviderEnabledConnection(provider, c), this.configuration.settings());
        }
    }

    @Override
    public final void record(Record r) {
        this.record = r;
    }

    @Override
    public final Record record() {
        return this.record;
    }

    @Override
    public final int rows() {
        return this.rows;
    }

    @Override
    public final void rows(int r) {
        this.rows = r;
        if (this.batchRows.length == 1) {
            this.batchRows[0] = r;
        }
    }

    @Override
    public final int[] batchRows() {
        return this.batchRows;
    }

    @Override
    public final void result(Result<?> r) {
        this.result = r;
    }

    @Override
    public final Result<?> result() {
        return this.result;
    }

    @Override
    public final RuntimeException exception() {
        return this.exception;
    }

    @Override
    public final void exception(RuntimeException e) {
        this.exception = e;
    }

    @Override
    public final SQLException sqlException() {
        return this.sqlException;
    }

    @Override
    public final void sqlException(SQLException e) {
        this.sqlException = e;
        this.exception(Utils.translate(this.sql(), e));
    }

    @Override
    public final SQLWarning sqlWarning() {
        return this.sqlWarning;
    }

    @Override
    public final void sqlWarning(SQLWarning e) {
        this.sqlWarning = e;
    }
}

