/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.DivideByOnStep;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.JoinType;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.Row;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.TablePartitionByStep;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.DivideBy;
import org.jooq.impl.Fields;
import org.jooq.impl.JoinTable;
import org.jooq.impl.RowImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.TableFieldImpl;
import org.jooq.impl.TableImpl;
import org.jooq.tools.StringUtils;

abstract class AbstractTable<R extends Record>
extends AbstractQueryPart
implements Table<R> {
    private static final long serialVersionUID = 3155496238969274871L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TABLE};
    private final Schema schema;
    private final String name;
    private final String comment;

    AbstractTable(String name) {
        this(name, null, null);
    }

    AbstractTable(String name, Schema schema) {
        this(name, schema, null);
    }

    AbstractTable(String name, Schema schema, String comment) {
        this.schema = schema;
        this.name = name;
        this.comment = comment;
    }

    @Override
    public Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    abstract Fields<R> fields0();

    @Override
    public final RecordType<R> recordType() {
        return this.fields0();
    }

    @Override
    public final Row fieldsRow() {
        return new RowImpl(this.fields0());
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.fieldsRow().field(field);
    }

    @Override
    public final Field<?> field(String string) {
        return this.fieldsRow().field(string);
    }

    @Override
    public final Field<?> field(int index) {
        return this.fieldsRow().field(index);
    }

    @Override
    public final Field<?>[] fields() {
        return this.fieldsRow().fields();
    }

    @Override
    public final Table<R> asTable() {
        return this;
    }

    @Override
    public final Table<R> asTable(String alias) {
        return this.as(alias);
    }

    @Override
    public final Table<R> asTable(String alias, String ... fieldAliases) {
        return this.as(alias, fieldAliases);
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public Identity<R, ? extends Number> getIdentity() {
        return null;
    }

    @Override
    public UniqueKey<R> getPrimaryKey() {
        return null;
    }

    @Override
    public TableField<R, ? extends Number> getRecordVersion() {
        return null;
    }

    @Override
    public TableField<R, ? extends Date> getRecordTimestamp() {
        return null;
    }

    @Override
    public List<UniqueKey<R>> getKeys() {
        return Collections.emptyList();
    }

    @Override
    public final <O extends Record> List<ForeignKey<O, R>> getReferencesFrom(Table<O> other) {
        return other.getReferencesTo(this);
    }

    @Override
    public List<ForeignKey<R, ?>> getReferences() {
        return Collections.emptyList();
    }

    @Override
    public final <O extends Record> List<ForeignKey<R, O>> getReferencesTo(Table<O> other) {
        ArrayList result = new ArrayList();
        for (ForeignKey<R, ?> reference : this.getReferences()) {
            Table aliased;
            if (other.equals(reference.getKey().getTable())) {
                result.add(reference);
                continue;
            }
            if (other instanceof TableImpl) {
                aliased = ((TableImpl)other).getAliasedTable();
                if (aliased == null || !aliased.equals(reference.getKey().getTable())) continue;
                result.add(reference);
                continue;
            }
            if (!(other instanceof TableAlias) || (aliased = ((TableAlias)other).getAliasedTable()) == null || !aliased.equals(reference.getKey().getTable())) continue;
            result.add(reference);
        }
        return Collections.unmodifiableList(result);
    }

    protected static final <R extends Record, T> TableField<R, T> createField(String name, DataType<T> type, Table<R> table) {
        return AbstractTable.createField(name, type, table, null);
    }

    protected static final <R extends Record, T> TableField<R, T> createField(String name, DataType<T> type, Table<R> table, String comment) {
        return AbstractTable.createField(name, type, table, comment, null);
    }

    protected static final <R extends Record, T, U> TableField<R, U> createField(String name, DataType<T> type, Table<R> table, String comment, Converter<T, U> converter) {
        DataType<T> actualType = converter == null ? type : type.asConvertedDataType(converter);
        TableFieldImpl<R, T> tableField = new TableFieldImpl<R, T>(name, actualType, table, comment, converter);
        if (table instanceof TableImpl) {
            ((TableImpl)table).fields0().add(tableField);
        }
        return tableField;
    }

    @Override
    public final DivideByOnStep divideBy(Table<?> divisor) {
        return new DivideBy(this, divisor);
    }

    @Override
    public final TableOptionalOnStep join(TableLike<?> table, JoinType type) {
        return new JoinTable(this, table, type);
    }

    @Override
    public final TableOnStep join(TableLike<?> table) {
        return this.join(table, JoinType.JOIN);
    }

    @Override
    public final TableOnStep join(String sql) {
        return this.join(DSL.table(sql));
    }

    @Override
    public final TableOnStep join(String sql, Object ... bindings) {
        return this.join(DSL.table(sql, bindings));
    }

    @Override
    public final TableOnStep join(String sql, QueryPart ... parts) {
        return this.join(DSL.table(sql, parts));
    }

    @Override
    public final TablePartitionByStep leftOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.LEFT_OUTER_JOIN);
    }

    @Override
    public final TablePartitionByStep leftOuterJoin(String sql) {
        return this.leftOuterJoin(DSL.table(sql));
    }

    @Override
    public final TablePartitionByStep leftOuterJoin(String sql, Object ... bindings) {
        return this.leftOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final TablePartitionByStep leftOuterJoin(String sql, QueryPart ... parts) {
        return this.leftOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final TablePartitionByStep rightOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.RIGHT_OUTER_JOIN);
    }

    @Override
    public final TablePartitionByStep rightOuterJoin(String sql) {
        return this.rightOuterJoin(DSL.table(sql));
    }

    @Override
    public final TablePartitionByStep rightOuterJoin(String sql, Object ... bindings) {
        return this.rightOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final TablePartitionByStep rightOuterJoin(String sql, QueryPart ... parts) {
        return this.rightOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final TableOnStep fullOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.FULL_OUTER_JOIN);
    }

    @Override
    public final TableOnStep fullOuterJoin(String sql) {
        return this.fullOuterJoin(DSL.table(sql));
    }

    @Override
    public final TableOnStep fullOuterJoin(String sql, Object ... bindings) {
        return this.fullOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final TableOnStep fullOuterJoin(String sql, QueryPart ... parts) {
        return this.fullOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> crossJoin(TableLike<?> table) {
        return this.join(table, JoinType.CROSS_JOIN);
    }

    @Override
    public final Table<Record> crossJoin(String sql) {
        return this.crossJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> crossJoin(String sql, Object ... bindings) {
        return this.crossJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> crossJoin(String sql, QueryPart ... parts) {
        return this.crossJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> naturalJoin(TableLike<?> table) {
        return this.join(table, JoinType.NATURAL_JOIN);
    }

    @Override
    public final Table<Record> naturalJoin(String sql) {
        return this.naturalJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalJoin(String sql, Object ... bindings) {
        return this.naturalJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> naturalJoin(String sql, QueryPart ... parts) {
        return this.naturalJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.NATURAL_LEFT_OUTER_JOIN);
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(String sql) {
        return this.naturalLeftOuterJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(String sql, Object ... bindings) {
        return this.naturalLeftOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> naturalLeftOuterJoin(String sql, QueryPart ... parts) {
        return this.naturalLeftOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(TableLike<?> table) {
        return this.join(table, JoinType.NATURAL_RIGHT_OUTER_JOIN);
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(String sql) {
        return this.naturalRightOuterJoin(DSL.table(sql));
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(String sql, Object ... bindings) {
        return this.naturalRightOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final Table<Record> naturalRightOuterJoin(String sql, QueryPart ... parts) {
        return this.naturalRightOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof AbstractTable) {
            if (StringUtils.equals(this.name, ((AbstractTable)that).name)) {
                return super.equals(that);
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

