# Error handling

All of the configuration options regarding errors and logging live in the
[config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.

```php
  /*
  |--------------------------------------------
  | Settings for the error handling behavior
  |--------------------------------------------
  */
  'error' => array(
    'ignore_levels' => array(E_USER_DEPRECATED),
    'debug_info' => true,
  	'log' => true,
  ),
```

The **ignore_levels** option contains an array of error levels that should be ignored by PIMF. By **ignored**, we mean that we won't stop execution
of the script on these errors. However, they will be logged when logging is enabled.

The **debug_info** option indicates if the framework should display the error message and stack trace when an error occurs. For development, you
will want this to be 'true'. In a production environment, set this to 'false'. When 'debug_info' is disabled, the view located in **core/Pimf/_error/500.php**
will be displayed, which contains a generic error message.

If a request enters your application but does not match any existing route, the 404 page will be raised.

To enable logging, set the **log** option in the error configuration to **true**. When enabled, the Closure defined by the logger configuration
item will be executed when an error occurs. This gives you total flexibility in how the error should be logged.

## Custom 404 and 500 pages
If you want to customize the the 404 or 500 view, just override it by creating a clone of it at you application like **app/MyFirstBlog/_error/500.php**.
