# Views & Template-Engines

PIMF Views contain the HTML that is sent to the user working with your application. By separating your view from the business
logic of your application, your code will be cleaner and easier to maintain.

All view-templates are stored within the **/app/MyFirstBlog/_templates/** directory and use the PHTML file extension. The
Pimf\View class provides a simple way to retrieve your view-templates and return them to the client.

Following views are available out of the box:
* Pimf\View for common usage
* Pimf\View\Haanga is optional and needs HAANGA template engine
* Pimf\View\Twig is optional and needs TWIG template engine

### Pimf-View
Magical printing out of the view

```php
  echo new Pimf\View(
    'theblog.phtml',
    array(
      'blog_title'   => 'This is my firs Blog with PIMF',
      'blog_content' => $view->render(),
      'blog_footer'  => 'A Blog about cool and thin framework'
    )
  );
```

Loading the main view of the blog separately - in a old school way

```php
  // use app/MyFirstBlog/_templates/theblog.phtml for viewing
  $viewMain = new Pimf\View('theblog.phtml');

  // assign data to the template
  $viewMain->assign('blog_title', 'This is my firs Blog with PIMF')
           ->assign('blog_content', $view->render())
           ->assign('blog_footer', 'A Blog about cool and thin framework');

  return $viewMain->render();
```

Renders a HTML list of all entries which are stored at the sqlite database

```php
  // use app/MyFirstBlog/_templates/list.phtml for viewing
  $viewAllEntries = new Pimf\View('list.phtml');
  $entries        = $this->em->entry->getAll();

  // assign data to the template
  $viewAllEntries->assign('entries', $entries);

  echo $this->loadMainView($viewAllEntries);
```

### Pimf-View Partial Helper
The methods **partial($template, array $model = array())** and **loop($template, array $model = array())** at Pimf\View are used to
render a specified template within its own variable scope. The primary use is for reusable template fragments with which you do not need to
worry about variable name clashes.

Action which handles with partials and uses **app/MyFirstBlog/_templates/booklist.phtml** and **app/MyFirstBlog/_templates/book.phtml** to
render a table.

```php
  $data['books'] = array(
    array(
      'author' => 'Hernando de Soto',
      'title'  => 'The Mystery of Capitalism'
    ),
    array(
      'author' => 'Henry Hazlitt',
      'title'  => 'Economics in One Lesson'
    ),
  );

  $view = new Pimf\View('booklist.phtml');

  echo $view->pump($data)->render();
```

Here how the **app/MyFirstBlog/_templates/booklist.phtml** looks like:

```phtml
  <?php if ($this->books) : ?>
    <table border=**1**>
        <thead>
          <tr>
              <th>Autor</th>
              <th>Title</th>
          </tr>
        </thead>
        <tbody>
         <?php echo $this->loop('book.phtml', $this->books); ?>
        </tbody>
      </table>
  <?php endif; ?>
```

Here how the looping through **app/MyFirstBlog/_templates/book.phtml** partial looks like:

```phtml
  <tr>
    <td><?php echo $this->author; ?></td>
    <td><?php echo $this->title; ?></td>
  </tr>
```

## Template Engines
PIMF works great with external template engines like TWIG and HAANGA. Twig is a flexible, fast, and secure template engine for PHP. Haanga
is a template engine that bases on the TWIGs idea and uses Django syntax for parsing the PHTML files. PIMF gives you the posibility to use
them both optionally or parallely. You can use more than one template engine. Go wild!

### Pimf-View-Twig
Before start using it - please add the following code to the end of the [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file:

```php
  'view' => array(
     'twig' => array(
        // if compilation caching should be used
       'cache'       => true,
        // if set to true, you can display the generated nodes
       'debug'       => false,
       // useful to recompile the template whenever the source code changes
       'auto_reload' => true,
    ),
  ),
```

A **Hallo world** action for showing that PIMF works great with TWIG

```php
  // use app/MyFirstBlog/_templates/parent.twig for viewing
  $view = new Pimf\View\Twig('parent.twig');

  // assign data to the template
  $view->assign('hello', 'Hello world')
       ->assign('now', date('d M Y h:i:s', time()));

  echo $view->render();
```

### Pimf-View-Haanga
Before start using it - please add the following code to the end of the [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file:

```php
  'view' => array(
     'haanga' => array(
        // if compilation caching should be used
       'cache'       => true,
        // if set to true, you can display the generated nodes
       'debug'       => false,
       // useful to recompile the template whenever the source code changes
       'auto_reload' => true,
    ),
  ),
```

A **Hallo world** action for showing that PIMF works great with HAANGA.

```php
  // use app/MyFirstBlog/_templates/parent.haanga for viewing
  $view = new Pimf\View\Haanga('parent.haanga');

  // assign data to the template
  $view->assign('hello', 'Hello world')
       ->assign('now', date('d M Y h:i:s', time()));

  echo $view->render();
```
