# Request

You can work with Pimf\Request instance at any class which extends the Pimf\Controller\Base class, or you can create it somewhere else
for at your application and retrieve the desired variables.

Creating a new instance outside of the controller.

```php
    $request = new Pimf\Request($_GET, $_POST, $_COOKIE, $_SERVER['argv']);
```

Retrieves the HTTP GET variables.

```php
    $request->fromGet()->get('name');
```

Retrieves the CLI arguments passed to script.

```php
    $request->fromCli()->get('name');
```

Retrieves the HTTP POST variables.

```php
    $request->fromPost()->get('name');
```

Retrieves the HTTP Cookies.

```php
    $request->fromCookie()->get('name');
```
