# Creating new command interface action

Yes, we programmers are lazy and pragmatic guys. Therefore  PIMF gives us the possibility to create our own interactive PHP Command Line Interface actions.  That is the easiest way to make some possibility for scaffolding or manipulating data without implementing a whole HTML backend interface.

A action at the controller for inserting a blog-article via command line interface.

```php
  public function insertCliAction()
  {

    $std = new \Pimf\Cli\Std();

    $title   = $std->read('article title');
    $content = $std->read('article content');

    $entry = new MyFirstBlog\Model\Entry();

    $entry->setTitle($title);
    $entry->setContent($content);

    $res = $this->em->entry->insert($entry);

    var_dump($res);
  }
```

Start your command line interface, go to your PIMF root directory, type following command and follow the instructions:

```php
php pimf blog:insert
```

Retrieving a list of available app or core commands:

    php pimf list

Chose the command you desire:

```cli
PIMF v1.8 PHP Command Line Interface by Gjero Krsteski
+------------------------------------------------------+
controller: blog

 action: insert

 action: update

 action: delete

 action: create_blog_table

+------------------------------------------------------+
controller: core

 action: init

 action: create_session_table

 action: create_cache_table

+------------------------------------------------------+
```
