# Run controller/action in two ways

If the controller method name has the suffix **Action()**, you can run at the browser, by calling the controller-action on sending the GET parameters to your request:

```bash
/index.php?controller=blog&action=showentry
```

If the controller method name has the suffix **CliAction()**, you can easy run at the command line interface by executing the command:

```bash
php pimf blog:insert
```

Here you can see how they are defined at the blog-controller:

```php
 class MyFirstBlog\Controller\Blog
 extends Pimf\Controller\Base
 {
   public function showentryAction()
   {
     // ...
   }

   public function insertCliAction()
   {
    // ...
   }
 }
```

Maybe you wonder about that - but that is the easiest way to make some possibility for scaffolding or manipulating data without implementing a backend interface.
All methods at the controller who have the suffix **Action()** can be accessed only from the browser and methods who have the suffix **CliAction()** can be accessed only on the command line interface.
If you want to send message to you interface than throw Pimf\Controller\Exception. This will be printed out at the view.
