# Database connection configuration

PIMF supports the following databases:

- SQLite
- MySQL
- PostgreSQL
- SQL Server

All of the database configuration options live in the [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.

## Quick start using SQLite
SQLite is an awesome, zero-configuration database system. By default, PIMF is configured to use a SQLite database. Really, you don't have to change anything. Just drop a SQLite database named blog-production.db into the 'app/MyFirstBlog/_database/ ' directory. You're done.
Of course, if you want to name your database something besides "application", you can modify the database option in the SQLite section of the [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file:

```php
  'production' => array(
    'db' => array(
      'driver' => 'sqlite',
      'database' => 'app/MyFirstBlog/_database/blog-production.db'
    ),
  ),
```

If your application receives less than 100,000 hits per day, SQLite should be suitable for production use in your application. OtherwixOtherwisese, consider using MySQL or PostgreSQL.

### Configuring other databases
If you are using MySQL, SQL Server or PostgreSQL, you will need to edit the configuration options in [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php). In the configuration file you can find sample configurations for each of these systems. Just change the options as necessary for your server and set the default connection name.

### Overwriting the default PDO options
The PDO connectors (core/Pimf/Pdo/) has a set of default PDO attributes defined which can be overwritten in the options array for each system. For example, one of the default attributes is to force column names to lowercase (PDO::CASE_LOWER) even if they are defined in UPPERCASE or CamelCase in the table. Therefore, under the default attributes, query result object variables would only be accessible in lowercase.

An example of the MySQL system settings with added default PDO attributes:

```php
  'db' => array(
    'driver'                    => 'mysql',
    'host'                      => 'localhost',
    'database'                  => 'database',
    'username'                  => 'root',
    'password'                  => '',
    'charset'                   => 'utf8',
    'prefix'                    => '',
    'options'                   => array(
      PDO::ATTR_CASE              => PDO::CASE_LOWER,
      PDO::ATTR_ERRMODE           => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_ORACLE_NULLS      => PDO::NULL_NATURAL,
      PDO::ATTR_STRINGIFY_FETCHES => false,
      PDO::ATTR_EMULATE_PREPARES  => false,
    ),
  ),
```

More about the PDO connection attributes can be found in the PHP manual.
