# Welcome to PIMF

Have you ever wanted a PHP framework which perfectly adapts to the needs of your project? 
A thin PHP framework with minimal installation configuration as well as being easy to learn? PIMF is about to satisfy your demands!

NOTE: This is a hands-on book. You won’t be able to complete it by reading it in a metro on your way to work. You’ll have to read 
this book while in front of a computer getting your hands dirty.

## PIMF principles
Most PHP frameworks are bigger than the problem you are trying to solve. 
A big and complex framework can't protect you from poor business logic, and will often become a large part of your problem. 
Often you need 20% or less from the functionality of a full-stack framework to solve your problem.
Therefore finding the right 20% of the framework functionality solves the remaining 80% of your problem.
PIMF is an opinionated framework which follows common best practises that strives to be those right 20%. 

## Behind PIMF

PIMF was first created for our own personal use. The aim was to deliver robust and secure projects fast. 
We just wanted one easy framework, which could be used for all of our projects. And then - PIMF was born!

PIMF’s implementation is based on well proven design patterns as well as fast object relation mapping mechanisms. 
PIMF is designed to be upgrade friendly - so that you can upgrade to newer versions with minimal effort. 

Build Status [travis-ci.org/gjerokrsteski/pimf-framework](https://travis-ci.org/gjerokrsteski/pimf-framework)

Scrutinizer Quality Score [scrutinizer-ci.com/g/gjerokrsteski/pimf-framework/](https://scrutinizer-ci.com/g/gjerokrsteski/pimf-framework/)

## Where to start

Learning a new framework can be daunting, but it's also exciting. To smoothen your transition, we've attempted to create clear,
concise documentation for PIMF. Here are some recommendations for what to read first:

1. Installation & Configuration
2. Auto-loading
3. Routing
4. Requests & Input
5. Views & Responses
6. Controllers

After reading through those chapters, you should have a good grasp on the basics of request / response handling in PIMF.
Next, you may wish to read about configuring your database, the happy utils and events handling.
