Welcome to PIMF
====================
[![Build Status](https://travis-ci.org/gjerokrsteski/pimf-framework.svg?branch=master)](https://travis-ci.org/gjerokrsteski/pimf-framework) [![Latest Stable Version](https://img.shields.io/packagist/v/gjerokrsteski/pimf-framework.svg?label=stable)](https://packagist.org/packages/gjerokrsteski/pimf-framework)  [![Code Climate](https://codeclimate.com/github/gjerokrsteski/pimf-framework.png)](https://codeclimate.com/github/gjerokrsteski/pimf-framework) [![SensioLabsInsight](https://insight.sensiolabs.com/projects/f73307c6-0864-454f-967d-cebfd1e4b304/mini.png)](https://insight.sensiolabs.com/projects/f73307c6-0864-454f-967d-cebfd1e4b304) [![Total Downloads](https://poser.pugx.org/gjerokrsteski/pimf/downloads)](https://packagist.org/packages/gjerokrsteski/pimf) [![License](https://img.shields.io/packagist/l/gjerokrsteski/pimf-framework.svg)](https://packagist.org/packages/gjerokrsteski/pimf-framework)
[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/pimf-framework/Lobby?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) [![Dependency Status](https://www.versioneye.com/user/projects/53db39104b3ac84fbb0001ca/badge.svg?style=flat-square)](https://www.versioneye.com/user/projects/53db39104b3ac84fbb0001ca) [![Scrutinizer Quality Score](https://scrutinizer-ci.com/g/gjerokrsteski/pimf-framework/badges/quality-score.png?s=6455d019460628327434d85520bd13c4d03a2673)](https://scrutinizer-ci.com/g/gjerokrsteski/pimf-framework/)

Have you ever wanted a PHP framework which perfectly adapts to the needs of your project? A thin PHP framework with minimal installation configuration as well as being easy to learn? PIMF is about to satisfy your demands!

Getting Started
---------------
This repository contains the core code of the PIMF framework. If you want to build an application using PIMF, please use one of the quick-start bundles below.

Quickstart with PIMF-Blog bundle using SQLite
---------------------------------------------
This Blog is a run-ready bundle which uses PIMF framework and includes a blog application based on the SQLite database. Here you can learn how to work with \Pimf\EntityManager, \Pimf\Util\Validator and \Pimf\View. https://github.com/gjerokrsteski/pimf-blog

Quickstart with PIMF-Blog bundle using MySQL and SQLite
-------------------------------------------------------
This Blog is a run-ready bundle which uses PIMF framework and includes a blog application based on the MySQL database. Sessions will be stored in a SQLite database.
Here you can learn how to work with Pimf\EntityManager, Pimf\Util\Validator and Pimf\View. https://github.com/gjerokrsteski/pimf-blog-mysql

Quickstart with PIMF-Vanilla bundle
------------------------------
This is a run-ready "Hello world" bundle using PIMF micro-framework. Here you can learn how to work with \Pimf\View and \Pimf\Router. https://github.com/gjerokrsteski/pimf-vanilla

Quickstart with PIMF-Haanga bundle
-----------------------------
This is a run-ready "Hello world" application using PIMF micro-framework and Haanga (http://haanga.org/documentation) - a fast and secure template engine for PHP that uses Django syntax.
Here you can learn how to work with \Pimf\View\Haanga template engine and \Pimf\Router. https://github.com/gjerokrsteski/pimf-haanga

Quickstart with PIMF-Twig bundle
-----------------------------
This is a run-ready "Hello world" application using PIMF micro-framework and Twig - a flexible, fast, and secure template
engine for PHP (http://twig.sensiolabs.org) brought to us by the Symfony framework developers. Here you can learn how to work
with \Pimf\View\Twig template engine and \Pimf\Router. https://github.com/gjerokrsteski/pimf-twig

Quickstart with PIMF-Command bundle
-----------------------------
This is a run ready "Hello world" bundle using PIMF micro framework. Here you can learn how to work with \Pimf\Cli and write actions for the command line interface. https://github.com/gjerokrsteski/pimf-command

Quickstart with PIMF-Transphporm bundle
-----------------------------
This is a run-ready "Hello world" application using PIMF micro framework and Transphporm (https://github.com/Level-2/Transphporm), a template engine that separates logic from markup and that uses a syntax already familiar to web developers. Here you can learn how to work with \Pimf\View\Transphporm template engine and \Pimf\Router. https://github.com/garrettw/pimf-transphporm


Learning PIMF
-------------
One of the best ways to learn PIMF is to read through the entirety of its documentation. This guide details all aspects of the framework and how to apply them to your application. http://docs.pimf-framework.de

Read the PIMF Starter book almost anywhere. Available as a PDF, EPUB, and MOBI. You can now read it on all devices, as well as offline: http://book.pimf-framework.de

PIMF Philosophy
---------------
Most PHP frameworks are bigger than the problem you are trying to solve. A big and complex framework can't protect you from poor business logic, and will often become a large part of your problem. Often you need 20% or less from the functionality of a full-stack framework to solve your problem. Therefore finding the right 20% of the framework functionality solves the remaining 80% of your problem. PIMF is an opinionated framework which follows common best practises that strives to be those right 20%.

PIMF was first created for our own personal use. The aim was to deliver robust and secure projects fast. We just wanted one easy framework, which could be used for all of our projects. And then - PIMF was born!

PIMF’s implementation is based on well proven design patterns as well as fast object relation mapping mechanisms. PIMF is designed to be upgrade friendly - so that you can upgrade to newer versions with minimal effort.

Framework Sponsor
-------------------
JetBRAINS supports the development of PIMF with PHPStorm licenses and we feel confident that PHPStorm strongly reinforces PIMF's quality. Use PHPStorm! http://www.jetbrains.com/phpstorm/

### License

The PIMF framework is open-sourced software licensed under the [MIT license](http://opensource.org/licenses/MIT)
