DROP TABLE IF EXISTS `product_content`;

CREATE TABLE `product_content` (
`product_id` INT NOT NULL,
`language_id` INT NOT NULL,
`name` TEXT NOT NULL DEFAULT "",
`slug` TEXT NOT NULL DEFAULT "",
`content` text,
`tag` text,
`meta_title` TEXT NOT NULL DEFAULT "",
`meta_description` TEXT NOT NULL DEFAULT "",
`meta_keywords` TEXT NOT NULL DEFAULT "",
PRIMARY KEY (`product_id`,`language_id`)
-- FULLTEXT `search` (`name`,`content`)
);


CREATE INDEX `product_content_slug` ON `product_content` (`slug`);

DROP TABLE IF EXISTS `product_content_search`;

DROP TRIGGER IF EXISTS `afterproductContentInsert`;
DROP TRIGGER IF EXISTS `afterproductContentDelete`;
DROP TABLE IF EXISTS `product_content_search`;

CREATE VIRTUAL TABLE product_content_search USING fts4(
  content='product_content', 
--  content_rowid='rowid', 
  name, 
  content 
);

create trigger afterproductContentInsert AFTER INSERT ON product_content BEGIN
  INSERT INTO product_content_search(
    rowid, 
    name, 
    content
  )
  VALUES(
    new.rowid,
    new.name, 
    new.content
);END;

CREATE TRIGGER afterproductContentDelete AFTER DELETE ON product_content BEGIN
  INSERT INTO product_content_search(
    product_content_search,
    rowid,
    name,
    content
  )
  VALUES(
    'delete',
    old.rowid,
    old.name,
    old.content
);END;
