# Feelback integrations

This repository is part of the [Feelback](https://www.feelback.dev) service.

## What is Feelback?
Feelback is a service allowing to collect any type of feedback for your content, such as _likes_, _reactions_, _ratings_, _suggestions_, _error reporting_ and so on. It integrates easily with any website with prebuilt components.

You can easily add:
- **Likes** to blog posts
- _"Is this page useful?"_ with **up/down votes** on documentation pages
- **Emoji reactions** to sections, parts or comments
- _"Send feedback"_ **form** for tips, appreciations or error reporting, with custom data

![](https://www.feelback.dev/images/hero-img.png)


### One Place For Any Content
You can manage all your web content types and signals in one place.
![](https://www.feelback.dev/images/panel-1.png)


### Content Performance At A Glance
You can track aggregate data by period, by volume and get a quick overview on **user sentiment** about your content.
![](https://www.feelback.dev/images/panel-2.png)
![](https://www.feelback.dev/images/panel-3.png)


## Repository structure
This repository includes:
- Integration SDKs with many frameworks and site builders -- dir [packages](packages)
- Integration examples with complete projects -- dir [samples](samples)


## Contributing
All contribution are welcome. Any PR, issue and feedback is appreciated.

## License
MIT © [Giuseppe La Torre](https://github.com/giuseppelt)
