---
lang: zh-hant
untranslated: false
title: 保持平衡——開源專案維護者的指南
description: 作為一名維護者，照顧自己並避免疲憊的小建議。
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

隨著一個開源專案的受歡迎程度不斷增長，設定清晰的界限變得至關重要，以幫助您保持平衡，確保長期保持清新和高效。

為了深入了解維護者的經驗以及他們尋找平衡的策略，我們與<a href="http://maintainers.github.com/">Maintainer Community</a>的40名成員一起進行了一個工作坊，讓我們能夠從他們在開源領域遭受疲憊的第一手經驗中學習，以及幫助他們在工作中保持平衡的實踐。這就是個人生態學的概念派上用場的地方。

那麼，什麼是個人生態學？正如<a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance%2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">Rockwood Leadership Institute所描述的</a>，它涉及"<strong>保持平衡、節奏和效率，以維持我們在長期活動中的能量</strong>。" 這個概念幫助維護者認識到他們的行為和貢獻是一個隨時間演變的更大生態系統的一部分。在維護者中，經常出現由於長期的工作壓力而導致的疲憊，這通常會導致動機的喪失，無法集中注意力，以及對您一起工作的貢獻者和社區缺乏同理心。根據世界衛生組織的定義，疲憊是一種由於長期的工作場所壓力而引起的綜合症狀，這種情況在維護者中並不少見。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  我無法專注或開始進行任務。我對使用者缺乏同理心。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>，Owncast直播流媒體伺服器的維護者，談到疲憊對他的開源工作的影響
  </p>
</aside>

透過擁抱個人生態學的概念，維護者可以主動避免疲憊，優先考慮自我照顧，並保持平衡感，以便做出最佳的工作表現。

## 作為維護者的自我照顧和避免疲憊的建議：

### 辨識您參與開源工作的動機

花些時間反思開源維護中哪些部分能夠為您注入活力。了解您的動機可以幫助您以一種讓自己保持參與和迎接新挑戰的方式來優先考慮工作。無論是來自使用者的積極反饋、與社區合作和社交的樂趣，還是深入研究程式碼所帶來的滿足感，認識自己的動機可以幫助引導您的關注點。

### 反思是什麼使您失去平衡並感到壓力重重

了解導致我們感到疲憊的原因至關重要。以下是一些我們在開源維護者中常見的主題：

* **缺乏積極的回饋：** 使用者更有可能在他們有投訴時聯絡您。如果一切都運作良好，他們通常會保持沉默。看到問題清單不斷增長，卻沒有積極的回饋顯示您的貢獻正在產生影響，可能會讓人感到沮喪。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  有時候感覺有點像在虛空中呼喊，我發現回饋真的能給我帶來活力。我們有很多滿意但寡言的使用者。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>，Apache Arrow的維護者
  </p>
</aside>

* **不說"不"：** 在開源專案中，很容易承擔比您應該負責的更多責任。無論是來自使用者、貢獻者還是其他維護者，我們不能總是滿足他們的期望。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
  我發現我承擔了比應該的更多責任，需要做多人份的工作，就像在自由開源軟體中常見的那樣。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>，Termux的維護者，談到導致他工作疲憊的原因
  </p>
</aside>

* **單獨工作：** 做一名維護者可能會讓人感到極度孤獨。即使您與一組維護者一起工作，過去幾年來，因分散的團隊難以親自聚會而變得困難。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  特別是自從COVID疫情以來，在家工作使得很難再見到人或與人交談。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>，Owncast直播流媒體伺服器的維護者，談到疲憊對他的開源工作的影響
  </p>
</aside>

* **時間和資源不足：** 對於那些必須犧牲自己的空閒時間來參與項目的志願維護者來說，這一點尤其真實。

<aside markdown="1" class="pquote">
  [我希望有] 更多的財務支持，這樣我就可以專注於開源工作，而不會消耗我的積蓄，並知道以後必須做很多合同工作來彌補。
  <p markdown="1" class="pquote-credit">
— 開源維護者
  </p>
</aside>

* **需求衝突：** 開源充滿了擁有不同動機的群體，這可能很難應對。如果您受薪工作於開源項目，您的雇主的利益有時可能與社區的利益相衝突。

<aside markdown="1" class="pquote">
  有薪開源中，雇主的關注點與社區最佳利益之間的衝突
  <p markdown="1" class="pquote-credit">
— 開源維護者
  </p>
</aside>

### 注意疲憊的跡象

您能夠保持這種節奏達10週嗎？10個月？10年？

有一些工具，例如來自 [@shaunagm](https://github.com/shaunagm) 的 [Burnout Checklist](https://governingopen.com/resources/signs-of-burnout-checklist.html) 和 可以幫助您反思您目前的節奏，並查看是否有任何調整的空間。一些維護者還使用可穿戴技術來追蹤睡眠質量和心率變異性等指標（這些都與壓力有關）。

<aside markdown="1" class="pquote">
 我非常相信優質的可穿戴設備。有了背後的科學知識，您可以了解如何做得更好，以及如何達到您想要達到的最佳狀態。
  <p markdown="1" class="pquote-credit">
— 開源維護者
  </p>
</aside>

### 您需要什麼來持續支持自己和您的社群？

對每位維護者來說，這可能因年齡階段和其他外部因素而有所不同。但以下是一些我們聽到的主題：

* **依賴社群：** 委託和找到貢獻者可以減輕工作負荷。項目有多個聯絡點可以幫助您在休息時不必擔心。與其他維護者和更廣泛的社群建立聯繫，例如 [Maintainer Community](http://maintainers.github.com/)。這可以是同儕支持和學習的重要資源。

您還可以尋找與使用者社群互動的方式，以便定期聽取反饋並了解您的開源工作的影響。

* **探索資金支持：** 無論您是尋找一些額外的財政支持，還是嘗試全職投入開源，都有許多資源可以幫助您！作為第一步，考慮啟用 [GitHub Sponsors](https://github.com/sponsors)，以允許其他人贊助您的開源工作。如果您考慮轉向全職，請申請下一輪的 [GitHub Accelerator](http://accelerator.github.com/)。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
 我一段時間前參加了一個播客，我們討論了開源維護和可持續性的問題。我發現即使有少數人在 GitHub 上支持我的工作，也能迅速決定不玩遊戲，而是做一點點開源工作。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>，EmberJS的維護者
  </p>
</aside>

* **使用工具：** 探索工具，如 [GitHub Copilot](https://github.com/features/copilot/) 和 [GitHub Actions](https://github.com/features/actions)，以自動化乏味的任務，釋放更多時間進行有意義的貢獻。

<aside markdown="1" class="pquote">
 使用 [Copilot](https://github.com/features/copilot/) 來處理沉悶的事情 - 做有趣的事情
  <p markdown="1" class="pquote-credit">
— 開源維護者
  </p>
</aside>

* **休息和恢復：** 為自己的興趣和愛好留出時間，遠離開源項目的工作。週末休息一下，放鬆身心，並設定您的 [GitHub status](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status) 以反映您的可用性！一晚好的睡眠對於您長期維護努力的能力可能會產生重大影響。

如果您發現項目的某些方面特別令人愉快，請嘗試結構化您的工作，以便您可以在一天中體驗到這些樂趣。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class="pquote-avatar" alt="avatar">
 我發現在白天更多機會嵌入"創造性時刻"，而不是試圖在晚上關掉。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>，Nuxt的維護者
  </p>
</aside>

* **設定界限：** 您無法對每個請求都答應。這可以是簡單地說，"我現在無法處理這個，並且將來也沒有計劃"，或在 README 中列出您有興趣和不願意做的事情。例如，您可以說："我只會合併明確列出為什麼要這樣做的 PR"，或者，"我只會在每兩週的週四晚上 6 點到 7 點之間審查問題。" 這會讓其他人對您的期望有所了解，並且在其他時候有助於緩解貢獻者或使用者對您的時間的需求。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
要在這些方面真正信任其他人，您不能成為對每個請求都說"是"的人。這樣一來，您就不會在專業或個人方面保持界限，也不會成為可靠的同事。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>，Homebrew的維護者，在 [Saying No](https://mikemcquaid.com/saying-no/) 上談及

  </p>
</aside>
學會堅定地制止有毒行為和負面互動。不對您不關心的事情付出精力是可以接受的。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
我的軟件是免費的，但我的時間和關注不是。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>，Leaflet的維護者
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
開源維護有其黑暗面，其中之一是有時必須與相當不感激、自以為是或明顯有毒的人互動。隨著項目的受歡迎程度增加，這種互動的頻率也增加，增加了維護者的負擔，可能成為維護者疲憊的重要風險因素。
  </p>
</aside>

請記住，個人生態學是一個不斷演變的實踐，隨著您在開源之旅中的進展而變化。通過優先考慮自我照顧和保持平衡感，您可以有效且持久地貢獻於開源社群，確保自己的幸福以及項目的長期成功。

## 額外資源

* [Maintainer Community](http://maintainers.github.com/)
* [The social contract of open source](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg 
* [How to deal with toxic people](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Rockwood Art of Leadership](https://rockwoodleadership.org/art-of-leadership/)
* [Saying No](https://mikemcquaid.com/saying-no/), Mike McQuaid
* [Governing Open](https://governingopen.com/)
* Workshop agenda was remixed from [Mozilla's Movement Building from Home](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/) series

## 貢獻者

非常感謝所有與我們分享他們經驗和建議的維護者！

本指南由[@abbycabs](https://github.com/abbycabs)撰寫，[@jianan1104](https://github.com/jianan1104)翻譯，並得到以下貢獻者的貢獻：

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious) + 很多人!
