---
lang: zh-hant
title: 透過為開源專案工作而獲得報酬
description: 透過經濟上的補助，支持你在開源專案裡的工作。
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
redirect_from: /zh-tw/getting-paid/
---

## **為何有人尋求經濟上的支持**

很多開源工作都來自志願者的辛勤付出。例如，有人在使用的過程中遇到了臭蟲，就自己著手修正；也有些人單純利用自己的閒暇時間享受維護開源專案所帶來的樂趣。

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/2894642?v=3&s=460" class="pquote-avatar" alt="avatar">
我當時試著尋找一個，單純作為興趣使然的的程式專案，讓我在耶誕假期間有些事情做。（...）我有一台家用電腦，手上沒甚麼其他的資源。在思考了一陣子之後，我決定為一個新的手稿語言撰寫直譯器，這主意我一直放在心上（...）後來我將這門語言叫做 Python。
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["撰寫 Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

有些人為開源貢獻，卻不求報酬，可能的原因有：

* **他們本來就有一份自己熱愛的全職工作**，這可以讓他們在沒有後顧之憂的情況下利用業餘空閒時間來爲開源做貢獻。
* **他們熱衷於沉浸在開源的思考中**，或是純粹享受創作的過程，不想因為有收錢而有要負責的壓力。
* **他們能夠從開源的貢獻中獲得其它好處**，比如獲得名聲、當作自己的作品集或是藉此學習新的技能，又或者是能跟社群互動。

<aside markdown="1" class="pquote">
  <img src="https://avatars1.githubusercontent.com/u/2320?v=3&s=460" class="pquote-avatar" alt="avatar">
  贊助會增加一種需要負責任的感覺，（...）這點對於我們來說很重要，尤其是一個全球性的社群，我們生活在一個快節奏的世界，不接受捐款代表一種想法就是「我覺得我現在更想要的是做一些不一樣的事情。」
  <p markdown="1" class="pquote-credit">
— @alloy, ["爲什麼我們不接受捐贈"](http://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

但是對其他人來說，尤其是正在進行的或者是需要花費大量時間的付出時，能夠取得報酬是人們積極參與開源的唯一理由，無論是專案的需要還是個人原因。

維護熱門的專案是一項很重要的責任，每週需要花上 10～20 小時，而不是每個月花上幾個小時就能搞定。

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/381411?v=3&s=460" class="pquote-avatar" alt="avatar">
  詢問任何一位開源專案的維護者，他們都會告訴你管理一個專案需要投入大量時間。你有使用者、替他們修正錯誤、撰寫新的功能。這些都需要花你的時間去完成。
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["無償勞動的道德哲學與開源軟體社群"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

有償工作也能使各行各業的人創造有意義的貢獻。有些人需要贊助才願意參與開源專案，可能是因為他當前的財務收入不足、身上有債務、或者需要照顧家庭、撫養他人。有能力但在經濟上沒辦法無償貢獻自己時間的人，依然能當個貢獻者。這涉及道德倫理，正如 @ashedryden 在 [無償勞動的倫理和開源軟體社群](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) 一文中所描述的，人們經常誤以為，專案成果都是由那些在事業上已經有成就的人們完成的，這些人得以透過無償貢獻獲得更多的成果，而其他無法負擔無償貢獻的人就會錯失了這樣的機會，不斷負向循環下去，會使得開源社群越來越缺乏多樣性。

<aside markdown="1" class="pquote">
  <img src="https://avatars3.githubusercontent.com/u/9287?v=3&s=460" class="pquote-avatar" alt="avatar">
   開源軟體爲科技業貢獻了巨大的好處，因此也助益了所有的行業。(...) 如果只有運氣好或有執念的人參與開源，那就還有許多潛藏的人才有待發掘。
  <p markdown="1" class="pquote-credit">
— @isaacs, ["金錢與開源"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c#.ftnd5qez0)
  </p>
</aside>

如果正在尋找經濟上的支持，有兩個方法可以參考。透過群眾募資，或是找一能夠爲專案提供資金的組織。

## **為你的貢獻募資**

在今日，無論是兼職或全職，很多人透過開源獲得了報酬。最爲常見的做法就是去找願意爲你付出的時間和工作成果掏腰包的雇主談談。

如果你的老闆使用了該開源專案，贊助的事情自然就比較好談，盡量發揮創意地去向雇主提案。也可能雇主沒有使用到開源專案，但他們有使用 Python ，用來經營一個熱門的專案，吸引有興趣的 Python 開發者，又或者都不是，那老闆也至少營造了一個對開發者友善的環境。

如果你現在還沒有爲開源專案做工作，但是你希望你現在所做得成績開源出來，那麼你可以和你的老闆講，奉勸他將內部的軟體開源。

很多公司都在開發開源專案，從而能夠打造自己的品牌，以及希望僱傭到高質量的人才。

@hueniverse ，舉例來說，有充足的證據證明 [沃爾瑪對開源的投資](https://hueniverse.com/2014/08/15/open-source-aint-charity/)是合理的。 @jamesgpearce 同樣，Facebook的開源專案讓它的招聘顯得[與衆不同](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) :

> 開源能夠與我們Hacker文化密切配合，也能夠和我們的組織融洽。我們詢問員工："在Facebook真的那麼的在意開源軟體？" 超過2/3的人的回答是"yes"。一半的人表示，該計劃對他們爲我們工作的決定作出了積極的貢獻。這可不是一個戲謔的數字，我們希望繼續保持這樣。

如果你所在的公司不贊同這麼做，沒關係，重要的是保持社群和企業活動之間的界限清晰。你要告訴老闆，開源的維持是由全球各地的人所貢獻，要比任何一個公司或某一地域都大的多。老闆會自己作出權衡的。

<aside markdown="1" class="pquote">
  <img src="https://avatars2.githubusercontent.com/u/1445228?v=3&s=460" class="pquote-avatar" alt="avatar">
  獲得開源的工作是一個難得的機會，而你不應該放棄對這個過程的熱情。公司應該爲你的激情付相應的報酬。
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

如果你實在無法在當前的僱主下開展相關開源的工作，那麼是該考慮換老闆的時候，應到找個支持想開源作貢獻的老闆！尋找那些致力於開源工作的公司。比如：

* [Ghost](https://ghost.org/)  就是一家圍繞很多[開源專案](https://github.com/tryghost/ghost)的好公司
* [Zalando](https://opensource.zalando.com) 甚至爲其員工提供了[貢獻開源守則](https://opensource.zalando.com/docs/using/contributing/)

那些大公司發起的專案，如 [Go](https://github.com/golang) 或 [React](https://github.com/facebook/react)，均希望僱傭到優秀的工程師來爲他們工作。

當然最終還是要看你自身的條件而定，你甚至可以利用你的開源專案來獨立的進行融資。這邊就有幾個案例：

* @Homebrew (and [many other maintainers and organizations](https://github.com/sponsors/community)) fund their work through [GitHub Sponsors](https://github.com/sponsors)
* @gaearon 通過 [Patreon crowdfunding campaign](http://redux.js.org/)爲他的專案 [Redux](https://github.com/reactjs/redux)成功的融到了資金。
* @andrewgodwin [通過 Kickstarter campaign](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django) 爲Django schema 遷移拿到了資金

## 為你的專案尋找資助

除了針對個人貢獻者的建議之外，還有一些專案可以從公司、獨立投資方、以及其它的資金處來獲得進一步的工作。

機構資金可能用於支付當前的貢獻者，涵蓋運行專案的成本（如託管費用）或投資於新功能或想法。

一些獲得組織資助的專案案例：

* **[webpack](https://github.com/webpack),**  [通過 OpenCollective](https://opencollective.com/webpack) 從公司和個人來籌集資金
* **[Ruby Together](https://rubytogether.org/),** 由 @indirect 創建的非盈利組織 ，爲諸如 [bundler](https://github.com/bundler/bundler)、[RubyGems](https://github.com/rubygems/rubygems)、以及其它的一些 Ruby 的基礎設施專案提供資金支持

儘管開源日漸的流行，但是爲專案尋找資金仍然是處於試驗中。目前所收集到的包括：

* **通過大力宣傳活動或募捐，爲您的工作籌集資金** 這策略在你擁有足夠的粉絲，或者是已經社群聲譽良好的情況下，又或者是專案非常的受歡迎，等情況下有效。
* **接受基金巨頭的資助** 一些軟體基金會和公司爲開源的相關工作提供很好的機會，如[Python 軟體基金會](https://www.python.org/psf/grants/), [Mozilla 基金會](https://www.mozilla.org/en-US/grants/)、以及[Stripe](https://stripe.com/blog/open-source-retreat-2016).
* **獲得公司或獨立投資商的贊助** 通過軟體基金會，或者是乾脆 **創業** 來支撐專案。

更多的案例和細節， @nayafia [專門寫過一個指南](https://github.com/nayafia/lemonade-stand) ，專門針對的就是如何爲開源工作獲得報酬。不同類型的資助需要不同的技能，所以仔細的掂量下資格，然後找個最適合自己的方式。

## 建立經濟上的支持

無論你的專案是新的創意，還是已經運行多年，你都需要爲你的資助者滿意，並提出有效而合理的案例。

不管是你自己尋找相應的工作，還是爲專案融資，你都應該嘗試回答下面的問題。

### 影響

爲什麼說這個專案有實際用處？你的用戶或潛在的用戶會喜歡它？5年之後它會是什麼樣子？

### 牽引

嘗試着去收集一些和你專案休慼相關的證據，比如指標、有趣的事情、還是其他人的推薦。是否有其它公司或者是業內意見領袖正在使用你的專案？如果沒有的話，是不是應該去找相應的人去推薦下？

### 充分利用資助者的價值

資助者，無論他是僱傭你的老闆，還是一家獲得授權的基金會，你都有機會和他們頻繁的進行接觸。 他們爲什麼會放棄其它機會而去支持你的專案？他們個人有何好處？

### 利用風險投資

您將如何用擬議的資金完成什麼？專注於專案里程碑或成果，而不是支付工資。

### 你將以何種方式接受資助

資助者是否有關於宣傳的額外需求？例如，你可能需要您可能需要成爲非盈利組織或擁有非營利性財政贊助商。又或者是資助者必須給到個人而不是一個組織。這些不同的需求會因爲不同的資助者而異，所以請事先做好準備。

<aside markdown="1" class="pquote">
  <img src="https://avatars1.githubusercontent.com/u/1076721?v=3&s=460" class="pquote-avatar" alt="avatar">
  多年以來，我們一直都是網站友好圖標資源的領先者，社群超過2千萬人，併爲7千萬網站提供資源，其中包括 Whitehouse.gov。 (...) 3年前我們發佈了Font Awesome 的第4個版本。Web技術從那時起改變了更多事情，而且坦率的說Font Awesome 都有點過時。 (...) 這也是我們剛剛發佈 FontAwesome 5的原因之一，我們模塊化和重寫了 CSS，並從上到下重新設計了每一個圖標。我們積極的探討更好的設計、更好的一致性、以及更好的可讀性。
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter 群眾募資影片](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## 嘗試，不要放棄

賺更多的錢不是件容易的事情，無論你是在開源專案，亦或是在非盈利組織，又或者是軟體的創業公司，但是無論在哪裏，掙得更多錢的祕密就是更多的創造力。當確定了你想如何獲得報酬的時候，請繼續你的研究，將自己放在投資人的角度來看問題，可以幫助你更好的構建一個更加令人信服的賺錢之道。
