---
lang: zh-hant
title: 打造友善、溫暖的社群
description: 打造個人們願意使用、貢獻並願意主動宣傳的人氣社群。
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
redirect_from: /zh-tw/building-community/
---

## 讓專案朝成功邁進

現在的你，你已經啓動屬於你自己的專案，正在向世界介紹它，有人對你的專案感到好奇。這真是令人振奮！接下來要考慮的是，如何讓有興趣的人持續地待在這個社群裡。

友善的社群對於專案的未來至關重要，如果你的專案開始有人願意貢獻，記得給這些先行者一個愉快的協作體驗，鼓勵他們持續參與。

### 讓大家感到受歡迎

@MikeMcQuaid 提供了一個思考專案社群的看法稱之為[貢獻者漏斗](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/)

![contributor funnel](https://opensource.guide/assets/images/building-community/contributor_funnel_mikemcquaid.png)

當你建立了自己的開源社群，想想這些處於漏斗上方的人（潛在用戶）是如何下潛到底部（活躍的維護者）。你的目標是減少貢獻者在每個階段所遇到的摩擦。當人們能從中輕易的獲得成就感時，就會樂意去做更多的事。

從你的說明文件開始著手：

* **讓大家很容易上手。** [一份好閱讀的 README](https://github.com/liadbiz/opensource-contribute-guide-chinise/blob/HEAD/github-open-source-guide-02.md#編寫readme)以及清晰的程式碼範例，讓大家很容易的上手。
* **清楚的說明該如何貢獻**，使用[你的CONTRIBUTING file](https://github.com/liadbiz/opensource-contribute-guide-chinise/blob/HEAD/github-open-source-guide-02.md#編寫你的貢獻指南)並持續更新issues。

在 [GitHub 2017 開源調查報告](http://opensourcesurvey.org/2017/)中指出，令人困惑或不完整的說明文件是開源使用者最大的困擾，好的說明文件會吸引人們與專案互動。總有一天，會有人開啟一個 issue 或 PR。盡量使用這些工具讓人們有機會朝漏斗的下方邁進。

* **當有人選擇了你們的專案，記得對他們表示謝意！** 因為可能只是一次不愉快的經歷，就足以讓一些人再也不想回來。
* **及時回應。** 如果一個月都沒有回答他們的 issue，他們可能也早就忘記了你們的專案。
* **以開放的態度接受各式各樣的貢獻。** 很多貢獻者是從提報一份 bug 或者修一些小東西開始的。這裡有[很多為專案做貢獻的方式](../how-to-contribute/#具體而言什麼是貢獻)。讓大家選擇他們喜歡的方式。
* **如果你不贊成一個貢獻。** 首先你需要對他們的想法表示感謝，同時 [解釋為什麼](../best-practices/#學會拒絕他人)這點子不適合專案，如果有必要的話你可以給出相關文件的連結。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  有些人能很自在的在開源工作。也有很多人害怕在社群裡被責備做錯事，害怕自己無法融入社群。（…）通過給貢獻者參與一些技術門檻較低的工作（文件、Web Content Markdown…），能有效地消除參與者的顧慮。
  <p markdown="1" class="pquote-credit">
— @mikeal, ["現代開源專案下如何增加貢獻者"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

多數開源貢獻者是「不固定的貢獻者」，因為他們只是偶爾參與專案。一位不固定的貢獻者可能沒有充裕的時間全程參與你的專案，所以你的工作是能讓他們很輕鬆地參與貢獻。

鼓勵其他的貢獻者也是對專案的一種投資。當你們授權大量的粉絲做他們感興趣的工作時，壓力就會少很多。

### 記錄一切

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  你是否參加過一個（技術）活動，你不認識在場的人，但似乎每個人都在自己的小組裡像老朋友一樣聊天？（…）現在想像，你想為一個開源專案做貢獻，但是你不知道為什麼這樣是辦得到的。

  <p markdown="1" class="pquote-credit">
— @janl, ["持續發展開源"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

當你開始一個新專案，會覺得就私下默默地工作是很正常的。但開源專案真正開始茁壯的時候，是當你開始公開的把你的進度歷程紀錄下來的時候。

把事情記錄下來，會更多的人參與，參與的人也方便能從歷程的每個階段著手。你甚至可能會得到意想不到的幫助。

技術文件只是文件紀錄的一種。任何時刻，你覺得有必要寫下來的事情，或是私下針對專案的討論內容，你都可以想想是不是能將內容公開。

試著盡量讓你的專案規劃保持透明公開：你們期待什麼類型的貢獻者，如何審查貢獻，或者你們做某些決定時的理由。

如果你注意到有很多使用者遇過同樣的問題，那麼你應該將回覆記錄在 README 中。

如果是會議的內容，試著將你的筆記或重點摘要附在相關的 issue 裡頭，這樣的公開方式有時會給你意想不到的回饋。

記錄一切也適用於你的工作。如果你正在進行重要的更新工作，請將它放入 pull request 並標記為正在進行中（WIP）。讓其他人了解，能夠在該工作的初期有參與感。

### 積極迴應

一旦你[推廣專案](https://github.com/liadbiz/opensource-contribute-guide-chinise/blob/HEAD/github-open-source-guide-03.md)，人們將會給你們回饋。他們可能會問專案是如何工作的，或者希望有人教他怎麼使用。

當有人提出一條 issue ，提交一個 pull request ，或詢問專案有關的問題時，你們應該盡快回覆他們。當你們快速地做出反應時，大家會覺得有參與到對話，會有熱情去參與專案。

如果你無法做到及時，至少試著去及早確認，如此一來有助於提高大眾的參與度。以下是@tdreyno在[Middleman](https://github.com/middleman/middleman/pull/1466)回覆的一個pull request：

![middleman pull request](/assets/images/building-community/middleman_pr.png)

[一項 Mozilla 的研究](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) 發現如果貢獻者在48小時內收到代碼審查，他們會有很高的回頭率，且極有可能會再次貢獻。

與專案有關的討論也可能發生在網路的其它地方，例如 Stack Overflow ， Twitter ，或者 Reddit 。你可以在這些網站設定通知，當有人提到你的專案時，可即時的收到提醒。

### 為你們社群提供一個聚會的場所

有兩個理由可以解釋為什麼要給社群提供聚會的場所。

第一個理由是為了貢獻者。讓社群的人相互認識。因為有共同興趣的人一定會想要一個可以聊天的地方。當資訊是公開的而且容易接觸時候，任何人可以透過過去的資料，快速的跟上大家的話題。

第二個理由是為了你自己。如果沒有提供公共場所來談論專案，大家可能會直接與你聯繫。剛開始可能覺得回覆私訊很輕鬆。但是一段時間後，尤其是如果專案變的熱門時，就會感到疲於應付。不要私下和人們討論你們的專案，直接請他們去指定的公共渠道。

公共交流和指引人開一條 issue 一樣簡單，而不是直接發電子郵件或者在你的部落格上留言。為了方便人們談論專案，你可以設置一個郵件列表、創一個 Twitter 賬號， Slack ， IRC 頻道。或者嘗試以上所有的方式。

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) 每隔一週抽出辦公時間來協助社群成員：

> Kops 每隔一週都會提供晤談時間，為社群提供幫助和指導。 Kops 維護者約定好留出一些時間專門與新手一起工作，處理 PR，以及討論新的功能。

此外請謹記，有一些事情反而是不適合公開討論的：1）有關資安方面的 issues 2）嚴重違規準則的行為。你應該為大家提供一個私下討論這些 issue 的方式。若不想用自己的個人信箱，那麼就設一個專用的郵箱

## 讓社群成長茁壯

社群擁有強大的能量。這種能量可能是正面的也可能是負面的，一切都取決於你如何駕馭它。隨著社群的成長，要想辦法讓之成為建設性的力量，而非具有破壞性的。

### 不要容忍來者不善的人

熱門的專案都不可避免地會吸引到想破壞社群的人。他們可能會從一些不必要的爭論開始，對一些細枝末節糾纏不清，或用語言傷害他人。

對於這些人，必須採取零容忍的政策。一旦猶豫不決，那麼這些負面的人會給社群的其他人帶來不愉快的感覺。甚至出現劣幣驅逐良幣的現象。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  專案成功的關鍵在於擁有一個能互相支持的社群。如果沒有我的同事、網路上友善的陌生人以及聊天頻道 IRC 的幫助，我不可能做好這些工作。(...）不要退而求其次。不要容忍來搗亂的人。
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["如何運營一個 FOSS 專案"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

對專案的顯而易見的問題進行定期辯論，會分散別人的注意力，包括你自己，新人如果看見這樣的情景，他們可能不會加入到專案中來。記得要將精力放在重要的任務上。

當發現社群中有負面的行為時，要即時、公開的指出來。要用堅定的語氣解釋他們的行為為什麼是不可接受的。如果問題持續發生，你有必要 [請他們離開](../code-of-conduct/#蒐集有關違規的資訊) 。你的 [行為準則](../code-of-conduct/) 是為這些情境準備的建設性指南。

### 知道貢獻者在哪裡

隨著專案的成長，好的說明文件會變得愈加重要。不固定的貢獻者或路人不可能一下子就對專案非常熟悉，一份好的文件，能讓他們很快地找到他們需要的資訊。

在 CONTRIBUTING 文件裡，需要明確告訴新來的貢獻者該如何使用。為了想要達到這個目的，你也許會想要設立一個專區說明。

![django new contributors page](/assets/images/building-community/django_new_contributors.png)

試著對每個 issue 標上標籤，為不同類型的貢獻者做指引：例如，[_"僅供入門者"_](https://kentcdodds.com/blog/first-timers-only), _"適合新手的Bug"_, 或者 _"說明文件"_. [這些標籤](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14)能夠幫助新人快速瀏覽 issues 並且著手開始。

最後，試著撰寫易讀的說明文件讓人們在每一步的過程中都很流暢。

你不可能與專案中大多數的人互動，因為有些人怕犯錯，或不知道該從何處開始，結果就可能讓你錯失獲得貢獻的機會。但有時候也只是幾個字，就能避免一些人沮喪地離開你們的專案。

例如[Rubinius](https://github.com/rubinius/rubinius/)在[它的貢獻指南](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md)開頭寫道：

> 我們感謝你們使用 Rubinius 。這專案是個充滿愛的工作，我們感激所有參與的人，不論是為我們抓 bug 、提升性能或完善說明文件。每一個貢獻都是有意義的，感謝你們的參與。話雖如此，我們還是要求參與者遵守一些指南，如此一來我們也才能夠回覆你們的 issue 。

### 分享專案的所有權

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  社群的領導者們有著不一樣的意見，這也是所有健康的社群能夠成長的原因！然而，你也必須在每個環節確保，大多數人的意見不會總是蓋過其他見解，讓傑出的、少數人的意見也能被聽見。
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["是什麼成就一個好的社群？"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

當大家覺得自己也是專案的主人之一時，就會非常樂意為專案付出。這並不代表就要去調整專案的願景，又或者代表要接受你不要的貢獻。但是社群越信任他們，他們就會越樂意待在這。

試著找一些方法向社群分享你的所有權，這裡有一些經驗和大家分享：

* **不要親自去修簡單（不嚴重）的錯誤。** 相反，將這些錯誤作為招募新貢獻者的工具，或指導有意貢獻付出的人。剛開始可能會覺得過程很不自然，但一段時間你會得到想要的結果。例如，在[Cookiecutter](https://github.com/audreyr/cookiecutter) 的一則 issue 下面， @michaeljoseph 要求貢獻者提交一個 pull request ，而不是親自處理它。

![cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **在專案中添加一個貢獻者列表或者作者列表** 記錄每一個參與貢獻的人。

* 如果社群有了一定的規模，就 **發送一封信或者發表一篇文章** 感謝貢獻者們。[Rust 週報](https://this-week-in-rust.org/)和 Hoodie 的[Shoutouts](http://hood.ie/blog/shoutouts-week-24.html)就是兩個非常好的範例。

* **給每個貢獻者提交的權限。**@發現這樣會使大家[越來越樂意發表他們的補丁](https://felixge.de/2013/03/11/the-pull-request-hack.html)，甚至找到人手來協助維護他已很久沒處理的專案。

* 如果專案是放在 GitHub 上，那麼 **將專案從你們的個人賬號轉移到一個[組織](https://help.github.com/articles/collaborating-with-groups-in-organizations/)**，加入至少一個備份管理員。組織能讓社群與來自外界的貢獻，彼此協作的工作變得更加容易。

事實上很多專案[只有一個或者兩個維護者](https://peerj.com/preprints/1233/)去做大部分的工作。隨著社群變得越來越大，就會有更多的人參與進來。

雖然並不是一直都有人在回答問題，但是你可以去試著增加一些機會，讓他人有能夠參與的機會，越是儘早開始，越是能夠獲得幫助。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  對社群最有利的做法是招募喜歡你們專案的人，而且這個人還能夠做你們做不到的事情。你是否喜歡寫程式，但不喜歡回覆 issue ？ 那就讓社群裡能做這件事的人去做。
  <p markdown="1" class="pquote-credit">
— @gr2m, ["打造溫暖的社群"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## 化解衝突

在專案的一開始，做決定是蠻容易的事。想做什麼就放手去做吧。

隨著專案變得熱門，會有更多人對社群的決策感興趣。如果專案有很多使用者，你會發現大家都很關心決策，或者踴躍的提交他們的 issue ，即使社群沒有很多貢獻者。

大多數情況下，如果你們經營了一個友善、受尊重的社群並紀錄社群歷程公開給大家知道，社群應該能自己找到解決方案。但有時也會遇到難以處理的麻煩。

### 建立友好的氛圍

當社群正熱烈討論一個困難的 issue 時，火氣可能會不小。人們可能會為此憤怒或者沮喪，甚至會做出直接的人身攻擊。

身為一名維護者的工作就是別讓這種情況惡化。即使你對該話題有自己強烈的看法，也要盡量擔任一個仲裁者或推動者的角色，而非跳下去參與爭論以及推動自己的觀點。如果有人態度不好或者嘗試壟斷話題，那麼請[立即採取行動](https://ocselected.github.io/open-source-guide/building-community/)，讓討論保持它應有的禮節，讓討論是有意義的。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  作為一名維護者，尊重你們的貢獻者是一件重要的事。他們經常會感情用事的去看待你的意見。

  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["保持和善，要麼滾蛋"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

一些人希望得到指導。試著當一個好典範。當然你仍然可以表達失望、不高興或者憂慮，但得心平氣和。

保持不慍不火並不容易，但是展現領導力能促進社群健康的發展。網路世界感謝你們的付出。

### 視 README 為最高原則

README [不僅僅是指導手冊](../starting-a-project/#編寫自述文件)。它也是一個談論目標、願景和路線的地方。
如果人們放太多精力在討論特定功能的優點，這時重新審視 README 並討論遠景也許會比較有幫助。關注 README 也能讓大家就事論事的去討論，讓對話變得有建設性的。

### 專注過程，而不是結果

一些專案用投票的方式做重要決定。雖然乍看之下覺得這樣是合理的作法，但投票強調的是得到一個「答案」，而不是傾聽以及理解每個人的顧慮。

投票會變成政治，不論是在往後互助的過程中，或是投票時，社群成員都會備感壓力。而且不是每個人會參與投票，可能你們的社群[保持沉默的人佔多數](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users)，或甚至使用者根本不知道投票這件事正在發生。

有時投票是必要的手段。盡你們所能的強調[「尋求共識」](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making)而不是要獲得共識本身。

尋求共識的過程中，社群成員討論關心在乎的事，直到他們覺得意見已經獲得充分的表達。當僅剩下一些次要的議題時，社群就往前邁進。「尋求共識」不能確保社群能得到一個完美的解答。而是側重聆聽和討論。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
Atom 專案的 Issues 沒有投票機制，因為 Atom 團隊並不會遵循投票的結果。有時我們必須選擇我們認為是對的事，即使它不是主流看法。（...）我能做的是傾聽社群的意見，這也是我能保證提供的服務。

  <p markdown="1" class="pquote-credit">
— @lee-dohm on Atom 決策流程
  </p>
</aside>

即使不全然採用尋求共識的方式，身為一名維護者，讓人們知道你願意傾聽意見是一件很重要的事。讓其他人知道意見有被聽見，並且承諾解決他們的問題，這很大程度上減少了棘手情況的發生。接著言出必行的去採取行動。

不要為了得到解決方案而急於做出決定。在有所行動前請確保每個人已經知情，保持所有的資訊公開。

### 將對話重點聚焦於行動

討論很重要，但是有成效和沒有效果的對話是有很大區別的。

鼓勵討論，只要它正積極地朝著解決問題的方向前進。如果你很清楚地發現對話已經漸漸停滯下來、偏離主題、溝通開始對人對不對事或在小細節上鑽牛角尖，那就是時候該結束對話了。

允許上述的這些對話進行下去，不僅無法解決問題，還不利於社群的健康發展。這樣讓大家認為這類的對話是被允許甚至是被鼓勵的，它可能阻礙了人們往後提問的意願或者在解決之後的問題上產生困擾。

當你或其他人每次提出想法時，問問自己：「這發言如何使我們更接近一個解決辦法？」

如果對話開始有發散的徵兆，問問團隊：「我們下一步該做什麼？」才能重新聚焦討論。

如果一個對話沒有清楚的方向，也會沒有明確的辦法可以執行，又或者合適的解決辦法已經被採納，那麼就結束 issue 並解釋為什麼結束它。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
如何循循善誘的將討論串引導到有益的方向，是一門藝術。直接要求人們不要發沒有建設性的文，要大家別浪費彼此的時間，這樣做是沒有效的。（...）反而，你必須設立一些限制條件，給大家一個方向，讓大家的意見最終導向成你所期待的結果，這樣就不像是無用的口頭訓斥。

  <p markdown="1" class="pquote-credit">
— @kfogel, [_打造開源軟體_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### 謹言慎行

了解來龍去脈很重要。想想誰正在參與討論，以及這些人如何代表社群的其他人。

社群的每個人都是否參與討論？大家是否對這個議題感到困擾？還是有人在搗亂？記得不僅要關心有發言的人，也要記得為社群中保持沉默的人考量。

如果這個議題不代表社群普遍的需求，你們可能要理解這只是少數人的疑慮。如果這是一個反覆出現的 issue ，而且直到現在還是沒有一個明確的解決辦法，那麼指引他們去看看以前討論的內容，並結束這個討論串。

### 找出社群中的決策者

保持態度良善，維持目標清晰的對話，很多困難都可以被解決。但即便在富有建設性的對話中，還是可能會對該如何執行有不同的意見。在這樣的情況下，你要找找看是否有一個人或一組人，可以擔任決策者。

負責做出決策的人可能是專案的主要維護者，或者是大家投票選出的一個團體。理想情況下，事前要先確定決策者是誰和與之相關的事宜，寫在 GOVERNANCE 文件以便不時之需。

使用決策者應該是你們最後的手段。區分這些 issues 是一個社群成長和學習的機會。利用這些機會協作，儘量找出問題的解決辦法。

## 社群是開源的❤️

健康，蓬勃的社群每週都會為開源注入大量的動力。許多貢獻者指出，開源專案的其他成員是促成他們參與（或導致不參與）的主要因素。通過學習如何建設性地利用這股力量，你會在協助的過程中讓他人有個難忘的開源體驗。
