---
lang: zh-hans
untranslated: true
title: 保持开源维护者的平衡
description: 作为维护者的自我护理和避免倦怠的技巧。
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

当一个开源项目越来越受欢迎时，设定清晰的边界来帮助您长时间保持活力和生产力就变得尤为重要了。

为了深入了解维护者的经验及他们如何找到工作平衡，我们与<a href="http://maintainers.github.com/">维护者社区</a>的 40 名成员举办了一个 workshop。通过这样的方式，我们得以学习到他们在开源领域所经历的疲劳过度的第一手情况，以及他们采取了哪些实践来在工作中维持平衡。这正是"个人生态学"概念得以应用的场景。

那么，个人生态学是什么？根据 <a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance%2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">Rockwood Leadership Institute 的描述</a>，它是"<strong>在我们的一生中，维持平衡、节奏和效率以保持能量</strong>”。这种观点为我们的交流提供了一个结构，帮助维护者意识到随时间发展，他们的行为和贡献是一个更大的生态系统中的组成部分。根据[世卫组织的定义](https://icd.who.int/browse11/l-m/en#/http://id.who.int/icd/entity/129180281)，由长时间的工作压力引起的综合症状，即"疲劳过度"，在维护者中并不罕见。这常常会导致失去工作动力、无法集中精力，以及对与之合作的贡献者和社区感到缺乏同情和理解。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  我无法集中注意力或开始任务。我对用户缺乏同情心。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>，Owncast 直播服务的维护者，谈到疲劳对他的开源工作的影响
  </p>
</aside>

通过理解个人生态学的理念，维护者可以主动避免疲劳，把自我护理放在首位，并保持心态平和，从而更好地工作。

## 作为维护者的自我护理和避免疲劳的提示：

### 确定您参与开源工作的动机

花时间思考哪些开源维护任务能激发您的热情。明白自己的驱动力可以帮您更有针对性地安排工作，保持热情并随时迎接新挑战。不论是用户的正面反馈、与社区的互动乐趣，还是深入探索代码带来的成就感，了解这些驱动力都能帮助您更好地集中精力。

### 反思什么使您失去平衡并感到压力

知道哪些因素导致我们感到疲倦是非常关键的。以下是在开源维护者中常见的一些情况：

* **缺乏积极的反馈：** 用户在遇到问题时更容易给出反馈。而当一切正常时，他们往往不会说什么。看到问题列表不断增长，而缺乏正面反馈来展示您的贡献所带来的改变，这可能会让人感到挫败。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  有时，我觉得自己有点像在虚空中大喊大叫，但我发现反馈意见真的让我充满活力。我们有很多快乐但安静的用户。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>，Apache Arrow 的维护者
  </p>
</aside>

* **不说'不'：** 在开源项目中，很容易承担超过自己能力范围的责任。不论是来自用户、贡献者还是其他维护者，我们不能始终满足每个人的期望。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
  我发现自己承担的工作超出了一个人的职责范围，不得不像 FOSS 中常见的那样，完成多人的工作。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>，Termux 的维护者，谈论他们工作中导致疲劳的原因
  </p>
</aside>

* **独自工作：** 作为维护者可能会感到很孤单。即使你与一群维护者合作，过去几年也很难召集分布在各地的团队。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
 特别是自从 COVID 和居家办公后，再也见不到人或和人说话就更难了。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>，Owncast 直播服务器的维护者，谈论疲劳对他的开源工作的影响
  </p>
</aside>

* **时间或资源不足：** 对于那些不得不牺牲自己休息时间来参与项目的志愿维护者来说，这尤其是真实的。

<aside markdown="1" class="pquote">
  [我希望]能得到更多的经济支持，这样我可以全心投入到开源工作中，而不是消耗掉自己的储蓄，然后担心未来需要做大量的工作来补偿这一损失。
  <p markdown="1" class="pquote-credit">
— 开源维护者
  </p>
</aside>

* **需求冲突：** 开源社区有很多出于不同目的而参与的团队，这有时会难以处理。如果您是被雇来进行开源工作的，那么您的雇主的利益有时与社区的利益可能不会完全一致。

<aside markdown="1" class="pquote">
  在有偿的开源工作中，雇主的关注点和对社区最有益的事物之间可能会存在矛盾。
  <p markdown="1" class="pquote-credit">
— 开源维护者
  </p>
</aside>

### 注意疲劳的迹象

这样的节奏你能保持多久？10周？10个月？还是10年？

有像 [@shaunagm](https://github.com/shaunagm) 的 [Burnout Checklist](https://governingopen.com/resources/signs-of-burnout-checklist.html) 这样的工具可以帮助你反思自己现在的工作节奏，看是否需要进行某些调整。一些维护者还利用可穿戴设备来监测睡眠质量和心率变异性等与压力有关的指标。

<aside markdown="1" class="pquote">
 我深信好的可穿戴设备的作用。有了其背后的科学依据，你可以了解如何更好地调整自己，达到完成任务的最佳状态。
  <p markdown="1" class="pquote-credit">
— 开源维护者
  </p>
</aside>

### 您需要什么来继续支撑自己和您的社区？

对每位维护者而言，这都会有所区别，并且会随着您的生活阶段和其他外部因素发生变化。但以下是我们收到的一些共同点：

* **依赖社区：** 分配任务和寻找贡献者可以帮助减轻你的负担。对一个项目而言，有多个协作者能让你放心休息。与其他维护者以及更广大的社区，如 [Maintainer Community](http://maintainers.github.com/) 建立联系，这对于获得同行的支持和学习都是宝贵的资源。

  您还可以探索与用户社区的交互方式，这样可以定期收到反馈，了解您在开源工作中所做的贡献的影响。

* **寻找资金：** 不管您是想找点小钱买披萨，还是计划全职投身开源，都有众多资源可供参考！首先，可以考虑开通 [GitHub Sponsors](https://github.com/sponsors) 让其他人赞助您的开源项目。如果您打算全职转型，可以申请下一期的 [GitHub Accelerator](http://accelerator.github.com/)。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
我曾参与一个播客，其中我们谈到了开源维护和可持续性。我发现，尽管只有少数人支持我在 GitHub 的工作，但这也帮助我做出了迅速的选择，放下游戏前端的工作转而去做一些小的开源贡献。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>，EmberJS 的维护者
  </p>
</aside>

* **使用工具：** 考虑使用像 [GitHub Copilot](https://github.com/features/copilot/) 和 [GitHub Actions](https://github.com/features/actions) 这样的工具，自动化常规任务，从而为更有价值的工作腾出时间。

<aside markdown="1" class="pquote">
 使用 [Copilot](https://github.com/features/copilot/) 来处理无聊的事情 - 做有趣的事情
  <p markdown="1" class="pquote-credit">
— 开源维护者
  </p>
</aside>

* **休息和充电：** 留出时间享受开源之外的爱好和兴趣。利用周末休息和充电，并调整您的 [GitHub status](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status) 来显示您是否在线！良好的睡眠对于长期保持工作热情和效率至关重要。

  如果您发现项目中某些部分特别令人享受，试着调整您的工作，这样您每天都可以体验到这种愉悦。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class="pquote-avatar" alt="avatar">
我发现在一天当中找到更多机会去散播"创意时刻"比起在晚上尝试放松更为有益。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>，Nuxt 的维护者
  </p>
</aside>

* **设定界限：** 您不能对每个请求都回应"好"。您可以简单地回答："我现在做不到，而且未来可能也不会这么做。"或者在 README 中明确列出您愿意做和不愿意做的事情。例如，您可以写："我只会合并那些清晰解释了为何创建的 PR。”或者，"我只在每两周的星期四的6-7点审查问题。”这样可以为他人设定预期，并在其他时间为您提供一个可以参考的依据，从而减少贡献者或用户对您时间的要求。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
为了在这些方面真正赢得他人的信任，你不能是一个对每个请求都说"是"的人。这样做意味着你没有设定职业和个人的界限，也难以成为一个可靠的合作伙伴。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>，Homebrew 的维护者在 [Saying No](https://mikemcquaid.com/saying-no/) 上
  </p>
</aside>

学会坚决制止有毒的行为和消极的互动。不对你不在乎的事情投入精力是完全可以的。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
我的软件是免费的，但我的时间和精力不是。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>，Leaflet 的维护者
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
开源代码维护工作有其阴暗面，这已经不是什么秘密了，其中之一就是有时不得不与那些忘恩负义、有权有势或完全有毒的人打交道。随着项目受欢迎程度的提高，这种互动的频率也会增加，从而加重维护者的负担，并可能成为维护者倦怠的一个重要风险因素。
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/foosel">@foosel</a>，Octoprint 的维护者，在[如何应对有毒的人](https://www.youtube.com/watch?v=7lIpP3GEyXs)上
  </p>
</aside>

请记住，个人生态是随着您在开源之旅中不断前行而演变的持续实践。通过把自我护理和保持平衡放在首位，您可以为开源社区提供持续有效的贡献，确保自己的健康和项目的长久发展。

## 额外资源

* [Maintainer Community](http://maintainers.github.com/)
* [开源的社会契约](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg
* [如何应对有毒的人](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Rockwood领导艺术](https://rockwoodleadership.org/art-of-leadership/)
* [说"不"](https://mikemcquaid.com/saying-no/), Mike McQuaid
* [Governing Open](https://governingopen.com/)
* Workshop 议程改编自 [Mozilla's Movement Building from Home](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/) 系列活动

## 贡献者

非常感谢所有与我们分享经验和技巧的维护者！

本指南是由[@abbycabs](https://github.com/abbycabs)编写的，由以下人员贡献：

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious) + many others!
