---
lang: zh-hans
title: 为项目寻找合适的用户
description: 通过找到称心如意的用户，帮助开源项目成长。
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
redirect_from: /zh-cn/finding-users/
---

## 四处传播

当你创建了一个开源项目时，并没有规定你要如何宣传它。也不是说你要默默地维护你的项目。相反，如果你希望更多人发现并使用你的开源项目，你应该大胆地让所有人知道你的努力！

## 发出你的声音

你在开始宣传你的项目之前，应该解释你的项目是做什么的，以及大家为什么需要它?

你的项目有什么与众不同或者有趣的地方，如果你自己心中明白这些问题会让你更容易地说服别人。

请牢记一点，别人之所以会使用你的项目，甚至为你的项目做贡献，是因为你的项目解决了他们的问题。所以你需要找出他们的痛点，然后把它当成你项目的卖点或者说价值所在。

举个例子，[@robb](https://github.com/robb)用代码实例来清晰的阐述为什么他的项目 [Cartography](https://github.com/robb/Cartography) 是有用的。

![cartography readme](/assets/images/finding-users/cartography.jpg)

如果你想深入了解如何挖掘项目的"卖点"，看一下 Mozilla 的 ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/)，学习如何建立用户形象。

## 帮助用户发现并关注你的项目

<aside markdown="1" class="pquote">
  你最好有一个唯一的官方"主页"链接用来宣传，引导人们关注你的项目。你不需要找炫酷的模板或者域名，但是你的项目确实需要一个入口。
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

通过引导他们到一个唯一的官方地址来帮助人们发现和记住你的项目。

**要有一个宣传的主阵地**。一个 Twitter 账号、GitHub 链接或者 IRC 频道是引导人们查看你项目的简单方式。这些方式也将会给你后续成长起来的社区有一个讨论的地方。

如果你目前还不想给你的项目搞这么多乱七八糟的东西，只想在合适的时候再宣传你的 Twitter 账户和 GitHub 账户即可。举个例子，当你在某次讨论或者活动上发言时，你可以在简介或者幻灯片上写上这些信息。这样人们就会了解你或者关注你的项目。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  我之前的一个失误就是没给项目开一个 Twitter 账户。Twitter 是一个让人们了解项目进展的好渠道，也可以让人们持续地接触你的项目。
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**考虑给你的项目做个网站**一个网站可以让你的项目更加友好，也更加容易浏览，更重要的是附上清晰的文档和教程。这也证明你的项目是活跃的，会让你的用户更放心地使用项目。可以用一些例子告诉人们如何使用你的项目。

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), Django 的作者说，我们给 Django 做的网站可以说是"在早期开发 Django 的时候做的最好的一件事情了"。

如果你的项目是托管在 GitHub 上的，你可以用 [GitHub Pages](https://pages.github.com/) 简单创建一个网站。[Yeoman](http://yeoman.io/)、[Vagrant](https://www.vagrantup.com/) 和 [Middleman](https://middlemanapp.com/) 是一些内容详细的优质网站[示例](https://github.com/showcases/github-pages-examples)。

![vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

现在你的项目有了"卖点"和容易被人们发现的渠道，接下来我们谈谈如何与你的用户交流吧！

## 在网上寻找你项目的用户

网络社区与论坛是分享和快速宣传项目的一个好地方。借助这些渠道，你有可能找到一大批受众。

利用好已有的线上社区和平台去找你的受众。如果你的开源项目是一个软件项目，你可以在 [Stack Overflow](https://stackoverflow.com/)、[reddit](https://www.reddit.com)、[Hacker News](https://news.ycombinator.com/) 或 [Quora](https://www.quora.com/) 找到可能从你的项目中受益或者感兴趣的话题。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  每个程序都会有一些方法是只有一部分人才用得到的，所以不打扰到所有人，把你的关注点放在可能会从你项目受益的话题就好。
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

看看下面的这些方法，获取在宣传你的项目时用得着。

* **快速找一下有没有相关的开源项目和社区**。有时候，你不要直接宣传你的项目。如果你的项目对使用 Python 的数据科学家来说是无可挑剔的，那么就去 Python 数据科学的社区宣传。等他们知道你的项目之后，很自然的就会谈论然后分享你的成果。
* **如果你的项目能够解决特定问题，找到会遇到这些问题的人**。想想你的项目受众会在哪些论坛，然后搜索这些论坛，回答他们提出的问题，然后找一个合适的时机，向他们建议使用你的项目来作为一种解决方案。
* **寻求反馈**。向可能会用到你项目的人介绍你自己和你的项目。请确保这些人是从你项目中受益的人。试着完善下面这句话："我觉得我的项目能够帮助到 A，或者那些尝试做 B 事情的人"。不要只是简单地宣传，更需要学会倾听和回复别人的反馈。

通常，你应该先想着帮助别人而不是获取回报。因为在网上宣传一个项目对任何人来说都很简单，所以肯定会有很多人在做同样的事情。告诉人们你是谁，而不是你想要什么，这样才能从众多宣传者中脱颖而出。

如果没有人对你的宣传感兴趣，不要灰心！大部分项目的发展都可能需要花费数月甚至数年。如果你开始的宣传没收到任何反馈，尝试换一种策略，或者想办法给别人的项目做贡献。这些都是需要时间和奉献精神的。

## 在线下寻找你的项目用户

![public speaking](/assets/images/finding-users/public_speaking.jpg)

线下活动是向观众宣传新项目的常见方式之一。这是一个接触忠实倾听者，建立深层次联系的好方法，如果你对到场的开发者感兴趣的话那就更好了。

如果你还是个[公开演讲的新手](https://speaking.io/)，找一个你项目使用的语言或者生态系统相关的线下聚会去尝试吧。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  我去 PyCon 的时候非常紧张。我要发表一次演讲，在那儿我只认识几个人，还是在那儿呆了整整一周。其实我不应该焦虑的。PyCon 真是太棒了！每个人都是非常友好热情，以至于我也非常愿意和大家讨论。
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

如果你从来没在公共场合演讲过，感到紧张是很正常的！记住你的听众和你在一起，他们都是真正想听你介绍你的项目。

当你在写你演讲稿的时候，把重点放在你的听众会感兴趣而且有价值的事情上。保证你的语言要友好且亲切。笑一笑，深呼吸，幽默一点儿。

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  你写演讲稿的时候，不管你的主题是什么，如果你能把你的演讲当成是给别人讲故事的话，效果会更好。
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

等你准备好了，考虑在某个会议上发言的时候宣传你的项目讨论可以帮助你接触更多人，可能会是来自世界各地的人。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  我非常认真地给 JSConf 的人写了一封信，然后请求他们给我一点时间在 JSConf 上展示我的项目。同时我也会担心，这个项目我做了六个月，如果大家不认可怎么办。那时候我就一直在想，我的天，我在这里都干些什么事啊？
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## 建立声誉

除了上面提到的策略之外，邀请人们分享和支持你的项目的最好办法就是分享和支持他们的项目。

帮助新手，分享资源，认真地给别人的项目做贡献，会帮助你建立起良好的声誉。然后他们就很有可能知道你的项目而且更有可能关注和分享你在做的事情。

有时候，这些关系还会进一步发展成更宽泛的生态中的官方合作伙伴（意思是你有可能成为那些知名社区的成员）

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  urllib3 现在成为最流行的 Python 第三方库的唯一原因就是大家都需要它。
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

种一棵树最好是在十年前，也是现在。所以任何时候开始建立你的声誉都不晚。即使是你是在很久以前建立的项目，也需要继续维护它并找办法帮助别人。

建立用户基础并不是一蹴而就的。获取别人的信任和尊重需要时间，同样，建立声誉也需要一直坚持下去。

## 保持下去!

有时候，让人们关注你的开源项目会花费很多时间。没关系！一些今天很流行的项目都是花了很多年才有如今的高活跃度的。把重点放在建立声誉上而不要企图一夜成名。保持耐心，请一如既往地和那些可能会从中受益的人分享你的项目。
