---
lang: tr
title: Açık Kaynağa Nasıl Katkıda Bulunulur
description: Açık kaynağa katkıda bulunmak ister misiniz? İlk defa yapacaklar ve tecrübeliler için katkı yapma rehberi.
class: contribute
order: 1
image: "/assets/images/cards/contribute.png"
related:
  - beginners
  - building
---

## Açık kaynağa neden katkıda bulunmalıyım?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar"> 
  \[Freenode\] üzerinde çalışmak, daha sonra üniversitedeki çalışmalarımda ve gerçek işimde kullandığım becerilerin çoğunu kazanmama yardımcı oldu. Açık kaynak kodlu projeler üzerinde çalışmanın projeye yardım ettiği kadar yapana da yardımcı olacağını düşünüyorum!
  <p markdown="1" class="pquote-credit">
- @errietta, ["Açık kaynaklı yazılımlara katkıda bulunmayı neden seviyorum"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Açık kaynağa katkıda bulunmak, hayal edebileceğiniz herhangi bir konuyu öğrenmek, öğretmek ve deneyim geliştirmek için faydalı bir yol olabilir.

İnsanlar neden açık kaynağa katkıda bulunur? Bunun bir sürü sebebi vardır!

### Güvendiğiniz yazılımı geliştirme

Açık kaynak projelere katkıda bulunanların birçoğu projeyle kullanıcısı olarak tanışırlar. Kullandığınız açık kaynak bir yazılımda bir hata bulduğunuzda, kendiniz yamalayıp düzeltip düzeltemeyeceğiniz görmek için kaynağa bakmak isteyebilirsiniz. Bu durumda, yamanın yapılmasına katkıda bulunmak, arkadaşlarınızın (ve bir sonraki sürüme geçtiğinizde kendinizin de) bundan faydalanmasını sağlamak için en iyi yoldur.

### Mevcut becerileri geliştirme

Kodlama, kullanıcı arayüzü tasarımı, grafik tasarımı, yazma veya düzenleme gibi konularda pratik arıyorsanız, herhangi bir açık kaynak projede sizin için mutlaka bir görev vardır.

### Benzer şeylerle ilgilenen insanlarla tanışma

Sıcak, misafirperver topluluklarla açık kaynak projeler insanları yıllarca müdavimleri yaparlar. Pek çok insan, konferanslarda ya da açık kaynak projelerine katılarak, farklı konularla ilgili çevrimiçi gece sohbetlerine gireyecekleri ömür boyu sürecek arkadaşlıklar kurarlar.

### Mentor bulma ve başkalarına öğretme

Paylaşımlı bir projede başkalarıyla çalışmak demek, işlerinizi nasıl yaptığınızı açıklamanın yanı sıra diğer insanlardan yardım istemek demektir. Öğrenme ve öğretme eylemleri, katılan herkes için tatmin edici bir aktivite olabilir.

### İtibarınızı (ve kariyerinizi) geliştirmenize yardımcı olacak eserler oluşturma

Tanım olarak, açık kaynak kodlu çalışmaların tamamı kamuya açıktır; yapabileceklerinizin bir göstergesi olarak herhangi bir yerde göstermek için ücretsiz örneklere sahip olursunuz.

### İnsani beceriler kazanma

Açık kaynak, çatışmaları çözmek, ekipleri organize etmek ve işlerin önceliklerini yönetmek gibi liderlik ve yönetim becerilerini uygulama fırsatları sunar.

### Küçük bile olsa değişiklik yapabilme gücü verir

Açık kaynak geliştirmekten zevk alabilmek için ömür boyu katkıda bulunmanız gerekmez. Hiç bir web sitesinde bir yazım hatası gördünüz ve birisinin düzeltmesini dilediniz mi? Açık kaynak bir projede, bunu siz yapabilirsiniz. Açık kaynak, insanların yaşamları ve dünyayı nasıl tecrübe ettikleri konusunda kendilerini etkin hissetmelerine yardımcı olur ve bu kendi içinde memnuniyet vericidir.

## Katkıda bulunmak ne demektir?

Açık kaynaklı bir projeye ilk defa katkıda bulunuyorsanız, bu süreç korkutucu olabilir. Doğru proje nasıl bulunur? Ya nasıl kodlanacağını bilmiyorsan? Ya bir şeyler ters giderse?

Endişe etmeyin! Açık kaynak kodlu bir projeye dahil olmanın çok farklı yolları vardır ve birkaç ipucu deneyiminizden en iyi şekilde yararlanmanıza yardımcı olacaktır.

### Kod yazarak katkıda bulunmak zorunda değilsin

Açık kaynağa katkıda bulunma konusunda yaygın bir yanılgı, kod yazarak katkıda bulunmanız gerektiğidir. Aslında, genellikle [en çok ihmal edilen veya göz ardı edilen](https://github.com/blog/2195-the-shape-of-open-source) projenin diğer kısımlarıdır. Bu tür katkılara katılmayı teklif ederek projeye _büyük bir_ iyilik yapacaksınız!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  CocoaPods'taki çalışmamla ünlüydüm, ama çoğu insan CocoaPods aracının kendisinde gerçek bir iş yapmadığımı bilmiyor. Projedeki zamanım çoğunlukla belgeleme ve markalaşma gibi şeyler yapmakla geçiyor.
  <p markdown="1" class="pquote-credit">
- @orta, ["Varsayılan olarak OSS’ye taşıma"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Kod yazmayı sevseniz bile, diğer katkı türleri de bir projeye katılmak ve diğer topluluk üyeleriyle tanışmak için harika bir yoldur. Bu ilişkileri kurmak size projenin diğer bölümlerinde de çalışma fırsatı verecektir.

### Etkinlik planlamayı sever misiniz?

* [NodeSchool için @fzamperin yaptığı gibi](https://github.com/nodeschool/organizers/issues/406), proje hakkında atölye çalışmaları veya buluşmalar düzenleyin
* Projenin konferansını düzenleyin (eğer varsa)
* Topluluk üyelerinin doğru konferansları bulmasına ve konuşma için öneriler sunmasına yardımcı olun

### Tasarlamayı sever misiniz?

* Projenin kullanılabilirliğini geliştirmek için şablonları yeniden yapılandırın
* [Drupal'ın önerdiği gibi](https://www.drupal.org/community-initiatives/drupal-core/usability), projenin navigasyonunu veya menülerini yeniden düzenleyin ve bunu yapmak için hassas kullanıcı araştırması yapın
* Projenin tutarlı bir görsel tasarıma sahip olması için bir stil rehberi hazırlayın
* [Hapi.js’in katılımcılarının yaptığı gibi](https://github.com/hapijs/contrib/issues/68) t-shirtler veya yeni bir logo tasarlayın

### Yazmayı sever misin?

* Proje dokümantasyonunu yazın ve geliştirin
* Projenin nasıl kullanıldığını gösteren örnekler oluşturun
* Proje için bir bülten başlatın veya posta listesinden önemli noktaları açığa çıkarın
* [PyPA'nın katılımcılarının yaptığı gibi](https://packaging.python.org/) proje için dersler yazın
* Projenin dokümantasyonu için çeviri yapın

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Cidden, \[belgeleme\] çok önemlidir. Şu ana kadarki belgeler mükemmeldi ve Babil'in keskin bir özelliği oldu. Bazı özellikleri kesinlikle kullanabilecek bölümler var, hatta burada bir paragrafın eklenmesi bile çok beğeni topluyor.
  <p markdown="1" class="pquote-credit">
- @kittens, ["Katkıda bulunanlar için çağrı"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Organize etmeyi sever misiniz?

* Projeyi daha organize hale getirmek için benzer sorunları bağlantılayın ve yeni sorun etiketleri önerin
* Açık sorunların üzerinden geçin ve eskileri kapatmayı önerin, [@nzakas'ın ESLint için yaptığı gibi](https://github.com/eslint/eslint/issues/6765)
* Tartışmayı ileriye taşımak için açılan konular hakkında açıklayıcı sorular sorun.

### Kod yazmayı sever misiniz?

* [@Dianjin'in Leaflet için yaptığı gibi](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560) çözülmesi gereken açık bir konu bulun
* Yeni bir özellik yazmak için yardımcı olabilir misiniz diye sorun
* Proje kurulumunu otomatikleştirin
* Araçları ve testleri geliştirin

### İnsanlara yardım etmeyi sever misiniz?

* Proje hakkında soruları yanıtlayın. Örneğin, Stack Overflow'da ([bu Postgres örneğinde olduğu gibi](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) veya Reddit'te
* İnsanlar için açık konulardaki soruları cevaplayın
* Tartışma panolarını veya konuşma kanallarını yönetmeye yardımcı olun

### Başkalarına kod yazarken yardım etmeyi sever misiniz?

* Diğer kişilerin gönderimlerindeki kodu inceleyin
* Bir projenin nasıl kullanılabileceğini öğretici yazılar yazın
* Başka bir katılımcıya mentor olmaya çalışın, [@ereichert Rust projesinde @bronzdoc için yaptığı gibi](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Sadece yazılım projeleri üzerinde çalışmak zorunda değilsiniz!

"Açık kaynak" genellikle yazılımla ilişkilendirilse de, her şey için işbirliği yapabilirsiniz. Açık kaynak projeleri olarak geliştirilen kitaplar, tarifler, listeler ve sınıflar var.

Örneğin:

* @sindresorhus ["harika" listelerin bir listesini oluşturuyor](https://github.com/sindresorhus/awesome)
* @h5bp ön yüz geliştirici adayları için [olası mülakat sorularının bir listesini](https://github.com/h5bp/Front-end-Developer-Interview-Questions) oluşturuyor
* @stuartlynn ve @nicole-a-tesla [martılar hakkında eğlenceli bilgiler topladı](https://github.com/stuartlynn/puffin_facts)

Bir yazılım geliştiricisi olsanız bile, bir dokümantasyon projesi üzerinde çalışmak açık kaynak kodla başlamanıza yardımcı olabilir. Kod içermeyen projeler üzerinde çalışmak genellikle daha az korkutucu olur ve işbirliği süreci sizin güven ve deneyiminizi artırır.

## Kendinizi yeni bir projeye yönlendirmek

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Bir sorun listesine giderseniz ve işler kafa karıştırıcı görünür, yalnız değilsiniz. Bu araçlar çok fazla bilgi gerektirir, ancak insanlar size yardımcı olabilir ve onlara sorular sorabilirsiniz.
  <p markdown="1" class="pquote-credit">
- @shaunagm, ["Açık Kaynağa Nasıl Katkıda Bulunulur"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/) 
  </p>
</aside>

Bir yazım hatasının düzeltilmesinden daha fazla olarak, açık kaynağa katkıda bulunmak, partideki bir grup yabancıyla konuşmaya çalışmak gibidir. Lamalar hakkında konuşmaya başlarsanız, akvaryum balığı ile ilgili derin bir tartışma yapıyorlarsa, muhtemelen size biraz garip bakarlar.

Kendi önerilerinizle kör bir şekilde atlamadan önce, odanın neler konuştuğunu öğrenmekle başlayın. Bunu yapmak, fikirlerinizi fark ettirme ve duyurma şansınızı arttırır.

### Açık kaynak kodlu bir projenin anatomisi

Her açık kaynak topluluğu kendine özgüdür.

Bir açık kaynak projeye yıllarınızı harcamak, projeyi tanıdığınız anlamına gelir. Farklı bir projeye geçin; kelime, norm ve iletişim biçimlerinin tamamen farklı olduğunu göreceksiniz.

Bununla birlikte, birçok açık kaynak projenin benzer organizasyon yapılarını takip ettiği söylenebilir. Farklı topluluk rollerini ve genel süreci anlamak, yeni projeye hızlı bir şekilde odaklanmanıza yardımcı olacaktır.

Tipik bir açık kaynak projesi aşağıdaki insan türlerine sahiptir:

* **Yazar:** Projeyi yaratan kişi(ler)/kurum(lar)
* **Sahip:** Kurum veya depo üzerinde yönetim hakkına sahip kişi/kişiler (her zaman orijinal yazarla aynı olmayabilir)
* **Geliştiriciler:** Vizyonu yönlendirmekten ve projenin organizasyonel yönlerini yönetmekten sorumlu olanlar ve katkıda bulunanlar (Projenin yazarları veya sahipleri de olabilirler)
* **Katkıda Bulunanlar:** Projeye katkıda bulunan herkes
* **Topluluk Üyeleri:** Projeyi kullanan insanlar. Sohbetlerde aktif olabilirler veya projenin yönü ile ilgili görüşlerini ifade edebilirler.

Daha büyük projeler ayrıca araç yönetimi, öncelik yönetimi, topluluk yönetimi ve etkinlik organizasyonu gibi farklı görevlere odaklanmış alt komitelere veya çalışma gruplarına sahip olabilir. Bu bilgileri bulmak için bir projenin "ekip" sayfasına veya yönetim dokümantasyon deposuna bakın.

Projelerin belgeleri de vardır. Bu dosyalar genellikle bir kütüphanenin dizin yapısının en üst seviyelerinde listelenir.

* **LICENCE:** Tanım gereği her açık kaynak projenin [bir açık kaynak lisansa](https://choosealicense.com) sahip olması gerekir. Projenin lisansı yoksa açık kaynak değildir.
* **README:** README, projeye yeni topluluk üyelerini karşılayan kullanım kılavuzudur. Projenin neden yararlı olduğunu ve nasıl başlayacaklarını açıklar.
* **CONTRIBUTING:** README dosyaları projeyi insanların _kullanmalarına_ yardımcı olurken, CONTRIBUTING dökümanları insanların projeye _katkıda_ bulunmalarına yardımcı olur. Hangi tür katkıların gerekli olduğunu ve sürecin nasıl çalıştığını açıklar. Her projenin bir CONTRIBUTING dosyası olmasa da, varlığı bunun katkı bekleyen bir proje olduğunu işaret eder.
* **CODE_OF_CONDUCT:** Davranış kuralları, katılımcıların davranışlarıyla ilgili temel kuralları belirler ve arkadaşça ve misafirperver bir ortamı oluşturmaya yardımcı olur. Her projenin bir CODE_OF_CONDUCT dosyası olmasa da, varlığı bu konuya dikkate edilen bir proje olduğunu gösterir.
* **Diğer belgeler:** Özellikle büyük projelerde öğretici belgeler, izlenecek yollar veya yönetim politikaları gibi ek belgeler olabilir.

Son olarak, açık kaynak projeler tartışmaları yönetmek için aşağıdaki araçları kullanır. Arşivleri okumak, topluluğun nasıl düşündüğü ve çalıştığı hakkında size iyi bir fikir verecektir.

* **Sorun listesi:** İnsanların projeyle ilgili sorunları tartıştıkları yerler.
* **PR (Değişiklik istekleri):** İnsanların devam etmekte olan değişiklikleri tartıştıkları ve inceledikleri yerler.
* **Tartışma forumları veya e-posta listeleri:** Bazı projeler, tartışma konuları için bu kanalları kullanabilir (örneğin, hata raporları veya özellik istekleri yerine _"Nasıl ...?"_ veya _"Ne düşünüyorsunuz ...?" gibi_). Diğerleri, tüm konuşmalar için sorun listesini kullanır.
* **Anlık sohbet kanalları:** Bazı projelerde gündelik konuşmalar, işbirlikleri ve hızlı fikir alışverişleri için sohbet kanalları (Slack veya IRC gibi) kullanılır.

## Katkıda bulunacak bir proje bulma

Açık kaynak projelerin nasıl çalıştığını çözdüğünüze göre, katkıda bulunacak bir proje bulma zamanı!

Daha önce hiç bir açık kaynak projeye katkıda bulunmadıysanız, _"Ülkenizin sizin için neler yapabileceğini değil, ülkeniz için neler yapabileceğinizi sorun"_ diyen ABD Başkanı John F. Kennedy'yi  örnek alın.

Açık kaynağa katkıda bulunmak, farklı projelerde her seviyede gerçekleşir. İlk katkınızın tam olarak ne olacağını veya nasıl görüneceğini düşünmeniz gerekmez.

Bunun yerine, zaten kullandığınız veya kullanmak istediğiniz projeleri düşünerek başlayın. Aktif olarak katkıda bulunacağınız projeler, kendinizi devamlı kullanırken bulduğunuz projelerdir.

Bu projeler içinde, bir şeyin daha iyi veya farklı olabileceğini düşündüğünüzü farkettiğinizde, içgüdülerinize göre hareket edin.

Açık kaynak bir seçilmişler kulübü değildir; tıpkı senin gibi insanlar tarafından yapılmıştır. "Açık kaynak", dünyadaki sorunların çözülebilir olarak algılanması için sadece süslü bir terimdir.

Bir README tarayabilir ve bozuk bir link ya da yazım hatası bulabilirsiniz. Ya da yeni bir kullanıcısınız ve bir şeylerin bozuk olduğunu ya da belgelerde gerçekten olması gerektiğini düşündüğünüz bir eksikliğin olduğunu fark ettiniz. Bunu görmezden gelip devam etmek ya da başka birinden düzeltmesini istemek yerine, araya girip düzeltebileceğinizi görün. Bakın açık kaynak budur!

> [Gündelik katkıların %28'i](https://www.igor.pro.br/publica/papers/saner2016.pdf) açık kaynağa yeniden biçimlendirme veya bir çeviri yazarken böyle bir yazım hatası düzeltme gibi belgelerdir.

Düzeltebileceğiniz açık sorunları arıyorsanız, her açık kaynak projenin başlayabileceğiniz acemi dostu sorunları vurgulayan bir `/contribute` sayfası vardır. GitHub'taki deponun ana sayfasına gidin ve URL'nin sonuna `/contrib` ekleyin (Örneğin [`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

Yeni projeleri keşfetmenize ve katkıda bulunmanıza yardımcı olmak için aşağıdaki kaynaklardan birini de kullanabilirsiniz:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)

### Katkıda bulunmadan önce üzerinden geçilebilecek bir kontrol listesi

Katkıda bulunmak istediğiniz bir proje bulduğunuzda, projenin katkıları kabul etmeye uygun olduğundan emin olmak için hızlı bir tarama yapın. Aksi takdirde, sıkı çalışmanız asla bir yanıt alamayabilirsiniz.

İşte bir projenin yeni katılımcılar için iyi olup olmadığını değerlendirmek için kullanışlı bir kontrol listesi.

**Açık kaynak tanımını karşılar**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    Lisans var mı? Genellikle, proje kök dizininde LICENCE adlı bir dosya vardır.
  </label>
</div>

**Proje aktif olarak katkı kabul ediyor**

Ana daldaki geliştirici faaliyetine bakın. GitHub'da, bu bilgiyi bir kütüphanenin ana sayfasında görebilirsiniz.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    En son kod değişikliği ne zaman yapılmış?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    Projenin kaç katılımcısı var?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    İnsanlar ne sıklıkta geliştirme yapıyor? (GitHub'da, bunu üstteki çubukta "Commits" i tıklayarak bulabilirsiniz.)
  </label>
</div>

Ardından, projenin sorun listesine bakın.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Kaç tane açık sorun var?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Geliştiriciler sorunlara hızlı bir şekilde yanıt veriyor mu?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Sorunların altında aktif tartışma var mı?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Sorunlar yeni mi?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Sorunlar kapanıyor mu? (GitHub'da kapalı sorunları görmek için Konular sayfasındaki "kapalı" sekmesine tıklayın.)
  </label>
</div>

Şimdi aynısını projenin PR listesi için yapın.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Kaç tane açık PR var?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Sağlayıcılar PR'ları hızlı bir şekilde yanıtlıyor mu?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    PR'lar üzerinde aktif tartışma var mı?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    PR yeni mi gelmiş?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Yakındazamanda ne kadar PR birleştirilmiş? (GitHub'da kapalı PR'leri görmek için PR sayfasındaki "kapalı" sekmesine tıklayın.)
  </label>
</div>

**Proje katkı bekliyor mu?**

Arkadaş canlısı ve misafirperver bir proje, yeni katılımcılara açık olacağını belirtir.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Geliştiriciler, sorunlardaki sorulara yardımcı oluyor mu?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    İnsanlar konularda, tartışma forumunda ve sohbette (örneğin, IRC veya Slack) arkadaş canlısı mı?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    PR'lar inceleniyor mu?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Geliştiriciler insanlara katkılarından dolayı teşekkür eder mi?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Ne zaman uzun bir tartışma görüyorsanız, çekirdek geliştiricilerin konu başından geç gelen cevaplarını anında kontrol edin. Yapıcı bir şekilde özetliyorlar mı ve kibarlıklarını korurken bir karar vermek için adımlar atıyorlar mı? Çok fazla söz savaşı yaşandığını görüyorsanız, bu genellikle enerjinin gelişme yerine tartışmaya girdiğinin işaretidir.
  <p markdown="1" class="pquote-credit">
- @kfogel, [_OPS_ üretiliyor](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Nasıl katkı yapılır?

Hoşunuza giden bir proje buldunuz ve katkıda bulunmaya hazırsınız. En sonunda! İşte katkınızı doğru şekilde yapmanın yolu.

### Etkili iletişim kurmak

İster bir kerelik bir katkı yapan, ister bir topluluğa katılmaya çalışan biri olun, başkalarıyla çalışmak açık kaynak dünyasında geliştireceğiniz en önemli becerilerden biridir.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Yeni bir katılımcı olarak \] ben bir sorunu çözmek istediğimde hemen soru sormam gerektiğini fark ettim. Kod tabanında dolaştım. Bir konunun ne olduğunu anladığıma dair bir şeyler hissettiğimde, daha fazla yardım istemiştim. Ve voilà! İhtiyacım olan tüm detayları aldıktan sonra sorunu çözebildim.
  <p markdown="1" class="pquote-credit">
- @shubheksha, [Yeni Başlayanlar İçin Açık Kaynak Dünyasında İnişli Çıkışlı Yolculuk](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Bir sorunu açmadan veya bir PR oluşturmadan ya da sohbette bir soru sormadan önce, fikirlerinizi etkili bir şekilde ortaya çıkarmak için bu noktaları aklınızda bulundurun.

**Bağlam ver.** Başkalarının sizi anlamada hızlanmalarına yardımcı olun. Bir hatayla karşılaşıyorsanız, ne yapmaya çalıştığınızı ve nasıl tekrarlanabileceğini açıklayın. Yeni bir fikir önerecekseniz, neden projeye faydalı olacağını düşündüğünüzü açıklayın (sadece sizin için değil!).

> 😇 _"Y yaptığımda X olmuyor"_
>
> 😢 _"X çalışmıyor! Lütfen düzeltin."_

**Ödevini önceden yap.** Bir şeyleri bilmemek normaldir, ama denediğini göster. Yardım istemeden önce, bir projenin README'sini, belgelerini, sorun listesini (açık veya kapalı), e-posta listesini kontrol ettiğinizden ve bir cevap için interneti aradığınızdan emin olun. Öğrenmeye çalıştığını gösterdiğin zaman insanlar takdir edeceklerdir.

> 😇 _"X'in nasıl uygulanacağından emin değilim. Yardım belgelerini kontrol ettim ve herhangi bir yerde bulamadım."_
>
> 😢 <em>"X nasıl yapılır?"</em>

**İstekleri kısa ve öz tutun.** Bir e-posta göndermek gibi, ne kadar basit veya yararlı olursa olsun, her katkı başkasının incelemesini gerektirir. Birçok projenin, yardım için uygunların yapabileceklerinden daha fazla gelen talebi olur. Basit olun. Birinin size yardım edebilme şansını artıracaksınız.

> 😇 _"Bir API öğretici belgesi yazmak istiyorum."_
>
> 😢 _"Geçen gün otoyoldan aşağı iniyordum ve benzin için durdum ve sonra aklıma yapmamız gereken bir şey için inanılmaz bir fikir geldi, ama bunu açıklamadan önce sana göstereyim ..."_

**Tüm iletişimi herkese açık tutun.** Her ne kadar cazip olsa da, hassas bilgileri (güvenlik sorunu veya ciddi davranış ihlali gibi) paylaşmanız gerekmedikçe, geliştiricilere özel olarak ulaşmayın. Sohbeti herkese açık tuttuğunuzda, daha fazla kişi alış verişinizden öğrenebilir ve bundan faydalanabilir. Tartışmalar da kendi başlarına katkı sayılabilir.

> 😇 _(yorum olarak) "@-maintainer Merhabalar! Bu PR'a nasıl devam edelim?"_
>
> 😢 _(bir e-posta olarak) "Hey, e-posta yüzünden sizi rahatsız ettiğim için özür dilerim, ancak PR'mi gözden geçirme şansınız olup olmadığını merak ediyordum"_

**Soru sormak sorun değil (ama sabırlı olun!).** Herkes bir zamanlar projede yeniydi ve deneyimli katılımcıların bile yeni bir projeye bakarken hız kazanmaları gerekiyor. Aynı şekilde, uzun süredir devam edenler bile, projenin her bölümüne aşina değildir. Onlara size göstermelerini istediğiniz sabrı gösterin.

> 😇 _"Bu hatayı incelediğiniz için teşekkür ederiz. Önerilerinizi takip ettim. İşte sonuç."_
>
> 😢 _"Neden sorunumu çözemiyorsun? Bu senin projen değil mi?"_

**Topluluk kararlarına saygı gösterin.** Fikirleriniz, toplumun öncelikleri veya vizyonundan farklı olabilir. Geri bildirim sunabilir veya fikrinizi sürdürmemeye karar verebilirler. Tartışmanız ve uzlaşı aramanız gerekirken, geliştiriciler kararınızla sizden daha uzun yaşamak zorundadır. Düşüncelerine katılmıyorsanız, her zaman kendi çatalınızla çalışabilir veya kendi projenizi başlatabilirsiniz.

> 😇 _"Fikrimi destekleyemediğiniz için hayal kırıklığına uğradım, ancak bunun sadece kullanıcıların küçük bir bölümünü etkilediğini açıkladığınızdan, nedenini anlıyorum. Dinlediğiniz için teşekkürler."_
>
> 😢 _"Neden fikrimi desteklemiyorsun? Bu kabul edilemez!"_

**Her şeyden önce, zarif olun.** Açık kaynak dünyanın her yerinden ortak çalışanlardan oluşur. Bağlam diller, kültürler, coğrafyalar ve zaman dilimleri arasında kaybolur. Ek olarak, yazılı iletişim bir ton veya ruh halini iletmeyi zorlaştırır. Bu konuşmaların niyetlerinin iyi olduğunu düşünün. Bir fikre kibarca geri dönmek, daha fazla içerik istemek veya konumunuzu daha da netleştirmek iyi bir şey. İnterneti bulduğunuzdan daha iyi bir yer bırakmaya çalışın.

### Bağlamı toparlama

Herhangi bir şey yapmadan önce, fikrinizin başka bir yerde tartışılmadığından emin olmak için hızlıca kontrol edin. Projenin README"sini, sorun (açık ve kapalı) listesini, e-posta listesini ve StackOverflow"u gözden geçirin. Her şeyi yapmak için zaman harcamak zorunda değilsiniz, ancak birkaç anahtar terim için hızlı arama yapmak çok fayda sağlar.

Fikrinizi başka bir yerde bulamazsanız, harekete geçmeye hazırsınız. Proje GitHub'taysa, muhtemelen bir sorun açarak veya PR oluşturarak iletişim kurarsınız:

* **Sorunlar** bir konuşma veya tartışma başlatmak için iyi yerdir
* **PR** bir çözüm üzerinde çalışmaya başlamak içindir
* **Daha hafif bir iletişim** için açıklayıcı veya nasıl yapılır sorusu gibi, eğer varsa projenin Stack Overflow, IRC, Slack veya diğer sohbet kanallarından sormayı deneyin.

Bir sorun açmadan veya talepte bulunmadan önce, belirli bir şey eklemeniz gerekip gerekmediğini görmek için projenin katkıda bulunma belgelerini (genellikle CONTRIBUTING veya README dosyaları) kontrol edin. Örneğin, bir şablon izlemenizi istenebilir veya test ortamı kullanmanız gerekebilir.

Önemli bir katkı yapmak istiyorsanız, üzerinde çalışmadan önce sormanız gereken bir sorun açın. Projeyi bir süre izlemeniz yararlı olacaktır (GitHub'da, tüm konuşmalar size bildirilmek için ["İzle"yi tıklayabilirsiniz](https://help.github.com/articles/watching-repositories/)) ve kabul edilmeyebilecek bir işe başlamadan önce topluluk üyelerini tanıyın.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Aktif olarak kullandığınız bir projeyi seçmek, GitHub'da “izlemek” ve her konuyu ve PR'ı okumaktan <em>çok şey</em> öğreneceksiniz.
  <p markdown="1" class="pquote-credit">
- @gaearon [birleştirme projelerinde](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Bir istek/sorun açmak

Genellikle aşağıdaki durumlarda bir sorun açmalısınız:

* Çözemediğiniz bir hatayı bildirmek için
* Üst düzey bir konuyu veya fikri tartışmak için (örneğin, topluluk, vizyon veya politikalar)
* Yeni bir özellik veya başka bir proje fikri önermek için

Sorunlar üzerinde iletişim kurmak için ipuçları:

* **Başa çıkmak istediğiniz açık bir sorun görürseniz**, konuyla ilgili insanlara çalıştığınızı bildirmek için yorum yapın. Bu şekilde, insanların aynı konu üzerinde gereksiz yere çalışması daha az olasıdır.
* **Eğer bir sorun bir süre önce açılmışsa**, başka bir yerde ele alınması ya da zaten çözülmüş olması olasıdır, bu nedenle çalışmaya başlamadan önce durum hakkında onay almak için yorum yapın.
* **Bir sorunu açtıysanız ancak cevabı daha sonra kendi başınıza çözdüyseniz**, durumu bildirmek için soruna yorum yapın, sonra sorunu kapatın. Bu sonucun belgelenmesi bile projeye bir katkıdır.

### PR açma

Genellikle aşağıdaki durumlarda bir PR açmalısınız:

* Önemsiz düzeltmeleri göndermek için (örneğin bir yazım hatası, bozuk bir bağlantı veya açık bir hata)
* Bir konuda önceden sorulmuş veya daha önce konuşmuş olduğunuz bir katkı için çalışmaya başladığınızda

Bir PR, bitmiş işi temsil etmek zorunda değildir. PR'ı erkenden açmak genellikle daha iyidir, bu nedenle diğerleri ilerlemeniz hakkında fikir sahibi olabilir veya geribildirimde bulunabilir. Sadece konu satırında bir "WIP" (Çalışmakta Olan Çalışma) etiketi ile işaretlemeniz yeterlidir. Daha sonra her zaman daha fazla geliştirme ekleyebilirsiniz.

Proje GitHub'taysa, PR nasıl gönderilir:

* **[Depoyu çatallayın](https://guides.github.com/activities/forking/)** ve yerel olarak klonlayın. Kendi yerelinize ana depoyu "upstream"  olarak bağlayın. Sık sık "upstream" den yapılan değişiklikleri çekin, böylece güncel kalırsınız ve çekme isteğinizi gönderdiğinizde, birleştirme çakışmalarının olasılığı daha düşük olur. ([Burada](https://help.github.com/articles/syncing-a-fork/) daha ayrıntılı talimatlara bakın.)
* Düzenlemeleriniz için **[bir dal oluşturun](https://guides.github.com/introduction/flow/)** .
* **PR'nızda ilgili sorunlara** veya destekleyici belgelere atıfta bulunun (örneğin, "Closes #37")
* Değişiklikleriniz HTML/CSS"de farklılıklar içeriyorsa **önceki ve sonraki ekran görüntülerini ekleyin**. Görüntüleri PR gövdesine sürükleyip bırakarak yükleyebilirsiniz.
* **Değişikliklerinizi test edin!** Varsa, testleriniz varsa test edin ve gerektiğinde yenilerini oluşturun. Testlerin olup olmadığı, değişikliklerin mevcut projeyi bozmadığından emin olun.
* **Projenin tarzına uygun şekilde** katkıda bulunun. Bu koddaki girintileri, noktalı virgülleri veya yorumları kendi deponuzda olduğundan farklı bir şekilde kullanmak anlamına gelebilir, ancak bakıcının birleştirmesini, başkalarının gelecekte anlamasını ve sürdürmesini kolaylaştırır.

Bu ilk PR ise, @kentcdodds'ın bir örnek video eğitimi olarak oluşturduğu [Bir PR Yap](http://makeapullrequest.com/)'ı izleyin. Ayrıca, @Roshanjossey tarafından oluşturulan [First Contributions](https://github.com/Roshanjossey/first-contributions) deposunda çekme isteği yapmayı da deneyebilirsiniz.

## Yaptığınız katkıyı gönderdikten sonra ne olur?

Başardınız! Açık kaynak dünyasına katkıda bulunduğunuz için tebrikler. Umarız yapacağınız katkıların ilkidir.

Katkınızı gönderdikten sonra, aşağıdakilerden biri olacaktır:

### 😭 Hiç bir cevap almazsınız.

Umarım bir katkı yapmadan önce [projeyi faaliyet belirtileri açısından kontrol](#katk%C4%B1da-bulunmadan-%C3%B6nce-%C3%BCzerinden-ge%C3%A7ilebilecek-bir-kontrol-listesi) ettiniz. Ancak aktif bir projede bile, katkınızın yanıt alamaması olası.

Bir haftadan uzun bir süredir yanıt alamadıysanız, aynı konuya kibarca yorum yazmak, birinden inceleme istemek doğru olur. Katkınızı gözden geçirecek doğru kişinin adını biliyorsanız, bunları o konuya ekleyebilirsiniz (@).

Özel olarak o kişiye ulaşmaya **çalışmayın;** Açık iletişiminin açık kaynaklı projeler için hayati önem taşıdığını unutmayın.

Kibar hatırlatmanıza rağmen hala kimse cevap vermiyorsa, hiç kimsenin cevap vermemesi mümkündür. Harika bir duygu değil, ama bunun sizin cesaretinizi kırmasına izin vermeyin. Herkesin başına gelmiştir! Kontrolünüz dışında olabilecek kişisel durumlar da dahil olmak üzere, yanıt alamamanızın birçok olası nedeni olabilir. Başka bir proje ya da katkıda bulunmanın başka bir yolunu bulmaya çalışın. Eğer bir şey bulamıyorsanız, bu topluluk üyeleri size dönmeden ve cevap vermeden önce katkı yapmak için çok fazla zaman harcamamak için iyi bir nedendir.

### 🚧 Biri katkınızda değişiklik talep eder.

Katkınızda değişiklik yapmanızın istenmesi, fikrinizin kapsamı hakkında geribildirimde bulunulması veya kodunuzda değişiklik yapmanız istenmesi yaygındır.

Birisi değişiklik istediğinde, duyarlı olun. Katkınızı gözden geçirmek için zaman harcadılar. Bir PR açmak ve uzaklaşmak kötü bir durumdur. Nasıl değişiklik yapılacağını bilmiyorsanız, sorunu araştırın, daha sonra ihtiyacınız olursa yardım isteyin.

Artık sorun üzerinde çalışmak için zamanınız yoksa (örneğin, tartışma aylardır devam ediyorsa ve koşullarınız değiştiyse), ilgili kişilere yanıt beklememelerini bildirin. Başkası devralmaktan mutlu olabilir.

### 👎 Katkınız kabul edilmez.

Katkınız sonunda kabul edilebilir veya kabul edilmeyebilir. Umarım zaten çok fazla iş yapmamışsındır. Neden kabul edilmediğinden emin değilseniz, bakıcıdan geri bildirim ve açıklama istemek tamamen mantıklıdır. Ancak, sonuçta, bunun kendi kararları olduğundan saygı duymanız gerekir. Tartışma içine girmeyin ya da düşmanca davranmayın. Anlaşmazsanız her zaman kendi versiyonunuzla çalışmaya hazırsınız!

### 🎉 Katkınız kabul edilir.

Yaşasın! Açık kaynak dünyasına bir katkı yaptınız!

## Başardınız!

İster açık kaynak dünyasına ilk katkıyı yapmış, ister katkıda bulunmak için yeni yollar arıyor olun, harekete geçmek için ilham aldığınızı umarız. Katkınız kabul edilmese bile, bir geliştirici size yardım etmek için çaba gösterdiğinde teşekkür etmeyi unutmayın. Açık kaynak, sizin gibi insanlar tarafından üretilir: bir sorun, bir PR, yorum ya da beşlik.
