---
lang: sw
title: Kuanzisha Mradi wa Open Source
description: Jifunze zaidi kuhusu ulimwengu wa Open Source na uwe tayari kuzindua mradi wako mwenyewe.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## "Nini" na "Kwa Nini" ya Open Source

Basi unafikiria kuanza na open source? Hongera! Ulimwengu unathamini mchango wako. Hebu tuzungumze kuhusu nini open source ni na kwa nini watu huifanya.

### Nini maana ya "open source"?

Wakati mradi ni open source, inamaanisha **mtu yeyote yuko huru kutumia, kujifunza, kubadilisha, na kusambaza mradi wako kwa kusudi lolote.** Ruhusa hizi zinaimarishwa kupitia [leseni ya open source](https://opensource.org/licenses).

Open source ni nguvu kwa sababu inashusha vizuizi vya kupitisha na ushirikiano, ikiruhusu watu kueneza na kuboresha miradi haraka. Pia kwa sababu inawapa watumiaji uwezo wa kudhibiti kompyuta zao, ikilinganishwa na mradi usio huria. Kwa mfano, biashara inayotumia programu ya open source ina chaguo la kuajiri mtu kufanya maboresho maalum kwa programu hiyo, badala ya kutegemea maamuzi ya bidhaa ya muuzaji wa mradi usio huria pekee.

_Programu ya bure_ inarejelea seti sawa ya miradi kama **open source**. Wakati mwingine utaona [maneno haya](https://en.wikipedia.org/wiki/Free_and_open-source_software) yakiwa pamoja kama "free and open source software" (FOSS) au "free, libre, and open source software" (FLOSS). 
_Free_ na _libre_ zinarejelea uhuru, [sio bei](#je-open-source-inamaanisha-bila-malipo).

### Kwa nini watu wanafungua chanzo cha kazi zao?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  Moja ya uzoefu wa kuridhisha zaidi ninapata kutokana na kutumia na kushirikiana kwenye open source inatokana na uhusiano ninayounda na wabunifu wengine wanaokabiliwa na matatizo mengi kama mimi.
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["Jinsi ya kuingia kwenye Open Source imekuwa nzuri kwangu"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[Kuna sababu nyingi](https://ben.balter.com/2015/11/23/why-open-source/) kwa nini mtu au shirika lingetaka kufungua chanzo cha mradi. Baadhi ya mifano ni pamoja na:

* **Ushirikiano:** Miradi ya open source inaweza kukubali mabadiliko kutoka kwa mtu yeyote duniani. [Exercism](https://github.com/exercism/), kwa mfano, ni jukwaa la mazoezi ya programu lenye washiriki zaidi ya 350.

* **Kupitishwa na kubadilisha:** Miradi ya open source inaweza kutumika na mtu yeyote kwa karibu kusudi lolote. Watu wanaweza hata kuitumia kujenga mambo mengine. [WordPress](https://github.com/WordPress), kwa mfano, ilianza kama fork ya mradi uliopo uitwao [b2](https://github.com/WordPress/book/blob/HEAD/Content/Part%201/2-b2-cafelog.md).

* **Uwazi:** Mtu yeyote anaweza kukagua mradi wa open source kwa makosa au kutokuelewana. Uwazi ni muhimu kwa serikali kama [Bulgaria](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) au [Marekani](https://www.cio.gov/2016/08/11/peoples-code.html), sekta zilizo chini ya udhibiti kama benki au huduma za afya, na programu za usalama kama [Let's Encrypt](https://github.com/letsencrypt).

Open source si kwa programu tu, pia unaweza kufungua kila kitu kutoka kwa seti za data hadi vitabu. Angalia [GitHub Explore](https://github.com/explore) kwa mawazo kuhusu nini kingine unaweza kufungua.

### Je, open source inamaanisha "bila malipo"?

Moja ya mvuto mkubwa wa open source ni kwamba haigharimu pesa. "Bila malipo", hata hivyo, ni matokeo ya thamani ya jumla ya open source.

Kwa sababu [leseni ya open source inahitaji](https://opensource.org/definition-annotated/) kwamba mtu yeyote anaweza kutumia, kubadilisha, na kushiriki mradi wako kwa karibu kusudi lolote, miradi yenyewe huwa bila malipo. Ikiwa mradi ungegharimu pesa kutumika, mtu yeyote angeweza kisheria kufanya nakala na kutumia toleo la bure badala yake.

Kwa hivyo, miradi mingi ya open source ni bure, lakini "bila malipo" si sehemu ya ufafanuzi wa open source. Kuna njia za kuchaji kwa miradi ya open source kwa njia zisizo za moja kwa moja kupitia leseni mbili au vipengele vilivyopunguzwa, huku bado ukikidhi ufafanuzi rasmi wa open source.

## Je, ni lazima nizindue mradi wangu wa open source?

Jibu fupi ni ndiyo, kwa sababu bila kujali matokeo, kuzindua mradi wako ni njia nzuri ya kujifunza jinsi open source inavyofanya kazi.

Ikiwa hujawahi kufungua mradi hapo awali, huenda ukawa na wasiwasi kuhusu kile watu watasema, au ikiwa mtu yeyote atagundua hata kidogo. Ikiwa hii inasikika kama wewe, huenda usiwe peke yako!

Kazi ya open source ni kama shughuli nyingine yoyote ya ubunifu, iwe ni uandishi au uchoraji. Inaweza kuonekana kutisha kushiriki kazi yako na ulimwengu, lakini njia pekee ya kuboresha ni kufanya mazoezi - hata kama huna hadhira.

Ikiwa bado hujashawishika, chukua muda kufikiria kuhusu malengo yako yanaweza kuwa yapi.

### Kuweka malengo yako

Malengo yanaweza kukusaidia kubaini ni nini cha kufanya, ni nini cha kukatalia, na ni wapi unahitaji msaada kutoka kwa wengine. Anza kwa kujuliza, _kwa nini ninafungua mradi huu?_

Hakuna jibu moja sahihi kwa swali hili. Unaweza kuwa na malengo mengi kwa mradi mmoja, au miradi tofauti yenye malengo tofauti.

Ikiwa lengo lako pekee ni kuonyesha kazi yako, huenda usitake hata michango, na hata kusema hivyo katika README yako. Kwa upande mwingine, ikiwa unataka wachangiaji, utawekeza muda katika nyaraka wazi na kuwafanya wapya wajisikie kukaribishwa.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  Katika hatua fulani nilitengeneza UIAlertView maalum ambayo nilikuwa nikitumia...na nikaamua kuifanya open source. Hivyo, niliifanyia marakebisho na kuiweka kwenye GitHub. Pia nilandika nyaraka zangu za kwanza zikielezea kwa waendelezaji wengine jinsi ya kuitumia kwenye miradi yao. Huenda hakuna mtu aliyewahi kuitumia kwa sababu ilikuwa mradi mdogo lakini nilihisi vizuri kuhusu mchango wangu.
  <p markdown="1" class="pquote-credit">
— @mavris, ["Wanaendelezaji wa Programu Wanaojifunza: Kwa Nini Open Source ni muhimu kwetu"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

Kadri mradi wako unavyokua, jamii yako inaweza kuhitaji zaidi ya msimbo kutoka kwako. Kujibu masuala, kupitia msimbo, na kuhamasisha mradi wako ni kazi muhimu katika mradi wa open source.

Wakati kiasi cha muda unachotumia kwenye kazi zisizo za kuandika kitategemea ukubwa na upeo wa mradi wako, unapaswa kuwa tayari kama mtunza mradi kukabiliana nazo mwenyewe au kupata mtu wa kukusaidia.

**Ikiwa wewe ni sehemu ya kampuni inayofungua mradi,** hakikisha mradi wako una rasilimali za ndani zinazohitajika ili kustawi. Utataka kubaini ni nani anayehusika na kutunza mradi baada ya uzinduzi, na jinsi utakavyoshiriki kazi hizo na jamii yako.

Ikiwa unahitaji bajeti maalum au wafanyakazi kwa ajili ya matangazo, operesheni na kutunza mradi, anza mazungumzo hayo mapema.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  Unapokuwa unafungua mradi, ni muhimu kuhakikisha kwamba michakato yako ya utunzaji inazingatia michango na uwezo wa jamii inayozunguka mradi wako. Usijali kuhusisha wachangiaji ambao hawana ajira katika biashara yako katika nyanja muhimu za mradi - hasa ikiwa ni wachangiaji wa mara kwa mara.
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["Hivyo unataka kufungua mradi, eh?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Kuchangia miradi mingine

Ikiwa lengo lako ni kujifunza jinsi ya kushirikiana na wengine au kuelewa jinsi open source inavyofanya kazi, zingatia kuchangia kwenye mradi uliopo. Anza na mradi ambao tayari unautumia na kuupenda. Kuchangia kwenye mradi kunaweza kuwa rahisi kama kurekebisha makosa ya tahajia au kuboresha nyaraka.

Ikiwa hujui jinsi ya kuanza kama mchango, angalia mwongozo wetu wa [Jinsi ya Kuchangia kwa Open Source](../how-to-contribute/).

## Kuzindua mradi wako wa open source

Hakuna wakati mzuri wa kufungua chanzo cha kazi yako. Unaweza kufungua wazo, kazi inayoendelea, au baada ya miaka ya kuwa closed source.

Kwa ujumla, unapaswa kufungua mradi wako unapojisikia vizuri kuwa na wengine wanaweza kuangalia, na kutoa maoni kuhusu, kazi yako.

Bila kujali hatua gani unachagua kufungua mradi wako, kila mradi unapaswa kujumuisha nyaraka zifuatazo:

* [Leseni ya open source](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Miongozo ya kuchangia](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [Kanuni ya tabia](../code-of-conduct/)

Kama mtunza mradi, vipengele hivi vitakusaidia kuwasiliana matarajio, kusimamia michango, na kulinda haki za kisheria za kila mtu (ikiwemo yako mwenyewe). Vinapanua sana nafasi zako za kuwa na uzoefu mzuri.

Ikiwa mradi wako uko kwenye GitHub, kuweka faili hizi kwenye saraka yako ya mizizi kwa majina yaliyopendekezwa kutasaidia GitHub kutambua na kuziwasilisha moja kwa moja kwa wasomaji wako.

### Kuchagua leseni

Leseni ya open source inahakikisha kwamba wengine wanaweza kutumia, nakala, kubadilisha, na kuchangia tena kwenye mradi wako bila madhara. Pia inakulinda kutokana na hali ngumu za kisheria. **Lazima ujumuisha leseni unapozindua mradi wa open source.**

Kazi ya kisheria si ya kufurahisha. Habari njema ni kwamba unaweza kunakili na kupaste leseni iliyopo kwenye hazina yako. Itachukua dakika moja kulinda kazi yako ngumu.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), na [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) ni leseni maarufu zaidi za open source, lakini [kuna chaguzi nyingine](https://choosealicense.com) za kuchagua.

Unapounda mradi mpya kwenye GitHub, unapata chaguo la kuchagua leseni. Kuweka leseni ya open source kutafanya mradi wako wa GitHub kuwa open source.

![Pick a license](/assets/images/starting-a-project/repository-license-picker.png)

Ikiwa una maswali au wasiwasi mengine kuhusu nyanja za kisheria za kusimamia mradi wa open source, [tumeandaa mwongozo](../legal/) kwa ajili yako.

### Kuandika README

READMEs hufanya zaidi ya kuelezea jinsi ya kutumia mradi wako. Pia zinaelezea kwa nini mradi wako ni muhimu, na ni nini watumiaji wako wanaweza kufanya nacho.

Katika README yako, jaribu kujibu maswali yafuatayo:

* Mradi huu unafanya nini?
* Kwa nini mradi huu ni muhimu?
* Nitaanzaje?
* Nitaweza kupata msaada zaidi wapi, ikiwa nahitaji?

Unaweza kutumia README yako kujibu maswali mengine, kama vile jinsi unavyoshughulikia michango, ni malengo gani ya mradi, na taarifa kuhusu leseni na kutambua. Ikiwa hutaki kukubali michango, au mradi wako haujawa tayari kwa uzalishaji, andika taarifa hii chini.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  Nyaraka bora zinamaanisha watumiaji wengi, maombi machache ya msaada, na wachangiaji wengi. (...) Kumbuka kwamba wasomaji wako si wewe. Kuna watu ambao wanaweza kuja kwenye mradi ambao wana uzoefu tofauti kabisa.
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Kuandika Ili Maneno Yako Yasomwe (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Wakati mwingine, watu wanakwepa kuandika README kwa sababu wanahisi mradi haujakamilika, au hawataki michango. Hizi ni sababu nzuri za kuandika moja.

Kwa maelezo zaidi, jaribu kutumia mwongozo wa @dguo ["Fanya README"](https://www.makeareadme.com/) au [templat ya README ya @PurpleBooth](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) kuandika README kamili.

Unapojumuisha faili ya README kwenye saraka ya mizizi, GitHub itaonyesha moja kwa moja kwenye ukurasa wa nyumbani wa hazina.

Wakati mwingine, watu huepuka kuandika README kwa sababu wanahisi kama mradi haujakamilika, au hawataki michango. Hizi zote ni sababu nzuri sana za kuandika moja.

Kwa msukumo zaidi, jaribu kutumia mwongozo wa @dguo ["Tengeneza README"](https://www.makeareadme.com/) au @PurpleBooth's [README template](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) kuandika SOMA kamili.

Unapojumuisha faili ya README kwenye saraka ya mizizi, GitHub itaionyesha kiotomatiki kwenye ukurasa wa nyumbani wa hazina.

### Kuandika miongozo yako ya kuchangia

Faili ya CONTRIBUTING inawaambia wasomaji wako jinsi ya kushiriki katika mradi wako. Kwa mfano, unaweza kujumuisha taarifa kuhusu:

* Jinsi ya kuwasilisha ripoti za makosa (jaribu kutumia [mifano ya masuala na ombi la kuvuta](https://github.com/blog/2111-issue-and-pull-request-templates))
* Jinsi ya kupendekeza kipengele kipya
* Jinsi ya kuweka mazingira yako na kuendesha majaribio

Mbali na maelezo ya kiufundi, faili ya CONTRIBUTING ni fursa ya kuwasilisha matarajio yako kwa michango, kama vile:

* Aina za michango unazotafuta
* Ramani yako au maono ya mradi
* Jinsi wachangiaji wanavyopaswa (au wasipasa) kuwasiliana nawe

Kutumia sauti ya kirafiki na ya kukaribisha na kutoa mapendekezo maalum ya michango (kama vile kuandika nyaraka, au kutengeneza tovuti) kunaweza kusaidia sana katika kuwafanya wapya wajisikie kukaribishwa na kufurahia kushiriki.

Kwa mfano, [Active Admin](https://github.com/activeadmin/activeadmin/) huanza [miongozo yake ya kuchangia](https://github.com/activeadmin/activeadmin/blob/HEAD/CONTRIBUTING.md) na:

> Kwanza kabisa, asante kwa kuzingatia kuchangia kwa Active Admin. Ni watu kama wewe wanaofanya Active Admin kuwa chombo bora.

Katika hatua za awali za mradi wako, faili yako ya CONTRIBUTING inaweza kuwa rahisi. Unapaswa kila wakati kuelezea jinsi ya kuripoti makosa au kuwasilisha masuala, na mahitaji yoyote ya kiufundi (kama majaribio) ili kufanya mchango.

Kadri muda unavyosonga, unaweza kuongeza maswali mengine yanayoulizwa mara kwa mara kwenye faili yako ya CONTRIBUTING. Kuandika habari hii kuna maana kwamba watu wachache watauliza maswali sawa mara kwa mara.

Kwa msaada zaidi wa kuandika faili yako ya CONTRIBUTING, angalia mwongozo wa @nayafia [template ya kuchangia](https://github.com/nayafia/contributing-template/blob/HEAD/CONTRIBUTING-template.md) au ["Jinsi ya Kujenga CONTRIBUTING.md" ya @mozilla](https://mozillascience.github.io/working-open-workshop/contributing/).

Linki kwa faili yako ya CONTRIBUTING kutoka kwenye README yako, ili watu wengi zaidi waione. Ikiwa [uweka faili ya CONTRIBUTING kwenye hazina ya mradi wako](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), GitHub itaunganisha moja kwa moja kwenye faili yako wakati mchangiaji anaunda suala au kufungua ombi la kuvuta.

![Miongozo ya kuchangia](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Kuanzisha kanuni ya tabia

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  Tumekuwa na uzoefu ambapo tulikabiliwa na kile ambacho labda kilikuwa unyanyasaji ama kama mtunza mradi akijaribu kueleza kwa nini kitu kinapaswa kuwa njia fulani, au kama mtumiaji...akiuliza swali rahisi. (...) Kanuni ya tabia inakuwa hati inayoweza kurejelea na kuunganishwa ambayo inaonyesha kwamba timu yako inachukulia mazungumzo ya kujenga kwa uzito.
  <p markdown="1" class="pquote-credit">
— @mlynch, ["Kufanya Open Source Kuwa Mahali Pazuri"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

Hatimaye, kanuni ya tabia husaidia kuweka sheria za msingi za tabia kwa washiriki wa mradi wako. Hii ni muhimu hasa ikiwa unazindua mradi wa open source kwa jamii au kampuni. Kanuni ya tabia inakupa uwezo wa kuwezesha tabia nzuri na ya kujenga katika jamii, ambayo itapunguza msongo wako kama mtunza mradi.

Kwa maelezo zaidi, angalia mwongozo wetu wa [Kanuni ya Tabia](../code-of-conduct/).

Mbali na kuwasilisha _jinsi_ unavyotarajia washiriki watende, kanuni ya tabia pia huwa inaelezea ni nani matarajio haya yanatumika, wakati yanatumika, na nini cha kufanya ikiwa ukiukaji unafanyika.

Kama leseni za open source, pia kuna viwango vinavyotokea kwa kanuni za tabia, hivyo huna haja ya kuandika yako mwenyewe. [Mkataba wa Wachangiaji](https://contributor-covenant.org/) ni kanuni ya tabia inayoweza kutumika ambayo inatumika na [mradi zaidi ya 40,000 wa open source](https://www.contributor-covenant.org/adopters), ikiwa ni pamoja na Kubernetes, Rails, na Swift. Haijalishi ni maandiko gani unayotumia, unapaswa kuwa tayari kutekeleza kanuni yako ya tabia inapohitajika.

Pachika maandiko moja kwa moja kwenye faili ya CODE_OF_CONDUCT kwenye hazina yako. Hifadhi faili hiyo kwenye saraka ya mradi wako ili iwe rahisi kuipata, na uunganishe nayo kutoka kwenye README yako.

## Kutoa jina na kuchapisha ya mradi wako

kuchapisha ni zaidi ya nembo ya kuvutia au jina la mradi linalokumbukwa. Ni kuhusu jinsi unavyoongea kuhusu mradi wako, na ni nani unayefikia na ujumbe wako.

### Kuchagua jina sahihi

Chagua jina ambalo ni rahisi kukumbuka na, kwa kawaida, linatoa wazo kuhusu mradi unavyofanya. Kwa mfano:

* [Sentry](https://github.com/getsentry/sentry) inafuatilia programu kwa ripoti za ajali
* [Thin](https://github.com/macournoyer/thin) ni seva ya wavuti ya Ruby yenye haraka na rahisi

Ikiwa unajenga juu ya mradi uliopo, kutumia jina lao kama kiambatisho kunaweza kusaidia kufafanua kile mradi wako unachofanya (kwa mfano, [node-fetch](https://github.com/bitinn/node-fetch) inaletee `window.fetch` Node.js).

Fikiria wazi zaidi kuliko yote. Mifano ni ya kufurahisha, lakini kumbuka kwamba baadhi ya vichekesho huenda visitafsiriwe kwa tamaduni nyingine au watu wenye uzoefu tofauti na wewe. Baadhi ya watumiaji wako wanaweza kuwa wafanyakazi wa kampuni: hutaki kuwafanya wajisikie wasumbufu wanapohitajika kuelezea mradi wako kazini!

### Kuepuka migongano ya majina

[Angalia miradi ya open source yenye jina sawa](https://namechecker.vercel.app/), hasa ikiwa unashiriki lugha ya programu au mfumo sawa. Ikiwa jina lako linagongana na mradi maarufu uliopo, unaweza kuchanganya hadhira yako.

Ikiwa unataka tovuti, jina la Twitter, au mali nyingine za kuwakilisha mradi wako, hakikisha unaweza kupata majina unayotaka. Kwa kawaida, [hifadhi majina hayo sasa](https://instantdomainsearch.com/) kwa amani ya akili, hata kama hujapanga kuyatumia bado.

Hakikisha jina la mradi wako halikiuka alama za biashara. Kampuni inaweza kukutaka uondoe mradi wako baadaye, au hata kuchukua hatua za kisheria dhidi yako. Si thamani ya hatari hiyo.

Unaweza kuangalia [WIPO Global Brand Database](http://www.wipo.int/branddb/en/) kwa migongano ya alama za biashara. Ikiwa uko kwenye kampuni, hii ni moja ya mambo ambayo [timu yako ya kisheria inaweza kukusaidia nayo](../legal/).

Hatimaye, fanya utafutaji wa haraka wa jina la mradi wako. Je, watu wataweza kuipata mradi wako kwa urahisi? Je, kuna kitu kingine kinachotokea kwenye matokeo ya utafutaji ambacho huenda hutaki watu waone?

### Jinsi unavyandika (na kuandika msimbo) inavyoathiri chapa yako pia!

Katika maisha ya mradi wako, utakuwa na maandiko mengi: READMEs, mafunzo, nyaraka za jamii, kujibu masuala, labda hata jarida na orodha za barua.

Iwe ni nyaraka rasmi au barua ya kawaida, mtindo wako wa uandishi ni sehemu ya chapa ya mradi wako. Fikiria jinsi unavyoweza kuonekana kwa hadhira yako na ikiwa hiyo ndiyo sauti unayotaka kuwasilisha.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Nilijaribu kujihusisha na kila mjadala kwenye orodha ya barua, na kuonyesha tabia bora, kuwa na wema kwa watu, kuchukua masuala yao kwa uzito na kujaribu kuwa msaada kwa ujumla. Baada ya muda, watu walibaki si tu kuuliza maswali, bali pia kusaidia na majibu, na kwa furaha yangu kamili, walinakili mtindo wangu.
  <p markdown="1" class="pquote-credit">
— @janl kwenye [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Kutumia lugha ya kukaribisha (kama "them", hata wakati ukirejelea mtu mmoja) kunaweza kusaidia sana katika kufanya mradi wako ujisikie unakaribisha kwa wachangiaji wapya. Kaa na lugha rahisi, kwani wengi wa wasomaji wako huenda si wazawa wa lugha ya Kiingereza.

Zaidi ya jinsi unavyandika maneno, mtindo wako wa kuandika msimbo pia unaweza kuwa sehemu ya chapa ya mradi wako. [Angular](https://angular.io/guide/styleguide) na [jQuery](https://contribute.jquery.org/style-guide/js/) ni mifano miwili ya miradi yenye mitindo na miongozo ya kuandika.

Sio lazima kuandika mwongozo wa mtindo kwa mradi wako unapokuwa unaanza, na unaweza kupata kwamba unafurahia kuunganisha mitindo tofauti ya kuandika msimbo katika mradi wako. Lakini unapaswa kutarajia jinsi mtindo wako wa uandishi na wa kuandika msimbo unaweza kuvutia au kukatisha tamaa aina tofauti za watu. Hatua za awali za mradi wako ni fursa yako ya kuweka mfano unayotaka kuona.

## Orodha yako ya ukaguzi kabla ya uzinduzi

Je, uko tayari kuweka mradi wako open source? Hapa kuna orodha ya ukaguzi ili kusaidia. Je, umekagua masanduku yote? Uko tayari kwenda! [Bonyeza "chapisha"](https://help.github.com/articles/making-a-private-repository-public/) na ujipatie sifa.

**Nyaraka**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    Mradi una faili ya LESENI yenye leseni ya open source
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    Mradi una nyaraka za msingi (README, CONTRIBUTING, CODE_OF_CONDUCT)
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    Jina ni rahisi kukumbuka, linatoa wazo fulani kuhusu kile mradi unafanya, na haligongani na mradi uliopo au kukiuka alama za biashara
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    Orodha ya masuala iko katika hali ya juu, na masuala yameandaliwa na kuwekwa alama wazi
  </label>
</div>

**Msimbo**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Mradi unatumia kanuni za msimbo zinazofanana na wazi ya function/method/variable names
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Msimbo umeandikwa kwa uwazi, ukielezea nia na hali za ukomo
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Hakuna vifaa nyeti katika historia ya marekebisho, masuala, au ombi la kuvuta (kwa mfano, nywila au taarifa nyingine zisizo za umma)
  </label>
</div>

**Watu**

Ikiwa wewe ni mtu binafsi:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  Umezungumza na idara ya kisheria na/au kuelewa sera za IP na open source za kampuni yako (ikiwa wewe ni mfanyakazi mahali fulani)
  </label>
</div>

Ikiwa wewe ni kampuni au shirika:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Umezungumza na idara yako ya kisheria
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Una mpango wa masoko wa kutangaza na kukuza mradi
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Mtu mmoja amejiandikisha kusimamia mwingiliano wa jamii (kujibu masuala, kupitia na kuunganisha ombi la kuvuta)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Angalau watu wawili wana ufikiaji wa utunzaji wa mradi
  </label>
</div>

## Umefanya!

Hongera kwa kuanzisha mradi wako wa kwanza wa open source. Bila kujali matokeo, kufanya kazi hadharani ni zawadi kwa jamii. Kwa kila commit, maoni, na ombi la kuvuta, unaunda fursa kwako mwenyewe na kwa wengine kujifunza na kukua.
