---
lang: sw
title: Takwimu za Open Source
description: Fanya maamuzi yenye taarifa ili kusaidia mradi wako wa open source kufanikiwa kwa kupima na kufuatilia mafanikio yake.
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## Kwa nini kupima chochote?

Data, inapotumika kwa busara, inaweza kusaidia kufanya maamuzi bora kama mtunzaji wa open source.

Kwa taarifa zaidi, unaweza:

* Elewa jinsi watumiaji wanavyopokea kipengele kipya
* Gundua wapi watumiaji wapya hutoka
* Tambua, na uamue ikiwa utaunga mkono, kesi ya matumizi ya nje au utendakazi
* Kupima umaarufu wa mradi wako
* Kuelewa jinsi mradi wako unavyotumika
* Kuongeza fedha kupitia udhamini na ruzuku

Kwa mfano, [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) inagundua kuwa Google Analytics inawasaidia kuzingatia kazi:

> Homebrew inatolewa bure na inasimamiwa na wajitolea katika wakati wao wa ziada. Kama matokeo, hatuna rasilimali za kufanya utafiti wa kina wa watumiaji wa Homebrew ili kuamua jinsi ya kubuni vipengele vya baadaye na kuzingatia kazi za sasa. Takwimu za watumiaji wa kawaida zinaturuhusu kuzingatia marekebisho na vipengele kulingana na jinsi, wapi, na wakati watu wanavyotumia Homebrew.

Umaarufu si kila kitu. Kila mtu anaingia kwenye open source kwa sababu tofauti. Ikiwa lengo lako kama mtunzaji wa open source ni kuonyesha kazi yako, kuwa wazi kuhusu msimbo wako, au tu kufurahia, takwimu huenda zisikuhusu.

Ikiwa _unavutiwa_ na kuelewa mradi wako kwa kiwango cha kina, endelea kusoma kwa njia za kuchambua shughuli za mradi wako.

## Ugunduzi

Kabla ya mtu yeyote kutumia au kuchangia mradi wako, wanahitaji kujua kuwa upo. Jiulize: _je, watu wanaupata mradi huu?_

![Grafu ya trafiki](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

Ikiwa mradi wako unahifadhiwa kwenye GitHub, [unaweza kuona](https://help.github.com/articles/about-repository-graphs/#traffic) ni watu wangapi wanaotembelea mradi wako na wanatoka wapi. Kutoka kwenye ukurasa wa mradi wako, bonyeza "Insights", kisha "Traffic". Katika ukurasa huu, unaweza kuona:

* **Total page views:** Inakuambia ni mara ngapi mradi wako umekaguliwa

* **Total unique visitors:** Inakuambia ni watu wangapi walitembelea mradi wako

* **Referring sites:** Inakuambia wapi wageni walitoka. Takwimu hii inaweza kusaidia kubaini wapi kufikia hadhira yako na ikiwa juhudi zako za matangazo zinafanya kazi.

* **Popular content:** Inakuambia wageni wanakoenda kwenye mradi wako, ikigawanywa kwa maoni na wageni wa kipekee.

[GitHub stars](https://help.github.com/articles/about-stars/) pia zinaweza kusaidia kutoa kipimo cha msingi cha umaarufu. Ingawa nyota za GitHub hazihusiani moja kwa moja na upakuaji na matumizi, zinaweza kukuambia ni watu wangapi wanachukua tahadhari kwa kazi yako.

Huenda pia ukataka [kufuatilia ugunduzi katika maeneo maalum](https://opensource.com/business/16/6/pirate-metrics): kwa mfano, Google PageRank, trafiki inayorejelea kutoka kwenye tovuti ya mradi wako, au marejeleo kutoka kwa miradi mingine ya open source au tovuti.

## Matumizi

Watu wanaupata mradi wako kwenye hiki kitu cha ajabu tunayoiita mtandao. Kwa kawaida, wanapoona mradi wako, watapaswa kuhisi kutaka kufanya jambo. Swali la pili unalotaka kujiuliza ni: _je, watu wanatumia mradi huu?_

Ikiwa unatumia package manager, kama npm au RubyGems.org, kusambaza mradi wako, huenda ukawa na uwezo wa kufuatilia upakuaji wa mradi wako.

Kila package manager unaweza kutumia ufafanuzi tofauti wa "download", na downloads hauhusiani moja kwa moja na usakinishaji au matumizi, lakini unatoa kipimo fulani cha kulinganisha. Jaribu kutumia [Libraries.io](https://libraries.io/) kufuatilia takwimu za matumizi katika meneja maarufu wa pakiti.

Ikiwa mradi wako uko kwenye GitHub, tembelea tena ukurasa wa "Traffic". Unaweza kutumia [grafu ya clone](https://github.com/blog/1873-clone-graphs) kuona ni mara ngapi mradi wako umeklonwa kwa siku fulani, ikigawanywa kwa clones za jumla na waklonaji wa kipekee.

![Grafu ya clone](/assets/images/metrics/clone_graph.png)

Ikiwa matumizi ni ya chini ikilinganishwa na idadi ya watu wanaogundua mradi wako, kuna masuala mawili ya kuzingatia. Ama:

* Mradi wako haufanikiwi kubadilisha hadhira yako, au
* Unavutia hadhira isiyo sahihi

Kwa mfano, ikiwa mradi wako unapatikana kwenye ukurasa wa mbele wa Hacker News, huenda ukapata ongezeko la ugunduzi (trafiki), lakini kiwango cha kubadilisha ni cha chini, kwa sababu unawafikia watu wote kwenye Hacker News. Ikiwa mradi wako wa Ruby unajulikana kwenye mkutano wa Ruby, hata hivyo, huenda ukapata kiwango cha juu cha kubadilisha kutoka kwa hadhira iliyolengwa.

Jaribu kubaini wapi hadhira yako inatoka na kuwauliza wengine maoni kuhusu ukurasa wako wa mradi ili kubaini ni ipi kati ya masuala haya mawili unayokabiliana nayo.

Mara tu unapoelewa kuwa watu wanatumia mradi wako, huenda ukataka kujua wanachofanya nacho. Je, wanajenga juu yake kwa kufork msimbo wako na kuongeza vipengele? Je, wanatumia kwa ajili ya sayansi au biashara?

## Uhifadhi

Watu wanaupata mradi wako na wanatumia. Swali la tatu unalotaka kujiuliza ni: _je, watu wanachangia mradi huu?_

Kamwe si mapema sana kuanza kufikiria kuhusu wachangiaji. Bila watu wengine kusaidia, unakabiliwa na hatari ya kujitumbukiza katika hali isiyo ya afya ambapo mradi wako ni _maarufu_ (watu wengi wanatumia) lakini _hauungwi mkono_ (sio muda wa kutosha wa watunzaji kukidhi mahitaji).

Uhifadhi pia unahitaji [kuongezeka kwa wachangiaji wapya](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2), kwani wachangiaji waliokuwa na shughuli hapo awali hatimaye watahamia kwenye mambo mengine.

Mifano ya takwimu za jamii ambazo unaweza kutaka kufuatilia mara kwa mara ni pamoja na:

* **Idadi ya jumla ya wachangiaji na idadi ya commits kwa kila mchangiaji:** Inakuambia ni wachangiaji wangapi unao, na nani yuko na shughuli zaidi au chini. Kwenye GitHub, unaweza kuona hii chini ya "Insights" -> "Contributors." Hivi sasa, grafu hii inahesabu tu wachangiaji ambao wamefanya commit kwenye tawi la msingi la hifadhi.

![Grafu ya wachangiaji](/assets/images/metrics/repo_contributors_specific_graph.png)

* **Wachangiaji wa mara ya kwanza, wa kawaida, na wa kurudi:** Hii husaidia kufuatilia ikiwa unapata wachangiaji wapya, na ikiwa wanarudi. (Wachangiaji wa kawaida ni wachangiaji wenye idadi ndogo ya commits. Ikiwa ni commit moja, chini ya commits tano, au kitu kingine, inategemea wewe.) Bila wachangiaji wapya, jamii ya mradi wako inaweza kuwa ya kusimama.

* **Idadi ya masuala wazi na ombi za kuvuta wazi:** Ikiwa hizi nambari zinakuwa kubwa sana, huenda ukahitaji msaada katika kuangalia masuala na mapitio ya msimbo.

* **Idadi ya masuala _iliyofunguliwa_ na ombi za kuvuta _iliyofunguliwa_:** Masuala yaliyofunguliwa yanamaanisha mtu anajali vya kutosha kuhusu mradi wako kufungua suala. Ikiwa nambari hiyo inaongezeka kwa muda, inamaanisha watu wanavutiwa na mradi wako.

* **Aina za michango:** Kwa mfano, commits, kurekebisha makosa au typos, au kutoa maoni kwenye suala.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  Open Source ni zaidi ya msimbo tu. Miradi ya open source yenye mafanikio inajumuisha michango ya msimbo na nyaraka pamoja na mazungumzo kuhusu mabadiliko haya.
  <p markdown="1" class="pquote-credit">
— @arfon, ["Umbo la Open Source"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## Shughuli za watunzaji

Hatimaye, unapaswa kufunga mzunguko kwa kuhakikisha kwamba watunzaji wa mradi wako wanaweza kushughulikia kiasi cha michango wanayopokea. Swali la mwisho unalotaka kujiuliza ni: _je, mimi (au sisi) tunajibu jamii yetu?_

Watunzaji wasiojibu wanakuwa kizuizi kwa miradi ya open source. Ikiwa mtu anawasilisha mchango lakini hajawahi kusikia kutoka kwa mtunzaji, wanaweza kujisikia kukatishwa tamaa na kuondoka.

[Utafiti kutoka Mozilla](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) unashauri kwamba ufanisi wa watunzaji ni kipengele muhimu katika kuhamasisha michango ya kurudi.

Fikiria [kufuatilia ni muda gani inachukua kwako (au mtunzaji mwingine) kujibu michango](https://github.blog/2023-07-19-metrics-for-issues-pull-requests-and-discussions/), iwe suala au ombi la kuvuta. Kujibu hakuhitaji kuchukua hatua. Inaweza kuwa rahisi kama kusema: _"Asante kwa kuwasilisha! Nitaangalia hii ndani ya wiki ijayo."_

Pia unaweza kupima muda inachukua kuhamasisha kati ya hatua katika mchakato wa mchango, kama vile:

* Wakati wa wastani suala linabaki wazi
* Ikiwa masuala yanakamilishwa na PRs
* Ikiwa masuala ya zamani yanakamilishwa
* Wakati wa wastani wa kuunganishwa kwa ombi la kuvuta

## Tumia 📊 kujifunza kuhusu watu

Kuelewa takwimu kutakusaidia kujenga mradi wa open source unaokua na wenye shughuli. Hata kama hujafuatilia kila takwimu kwenye dashibodi, tumia mfumo huu kulenga umakini wako kwenye aina ya tabia ambayo itasaidia mradi wako kufanikiwa.

[CHAOSS](https://chaoss.community/) ni jamii ya wazi inayokaribisha inayolenga uchambuzi, takwimu na programu za afya ya jamii.
