---
lang: sw
title: Upande wa Kisheria wa Open Source
description: Kila kitu ambacho umewahi kujiuliza kuhusu upande wa kisheria wa open source, na mambo machache ambayo hujui.
class: legal
order: 10
image: /assets/images/cards/legal.png
related:
  - contribute
  - leadership
---

## Kuelewa athari za kisheria za open source

Kushiriki kazi yako ya ubunifu na ulimwengu kunaweza kuwa uzoefu wa kusisimua na wa kuridhisha. Pia kunaweza kumaanisha mambo mengi ya kisheria ambayo hujui unapaswa kuwa na wasiwasi nayo. Kwa bahati nzuri, kwa mwongozo huu utapata pahali pa kuanzia. (Kabla hujaanza, hakikisha unasoma [kanusho letu](/notices/).)

## Kwa nini watu wanajali sana upande wa kisheria wa open source?

Nafurahi umeniuliza! Unapofanya kazi ya ubunifu (kama kuandika, picha, au msimbo), kazi hiyo inakuwa chini ya hakimiliki ya kipekee kwa default. Hiyo ni kusema, sheria inadhani kwamba kama mwandishi wa kazi yako, una sauti katika kile wengine wanaweza kufanya nayo.

Kwa ujumla, hiyo inamaanisha hakuna mtu mwingine anaweza kutumia, kunakili, kusambaza, au kubadilisha kazi yako bila kuwa katika hatari ya kuondolewa, kutishiwa, au kesi.

Hata hivyo, open source ni hali isiyo ya kawaida, kwa sababu mwandishi anatarajia kwamba wengine watatumia, kubadilisha, na kushiriki kazi hiyo. Lakini kwa sababu msingi wa kisheria bado ni hakimiliki ya kipekee, unahitaji kutoa ruhusa hizi waziwazi kwa leseni.

Sheria hizi pia zinatumika wakati mtu anachangia kwenye mradi wako. Bila leseni au makubaliano mengine yaliyowekwa, michango yoyote inamilikiwa kwa kipekee na waandishi wao. Hiyo inamaanisha hakuna mtu -- hata wewe -- anaweza kutumia, nakala, kusambaza, au kubadilisha michango yao.

Hatimaye, mradi wako unaweza kuwa na utegemezi wenye mahitaji ya leseni ambayo hujui. Jamii ya mradi wako, au sera za mwajiri wako, pia zinaweza kuhitaji mradi wako kutumia leseni maalum za open source. Tutazungumzia hali hizi hapa chini.

## Je, miradi ya umma ya GitHub ni open source?

Unapounda [mradi mpya](https://help.github.com/articles/creating-a-new-repository/) kwenye GitHub, una chaguo la kufanya hifadhi kuwa **binafsi** au **ya umma**.

![Unda hifadhi](/assets/images/legal/repo-create-name.png)

**Kufanya mradi wako wa GitHub kuwa wa umma si sawa na kutoa leseni kwa mradi wako.** Miradi ya umma inafunikwa na [Masharti ya Huduma ya GitHub](https://docs.github.com/en/site-policy/github-terms/github-terms-of-service#3-ownership-of-content-right-to-post-and-license-grants), ambayo inaruhusu wengine kuona na kufork mradi wako, lakini kazi yako kwa ujumla haina ruhusa yoyote.

Ikiwa unataka wengine watumie, wasambaze, wabadilishe, au wachangie mradi wako, unahitaji kujumuisha leseni ya open source. Kwa mfano, mtu hawezi kutumia kisheria sehemu yoyote ya mradi wako wa GitHub katika msimbo wao, hata ikiwa ni ya umma, isipokuwa unawapa wazi haki ya kufanya hivyo.

## Nipe tu muhtasari wa kile ninachohitaji kulinda mradi wangu.

Uko bahati, kwa sababu leo, leseni za open source zimekuwa za kawaida na rahisi kutumia. Unaweza kunakili na kubandika leseni iliyopo moja kwa moja kwenye mradi wako.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), na [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) ni [leseni maarufu za open source](https://innovationgraph.github.com/global-metrics/licenses), lakini kuna chaguzi nyingine za kuchagua. Unaweza kupata maandiko kamili ya leseni hizi, na maelekezo ya jinsi ya kuzitumia, kwenye [choosealicense.com](https://choosealicense.com/).

Unapounda mradi mpya kwenye GitHub, utaulizwa kuongeza leseni [hapa](https://help.github.com/articles/open-source-licensing/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/benbalter?s=180" class="pquote-avatar" alt="avatar">
  Leseni iliyokuwa ya kawaida inatumika kama mbadala kwa wale wasio na mafunzo ya kisheria kujua kwa usahihi kile wanachoweza na hawawezi kufanya na programu. Isipokuwa inahitajika kabisa, epuka masharti ya kawaida, yaliyobadilishwa, au yasiyo ya kawaida, ambayo yatakuwa kizuizi kwa matumizi ya chini ya msimbo wa wakala.
  <p markdown="1" class="pquote-credit">
— @benbalter, ["Kila kitu ambacho wakili wa serikali anahitaji kujua kuhusu leseni ya programu ya open source"](https://ben.balter.com/2014/10/08/open-source-licensing-for-government-attorneys/)
  </p>
</aside>

## Leseni ipi ya open source inafaa kwa mradi wangu?

Ni vigumu kukosea na [Leseni ya MIT](https://choosealicense.com/licenses/mit/) ikiwa unaanza na karatasi tupu. Ni fupi, inayoeleweka kwa urahisi, na inaruhusu mtu yeyote kufanya chochote mradi tu wahifadhi nakala ya leseni, ikiwa ni pamoja na taarifa yako ya hakimiliki. Utaweza kutoa mradi huo chini ya leseni tofauti ikiwa utahitaji.

Vinginevyo, kuchagua leseni sahihi ya open source kwa mradi wako inategemea malengo yako.

Mradi wako huenda una (au utakuwa na) **utegemezi(dependencies)**, kila mmoja wao utakuwa na leseni yake ya open source yenye masharti unayohitaji kuheshimu. Kwa mfano, ikiwa unatoa mradi wa Node.js kama open source, huenda ukatumia maktaba kutoka Meneja wa Kifurushi cha Node (npm).

Utegemezi wenye **leseni za ruhusa** kama [MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), [ISC](https://choosealicense.com/licenses/isc), na [BSD](https://choosealicense.com/licenses/bsd-3-clause) zinakuruhusu kutoa leseni kwa mradi wako jinsi unavyotaka.

Utegemezi wenye **leseni za copyleft** unahitaji umakini zaidi. Kujumuisha maktaba yoyote yenye leseni "ngumu" ya copyleft kama [GPLv2](https://choosealicense.com/licenses/gpl-2.0), [GPLv3](https://choosealicense.com/licenses/gpl-3.0), au [AGPLv3](https://choosealicense.com/licenses/agpl-3.0) inahitaji wewe kuchagua leseni sawa au [iliyofaa](https://www.gnu.org/licenses/license-list.en.html#GPLCompatibleLicenses) kwa mradi wako. Maktaba zenye leseni "dhaifu" au "kikomo" cha copyleft kama [MPL 2.0](https://choosealicense.com/licenses/mpl-2.0/) na [LGPL](https://choosealicense.com/licenses/lgpl-3.0/) zinaweza kujumuishwa katika miradi yenye leseni yoyote, mradi tu ufuate [sheria za ziada](https://fossa.com/blog/all-about-copyleft-licenses/#:~:text=weak%20copyleft%20licenses%20also%20obligate%20users%20to%20release%20their%20changes.%20however%2C%20this%20requirement%20applies%20to%20a%20narrower%20set%20of%20code.) wanazozitaja.

Huenda pia ukataka kuzingatia **jamii** unazotarajia zitumie na kuchangia mradi wako:

* **Je, unataka mradi wako utumike kama utegemezi na miradi mingine?** Huenda ni bora kutumia leseni maarufu zaidi katika jamii yako inayohusiana. Kwa mfano, [MIT](https://choosealicense.com/licenses/mit/) ndiyo leseni maarufu zaidi kwa [maktaba za npm](https://libraries.io/search?platforms=NPM).
* **Je, unataka mradi wako uvutie biashara kubwa?** Biashara kubwa inaweza kuwa na faraja kutokana na leseni ya wazi ya patent kutoka kwa wachangiaji wote. Katika kesi hii, [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) inakuhakikishia (na wao).
* **Je, unataka mradi wako uvutie wachangiaji ambao hawataki michango yao itumike katika programu za software zilizofungwa?** [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) au (ikiwa pia hawataki kuchangia katika huduma za software kilichofungwa) [AGPLv3](https://choosealicense.com/licenses/agpl-3.0/) itakuwa nzuri.

**Kampuni yako** inaweza kuwa na sera za leseni za miradi ya open source. Baadhi ya kampuni zinahitaji miradi yako kuwa na leseni ya ruhusa ili kuruhusu kuunganishwa na bidhaa za kampuni. Sera nyingine zinaweka leseni ya copyleft kali na makubaliano ya ziada ya wachangiaji ([ona hapa chini](#je-mradi-wangu-unahitaji-makubaliano-ya-ziada-ya-wachangiaji)) ili kampuni yako pekee iweze kutumia mradi huo katika programu za closed source software. Mashirika yanaweza pia kuwa na viwango fulani, malengo ya uwajibikaji wa kijamii, au mahitaji ya uwazi ambayo yanaweza kuhitaji mkakati maalum wa leseni. Zungumza na [idara ya kisheria ya kampuni yako](#ni-nini-ambacho-timu-yangu-ya-kisheria-ya-kampuni-inahitaji-kujua) kwa mwongozo.

Unapounda mradi mpya kwenye GitHub, unapata chaguo la kuchagua leseni. Kujumuisha moja ya leseni zilizotajwa hapo juu kutafanya mradi wako wa GitHub kuwa open source. Ikiwa ungependa kuona chaguzi nyingine, angalia [choosealicense.com](https://choosealicense.com) ili kupata leseni sahihi kwa mradi wako, hata ikiwa [siyo programu](https://choosealicense.com/non-software/).

## Nifanye nini ikiwa nataka kubadilisha leseni ya mradi wangu?

Miradi mingi kamwe hazihitaji kubadilisha leseni. Lakini wakati mwingine hali hubadilika.

Kwa mfano, mradi wako unavyokua unapata utegemezi au watumiaji, au kampuni yako inabadilisha mikakati, yoyote kati ya hizi inaweza kuhitaji au kutaka leseni tofauti. Pia, ikiwa umepuuza kutoa leseni kwa mradi wako tangu mwanzo, kuongeza leseni ni sawa na kubadilisha leseni. Kuna mambo matatu ya msingi ya kuzingatia unapoongeza au kubadilisha leseni ya mradi wako:

**Ni ngumu.** Kuweka wazi ulinganifu wa leseni na kufuata sheria na nani anashikilia hakimiliki kunaweza kuwa ngumu na kuchanganya haraka. Kubadilisha leseni mpya lakini inayofaa kwa matoleo mapya na michango ni tofauti na kubadilisha leseni ya michango yote iliyopo. Wajulishe timu yako ya kisheria mara tu unapohisi kuwa na tamaa ya kubadilisha leseni. Hata ikiwa una au unaweza kupata ruhusa kutoka kwa wamiliki wa hakimiliki wa mradi wako kwa kubadilisha leseni, zingatia athari za mabadiliko hayo kwa watumiaji na wachangiaji wengine wa mradi wako. Fikiria kubadilisha leseni kama "tukio la utawala" kwa mradi wako ambalo litakuwa rahisi zaidi ikiwa kutakuwa na mawasiliano wazi na ushauri na wadau wa mradi wako. Hii ni sababu zaidi ya kuchagua na kutumia leseni inayofaa kwa mradi wako kutokea mwanzo!

**Leseni ya sasa ya mradi wako.** Ikiwa leseni ya sasa ya mradi wako inaingiliana na leseni unayotaka kubadilisha, unaweza kuanza kutumia leseni mpya. Hiyo ni kwa sababu ikiwa leseni A inaingiliana na leseni B, utatii masharti ya A wakati unatii masharti ya B (lakini si lazima kinyume chake). Hivyo basi ikiwa unatumia leseni ya ruhusa (k.m., MIT), unaweza kubadilisha kuwa leseni yenye masharti zaidi, mradi tu uhifadhi nakala ya leseni ya MIT na taarifa yoyote ya hakimiliki inayohusiana (yaani, endelea kutii masharti madogo ya leseni ya MIT). Lakini ikiwa leseni yako ya sasa si ya ruhusa (k.m., copyleft, au huna leseni) na wewe si mmiliki pekee wa hakimiliki, huwezi kubadilisha leseni ya mradi wako kuwa MIT. Kimsingi, kwa leseni ya ruhusa wamiliki wa hakimiliki wa mradi wamepewa ruhusa mapema kubadilisha leseni.

**Wamiliki wa hakimiliki wa mradi wako.** Ikiwa wewe ndiye wa kuchanga pekee wa mradi wako basi wewe au kampuni yako ndiye mmiliki pekee wa hakimiliki wa mradi huo. Unaweza kuongeza au kubadilisha kuwa leseni yoyote unayotaka. Vinginevyo, huenda kuna wamiliki wengine wa hakimiliki ambao unahitaji makubaliano kutoka kwao ili kubadilisha leseni. Ni nani hao? [Watu walio na commits katika mradi wako](https://github.com/thehale/git-authorship) ni mahali pazuri pa kuanzia. Lakini katika baadhi ya matukio hakimiliki itashikiliwa na waajiri wa watu hao. Katika baadhi ya matukio watu watakuwa wamefanya michango ya chini tu, lakini hakuna sheria kali na ya haraka kwamba michango chini ya idadi fulani ya mistari ya msimbo haipaswi kuwa chini ya hakimiliki. Unapaswa kufanya nini? Inategemea. Kwa mradi mdogo na mchanga, inaweza kuwa rahisi kupata wachangiaji wote waliopo kukubali mabadiliko ya leseni katika suala au ombi la kuvuta. Kwa miradi mikubwa na ya muda mrefu, huenda ukahitaji kutafuta wachangiaji wengi na hata warithi wao. Mozilla ilichukua miaka (2001-2006) kubadilisha leseni ya Firefox, Thunderbird, na programu zinazohusiana.

Vinginevyo, unaweza kuwa na wachangiaji wakikubali mabadiliko fulani ya leseni kwa makubaliano ya ziada ya wachangiaji ([ona hapa chini](#je-mradi-wangu-unahitaji-makubaliano-ya-ziada-ya-wachangiaji). Hii inahamisha ugumu wa kubadilisha leseni kidogo. Utahitaji msaada zaidi kutoka kwa wanasheria wako mapema, na bado utataka kuwasiliana wazi na wadau wa mradi wako unapotekeleza mabadiliko ya leseni.

## Je, mradi wangu unahitaji makubaliano ya ziada ya wachangiaji?

Huenda si. Kwa sehemu kubwa ya miradi ya open source, leseni ya open source inatumika kimya kama leseni ya kuingia (kutoka kwa wachangiaji) na leseni ya kutoka (kwa wachangiaji wengine na watumiaji). Ikiwa mradi wako uko kwenye GitHub, Masharti ya Huduma ya GitHub yanafanya "kuingia=kuondoka" kuwa [wa kutumika](https://help.github.com/en/github/site-policy/github-terms-of-service#6-contributions-under-repository-license).

Makubaliano ya ziada ya wachangiaji -- mara nyingi huitwa Contributor License Agreement (CLA) -- yanaweza kuunda kazi za kiutawala kwa watunzaji wa mradi. Kiasi gani kazi makubaliano yanaongeza inategemea mradi na utekelezaji. Makubaliano rahisi yanaweza kuhitaji wachangiaji kuthibitisha, kwa kubonyeza, kwamba wana haki zinazohitajika kuchangia chini ya leseni ya open source ya mradi. Makubaliano magumu zaidi yanaweza kuhitaji ukaguzi wa kisheria na idhini kutoka kwa waajiri wa wachangiaji.

Pia, kwa kuongeza "karatasi" ambayo wengine wanaweza kuamini kuwa si ya lazima, ngumu kueleweka, au isiyo ya haki (wakati mpokeaji wa makubaliano anapata haki zaidi kuliko wachangiaji au umma kupitia leseni ya open source ya mradi), makubaliano ya ziada ya wachangiaji yanaweza kuonekana kama yasiyo ya kirafiki kwa jamii ya mradi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/bcantrill?s=180" class="pquote-avatar" alt="avatar">
  Tumefuta CLA kwa Node.js. Kufanya hivyo kunapunguza kizuizi cha kuingia kwa wachangiaji wa Node.js hivyo kupanua msingi wa wachangiaji.
  <p markdown="1" class="pquote-credit">
— @bcantrill, ["Kupanua Michango ya Node.js"](https://www.tritondatacenter.com/blog/broadening-node-js-contributions)
  </p>
</aside>

Baadhi ya hali ambapo huenda ukataka kuzingatia makubaliano ya ziada ya wachangiaji kwa mradi wako ni pamoja na:

* Wanasheria wako wanataka wachangiaji wote kukubali wazi (_saini_, mtandaoni au nje ya mtandao) masharti ya mchango, labda kwa sababu wanahisi leseni ya open source yenyewe haitoshi (hata ingawa inatosha!). Ikiwa hii ndiyo wasiwasi pekee, makubaliano ya wachangiaji yanayothibitisha leseni ya open source ya mradi yanapaswa kutosha. [Makubaliano ya Leseni ya Mchangiaji wa jQuery](https://web.archive.org/web/20161013062112/http://contribute.jquery.org/CLA/) ni mfano mzuri wa makubaliano ya ziada ya wachangiaji yenye uzito mdogo.
* Wewe au wanasheria wako wanataka waendelezaji kuthibitisha kwamba kila commit wanayofanya imeidhinishwa. [Cheti cha Mwandiko wa Asili](https://developercertificate.org/) ni jinsi miradi mingi inavyofikia hili. Kwa mfano, jamii ya Node.js [inatumia](https://github.com/nodejs/node/blob/HEAD/CONTRIBUTING.md) DCO [badala](https://nodejs.org/en/blog/uncategorized/notes-from-the-road/#easier-contribution) ya CLA yao ya awali. Chaguo rahisi la kuimarisha utekelezaji wa DCO kwenye hifadhi yako ni [DCO Probot](https://github.com/probot/dco).
* Mradi wako unatumia leseni ya open source ambayo haina ruhusa ya wazi ya patent (kama MIT), na unahitaji ruhusa ya patent kutoka kwa wachangiaji wote, baadhi yao wanaweza kufanya kazi kwa kampuni zenye mifuko mikubwa ya patent ambazo zinaweza kutumika kukulenga wewe au wachangiaji na watumiaji wengine wa mradi. [Makubaliano ya Leseni ya Mchangiaji wa Apache](https://www.apache.org/licenses/icla.pdf) ni makubaliano ya ziada ya wachangiaji yanayotumika mara nyingi ambayo yana ruhusa ya patent inayofanana na ile inayopatikana katika Leseni ya Apache 2.0.
* Mradi wako uko chini ya leseni ya copyleft, lakini unahitaji pia kusambaza toleo la miliki la mradi. Utahitaji kila mchango kukabidhi hakimiliki kwako au kukupa (lakini si umma) leseni ya ruhusa. [Makubaliano ya Mchangiaji wa MongoDB](https://www.mongodb.com/legal/contributor-agreement) ni mfano wa aina hii ya makubaliano.
* Unafikiri mradi wako huenda ukahitaji kubadilisha leseni katika maisha yake na unataka wachangiaji wakubali mapema mabadiliko kama hayo.

Ikiwa unahitaji kutumia makubaliano ya ziada ya wachangiaji na mradi wako, fikiria kutumia ujumuishaji kama [CLA assistant](https://github.com/cla-assistant/cla-assistant) ili kupunguza usumbufu kwa wachangiaji.

## Ni nini ambacho timu yangu ya kisheria ya kampuni inahitaji kujua?

Ikiwa unatoa mradi wa open source kama mfanyakazi wa kampuni, kwanza, timu yako ya kisheria inapaswa kujua kwamba unatoa mradi wa open source.

Kwa mema au mabaya, fikiria kuwaambia hata ikiwa ni mradi wa kibinafsi. Huenda una "makubaliano ya IP ya mfanyakazi" na kampuni yako ambayo inawapa udhibiti fulani wa miradi yako, hasa ikiwa yanahusiana na biashara ya kampuni au unatumia rasilimali zozote za kampuni kuendeleza mradi huo. Kampuni yako _inapaswa_ kukupa ruhusa kwa urahisi, na huenda tayari imefanya hivyo kupitia makubaliano ya IP rafiki kwa mfanyakazi au sera ya kampuni. Ikiwa si hivyo, unaweza kujadili (kwa mfano, eleza kwamba mradi wako unahudumia malengo ya kujifunza na maendeleo ya kitaaluma ya kampuni kwako), au epuka kufanya kazi kwenye mradi wako hadi upate kampuni bora.

**Ikiwa unatoa mradi wa open source kwa kampuni yako,** basi hakika waambie. Timu yako ya kisheria huenda tayari ina sera za nini leseni ya open source (na labda makubaliano ya ziada ya wachangiaji) inapaswa kutumika kulingana na mahitaji ya biashara ya kampuni na utaalamu wa kuhakikisha mradi wako unatii leseni za utegemezi wake. Ikiwa si hivyo, wewe na wao mko bahati! Timu yako ya kisheria inapaswa kuwa na hamu ya kufanya kazi nawe ili kufafanua mambo haya. Mambo kadhaa ya kuzingatia:

* **Vifaa vya wahusika wengine:** Je, mradi wako una utegemezi ulioandaliwa na wengine au vinginevyo unajumuisha au kutumia msimbo wa wengine? Ikiwa hizi ni open source, utahitaji kuzingatia leseni za vifaa hivyo vya open source. Hiyo inaanza na kuchagua leseni inayofanya kazi na leseni za open source za wahusika wengine ([ona hapo juu](#leseni-ipi-ya-open-source-inafaa-kwa-mradi-wangu)). Ikiwa mradi wako unarekebisha au kusambaza vifaa vya open source vya wahusika wengine, basi timu yako ya kisheria itataka kujua kwamba unakidhi masharti mengine ya leseni za open source za wahusika wengine kama vile kuhifadhi taarifa za hakimiliki. Ikiwa mradi wako unatumia msimbo wa wengine ambao huna leseni ya open source, huenda ukahitaji kuwaomba watunzaji wa wahusika wengine [kuongeza leseni ya open source](https://choosealicense.com/no-license/#for-users), na ikiwa huwezi kupata moja, acha kutumia msimbo wao katika mradi wako.

* **Siri za biashara:** Fikiria ikiwa kuna kitu chochote katika mradi ambacho kampuni haitaki kupatikana kwa umma. Ikiwa ndivyo, unaweza kutoa open source cha mradi wako, baada ya kutoa vifaa unavyotaka kuweka faragha.

* **Patenti:** Je, kampuni yako inatumia patente ambayo kutoa open source kwa mradi wako kutakuwa [ufichuzi wa umma](https://en.wikipedia.org/wiki/Public_disclosure)? Kwa bahati mbaya, huenda ukatakiwa kusubiri (au labda kampuni itafikiria tena hekima ya maombi). Ikiwa unatarajia michango kwa mradi wako kutoka kwa wafanyakazi wa kampuni zenye mifuko mikubwa ya patent, timu yako ya kisheria inaweza kutaka uweke leseni yenye ruhusa ya wazi ya patent kutoka kwa wachangiaji (kama vile Apache 2.0 au GPLv3), au makubaliano ya ziada ya wachangiaji ([ona hapo juu](#leseni-ipi-ya-open-source-inafaa-kwa-mradi-wangu)).

* **Alama za biashara:** Hakikisha jina la mradi wako [halipingani na alama zozote zilizopo](../starting-a-project/#kuepuka-migongano-ya-majina). Ikiwa unatumia alama za biashara za kampuni yako katika mradi, hakikisha kwamba haileti migongano yoyote. [FOSSmarks](http://fossmarks.org/) ni mwongozo wa vitendo wa kuelewa alama katika muktadha wa miradi ya bure na open source.

* **Faragha:** Je, mradi wako unakusanya data kuhusu watumiaji? "Simu nyumbani" kwa seva za kampuni? Timu yako ya kisheria inaweza kukusaidia kuzingatia sera za kampuni na kanuni za nje.

Ikiwa unatoa mradi wa kwanza wa open source wa kampuni yako, mambo yaliyo hapo juu yanatosha kupita (lakini usijali, miradi mingi haipaswi kuleta wasiwasi wowote mkubwa).

Kwa muda mrefu, timu yako ya kisheria inaweza kufanya zaidi kusaidia kampuni kupata zaidi kutoka kwa ushiriki wake katika open source, na kubaki salama:

* **Sera za mchango wa wafanyakazi:** Fikiria kuunda sera ya kampuni inayobainisha jinsi wafanyakazi wako wanavyoshiriki katika miradi ya open source. Sera wazi itapunguza mkanganyiko kati ya wafanyakazi wako na kuwasaidia kuchangia katika miradi ya open source kwa maslahi bora ya kampuni, iwe kama sehemu ya kazi zao au katika wakati wao wa ziada. Mfano mzuri ni [Sera ya Mfano ya IP na Mchango wa open source ya Rackspace](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/vanl?s=180" class="pquote-avatar" alt="avatar">
  Kuachilia IP inayohusiana na patch kunajenga msingi wa maarifa na sifa ya mfanyakazi. Inadhihirisha kwamba kampuni imewekeza katika maendeleo ya mfanyakazi huyo na inaunda hisia ya uwezeshaji na uhuru. Faida zote hizi pia zinapelekea morali ya juu na uhifadhi bora wa wafanyakazi.
  <p markdown="1" class="pquote-credit">
— @vanl, ["Mfano wa Sera ya IP na Mchango wa open source"](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/)
  </p>
</aside>

* **Nini cha kutoa:** [(Karibu) kila kitu?](http://tom.preston-werner.com/2011/11/22/open-source-everything.html) Ikiwa timu yako ya kisheria inaelewa na inajihusisha na mkakati wa open source wa kampuni yako, watakuwa bora zaidi kusaidia badala ya kuzuia juhudi zako.
* **Uzingatiaji:** Hata kama kampuni yako haitoi miradi yoyote ya open source, inatumia programu za open source za wengine. [Uelewa na mchakato](https://www.linuxfoundation.org/blog/blog/why-companies-that-use-open-source-need-a-compliance-program/) kunaweza kuzuia maumivu ya kichwa, ucheleweshaji wa bidhaa, na mashtaka.

<aside markdown="1" class="pquote">
  Mashirika yanapaswa kuwa na mkakati wa leseni na uzingatiaji ambao unafaa kwa [kategoria "za ruhusa" na "copyleft"]. Hii inaanza na kuweka rekodi ya masharti ya leseni yanayohusiana na programu ya open source unayotumia — ikiwa ni pamoja na sehemu ndogo na utegemezi.
  <p markdown="1" class="pquote-credit">
— Heather Meeker, ["Programu ya Open Source: Msingi wa Uzingatiaji na Mbinu Bora"](https://techcrunch.com/2012/12/14/open-source-software-compliance-basics-and-best-practices/)
  </p>
</aside>

* **Patenti:** Kampuni yako inaweza kutaka kujiunga na [Mtandao wa Uvumbuzi wa Wazi](https://www.openinventionnetwork.com/), mkataba wa pamoja wa ulinzi wa patent ili kulinda matumizi ya wanachama wa miradi mikubwa ya open source, au kuchunguza [leseni mbadala za patent](https://www.eff.org/document/hacking-patent-system-2016).
* **Utawala:** Haswa ikiwa na wakati inafaa kuhamasisha mradi kwa [entiti ya kisheria nje ya kampuni](../leadership-and-governance/#je-nahitaji-nyaraka-za-utawala-ninapozindua-mradi-wangu).
