---
lang: sw
title: Uongozi na Utawala
description: Kuendeleza miradi ya open source kunaweza kufaidika na sheria rasmi za kufanya maamuzi.
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## Kuelewa utawala kwa mradi wako unaokua

Mradi wako unakua, watu wanahusika, na umejizatiti kuendelea na hili. Katika hatua hii, huenda unajiuliza jinsi ya kuingiza wachangiaji wa kawaida wa mradi katika mtiririko wako wa kazi, iwe ni kumpa mtu ufikiaji wa kuandika au kutatua migogoro ya jamii. Ikiwa una maswali, tuna majibu.

## Ni mifano gani ya majukumu rasmi yanayotumiwa katika miradi ya open source?

Miradi mingi inafuata muundo sawa wa majukumu ya wachangiaji na utambulizi.

Hata hivyo, kile majukumu haya yanamaanisha, ni kabisa juu yako. Hapa kuna aina chache za majukumu unaweza kutambua:

* **Mtunzaji**
* **Mchangiaji**
* **Mwandikaji**

**Kwa miradi fulani, "watunzaji"** ndio watu pekee katika mradi wenye ufikiaji wa kuandika. Katika miradi mingine, wao ni watu tu ambao wameorodheshwa katika README kama watunzaji.

Mtunzaji haimaanishi lazima kuwa mtu anayandika msimbo kwa mradi wako. Inaweza kuwa mtu ambaye amefanya kazi nyingi ya kuhamasisha mradi wako, au ameandika nyaraka ambazo zimefanya mradi kuwa rahisi zaidi kwa wengine. Bila kujali wanavyofanya kazi kila siku, mtunzaji ni mtu ambaye anaweza kuhisi wajibu juu ya mwelekeo wa mradi na amejiandaa kuboresha.

**"Mchangiaji" anaweza kuwa mtu yeyote** anayetoa maoni kwenye suala au ombi la kuvuta, watu wanaoongeza thamani kwa mradi (iwe ni kutunga masuala, kuandika msimbo, au kuandaa matukio), au mtu yeyote mwenye ombi la kuvuta lililopitishwa (labda tafsiri nyembamba zaidi ya mchangiaji).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[Kwa Node.js,\] kila mtu anayekuja kutoa maoni kwenye suala au kuwasilisha msimbo ni mwanachama wa jamii ya mradi. Kuwa na uwezo wa kuwaona inamaanisha kwamba wamevuka mstari kutoka kuwa mtumiaji hadi kuwa mchangiaji.
  <p markdown="1" class="pquote-credit">
— @mikeal, [“Healthy Open Source”](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)
  </p>
</aside>

**Neno "mwandikaji" au "committer"** linaweza kutumika kutofautisha ufikiaji wa kuandika, ambayo ni aina maalum ya wajibu, kutoka kwa aina nyingine za mchango.

Ingawa unaweza kufafanua majukumu ya mradi wako kwa njia yoyote unavyopenda, [zingatia kutumia tafsiri pana](../how-to-contribute/#nini-maana-ya-kuchangia) ili kuhamasisha aina zaidi za mchango. Unaweza kutumia majukumu ya uongozi kutambua rasmi watu ambao wamefanya michango bora kwa mradi wako, bila kujali ujuzi wao wa kiufundi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  Huenda unanijua kama "mvumbuzi" wa Django...lakini kweli mimi ni mtu aliyeajiriwa kufanya kazi kwenye jambo mwaka mmoja baada yake kutengenezwa. (...) Watu hudhani kuwa mimi ni mwenye mafanikio kwa sababu ya ujuzi wangu wa kuandika programu...lakini mimi ni mwandishi wa programu wa kawaida tu.
  <p markdown="1" class="pquote-credit">
— @jacobian, ["Hotuba ya Mfunguo wa PyCon 2015" (video)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)
  </p>
</aside>

## Je, ninawezaje kuimarisha majukumu haya ya uongozi?

Kuimarisha majukumu yako ya uongozi husaidia watu kuhisi umiliki na kuwaambia wanajamii wengine ni nani wa kumtazama kwa msaada.

Kwa mradi mdogo, kutaja viongozi kunaweza kuwa rahisi kama kuongeza majina yao kwenye README yako au faili ya CONTRIBUTORS.

Kwa mradi mkubwa, ikiwa una tovuti, tengeneza ukurasa wa timu au orodheshe viongozi wa mradi wako huko. Kwa mfano, [Postgres](https://github.com/postgres/postgres/) ina [ukurasa wa timu wa kina](https://www.postgresql.org/community/contributors/) wenye wasifu mfupi wa kila mchango.

Ikiwa mradi wako una jamii ya wachangiaji wenye shughuli nyingi, huenda ukaunda "timu ya msingi" ya watunzaji, au hata kamati ndogo za watu wanaochukua umiliki wa maeneo tofauti ya masuala (kwa mfano, usalama, kutunga masuala, au mwenendo wa jamii). Wacha watu wajipange na kujitolea kwa majukumu wanayofurahia zaidi, badala ya kuwapa.

<aside markdown="1" class="pquote">
  \[Sisi\] tunakamilisha timu ya msingi na timu ndongo au subteams kadhaa chini yao. Kila timu ndogo inazingatia eneo maalum, kwa mfano, muundo wa lugha au maktaba. (...) Ili kuhakikisha uratibu wa kimataifa na maono thabiti, kila subteam inaongozwa na mwanachama wa timu ya msingi.
  <p markdown="1" class="pquote-credit">
— ["Rust Governance RFC"](https://github.com/rust-lang/rfcs/blob/HEAD/text/1068-rust-governance.md)
  </p>
</aside>

Timu za uongozi zinaweza kutaka kuunda njia maalum (kama kwenye IRC) au kukutana mara kwa mara kujadili mradi (kama kwenye Gitter au Google Hangout). Unaweza hata kufanya mikutano hiyo kuwa ya umma ili watu wengine waweze kusikiliza. [Cucumber-ruby](https://github.com/cucumber/cucumber-ruby), kwa mfano, [hufanya ofisi za masaa kila wiki](https://github.com/cucumber/cucumber-ruby/blob/HEAD/CONTRIBUTING.md#talking-with-other-devs).

Mara tu umeshaunda majukumu ya uongozi, usisahau kuandika jinsi watu wanaweza kuyapata! Weka mchakato wazi wa jinsi mtu anavyoweza kuwa mtunzaji au kujiunga na kamati ndogo katika mradi wako, na uandike kwenye GOVERNANCE.md yako.

Zana kama [Vossibility](https://github.com/icecrime/vossibility-stack) zinaweza kusaidia kufuatilia hadharani ni nani (au sio) anayechangia mradi. Kuandika habari hii husaidia kuepusha dhana ya jamii kwamba watunzaji ni kundi linalofanya maamuzi yake kwa siri.

Hatimaye, ikiwa mradi wako uko kwenye GitHub, zingatia kuhamasisha mradi wako kutoka kwenye akaunti yako binafsi hadi Shirika na kuongeza angalau mtunzaji mmoja wa akiba. [Mashirika ya GitHub](https://help.github.com/articles/creating-a-new-organization-account/) yanafanya iwe rahisi kusimamia ruhusa na hazina nyingi na kulinda urithi wa mradi wako kupitia [umiliki wa pamoja](../building-community/#shiriki-umiliki-wa-mradi-wako).

## Ni lini ninapaswa kupatia mtu uwezo wa ufikiaji wa kuandika au kucommit?

Watu wengine wanafikiri unapaswa kumwambia kila mtu ambaye anachangia kuwa na ufikiaji wa kuandika. Kufanya hivyo kunaweza kuhamasisha watu zaidi kuhisi umiliki wa mradi wako.

Kwa upande mwingine, hasa kwa miradi mikubwa na ngumu zaidi, huenda unataka kuwapatia tu wale ambao wameonyesha kujitolea kwao. Hakuna njia moja sahihi ya kufanya hivyo - fanya kile kinachokufanya ujisikie vizuri!

Ikiwa mradi wako uko kwenye GitHub, unaweza kutumia [protected branches](https://help.github.com/articles/about-protected-branches/) kusimamia ni nani anayeweza kusukuma kwenye tawi fulani, na chini ya hali gani.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  Kila wakati mtu anapokutumia ombi la kuvuta, mpe ufikiaji wa kuandika kwenye mradi wako. Ingawa inaweza kuonekana kuwa ya kipumbavu mwanzoni, kutumia mkakati huu kutakuruhusu kuachilia nguvu halisi ya GitHub. (...) Mara watu wanapokuwa na ufikiaji wa kuandika, hawana wasiwasi kwamba marekebisho yao yanawezakosa kuunganishwa...hivyo wanajitolea kufanya kazi zaidi kwa hiyo.
  <p markdown="1" class="pquote-credit">
— @felixge, ["Mkakati wa Ombi la Kuvuta"](https://felixge.de/2013/03/11/the-pull-request-hack.html)
  </p>
</aside>

## Ni mifano gani ya muundo wa utawala wa miradi ya open source?

Kuna muundo tatu wa kawaida wa utawala unaohusishwa na miradi ya open source.

* **BDFL:** BDFL inasimamia "Benevolent Dictator for Life". Chini ya muundo huu, mtu mmoja (kawaida mwandishi wa awali wa mradi) ana neno la mwisho juu ya maamuzi makubwa ya mradi. [Python](https://github.com/python) ni mfano wa kawaida. Miradi midogo huenda ikawa BDFL kwa default, kwa sababu kuna watunzaji mmoja au wawili tu. Mradi ulioanzishwa katika kampuni unaweza pia kuingia kwenye kundi la BDFL.

* **Meritocracy:** **(Kumbuka: neno "meritocracy" lina maana mbaya kwa baadhi ya jamii na lina [historia ngumu ya kijamii na kisiasa](http://geekfeminism.wikia.com/wiki/Meritocracy).)** Chini ya meritocracy, wachangiaji wa mradi wenye shughuli (wale wanaoonyesha "merit") wanapewa jukumu rasmi la kufanya maamuzi. Maamuzi kwa kawaida hufanywa kwa msingi wa makubaliano ya kupiga kura. Dhana ya meritocracy ilianzishwa na [Apache Foundation](https://www.apache.org/); [miradi yote ya Apache](https://www.apache.org/index.html#projects-list) ni meritocracies. Michango inaweza kufanywa tu na watu binafsi wanaowakilisha wenyewe, si na kampuni.

* **Mchango wa Huru au Liberal contribution:** Chini ya mfano wa mchango wa huru, watu wanaofanya kazi nyingi wanatambuliwa kama wenye ushawishi zaidi, lakini hii inategemea kazi ya sasa na si michango ya kihistoria. Maamuzi makubwa ya mradi hufanywa kwa msingi wa mchakato wa kutafuta makubaliano (kujadili malalamiko makubwa) badala ya kura, na kujitahidi kujumuisha maoni kadhaa ya jamii. Mifano maarufu ya miradi inayotumia mfano wa mchango wa huru ni [Node.js](https://foundation.nodejs.org/) na [Rust](https://www.rust-lang.org/).

Ni ipi unapaswa kutumia? Inakutegemea mwenyewe! Kila mfano una faida na hasara. Na ingawa yanaweza kuonekana tofauti sana mwanzoni, mifano yote mitatu ina mambo mengi ya kawaida kuliko inavyoonekana. Ikiwa unavutiwa na kupitisha mmoja wa mifano hii, angalia hizi templeti.

* [BDFL model template](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [Meritocracy model template](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Node.js's liberal contribution policy](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## Je, nahitaji nyaraka za utawala ninapozindua mradi wangu?

Hakuna wakati sahihi wa kuandika utawala wa mradi wako, lakini ni rahisi zaidi kufafanua mara tu unapokuwa umeona mienendo ya jamii yako ikicheza. Sehemu bora (na ngumu) kuhusu utawala wa open source ni kwamba unaundwa na jamii!

Nyaraka za mapema bila shaka zitaongeza kwenye utawala wa mradi wako, hata hivyo, hivyo anza kuandika kile unachoweza. Kwa mfano, unaweza kufafanua matarajio wazi ya tabia, au jinsi mchakato wako wa wachangiaji unavyofanya kazi, hata wakati wa uzinduzi wa mradi wako.

Ikiwa wewe ni sehemu ya kampuni inayozindua mradi wa open source, ni muhimu kuwa na majadiliano ya ndani kabla ya uzinduzi kuhusu jinsi kampuni yako inatarajia kudumisha na kufanya maamuzi kuhusu mradi kuendelea. Unaweza pia kutaka kueleza hadharani chochote maalum kuhusu jinsi kampuni yako itahusika (au haitahusika!) na mradi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
  Tunapanga timu ndogo kusimamia miradi kwenye GitHub ambao kwa kweli wanashughulikia haya katika Facebook. Kwa mfano, React inaendeshwa na mhandisi wa React.
  <p markdown="1" class="pquote-credit">
— @caabernathy, ["Mtazamo wa ndani wa open source katika Facebook"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)
  </p>
</aside>

## Ni nini kinatokea ikiwa wafanyakazi wa kampuni wanza kuwasilisha michango?

Miradi ya open source yenye mafanikio hutumiwa na watu wengi na kampuni, na baadhi ya kampuni zinaweza hatimaye kuwa na vyanzo vya mapato vinavyohusishwa na mradi. Kwa mfano, kampuni inaweza kutumia msimbo wa mradi kama sehemu moja katika huduma ya kibiashara.

Kadri mradi unavyotumiwa zaidi, watu wenye ujuzi katika hilo wanakuwa na mahitaji zaidi - huenda wewe ni mmoja wao! - na mara nyingi hulipwa kwa kazi wanazofanya katika mradi.

Ni muhimu kutibu shughuli za kibiashara kama kawaida na kama chanzo kingine cha nishati ya maendeleo. Waandishi wa msimbo wanaopokea malipo hawapaswi kupata matibabu maalum kuliko wale wasiolipwa, bila shaka; kila mchango unapaswa kutathminiwa kwa sifa zake za kiufundi. Hata hivyo, watu wanapaswa kujisikia vizuri kushiriki katika shughuli za kibiashara, na kujisikia huru kuelezea matumizi yao wanapojadili uboreshaji au kipengele fulani.

"Biashara" inapatana kabisa na "open source". "Biashara" inamaanisha tu kuwa kuna pesa zinazohusika mahali fulani - kwamba programu inatumika katika biashara, ambayo inakuwa ya kawaida kadri mradi unavyopata umaarufu. (Wakati programu ya open source inatumika kama sehemu ya bidhaa isiyo ya open source, bidhaa hiyo kwa ujumla bado ni programu "miliki", ingawa, kama open source, inaweza kutumika kwa madhumuni ya kibiashara au yasiyo ya kibiashara.)

Kama mtu mwingine yeyote, waandishi wa msimbo wanaolipwa wanapata ushawishi katika mradi kupitia ubora na wingi wa michango yao. Bila shaka, mwandishi anayelipwa kwa wakati wake anaweza kufanya zaidi kuliko yule ambaye halipwi, lakini hiyo ni sawa: malipo ni moja ya mambo mengi yanayoweza kuathiri jinsi mtu anavyofanya kazi. Weka mazungumzo yako ya mradi kuwa na mwelekeo kwenye michango, si kwenye mambo ya nje yanayowezesha watu kufanya michango hayo.

## Je, nahitaji shirika la kisheria kusaidia mradi wangu?

Huhitaji shirika la kisheria kusaidia mradi wako wa open source isipokuwa unashughulikia pesa.

Kwa mfano, ikiwa unataka kuanzisha biashara, utahitaji kuanzisha C Corp au LLC (ikiwa uko Marekani). Ikiwa unafanya kazi ya mkataba inayohusiana na mradi wako wa open source, unaweza kupokea pesa kama mmiliki mmoja, au kuanzisha LLC (ikiwa uko Marekani).

Ikiwa unataka kupokea michango kwa mradi wako wa open source, unaweza kuanzisha kitufe cha michango (ukitumia PayPal au Stripe, kwa mfano), lakini pesa hiyo haitakuwa na ushuru wa kukatwa isipokuwa wewe ni shirika linalostahiki (501c3, ikiwa uko Marekani).

Miradi mingi haitaki kupitia shida ya kuanzisha shirika la kiserikali, hivyo wanapata mdhamini wa kiserikali badala yake. Mdhamini wa kiserikali anapokea michango kwa niaba yako, kwa kawaida kwa kubadilishana asilimia ya mchango. [Software Freedom Conservancy](https://sfconservancy.org/), [Apache Foundation](https://www.apache.org/), [Eclipse Foundation](https://eclipse.org/org/foundation/), [Linux Foundation](https://www.linuxfoundation.org/projects) na [Open Collective](https://opencollective.com/opensource) ni mifano ya mashirika yanayohudumia kama wadhamini wa kiserikali kwa miradi ya open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  Lengo letu ni kutoa miundombinu ambayo jamii zinaweza kutumia kuwa na uwezo wa kujitegemea, hivyo kuunda mazingira ambapo kila mtu - wachangiaji, wafuasi, wadhamini - wanapata faida halisi kutoka kwa hiyo.
  <p markdown="1" class="pquote-credit">
— @piamancini, ["Kuhama kutoka mfumo wa hisani"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141)
  </p>
</aside>

Ikiwa mradi wako unahusishwa kwa karibu na lugha au mfumo fulani, huenda pia kuna shirika la programu linalohusiana ambalo unaweza kufanya kazi nalo. Kwa mfano, [Python Software Foundation](https://www.python.org/psf/) husaidia [PyPI](https://pypi.org/), meneja wa pakiti wa Python, na [Node.js Foundation](https://foundation.nodejs.org/) husaidia [Express.js](https://expressjs.com/), mfumo wa Node.
