---
lang: sw
title: Jinsi ya kuchangia kwa Open Source
description: Je, ungependa kuchangia katika open source? Mwongozo wa kutoa michango ya open source, kwa wanaoanza na kwa maveterani.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Kwa nini uchangie katika open source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Kufanya kazi kwa \[freenode]\ kulinisaidia kupata ujuzi mwingi nilioutumia baadaye kwa masomo yangu katika chuo kikuu na kazi yangu halisi. Nadhani kufanya kazi kwenye miradi ya Open Source hunisaidia kadiri inavyosaidia mradi!
  <p markdown="1" class="pquote-credit">
— [@errietta](https://github.com/errietta), ["Sababu yangu kupenda kuchangia programu za Open Source"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Kuchangia kwenye Open Source kunaweza kuwa njia ya kuridhisha ya kujifunza, kufundisha na kujenga uzoefu katika takriban ujuzi wowote unaoweza kufikiria.

Kwa nini watu wanachangia katika Open Source? Sababu nyingi!

### Boresha programu unayoitegemea

Wachangiaji wengi wa Open Source huanza kwa kuwa watumiaji wa programu wanazochangia. Unapopata hitilafu katika programu huria unayotumia, unaweza kutaka kuangalia chanzo ili kuona ikiwa unaweza kuibandika mwenyewe. Ikiwa ndivyo hivyo, basi kuchangia kiraka ni njia bora ya kuhakikisha kuwa marafiki zako (na wewe mwenyewe unaposasisha toleo linalofuata) mtaweza kunufaika nayo.

### Kuboresha ujuzi uliopo

Iwe ni usimbaji, muundo wa kiolesura cha mtumiaji, muundo wa picha, uandishi, au kupanga, ikiwa unatafuta mazoezi, kuna jukumu lako kwenye mradi wa Open Source.

### Kutana na watu wanaovutiwa na mambo sawa

Miradi ya Open Source yenye jumuiya zenye uchangamfu, zinazokaribisha watu huwafanya watu warudi kwa miaka mingi. Watu wengi huunda urafiki wa kudumu kupitia ushiriki wao katika Open Source, iwe ni kupatana kwenye mikutano au soga za mtandaoni za usiku wa manane kuhusu burritos.

### Tafuta washauri na uwafundishe wengine

Kufanya kazi na wengine kwenye mradi ulioshirikiwa inamaanisha itabidi ueleze jinsi unavyofanya mambo, na pia kuomba msaada kutoka kwa watu wengine. Matendo ya kujifunza na kufundisha yanaweza kuwa shughuli ya kutimiza kwa kila mtu anayehusika.

### Unda vibaki vya umma vinavyokusaidia kukuza sifa (na taaluma)

Kwa ufafanuzi, kazi yako yote ya programu huria ni ya umma, ambayo ina maana kwamba unapata mifano isiyolipishwa ya kuchukua popote kama onyesho la unachoweza kufanya.

### Jifunze ujuzi wa watu

Open Source hutoa fursa za kufanya mazoezi ya ujuzi wa uongozi na utunzaji, kama vile kusuluhisha mizozo, kupanga timu za watu, na kuipa kazi kipaumbele.

### Inawezesha kuweza kufanya mabadiliko, hata madogo

Si lazima uwe mchangiaji wa maisha yote ili kufurahia kushiriki katika Open Source. Je, umewahi kuona hitilafu kwenye tovuti, na ukatamani mtu airekebishe? Kwenye mradi wa Open Source, unaweza kufanya hivyo. Open Source huwasaidia watu kuhisi wakala katika maisha yao na jinsi wanavyopitia ulimwengu, na hiyo yenyewe inafurahisha.

## Nini maana ya kuchangia

Ikiwa wewe ni mchangiaji mpya wa Open Source, mchakato unaweza kuogopesha. Je, unapataje mradi sahihi? Je, ikiwa hujui jinsi ya kuweka msimbo? Je, ikiwa kitu kitaenda vibaya?

Usiwe na wasiwasi! Kuna kila aina ya njia za kujihusisha na mradi wa Open Source, na vidokezo vichache vitakusaidia kupata zaidi kutokana na matumizi yako.

### Si lazima kuchangia msimbo

Dhana potofu ya kawaida kuhusu kuchangia Open Source ni kwamba unahitaji kuchangia msimbo. Kwa kweli, mara nyingi ni sehemu zingine za mradi ambazo [hupuuzwa zaidi au kutopewa umakini](https://github.com/blog/2195-the-shape-of-open-source). Utaufanyia mradi upendeleo _mkubwa_ kwa kujitolea kushiriki na aina hizi za michango!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Nimekuwa maarufu kwa kazi yangu kwenye CocoaPods, lakini watu wengi hawajui kuwa sifanyi kazi yoyote halisi kwenye zana ya CocoaPods yenyewe. Wakati wangu kwenye mradi huo hutumiwa sana kufanya vitu kama nyaraka na kufanya kazi kwenye chapa.
  <p markdown="1" class="pquote-credit">
— [@orta](https://github.com/orta), ["Kujiingiza kwa OSS kwa chaguo-msingi"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Hata kama ungependa kuandika msimbo, aina nyingine za michango ni njia nzuri ya kujihusisha na mradi na kukutana na wanajamii wengine. Kujenga mahusiano hayo kutakupa fursa za kufanya kazi kwenye sehemu nyingine za mradi.

### Je, unapenda kupanga matukio?

* Panga warsha au mikutano kuhusu mradi, [kama @fzamperin alivyofanya kwa NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Panga mkutano wa mradi (ikiwa wanayo)
* Wasaidie wanajamii kupata mikutano inayofaa na uwasilishe mapendekezo ya kuzungumza

### Je, unapenda kubuni?

* Rekebisha mipangilio ili kuboresha utumiaji wa mradi
* Fanya utafiti wa mtumiaji ili kupanga upya na kuboresha urambazaji au menyu za mradi, [kama vile Drupal inavyopendekeza](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Weka pamoja mwongozo wa mtindo ili kusaidia mradi kuwa na muundo thabiti wa kuona
* Unda sanaa ya fulana au nembo mpya, [kama wachangiaji wa hapi.js walivyofanya](https://github.com/hapijs/contrib/issues/68)

### Je, unapenda kuandika?

* Andika na uboreshe nyaraka za mradi, [kama @CBID2 alivyofanya kwa nyaraka za OpenSauced](https://github.com/open-sauced/docs/pull/151)
* Andaa folda ya mifano inayoonyesha jinsi mradi unavyotumika
* Anzisha jarida la mradi, au kusanya mambo muhimu kutoka kwenye orodha ya barua, [kama @opensauced alivyofanya kwa bidhaa yao](https://news.opensauced.pizza/about/)
* Andika mafunzo kwa mradi, [kama wachangiaji wa PyPA walivyofanya](https://packaging.python.org/)
* Andika tafsiri ya nyaraka za mradi, [kama @frontendwizard alivyofanya kwa maelekezo ya changamoto ya CSS Flexbox ya freeCodeCamp](https://github.com/freeCodeCamp/freeCodeCamp/pull/19077)

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Kwa kweli, \[nyaraka\] ni muhimu sana. Nyaraka zilizopo zimekuwa nzuri na zimekuwa sifa kubwa ya Babel. Kuna sehemu ambazo zinaweza kuhitaji kazi na hata kuongeza aya hapa na pale kunathaminiwa sana.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Wito kwa wachangiaji"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Je, unapenda kupanga?

* Unganisha masuala yanayofanana, na upendekeze lebo mpya za masuala, ili kuweka vitu katika mpangilio
* Pitia masuala yaliyofunguliwa na upendekeze kufunga yale ya zamani, [kama @nzakas alivyofanya kwa ESLint](https://github.com/eslint/eslint/issues/6765)
* Uliza maswali ya ufafanuzi kuhusu masuala yaliyofunguliwa hivi karibuni ili kuendeleza mjadala

### Je, unapenda kusimba?

* Tafuta suala lililofunguliwa ili kushughulikia, [kama @dianjin alivyofanya kwa Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Uliza ikiwa unaweza kusaidia kuandika kipengele kipya
* Tengeneza mfumo wa kuanzisha mradi kiotomatiki
* Boresha zana na majaribio

### Je, unapenda kusaidia watu?

* Jibu maswali kuhusu mradi kwenye, kwa mfano, Stack Overflow ([kama mfano huu wa Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) au Reddit
* Jibu maswali ya watu kwenye masuala yaliyofunguliwa
* Saidia kusimamia bodi za majadiliano au vituo vya mazungumzo

### Je, unapenda kuwasaidia wengine kusimba?

* Pitia msimbo kwenye mawasilisho ya watu wengine
* Andika mafunzo ya jinsi mradi unavyoweza kutumika
* Jitolee kuwa mshauri kwa mchangiaji mwingine, [kama @ereichert alivyofanya kwa @bronzdoc kwenye Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Sio lazima ufanye kazi kwenye miradi ya programu ya software pekee!

Ingawa "Open Source" mara nyingi inahusu programu z software, unaweza kushirikiana katika karibu kitu chochote. Kuna vitabu, mapishi, orodha, na madarasa yanayotengenezwa kama miradi ya Open Source.

Kwa mfano:

* @sindresorhus anasimamia [orodha ya maorodha "bora zaidi"](https://github.com/sindresorhus/awesome)
* @h5bp anahifadhi [orodha ya maswali yanayoweza kuulizwa kwenye mahojiano](https://github.com/h5bp/Front-end-Developer-Interview-Questions) kwa watafuta zaki wa nafasi ya front-end
* @stuartlynn na @nicole-a-tesla walitengeneza [mkusanyiko wa ukweli wa kufurahisha kuhusu ndege aina ya puffin](https://github.com/stuartlynn/puffin_facts)

Hata kama wewe ni msanidi programu, kufanya kazi kwenye mradi wa nyaraka kunaweza kukusaidia kuanza katika Open Source. Mara nyingi si jambo la kutisha kufanya kazi kwenye miradi isiyohusisha msimbo, na mchakato wa ushirikiano utajenga imani yako na uzoefu.

## Kujielekeza kwenye mradi mpya

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Ukienda kwenye kifuatiliaji cha masuala na vitu vinaonekana kuchanganya, sio kwako pekee. Zana hizi zinahitaji maarifa mengi yasiyoelezwa wazi, lakini watu wanaweza kukusaidia kuzielewa na unaweza kuwauliza maswali.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["Jinsi ya Kuchangia kwenye Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Kwa kitu chochote zaidi ya kurekebisha makosa madogo, kuchangia kwenye Open Source ni kama kusogelea kikundi cha watu usiowajua kwenye sherehe. Ikiwa utaanza kuzungumza kuhusu llama, wakati walikuwa kwenye majadiliano ya kina kuhusu samaki wa dhahabu, watakutazama kwa namna ya ajabu.

Kabla ya kuruka bila kujua na kutoa mapendekezo yako, anza kwa kujifunza jinsi ya kusoma hali. Kufanya hivyo kunaongeza uwezekano wa mawazo yako kutambuliwa na kusikilizwa.

### Anatomia ya mradi wa Open Source

Kila jamii ya Open Source ni tofauti.

Kuwa kwenye mradi mmoja wa Open Source kwa miaka mingi inamaanisha umejifunza mradi mmoja wa Open Source. Ukihamia kwenye mradi mwingine, unaweza kukuta msamiati, desturi, na mitindo ya mawasiliano ni tofauti kabisa.

Hata hivyo, miradi mingi ya Open Source inafuata muundo wa shirika unaofanana. Kuelewa majukumu tofauti ya jamii na mchakato wa jumla kutakusaidia kuelekeza haraka kwenye mradi wowote mpya.

Mradi wa kawaida wa Open Source una aina zifuatazo za watu:

* **Mwandishi:** Mtu/watu au shirika lililounda mradi
* **Mmiliki:** Mtu/watu wenye umiliki wa kiutawala wa shirika au hazina (sio kila wakati ni sawa na mwandishi wa awali)
* **Watunzaji:** Wachangiaji wanaowajibika kuendesha maono na kusimamia vipengele vya kimuundo vya mradi (Wanaweza pia kuwa waandishi au wamiliki wa mradi.)
* **Wachangiaji:** Kila mtu aliyechangia kitu kwenye mradi
* **Wanachama wa Jamii:** Watu wanaotumia mradi. Wanaweza kuwa washiriki hai katika mazungumzo au kutoa maoni yao kuhusu mwelekeo wa mradi

Miradi mikubwa pia inaweza kuwa na kamati ndogo au vikundi vya kazi vinavyolenga kazi tofauti, kama vile zana, uchujaji, uangalizi wa jamii, na uandaaji wa matukio. Tafuta kwenye tovuti ya mradi ukurasa wa "timu", au kwenye hazina kwa nyaraka za utawala, ili kupata taarifa hizi.

Mradi pia una nyaraka. Faili hizi kwa kawaida zimeorodheshwa katika kiwango cha juu cha hazina.

* **LICENSE:** Kwa ufafanuzi, kila mradi wa Open Source lazima uwe na [leseni ya Open Source](https://choosealicense.com). Ikiwa mradi hauna leseni, sio Open Source.
* **README:** README ni mwongozo wa maelekezo unaowakaribishia wanachama wapya wa jamii kwenye mradi. Inaeleza kwa nini mradi ni muhimu na jinsi ya kuanza.
* **CONTRIBUTING:** Wakati README husaidia watu _kutumia_ mradi, nyaraka za kuchangia husaidia watu _kuchangia_ kwenye mradi. Inaeleza ni aina gani za michango inayohitajika na jinsi mchakato unavyofanya kazi. Ingawa si kila mradi una faili ya CONTRIBUTING, uwepo wake unaashiria kuwa huu ni mradi unaokaribishwa kuchangiwa. Mfano mzuri wa Mwongozo mzuri wa Kuchangia utakuwa ule kutoka [Codecademy's Docs repository](https://www.codecademy.com/resources/docs/contribution-guide).
* **CODE_OF_CONDUCT:** Kanuni za maadili zinaweka sheria za msingi za tabia ya washiriki na husaidia kuwezesha mazingira ya kirafiki na ya kukaribishana. Ingawa si kila mradi una faili ya CODE_OF_CONDUCT, uwepo wake unaashiria kuwa huu ni mradi unaokaribishwa kuchangiwa.
* **Nyaraka zingine:** Kunaweza kuwa na nyaraka za ziada, kama vile mafunzo, miongozi, au sera za utawala, hasa kwenye miradi mikubwa kama vile [Astro Docs](https://docs.astro.build/en/contribute/#contributing-to-docs).

Mwishowe, miradi ya Open Source hutumia zana zifuatazo kupanga majadiliano. Kusoma kumbukumbu kutakupa picha nzuri ya jinsi jamii inavyofikiria na kufanya kazi.

* **Kifuatiliaji cha masuala au Issue Tracker:** Mahali ambapo watu wanajadili masuala yanayohusiana na mradi.
* **Maombi ya kuvuta au Pull requests:** Mahali ambapo watu hujadili na kukagua mabadiliko yanayoendelea ikiwa ni kuboresha safu ya msimbo ya mchangiaji, matumizi ya sarufi, matumizi ya picha, n.k. Baadhi ya miradi, kama vile [MDN Web Docs](https://github.com/mdn/content/blob/main/.github/workflows/markdown-lint.yml), hutumia mtiririko fulani wa GitHub Action kubinafsisha na kuharakisha kulalisha misimbo. 
* **Majukwaa ya majadiliano au orodha za barua:** Baadhi ya miradi inaweza kutumia vituo hivi kwa mada za mazungumzo (kwa mfano, _"Jinsi ya..."_ au _"Unafikiri nini kuhusu..."_ badala ya ripoti za hitilafu au maombi ya vipengele). Wengine hutumia kifuatilia toleo kwa mazungumzo yote. Mfano mzuri wa hili utakuwa [Jarida la kila wiki la CHAOSS](https://chaoss.community/news/).
* **Kituo cha mazungumzo cha papo kwa papo:** Baadhi ya miradi hutumia vituo vya mazungumzo (kama vile Slack au IRC) kwa mazungumzo ya kawaida, ushirikiano, na kubadilishana haraka. Mfano mzuri wa hii itakuwa [jamii ya Discord ya EddieHub](http://discord.eddiehub.org/).

## Kutafuta mradi wa kuchangia

Sasa kwamba umeelewa jinsi miradi ya Open Source inavyofanya kazi, ni wakati wa kutafuta mradi wa kuchangia!

Ikiwa hujawahi kuchangia kwenye Open Source hapo awali, chukua ushauri kutoka kwa Rais wa Marekani John F. Kennedy, ambaye aliwahi kusema: _"Usiulizie kile nchi yako inaweza kukufanyia - ulizia kile unaweza kufanya kwa nchi yako."_

<aside markdown="1" class="pquote">
  <img src="/assets/images/how-to-contribute/johnfkennedy.jpg" class="pquote-avatar" alt="avatar">
  Usiulizie kile nchi yako inaweza kukufanyia - ulizia kile unaweza kufanya kwa nchi yako.
  <p markdown="1" class="pquote-credit">
— [_Maktaba ya John F. Kennedy_](https://www.jfklibrary.org/learn/education/teachers/curricular-resources/ask-not-what-your-country-can-do-for-you)
  </p>
</aside>

Kuchangia kwenye Open Source kunatokea katika ngazi zote, kupitia miradi mbalimbali. Huhitaji kufikiria sana kuhusu nini hasa mchango wako wa kwanza utakuwa, au itakavyokuwa.

Badala yake, anza kwa kufikiria kuhusu miradi unayotumia tayari, au unayotaka kutumia. Miradi ambayo utachangia kwa nguvu ni zile unazojikuta ukijirudisha kwao mara kwa mara.

Katika miradi hiyo, kila wakati unapoona kitu ambacho kinaweza kuwa bora au tofauti, fanya kazi kwa hisia zako.

Open Source si klabu ya kipekee; inatengenezwa na watu kama wewe. "Open Source" ni neno la kisasa kwa kutibu matatizo ya ulimwengu kama yanayoweza kutatuliwa.

Unaweza kuangalia README na kupata kiungo kilichovunjika au makosa ya tahajia. Au wewe ni mtumiaji mpya na umeona kitu kilichovunjika, au suala ambalo unafikiri linapaswa kuwa kwenye nyaraka. Badala ya kupuuza na kuendelea, au kumuuliza mtu mwingine akirekebishe, angalia ikiwa unaweza kusaidia kwa kuchangia. Hiyo ndiyo maana ya Open Source!

> Kulingana na utafiti uliofanywa na Igor Steinmacher na watafiti wengine wa Sayansi ya Kompyuta, [28% ya michango ya kawaida](https://www.igor.pro.br/publica/papers/saner2016.pdf) kwenye Open Source ni nyaraka, kama vile marekebisho ya makosa ya tahajia, urekebishaji, au kuandika tafsiri.

Ikiwa unatafuta masuala yaliyopo ambayo unaweza kurekebisha, kila mradi wa Open Source una ukurasa wa `/contribute` unaoangazia masuala nyepesi kwa waanziaji ambayo unaweza kuanza nayo. Tembelea ukurasa wa msingi wa hazina kwenye GitHub, na ongeza `/contribute` mwishoni mwa URL (kwa mfano [`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

Unaweza pia kutumia moja ya rasilimali zifuatazo kukusaidia kugundua na kuchangia kwenye miradi mipya:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)
* [OpenSauced](https://opensauced.pizza/)

### Orodha ya ukaguzi kabla ya kuchangia

Wakati umepata mradi unayotaka kuchangia, fanya uchunguzi wa haraka ili kuhakikisha kuwa mradi huo unafaa kwa kukubali michango. Vinginevyo, kazi yako ngumu inaweza kutopata majibu.

Hapa kuna orodha ya ukaguzi ya kutathmini ikiwa mradi ni mzuri kwa wachangiaji wapya.

**Inakidhi ufafanuzi wa Open Source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Je, ina leseni? Kawaida, kuna faili inayoitwa LICENSE katika mizizi ya hazina.
  </label>
</div>

**Mradi unakubali michango kwa sasa**

Angalia shughuli za kujitolea kwenye tawi kuu. Kwenye GitHub, unaweza kuona habari hii katika tab ya Insights ya ukurasa wa nyumbani wa hazina, kama [Virtual-Coffee](https://github.com/Virtual-Coffee/virtualcoffee.io/pulse)

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Ni lini kujitolea kwa mwisho kulifanyika?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Mradi una wachangiaji wangapi?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Watu wanajitolea mara ngapi? (Kwenye GitHub, unaweza kupata hii kwa kubofya "Commits" kwenye bar ya juu.)
  </label>
</div>

Sasa, angalia masuala ya mradi.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Ni masuala mangapi yaliyofunguliwa?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Je, watunzaji wanajibu haraka kwa masuala yanapofunguliwa?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Je, kuna majadiliano ya shughuli kwenye masuala?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Je, masuala ni ya hivi karibuni?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Je, masuala yanapata kufungwa? (Kwenye GitHub, bonyeza tab "closed" kwenye ukurasa wa Masuala ili kuona masuala yaliyofungwa.)
  </label>
</div>

Sasa fanya vivyo hivyo kwa maombi ya kuvuta ya mradi.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Ni maombi mangapi ya kuvuta yaliyofunguliwa?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Je, watunzaji wanajibu haraka kwa maombi ya kuvuta yanapofunguliwa?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Je, kuna majadiliano ya hivi karibuni kwenye maombi ya kuvuta?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Je, maombi ya kuvuta ni ya hivi karibuni?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Ni lini maombi yoyote ya kuvuta yalifungwa? (Kwenye GitHub, bonyeza tab "closed" kwenye ukurasa wa Maombi ya Kuvuta ili kuona PRs zilizofungwa.)
  </label>
</div>

**Mradi unakaribisha**

Mradi ambao ni rafiki na unakaribisha unamaanisha kuwa watakuwa tayari kupokea wachangiaji wapya.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Je, watunzaji wanajibu kwa msaada kwa maswali katika masuala?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Je, watu ni rafiki katika masuala, jukwaa la majadiliano, na mazungumzo (kwa mfano, IRC au Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Je, maombi ya kuvuta yanapitiwa?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Je, watunzaji wanawashukuru watu kwa michango yao?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Kila wakati unapoona mjadala mrefu, angalia majibu kutoka kwa waendelezaji wa msingi wanaokuja mwishoni mwa mjadala. Je, wanatoa muhtasari kwa njia ya kujenga, na kuchukua hatua za kuleta mjadala kwenye uamuzi huku wakidhinisha adabu? Ikiwa unaona vita vingi vya maneno, hiyo mara nyingi ni ishara kwamba nguvu inaelekezwa kwenye mabishano badala ya maendeleo.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Jinsi ya kuwasilisha mchango

Umefinda mradi unayopenda, na uko tayari kufanya mchango. Hatimaye! Hapa kuna jinsi ya kuwasilisha mchango wako kwa njia sahihi.

### Kuwasiliana kwa ufanisi

Iwe wewe ni mchango wa mara moja au unajaribu kujiunga na jamii, kufanya kazi na wengine ni moja ya ujuzi muhimu zaidi utakaopata katika Open Source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Kama mchangiaji mpya,\] niligundua haraka nilihitaji kuuliza maswali ikiwa nilitaka kufunga suala hilo. Nilipitia msingi wa msimbo. Mara nilipokuwa na hisia ya kile kilichokuwa kikifanyika, nilitaka kuelekezwa zaidi. Na voilà! Niliweza kutatua suala hilo baada ya kupata maelezo muhimu yote niliyohitaji.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [Safari ya Kwanza ya Mchango Katika Ulimwengu wa Open Source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Kabla ya kufungua suala au ombi la kuvuta, au kuuliza swali katika mazungumzo, zingatia mambo haya ili kusaidia mawazo yako kuwasilishwa kwa ufanisi.

**Toa muktadha.** Saidia wengine wapate haraka. Ikiwa unakutana na kosa, eleza unachojaribu kufanya na jinsi ya kulifanya litokee tena. Ikiwa unashauri wazo jipya, eleza kwa nini unafikiri litakuwa na manufaa kwa mradi (sio tu kwako!).

> 😇 _"X haifanyiki ninapofanya Y"_
>
> 😢 _"X imevunjika! Tafadhali rekebisha."_

**Fanya kazi yako ya nyumbani kabla.** Ni sawa kutojua mambo, lakini onyesha kuwa umejaribu. Kabla ya kuomba usaidizi, hakikisha kuwa umeangalia README ya mradi, nyaraka, masuala (yamefunguliwa au kufungwa), orodha ya wanaotuma barua, na utafute mtandaoni ili kupata jibu. Watu watakushukuru unapoonyesha kwamba unajaribu kujifunza.

> 😇 _"Sina hakika jinsi ya kutekeleza X. Nilikagua nyaraka za usaidizi na sikupata mtaji wowote."_
>
> 😢 _"Nifanyeje X?"_

**Weka maombi mafupi na ya moja kwa moja.** Kama vile kutuma barua pepe, kila mchango, haijalishi ni rahisi kiasi gani au wa manufaa kiasi gani, unahitaji ukaguzi wa mtu mwingine. Miradi mingi ina maombi mengi yanayoingia kuliko watu wanaopatikana kusaidia. Kuwa na mafupi. Utaongeza nafasi kwamba mtu ataweza kukusaidia.

> 😇 _"Ningependa kuandika mafunzo ya API."_
>
> 😢 _"Nilikuwa nikiendesha barabara kuu siku nyingine na nikasimama kutafuta gesi, kisha nikawa na wazo hili la kushangaza la kitu ambacho tunapaswa kufanya, lakini kabla sijaelezea hilo, wacha nikuonyeshe..."_

**Weka mawasiliano yote hadharani.** Ingawa inavutia, usiwasiliane na watunzaji kwa faragha isipokuwa unapohitaji kushiriki maelezo nyeti (kama vile suala la usalama au ukiukaji mkubwa wa maadili). Unapoweka mazungumzo hadharani, watu zaidi wanaweza kujifunza na kufaidika kutokana na ubadilishanaji wenu  . Majadiliano yanaweza kuwa, yenyewe, michango.

> 😇 _(kama maoni) "@-maintainer Hujambo! Tunapaswa kuendeleaje kuhusu PR hii?"_
>
> 😢 _(kama barua pepe) "Haya, samahani kwa kukusumbua kupitia barua pepe, lakini nilikuwa najiuliza ikiwa umepata nafasi ya kukagua PR yangu"_

**Ni sawa kuuliza maswali (lakini kuwa na subira!).** Kila mtu alikuwa mpya kwa mradi wakati fulani, na hata wachangiaji wenye uzoefu wanahitaji muda kiasi wanapotazama mradi mpya. Kwa mantiki hiyo, hata watunzaji wa muda mrefu huwa hawafahamu kila sehemu ya mradi. Waonyeshe uvumilivu ule ambao ungetaka wakuonyeshe.

> 😇 _"Asante kwa kuangalia hitilafu hii. Nimefuata mapendekezo yako. Haya ndio matokeo."_
>
> 😢 _"Kwa nini huwezi kurekebisha tatizo langu? Je, huu si mradi wako?"_

**Heshimu maamuzi ya jamii.** Mawazo yako yanaweza kutofautiana na vipaumbele au maono ya jumuiya. Wanaweza kutoa maoni au kuamua kutofuata wazo lako. Ingawa unapaswa kujadiliana na kutafuta maelewano, watunzaji wanapaswa kuishi na uamuzi wako kwa muda mrefu zaidi kuliko utakavyo. Ikiwa hukubaliani na mwelekeo wao, unaweza daima kufanya kazi kwa uma yako mwenyewe au kuanza mradi wako mwenyewe.

> 😇 _"Nimesikitishwa kuwa huwezi kuunga mkono kesi yangu ya utumiaji, lakini kama ulivyoelezea inaathiri tu sehemu ndogo ya watumiaji, ninaelewa ni kwa nini. Asante kwa kusikiliza."_
>
> 😢 _"Kwa nini hauungi mkono kesi yangu ya utumiaji? Hili halikubaliki!"_

**Zaidi ya yote, kuwa na adabu.** Open Source kinajumuisha washiriki kutoka sehemu mbalimbali za dunia. Muktadha hupotea kati ya lugha, tamaduni, jiografia, na maeneo ya wakati. Aidha, mawasiliano ya maandiko yanafanya iwe vigumu kuwasilisha sauti au hali. Kadiria nia njema katika mazungumzo haya. Ni sawa kupinga wazo kwa adabu, kuuliza maelezo zaidi, au kufafanua msimamo wako. Jaribu tu kuacha mtandao mahali pazuri zaidi kuliko ulivyokutana nalo.

### Kukusanya muktadha

Kabla ya kufanya chochote, fanya uchunguzi wa haraka ili kuhakikisha wazo lako halijajadiliwa mahali pengine. Pitia README ya mradi, masuala (yamefunguliwa na yaliyofungwa), orodha ya wanaotuma barua, na Stack Overflow. Huhitaji kutumia masaa mengi kupitia kila kitu, lakini utafutaji wa haraka wa maneno muhimu kadhaa unaweza kusaidia sana.

Ikiwa huwezi kupata wazo lako mahali pengine, uko tayari kuchukua hatua. Ikiwa mradi uko kwenye GitHub, kuna uwezekano kwamba utawasiliana kwa kufanya yafuatayo:

* **Kufungua Suala:** Haya ni kama kuanzisha mazungumzo au majadiliano
* **Maombi ya Kuvuta** ni kwa kuanzisha kazi juu ya suluhisho.
* **Makanisa ya Mawasiliano:** Ikiwa mradi una kituo maalum cha Discord, IRC, au Slack, fikiria kuanzisha mazungumzo au kuuliza ufafanuzi kuhusu mchango wako.

Kabla ya kufungua suala au ombi la kuvuta, angalia nyaraka za kuchangia za mradi (kawaida faili inayoitwa CONTRIBUTING, au katika README), ili kuona ikiwa unahitaji kujumuisha kitu chochote maalum. Kwa mfano, wanaweza kuomba ufuate templeti, au kuhitaji utumie majaribio(tests).

Ikiwa unataka kutoa mchango mkubwa, fungua suala ili kuuliza kabla ya kufanya kazi juu yake. Ni muhimu kufuatilia mradi kwa muda (katika GitHub, [unaweza kubofya "Watch"](https://help.github.com/articles/watching-repositories/) ili kupokea taarifa za mazungumzo yote), na kujifunza kuhusu wanajamii, kabla ya kufanya kazi ambayo huenda isikubaliwe.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Utajifunza <em>mengi</em> kwa kuchukua mradi mmoja unautumia, "kuangalia" kwenye GitHub na kusoma kila suala na PR.
<p markdown="1" class="pquote-credit">
— @gaearon [kuhusu kujiunga na miradi](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Kufungua suala

Kawaida unapaswa kufungua suala katika hali zifuatazo:

* Ripoti kosa ambalo huwezi kulitatua mwenyewe
* Jadili mada au wazo la juu (kwa mfano, jamii, maono au sera)
* Pendekeza kipengele kipya au wazo lingine la mradi

Vidokezo vya kuwasiliana kwenye masuala:

* **Ikiwa unaona suala lililofunguliwa ambalo unataka kulishughulikia,** toa maoni kwenye suala hilo ili kuwajulisha watu kwamba unaishughulikia. Hivyo, watu hawataweza kurudia kazi yako.
* **Ikiwa suala lilifunguliwa muda mrefu uliopita,** kuna uwezekano kwamba linashughulikiwa mahali pengine, au tayari limekamilishwa, hivyo toa maoni ili kuuliza uthibitisho kabla ya kuanza kazi.
* **Ikiwa ulifungua suala, lakini ukapata jibu baadaye mwenyewe,** toa maoni kwenye suala hilo ili kuwajulisha watu, kisha funga suala hilo. Hata kuandika matokeo hayo ni mchango kwa mradi.

### Kufungua ombi la kuvuta

Kawaida unapaswa kufungua ombi la kuvuta katika hali zifuatazo:

* Wasilisha marekebisho madogo kama vile makosa ya tahajia, kiungo kilichovunjika au kosa dhahiri.
* Anza kazi juu ya mchango ambao tayari umeombwa, au ambao tayari umeshajadiliwa, katika suala.

Ombi la kuvuta halihitaji kuwakilisha kazi iliyokamilika. Kawaida ni bora kufungua ombi la kuvuta mapema, ili wengine waweze kufuatilia au kutoa maoni juu ya maendeleo yako. Fungua tu kama "draft" au weka alama kama "WIP" (Kazi katika Maendeleo) katika kichwa au sehemu za "Maelezo kwa Wakaguzi" ikiwa zinapatikana (au unaweza tu kuunda yako mwenyewe. Kama hii: `**## Maelezo kwa Mhakiki**`). Unaweza kila wakati kuongeza mabadiliko zaidi baadaye.

Ikiwa mradi uko kwenye GitHub, hapa kuna jinsi ya kuwasilisha ombi la kuvuta:

* **["Fork" hazina](https://guides.github.com/activities/forking/)** kisha "clone" kwenye kompyuta yako. Unganisha yako ya ndani na hazina ya asili "upstream" kwa kuongeza kama rimoti. Vuruta mabadiliko kutoka "upstream" mara kwa mara ili uwe na mabadiliko mapya ili wakati unawasilisha ombi lako la kuvuta, migogoro ya kuungana itakuwa na uwezekano mdogo. (Tazama maelekezo ya kina [hapa](https://help.github.com/articles/syncing-a-fork/).)
* **[Unda tawi](https://guides.github.com/introduction/flow/)** kwa ajili ya marekebisho yako.
* **Rejelea masuala yoyote muhimu** au nyaraka za kuunga mkono katika PR yako (kwa mfano, "Inafunga #37.")
* **Jumuisha picha za kabla na baada** ikiwa mabadiliko yako yanajumuisha tofauti katika HTML/CSS. Buruta na uachie picha hizo kwenye mwili wa ombi lako la kuvuta.
* **Jaribu mabadiliko yako!** Pitisha mabadiliko yako dhidi ya majaribio yoyote yaliyopo ikiwa yapo na tengeneza mapya inapohitajika. Ni muhimu kuhakikisha mabadiliko yako hayavunji mradi uliopo.
* **Changia kwa mtindo wa mradi** kadri uwezavyo. Hii inaweza kumaanisha kutumia indenti, semi-coloni au maoni tofauti kuliko unavyofanya katika hazina yako mwenyewe, lakini inafanya iwe rahisi kwa mtunzaji kuunganishwa, wengine kuelewa na kudumisha katika siku zijazo.

Ikiwa hii ni ombi lako la kwanza la kuvuta, angalia [Fanya Ombi la Kuvuta](http://makeapullrequest.com/), ambayo @kentcdodds alitengeneza kama video ya mwongozo. Unaweza pia kufanya mazoezi ya kufungua ombi la kuvuta katika hazina ya [Mchango wa Kwanza](https://github.com/Roshanjossey/first-contributions), iliyoundwa na @Roshanjossey.

## Nini kinatokea baada ya kuwasilisha mchango wako

Kabla ya kuanza kusherehekea, moja ya yafuatayo itatokea baada ya kuwasilisha mchango wako:

### 😭 Hupati jibu

Tunatumahi [uliangalia mradi kwa ishara za shughuli](#orodha-ya-ukaguzi-kabla-ya-kuchangia) kabla ya kutoa mchango. Hata kwenye mradi unaoendelea, kuna uwezekano kwamba mchango wako hautapata jibu.

Kama hujapata jibu kwa zaidi ya wiki moja, ni haki kuuliza kwa adabu katika thread yenyewe, ukiomba mtu yeyote kuhusu mapitio. Ikiwa unajua jina la mtu sahihi wa kupitia mchango wako, unaweza kumtaja katika laini hiyo.

**Usijaribu kuwasiliana na mtu huyo kwa faragha**; kumbuka kwamba mawasiliano ya hadharani ni muhimu kwa miradi ya Open Source.

Ikiwa utatoa ukumbusho wa adabu na bado hujapata jibu, inawezekana kwamba hakuna atakayejibu. Hii si hisia nzuri, lakini usiruhusu hiyo ikukatisha tamaa! Kuna sababu nyingi zinazoweza kusababisha kutopata jibu, ikiwa ni pamoja na hali za kibinafsi ambazo zinaweza kuwa nje ya udhibiti wako. Jaribu kutafuta mradi mwingine au njia nyingine ya kuchangia. Ikiwa chochote, hii ni sababu nzuri ya kutoshughulikia muda mwingi katika kufanya mchango kabla ya wanajamii wengine kushiriki na kujibu.

### 🚧 Mtu anahitaji mabadiliko kwenye mchango wako

Ni kawaida kwamba utaombwa kufanya mabadiliko kwenye mchango wako, iwe ni maoni kuhusu wigo wa wazo lako, au mabadiliko kwenye msimbo wako.

Wakati mtu anapohitaji mabadiliko, kuwa na majibu. Wamechukua muda wao kupitia mchango wako. Kufungua PR na kuondoka ni tabia mbaya. Ikiwa hujui jinsi ya kufanya mabadiliko, tafuta tatizo, kisha uliza msaada ikiwa unahitaji. Mfano mzuri wa hii ni [maoni ambayo mchangiaji mwingine ametoa kwa @a-m-lamb kwenye ombi lao la kuvuta kwenye nyaraka za Codecademy](https://github.com/Codecademy/docs/pull/3239#pullrequestreview-1628036286).

Ikiwa huna muda wa kufanya kazi kwenye suala hilo tena kutokana na sababu kama mazungumzo yamekuwa yakiendelea kwa miezi, na hali zako zimebadilika au huwezi kupata suluhisho, mwambie mtunzaji ili waweze kufungua suala hilo kwa mtu mwingine, kama [@RitaDee alivyofanya kwa suala katika hazina ya programu ya OpenSauced](https://github.com/open-sauced/app/issues/1656#issuecomment-1729353346).

### 👎 Mchango wako haukubaliki

Mchango wako unaweza au usikubaliwe mwishowe. Tunatarajia hujaweka kazi nyingi ndani yake tayari. Ikiwa hujui kwa nini haikukubaliwa, ni sawa kabisa kumuuliza mtunzaji kwa maoni na ufafanuzi. Mwishowe, hata hivyo, itabidi uheshimu kuwa hii ni uamuzi wao. Usijadili au kuwa na hasira. Daima unakaribishwa ku "fork" na kufanya kazi kwenye toleo lako mwenyewe ikiwa huafikiani!

### 🎉 Mchango wako unakubaliwa

Hongera! Umefanikiwa kufanya mchango wa Open Source!

## Umeifanya! 🎉

Iwe umetoa mchango wako wa kwanza wa Open Source, au unatafuta njia mpya za kuchangia, tunatumai kuwa umehamasishwa kuchukua hatua. Hata kama mchango wako haukukubaliwa, usisahau kusema asante wakati mtunza huduma anaweka juhudi kukusaidia. Open Source hutengenezwa na watu kama wewe: toleo moja, ombi la kuvuta, maoni au matano ya juu kwa wakati mmoja.
