---
lang: sw
title: Kupata Malipo kwa Kazi ya Open Source
description: Dumisha kazi yako katika Open Source kwa kupata usaidizi wa kifedha kwa wakati wako au mradi wako.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Kwa nini baadhi ya watu wanatafuta msaada wa kifedha

Mengi ya kazi ya open source ni ya hiari. Kwa mfano, mtu anaweza kukutana na hitilafu katika mradi anaoutumia na kuwasilisha suluhisho haraka, au wanaweza kufurahia kuburudika na mradi wa open source katika wakati wao wa ziada.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Nilikuwa nikitafuta mradi wa "hobby" wa programu ambao ungenifanya niwe na shughuli wakati wa juma karibu na Krismasi. (...) Nilikuwa na tarakilishi ya nyumbani, na sio kitu kingine chochote mikononi mwangu. Niliamua kuandika interpreter kwa lugha mpya ya skripti ambayo nilikuwa nikifikiria hivi karibuni. (...) Nilichagua Python kama jina la kazi.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Kuna sababu nyingi kwa nini mtu anaweza kutotaka kulipwa kwa kazi yao ya open source.

* **Wanaweza kuwa na kazi ya wakati wote wanayoipenda,** ambayo inawaruhusu kuchangia kwenye open source katika wakati wao wa ziada.
* **Wanafurahia kufikiria open source kama hobby** au njia ya ubunifu na hawataki kujisikia kuwa na wajibu wa kifedha kufanya kazi kwenye miradi yao.
* **Wanapata faida nyingine kutokana na kuchangia kwenye open source,** kama vile kujenga sifa yao au portfolio, kujifunza ujuzi mpya, au kujisikia karibu na jamii.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Misaada ya kifedha huleta hisia ya wajibu, kwa wengine. (...) Ni muhimu kwetu, katika ulimwengu ulio na uhusiano wa kimataifa na wa kasi, kuwa na uwezo wa kusema "sasa si, nahisi kama kufanya kitu tofauti kabisa".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Kwa Nini Hatukubali Misaada"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Kwa wengine, hasa wakati michango ni ya kudumu au inahitaji muda mwingi, kulipwa kuchangia kwenye open source ndiyo njia pekee wanaweza kushiriki, ama kwa sababu mradi unahitaji hivyo, au kwa sababu za kibinafsi.

Kuhifadhi miradi maarufu kunaweza kuwa na wajibu mkubwa, ikichukua masaa 10 au 20 kwa wiki badala ya masaa machache kwa mwezi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Uliza yeyote anayehifadhi mradi wa open source, na watakuambia kuhusu ukweli wa kiasi cha kazi kinachohitajika katika kusimamia mradi. Una wateja. Unarekebisha matatizo kwao. Unaunda vipengele vipya. Hii inakuwa hitaji halisi kwa wakati wako.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["Maadili ya Kazi Isiyolipwa na Jamii ya OSS"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Kazi ya kulipwa pia inawawezesha watu kutoka nyanja tofauti kufanya michango yenye maana. Watu wengine hawawezi kumudu kutumia muda wa bure kwenye miradi ya open source, kulingana na hali zao za kifedha, deni, au wajibu wa kulea familia au wengine. Hii inamaanisha ulimwengu hauoni michango kutoka kwa watu wenye talanta ambao hawawezi kumudu kujitolea wakati wao. Hii ina athari za kimaadili, kama @ashedryden [ameelezea](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), kwani kazi inayofanywa inakabiliwa na upendeleo kwa wale ambao tayari wana faida katika maisha, ambao kisha wanapata faida zaidi kutokana na michango yao ya kujitolea, wakati wengine ambao hawawezi kujitolea basi hawapati fursa za baadaye, ambayo inaimarisha ukosefu wa utofauti katika jamii ya open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS inatoa faida kubwa kwa tasnia ya teknolojia, ambayo, kwa upande wake, inamaanisha faida kwa sekta zote. (...) Hata hivyo, ikiwa watu pekee wanaoweza kuizingatia ni wale wenye bahati na walio na shauku, basi kuna uwezo mkubwa usiotumika.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Pesa na Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Ikiwa unatafuta msaada wa kifedha, kuna njia mbili za kuzingatia. Unaweza kufadhili wakati wako kama mchangiaji, au unaweza kupata ufadhili wa shirika kwa mradi.

## Kufadhili wakati wako mwenyewe

Leo, watu wengi wanapata malipo ya kufanya kazi kwa muda wa nusu au muda wote kwenye open source. Njia ya kawaida ya kulipwa kwa wakati wako ni kuzungumza na mwajiri wako.

Ni rahisi kutoa sababu za kufanya kazi kwenye open source ikiwa mwajiri wako anatumia mradi huo, lakini kuwa mbunifu katika pendekezo lako. Labda mwajiri wako hatumii mradi huo, lakini wanatumia Python, na kuhifadhi mradi maarufu wa Python husaidia kuvutia waendelezaji wapya wa Python. Labda inafanya mwajiri wako kuonekana kuwa rafiki zaidi kwa waendelezaji kwa ujumla.

Ikiwa huna mradi wa open source ulio tayari kufanya kazi nao, lakini ungependa kwamba matokeo yako ya kazi ya sasa ya ndani ya shirika yafanywe kuwa open source, fanya kesi kwa mwajiri wako kufungua baadhi ya programu zao za ndani.

Makampuni mengi yanaendeleza programu za open source ili kujenga chapa yao na kuajiri talanta bora.

@hueniverse, kwa mfano, aligundua kwamba kulikuwa na sababu za kifedha za kuhalalisha [uwekezaji wa Walmart katika open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). Na @jamesgpearce aligundua kwamba programu ya open source ya Facebook [ilifanya tofauti](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) katika kuajiri:

> Inahusiana kwa karibu na utamaduni wetu wa hacking, na jinsi shirika letu lilivyoonekana. Tulikuwauliza wafanyakazi wetu, "Je, mlikuwa na ufahamu wa programu ya open source ya Facebook?". Theluthi mbili walisema "Ndio". Nusu walisema kwamba programu hiyo ilichangia kwa njia chanya katika uamuzi wao wa kufanya kazi kwetu. Hizi si nambari za kawaida, na natumai, ni mwenendo unaoendelea.

Ikiwa kampuni yako inaenda kwenye njia hii, ni muhimu kuweka mipaka kati ya shughuli za jamii na za kampuni wazi. Hatimaye, open source hujitegemea kupitia michango kutoka kwa watu kote ulimwenguni, na hiyo ni kubwa zaidi kuliko kampuni moja au eneo lolote.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Kupata malipo ya kufanya kazi kwenye open source ni fursa adimu na nzuri, lakini haupaswi kuacha shauku yako katika mchakato. Shauku yako inapaswa kuwa sababu ambayo makampuni yanataka kukulipa.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Mipaka Iliyokolea"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Ikiwa huwezi kumshawishi mwajiri wako wa sasa kuipa kipaumbele kazi ya open source, fikiria kutafuta mwajiri mpya anayehimiza michango ya wafanyakazi kwenye open source. Tafuta makampuni ambayo yanaweka wazi kujitolea kwao kwa kazi ya open source. Kwa mfano:

* Makampuni mengine, kama [Netflix](https://netflix.github.io/), yana tovuti zinazosisitiza ushiriki wao katika open source
* [Zalando](https://opensource.zalando.com) ilichapisha [sera yake ya mchango wa open source](https://opensource.zalando.com/docs/using/contributing/) kwa wafanyakazi

Miradi ambayo ilianza katika kampuni kubwa, kama [Go](https://github.com/golang) au [React](https://github.com/facebook/react), pia itakuwa na uwezekano wa kuajiri watu kufanya kazi kwenye open source.

Kulingana na hali zako binafsi, unaweza kujaribu kukusanya fedha kwa kujitegemea kufadhili kazi yako ya open source. Kwa mfano:

* @Homebrew (na [watunzaji na mashirika mengine mengi](https://github.com/sponsors/community)) wanakusanya kazi zao kupitia [GitHub Sponsors](https://github.com/sponsors)
* @gaearon alifadhili kazi yake kwenye [Redux](https://github.com/reactjs/redux) kupitia kampeni ya [Patreon crowdfunding](https://redux.js.org/)
* @andrewgodwin alifadhili kazi kwenye uhamasishaji wa schema ya Django [kupitia kampeni ya Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

Hatimaye, wakati mwingine miradi ya open source huweka zawadi kwenye masuala ambayo unaweza kufikiria kusaidia nayo.

* @ConnorChristie alifaulu kulipwa kwa [kusaidia](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol kufanya kazi kwenye maktaba yao ya JavaScript [kupitia zawadi kwenye gitcoin](https://gitcoin.co/).
* @mamiM alifanya tafsiri za Kijapani kwa @MetaMask baada ya [suala kufadhiliwa kwenye Bounties Network](https://explorer.bounties.network/bounty/134).

## Kutafuta ufadhili kwa mradi wako

Mbali na mipango ya wafanyakazi binafsi, wakati mwingine miradi hujikusanyia fedha kutoka kwa makampuni, watu binafsi, au wengine ili kufadhili kazi ya kudumu.

Ufadhili wa shirika unaweza kuelekezwa kwa kulipa wachangiaji wa sasa, kufidia gharama za kuendesha mradi (kama vile ada za "hosting"), au kuwekeza katika vipengele au mawazo mapya.

Kadri umaarufu wa open source unavyoongezeka, kutafuta ufadhili kwa miradi bado ni jambo la majaribio, lakini kuna chaguzi kadhaa za kawaida zinazopatikana.

### Kusanya fedha kwa kazi yako kupitia kampeni za ufadhili au udhamini

Kukusanya udhamini kunafanya kazi vizuri ikiwa una hadhira au sifa nzuri tayari, au mradi wako ni maarufu sana.
Mifano ya miradi iliyo na udhamini ni pamoja na:

* **[webpack](https://github.com/webpack)** inakusanya fedha kutoka kwa makampuni na watu binafsi [kupitia OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** shirika lisilo la faida linalolipa kazi kwenye [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), na miradi mingine ya miundombinu ya Ruby

### Kuunda mtiririko wa mapato

Kulingana na mradi wako, huenda ukawa na uwezo wa kuchaji kwa msaada wa kibiashara, chaguzi za hosting, au vipengele vya ziada. Mifano kadhaa ni pamoja na:

* **[Sidekiq](https://github.com/mperham/sidekiq)** inatoa toleo lililolipwa kwa msaada wa ziada
* **[Travis CI](https://github.com/travis-ci)** inatoa toleo lililolipwa la bidhaa yake
* **[Ghost](https://github.com/TryGhost/Ghost)** ni shirika lisilo la faida lenye huduma ya utunzaji inayolipwa

Miradi maarufu, kama [npm](https://github.com/npm/cli) na [Docker](https://github.com/docker/docker), huwa zinakusanya mtaji wa uwekezaji ili kusaidia ukuaji wa biashara zao.

### Kuomba ufadhili wa ruzuku

Baadhi ya mashirika ya programu za software na makampuni hutoa ruzuku kwa kazi ya open source. Wakati mwingine, ruzuku zinaweza kulipwa kwa watu binafsi bila kuanzisha kitengo cha kisheria kwa mradi.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** ilipokea ruzuku kutoka [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** kazi yake ilifadhiliwa na [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** ilipokea ruzuku kutoka [Sloan Foundation](https://sloan.org/programs/digital-technology)
* **[Python Software Foundation](https://www.python.org/psf/grants/)** inatoa ruzuku kwa kazi inayohusiana na Python

Kwa maelezo zaidi na mifano ya kesi, @nayafia [aliandika mwongozo](https://github.com/nayafia/lemonade-stand) wa jinsi ya kulipwa kwa kazi ya open source. Aina tofauti za ufadhili zinahitaji ujuzi tofauti, hivyo fikiria nguvu zako ili kubaini ni chaguo lipi linafaa kwako.

## Kujenga kesi ya msaada wa kifedha

Iwe mradi wako ni wazo jipya, au umekuwepo kwa miaka, unapaswa kutarajia kuweka mawazo makubwa katika kutambua mfadhili wako wa lengo na kufanya kesi yenye nguvu.

Iwe unatafuta kulipia wakati wako, au kufadhili mradi, unapaswa kuwa na uwezo wa kujibu maswali yafuatayo.

### Athari

Kwa nini mradi huu ni muhimu? Kwa nini watumiaji wako, au watumiaji wanaowezekana, wanaupokea sana? Itakuwa wapi katika miaka mitano?

### Ufanisi

Jaribu kukusanya ushahidi kwamba mradi wako ni muhimu, iwe ni takwimu, hadithi, au ushuhuda. Je, kuna makampuni au watu mashuhuri wanaotumia mradi wako sasa hivi? Ikiwa sivyo, je, kuna mtu mashuhuri aliyekubali?

### Thamani kwa mfadhili

Wafadhili, iwe ni mwajiri wako au msingi wa kutoa ruzuku, mara nyingi wanakaribishwa na fursa. Kwa nini wanapaswa kusaidia mradi wako badala ya fursa nyingine yoyote? Je, wanapata faida gani binafsi?

### Matumizi ya fedha

Ni nini hasa, utatimiza nini kwa ufadhili uliopendekezwa? Zingatia hatua au matokeo ya mradi badala ya kulipa mshahara.

### Jinsi utakavyopokea fedha

Je, mfadhili ana masharti yoyote kuhusu utoaji? Kwa mfano, huenda ukahitaji kuwa shirika lisilo la faida au kuwa na mdhamini wa kifedha wa shirika lisilo la faida. Au labda fedha zinapaswa kutolewa kwa mkandarasi binafsi badala ya shirika. Masharti haya yanatofautiana kati ya wafadhili, hivyo hakikisha unafanya utafiti kabla.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Kwa miaka mingi, tumekuwa rasilimali inayoongoza kwa icons za kirafiki za tovuti, na jamii ya watu zaidi ya milioni 20 na kuonekana kwenye tovuti zaidi ya milioni 70, ikiwa ni pamoja na Whitehouse.gov. (...) Toleo la 4 lilikuwa miaka mitatu iliyopita. Teknolojia imebadilika sana tangu wakati huo, na kwa kweli, Font Awesome imekuwa kidogo ya zamani. (...) Ndio maana tunazindua Font Awesome 5. Tunaboresha na kuandika upya CSS na kubuni kila icon kutoka juu hadi chini. Tunazungumzia kubuni bora, umoja bora, na usomaji bora.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Video ya Kickstarter ya Font Awesome](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Jaribu na usikate tamaa

Kuchangisha fedha sio rahisi, iwe wewe ni mradi wa open source, shirika lisilo la faida, au uanzishaji wa kampuni ya programu za software, na katika hali nyingi huhitaji uwe mbunifu. Kutambua jinsi unavyotaka kulipwa, kufanya utafiti wako, na kujiweka katika nafasi ya mfadhili wako kutakusaidia kuunda kesi inayoshawishi ya ufadhili.
