---
lang: sw
title: Kupata Watumiaji kwa Mradi Wako
description: Saidia mradi wako wa open source kukua kwa kuufikisha kwa watumiaji wenye furaha.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Kueneza neno

Hakuna sheria inayosema unapaswa kutangaza mradi wa open source unapozindua. Kuna sababu nyingi zinazoridhisha za kufanya kazi katika open source ambazo hazihusiani na umaarufu. Badala ya kutumaini wengine wataupata na kuutumia mradi wako wa open source, unapaswa kueneza neno kuhusu kazi yako ngumu!

## Tambua ujumbe wako

Kabla hujaanza kazi halisi ya kutangaza mradi wako, unapaswa kuwa na uwezo wa kueleza kile mradi wako unachofanya, na kwa nini ni muhimu.

Nini kinachofanya mradi wako kuwa tofauti au wa kuvutia? Kwa nini uliiunda? Kujibu maswali haya kwa ajili yako mwenyewe kutakusaidia kuwasilisha umuhimu wa mradi wako.

Kumbuka kwamba watu hujiunga kama watumiaji, na hatimaye kuwa wachangiaji, kwa sababu mradi wako unatatua tatizo kwao. Unapofikiria ujumbe na thamani ya mradi wako, jaribu kuangalia kupitia mtazamo wa kile _watumiaji na wachangiaji_ wanaweza kutaka.

Kwa mfano, @robb anatumia mifano ya msimbo kuwasilisha kwa uwazi kwa nini mradi wake, [Cartography](https://github.com/robb/Cartography), ni wa manufaa:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Kwa maelezo zaidi kuhusu ujumbe, angalia mazoezi ya Mozilla ya ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) kwa ajili ya kuunda wahusika wa watumiaji.

## Saidia watu wapate na kufuata mradi wako

<aside markdown="1" class="pquote">
  Unahitaji URL moja "nyumbani" ambayo unaweza kutangaza na kuelekeza watu kuhusiana na mradi wako. Huhitaji kutumia pesa nyingi kwenye template ya kifahari au hata jina la kikoa, lakini mradi wako unahitaji kuwa na kitovu.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["Jinsi ya Kueneza Neno Kuhusu Msimbo Wako"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Saidia watu wapate na kukumbuka mradi wako kwa kuwaelekeza kwenye namespace moja.

**Kuwa na akaunti wazi wa kutangaza kazi yako.** Akaunti ya Twitter, URL ya GitHub, au kituo cha IRC ni njia rahisi ya kuwaelekeza watu kwenye mradi wako. Njia hizi za usambazaji pia zinawapa jamii inayokua ya mradi wako mahali pa kukutana.

Ikiwa hutaki kuweka vitengo vya usambazaji katika mradi wako bado, tangaza Handle yako ya Twitter au GitHub katika kila kitu unachofanya. Kutangaza handle yako ya Twitter au GitHub kutawajulisha watu jinsi ya kukufikia au kufuata kazi yako. Ikiwa unazungumza katika mkutano au tukio, hakikisha kuwa taarifa zako za mawasiliano zimejumuishwa katika wasifu wako au slaidi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Makosa niliyofanya katika siku hizo za awali (...) ilikuwa kutokuanza akaunti ya Twitter kwa mradi. Twitter ni njia nzuri ya kuwajulisha watu kuhusu mradi na pia kuendelea kuwafahamisha watu kuhusu mradi.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["Historia ya Apache Storm na Masomo Yaliyopatikana"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Fikiria kuunda tovuti kwa mradi wako.** Tovuti inafanya mradi wako kuwa rafiki zaidi na rahisi kuvinjari, hasa inapounganishwa na nyaraka wazi na mafunzo. Kuwa na tovuti pia kunamaanisha kwamba mradi wako unafanya kazi ambayo itawafanya watazamaji wako wajisikie vizuri zaidi kutumia. Toa mifano ili kuwapa watu mawazo ya jinsi ya kutumia mradi wako.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), muundaji mwenza wa Django, alisema kwamba tovuti ilikuwa _"kitu bora zaidi tulichofanya na Django katika siku za awali"_.

Ikiwa mradi wako umehifadhiwa kwenye GitHub, unaweza kutumia [GitHub Pages](https://pages.github.com/) kwa urahisi kuunda tovuti. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), na [Middleman](https://middlemanapp.com/) ni [mfano kadhaa](https://github.com/showcases/github-pages-examples) wa tovuti bora na kamili.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Sasa kwamba una ujumbe wa mradi wako, na njia rahisi kwa watu kupata mradi wako, hebu tuondoke na kuzungumza na hadhira yako!

## Nenda mahali ambapo hadhira ya mradi wako iko (mtandaoni)

Kufikia mtandaoni ni njia nzuri ya kushiriki na kueneza neno haraka. Kwa kutumia njia za mtandaoni, una uwezo wa kufikia hadhira kubwa sana.

Tumia jamii na majukwaa yaliyopo mtandaoni kufikia hadhira yako. Ikiwa mradi wako wa open source ni mradi wa programu ya software, unaweza kupata hadhira yako kwenye [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), au [Quora](https://www.quora.com/). Tafuta njia ambazo unafikiri watu watafaidika zaidi au kufurahishwa na kazi yako.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Kila programu ya software ina kazi maalum ambazo ni za manufaa kwa sehemu ndogo ya watumiaji. Usijaribu kuwasilisha kwa watu wengi kadri uwezavyo. Badala yake, elekeza juhudi zako kwa jamii ambazo zitafaidika na kujua kuhusu mradi wako.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Masoko kwa miradi ya open source"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Tafuta njia za kushiriki mradi wako kwa njia zinazofaa:

* **Jifunze kuhusu miradi na jamii zinazohusiana na open source.** Wakati mwingine, huna haja ya kutangaza mradi wako moja kwa moja. Ikiwa mradi wako ni mzuri kwa wanasayansi wa data wanaotumia Python, jifunze kuhusu jamii ya sayansi ya data ya Python. Watu wanapokujua, fursa za asili zitajitokeza za kuzungumza na kushiriki kazi yako.
* **Pata watu wanaokabiliwa na tatizo ambalo mradi wako unatatua.** Tafuta kwenye majukwaa yanayohusiana kwa watu wanaoangukia kwenye hadhira lengwa ya mradi wako. Jibu swali lao na pata njia ya busara, inapofaa, kupendekeza mradi wako kama suluhisho.
* **Omba maoni.** Jitambulisha na kazi yako kwa hadhira ambayo itapata umuhimu na kufurahishwa. Kuwa maalum kuhusu ni nani unadhani atafaidika na mradi wako. Jaribu kumaliza sentensi: _"Nafikiri mradi wangu utawasaidia X, ambao wanajaribu kufanya Y"_. Sikiliza na kujibu maoni ya wengine, badala ya kutangaza tu kazi yako.

Kwa ujumla, zingatia kusaidia wengine kabla ya kuomba mambo kwa ajili yako. Kwa sababu mtu yeyote anaweza kwa urahisi kutangaza mradi mtandaoni, kutakuwa na kelele nyingi. Ili kujitenga na umati, wape watu muktadha wa nani ulivyo na sio tu kile unachotaka.

Ikiwa hakuna anayekusikiliza au kujibu juhudi zako za awali, usikate tamaa! Uzinduzi wa miradi nyingi ni mchakato wa kurudiwa ambao unaweza kuchukua miezi au miaka. Ikiwa hujapata majibu mara ya kwanza, jaribu mbinu tofauti, au tafuta njia za kuongeza thamani kwa kazi ya wengine kwanza. Kutangaza na kuzindua mradi wako inachukua muda na kujitolea.

## Nenda mahali ambapo hadhira ya mradi wako iko (nje ya mtandao)

![Kuongea hadharani](/assets/images/finding-users/public_speaking.jpg)

Matukio ya nje ya mtandao ni njia maarufu ya kutangaza miradi mipya kwa hadhira. Ni njia nzuri ya kufikia hadhira inayoshiriki na kujenga uhusiano wa kina wa kibinadamu, hasa ikiwa unavutiwa na kufikia waendelezaji.

Ikiwa wewe ni [mpya katika kuzungumza hadharani](https://speaking.io/), anza kwa kutafuta mkutano wa ndani unaohusiana na lugha au mfumo wa mradi wako.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Nilikuwa na wasiwasi sana kuhusu kwenda PyCon. Nilikuwa nikitoa hotuba, nilikuwa na watu wachache tu niliowajua huko, nilikuwa nikienda kwa wiki nzima. (...) Sikuwa na haja ya kuwa na wasiwasi, hata hivyo. PyCon ilikuwa nzuri sana! (...) Kila mtu alikuwa rafiki na mwenye kupenda, kiasi kwamba nilipata wakati mgumu kutokuwa na mazungumzo na watu!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["Jinsi Nilivyojifunza Kusahau Wasiwasi na Kupenda PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Ikiwa hujawahi kuzungumza katika tukio kabla, ni kawaida kabisa kuhisi wasiwasi! Kumbuka kwamba hadhira yako iko hapo kwa sababu wanataka kwa dhati kusikia kuhusu kazi yako.

Unapoandika hotuba yako, zingatia kile hadhira yako itakachokiona kuwa cha kuvutia na kupata thamani. Hifadhi lugha yako kuwa rafiki na inayokaribisha. Tabasamu, pumua, na furahia.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Unapokuwa unaanza kuandika hotuba yako, bila kujali mada yako ni ipi, inaweza kusaidia ikiwa utaona hotuba yako kama hadithi unayowaambia watu.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["Jinsi ya Kuandaa na Kuandika Hotuba ya Mkutano wa Teknolojia"](https://web.archive.org/web/20201128162836/http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Unapojisikia tayari, fikiria kuzungumza katika mkutano ili kutangaza mradi wako. Mikutano inaweza kukusaidia kufikia watu wengi zaidi, wakati mwingine kutoka sehemu mbalimbali za dunia.

Tafuta mikutano ambayo ni maalum kwa lugha yako au mfumo. Kabla ya kuwasilisha hotuba yako, fanya utafiti kuhusu mkutano ili kubinafsisha hotuba yako kwa wahudhuriaji na kuongeza nafasi zako za kukubaliwa kuzungumza katika mkutano. Mara nyingi unaweza kupata hisia ya hadhira yako kwa kuangalia watoa hotuba wa mkutano.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Niliwaandikia kwa heshima watu wa JSConf na kuwaomba wanipe nafasi ya kuwasilisha katika JSConf EU. (...) Nilikuwa na hofu sana, nikitoa hii kitu ambacho nilikuwa nikifanya kwa miezi sita. (...) Wakati wote nilikuwa nikifikiria, oh Mungu wangu. Niko hapa kufanya nini?
  <p markdown="1" class="pquote-credit">
— @ry, ["Historia ya Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Jenga sifa

Mbali na mikakati iliyoorodheshwa hapo juu, njia bora ya kuwakaribisha watu kushiriki na kuchangia mradi wako ni kushiriki na kuchangia miradi yao.

Kusaidia wanaojiunga kwa mara ya kwanza, kushiriki rasilimali, na kufanya michango ya busara kwa miradi ya wengine kutakusaidia kujenga sifa nzuri. Kuwa mwanachama mwenye shughuli katika jamii ya open source kutawasaidia watu kuwa na muktadha wa kazi yako na kuwa na uwezekano mkubwa wa kuipa kipaumbele na kushiriki na kusambaza mradi wako. Kuendeleza uhusiano na miradi mingine ya open source kunaweza hata kupelekea ushirikiano rasmi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Sababu pekee ambayo urllib3 ni maktaba maarufu ya tatu ya Python leo ni kwa sababu ni sehemu ya maombi.
  <p markdown="1" class="pquote-credit">
— @shazow, ["Jinsi ya kufanya mradi wako wa open source ufanikiwe"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Kamwe si mapema, au kuchelewa, kuanza kujenga sifa yako. Hata kama umeshazindua mradi wako tayari,endelea kutafuta njia za kusaidia wengine.

Hakuna suluhisho la usiku mmoja la kujenga hadhira. Kupata imani na heshima ya wengine inachukua muda, na kujenga sifa yako hakumaliziki kamwe.

## Endelea!

Inaweza kuchukua muda mrefu kabla watu wajue mradi wako wa open source. Hiyo ni sawa! Baadhi ya miradi maarufu leo ilichukua miaka kufikia viwango vya juu vya shughuli. Zingatia kujenga uhusiano badala ya kutumaini kwamba mradi wako utaweza kupata umaarufu kwa bahati. Kuwa na subira, na endelea kushiriki kazi yako na wale wanaoithamini.
