---
lang: sw
title: Kujenga Jamii za Kukaribisha
description: Kujenga jamii inayohamasisha watu kutumia, kuchangia, na kuhubiri mradi wako.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Kuandaa mradi wako kwa mafanikio

Umeanzisha mradi wako, unaeneza neno, na watu wanakagua. Sambamba! Sasa, unawafanya vipi wabaki?

Jamii ya kukaribisha ni uwekezaji katika siku zijazo na sifa ya mradi wako. Ikiwa mradi wako unaanza kuona michango yake ya kwanza, anza kwa kuwapa wachangiaji wa mapema uzoefu mzuri, na uwafanye iwe rahisi kwao kurudi tena.

### Wafanya watu wajisikie kukaribishwa

Njia moja ya kufikiria kuhusu jamii ya mradi wako ni kupitia kile @MikeMcQuaid anachokiita [mchoro wa wachangiaji](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Mchoro wa wachangiaji](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Unapojenga jamii yako, fikiria jinsi mtu aliye juu ya mchoro (anayeweza kuwa mtumiaji) anaweza nadharia kuja chini (mtunzaji wa kila mara). Lengo lako ni kupunguza vikwazo katika kila hatua ya uzoefu wa mchango. Wakati watu wanapata ushindi rahisi, watakuwa na motisha ya kufanya zaidi.

Anza na nyaraka zako:

* **Fanya iwe rahisi kwa mtu kutumia mradi wako.** [README ya kirafiki](../starting-a-project/#kuandika-readme) na mifano wazi ya msimbo itafanya iwe rahisi kwa yeyote anayekuja kwenye mradi wako kuanza.
* **Eleza wazi jinsi ya kuchangia**, ukitumia [faili yako ya CONTRIBUTING](../starting-a-project/#kuandika-miongozo-yako-ya-kuchangia) na kuweka masuala yako kuwa ya kisasa.
* **Masuala mazuri ya kwanza**: Ili kuwasaidia wachangiaji wapya kuanza, fikiria wazi [kuyapachika masuala ambayo ni rahisi vya kutosha kwa waanzilishi kushughulikia](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub kisha itawasilisha masuala haya katika maeneo mbalimbali kwenye jukwaa, itakayoongeza michango yenye manufaa, na kupunguza vikwazo kutoka kwa watumiaji wanaoshughulikia masuala ambayo ni magumu sana kwa kiwango chao.

[Utafiti wa Open Source wa GitHub wa 2017](http://opensourcesurvey.org/2017/) ulionyesha kuwa nyaraka zisizokamilika au zenye kuchanganya ni tatizo kubwa kwa watumiaji wa open source. Nyaraka nzuri zinawakaribisha watu kuingiliana na mradi wako. Hatimaye, mtu atafungua suala au ombi la kuvuta. Tumia mwingiliano haya kama fursa za kuwahamisha chini ya mchoro.

* **Wakati mtu mpya anapojiunga kwenye mradi wako, mshukuru kwa nia yao!** Inachukua tu uzoefu mmoja mbaya kumfanya mtu asitake kurudi.
* **Kuwa na majibu.** Ikiwa hujajibu suala lao kwa mwezi, kuna uwezekano, tayari wamesahau kuhusu mradi wako.
* **Kuwa na akili wazi kuhusu aina za michango utazokubali.** Wachangiaji wengi huanza na ripoti ya makosa au marekebisho madogo. Kuna [njia nyingi za kuchangia](../how-to-contribute/#nini-maana-ya-kuchangia) kwenye mradi. Wacha watu wasaidie jinsi wanavyotaka kusaidia.
* **Ikiwa kuna mchango usiokubaliana nao,** mshukuru kwa wazo lao na [eleza kwa nini](../best-practices/#kujifunza-kusema-hapana) haifai katika upeo wa mradi, ukirejelea nyaraka husika ikiwa unayo.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Kuchangia kwenye open source ni rahisi kwa wengine kuliko wengine. Kuna hofu kubwa ya kupigiwa kelele kwa kutofanya kitu kwa usahihi au tu kutofaa. (...) Kwa kuwapa wachangiaji mahali pa kuchangia kwa ujuzi wa chini wa kiufundi (nyaraka, maudhui ya wavuti markdown, nk) unaweza kupunguza sana wasiwasi hao.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Kukuza msingi wa wachangiaji katika open source ya kisasa"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Wengi wa wachangiaji wa open source ni "wachangiaji wa kawaida": watu wanaochangia kwenye mradi mara chache tu. Mchangiaji wa kawaida huenda hana muda wa kujifunza kwa undani kuhusu mradi wako, hivyo kazi yako ni kuwafanya iwe rahisi kwao kuchangia.

Kuhamasisha wachangiaji wengine ni uwekezaji kwako pia. Unapowapa mashabiki wako wakubwa uwezo wa kufanya kazi wanazofurahia, kuna shinikizo kidogo la kufanya kila kitu mwenyewe.

### Andika kila kitu

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Je, umewahi kutembelea tukio (la teknolojia) ambapo hukujua mtu yeyote, lakini kila mtu mwingine alionekana kusimama katika makundi na kuzungumza kama marafiki wa zamani? (...) Sasa fikiria unataka kuchangia kwenye mradi wa open source, lakini huoni kwa nini au jinsi hii inavyotokea.
  <p markdown="1" class="pquote-credit">
— @janl, ["Open Source Endelevu"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Unapozindua mradi mpya, inaweza kuonekana kuwa ya asili kuweka kazi yako kuwa ya faragha. Lakini miradi ya open source inastawi unapokuwa na nyaraka za mchakato wako hadharani.

Unapandika mambo, watu wengi wanaweza kushiriki katika kila hatua ya njia. Unaweza kupata msaada kwenye jambo ambalo hukujua hata unahitaji.

Kuandika mambo kuna maana zaidi ya nyaraka za kiufundi. Wakati wowote unavyohisi hamu ya kuandika kitu au kujadili mradi wako kwa faragha, jiulize ikiwa unaweza kufanya kuwa hadharani.

Kuwa wazi kuhusu ramani ya mradi wako, aina za michango unazotafuta, jinsi michango inavyopitiwa, au kwa nini ulifanya maamuzi fulani.

Ikiwa unagundua watumiaji wengi wakikabiliwa na tatizo moja sawa, andika majibu katika README.

Kwa mikutano, fikiria kuchapisha maelezo yako au maelezo muhimu katika suala husika. Maoni utakayopata kutoka kwa kiwango hiki cha uwazi yanaweza kukushangaza.

Kuhifadhi kila kitu kuna maana kwa kazi unayofanya pia. Ikiwa unafanya kazi kwenye sasisho kubwa kwa mradi wako, weka katika ombi la kuvuta na uweke alama kama kazi katika maendeleo (WIP). Hivyo, watu wengine wanaweza kuhisi kuwa wanahusika katika mchakato mapema.

### Kuwa na majibu

Unapokuwa [ukitangaza mradi wako](../finding-users), watu watakuwa na maoni kwako. Wanaweza kuwa na maswali kuhusu jinsi mambo yanavyofanya kazi, au wanahitaji msaada wa kuanza.

Jaribu kuwa na majibu wakati mtu anafungua suala, kuwasilisha ombi la kuvuta, au kuuliza swali kuhusu mradi wako. Unapojibu haraka, watu watajisikia wakiwa katika mazungumzo, na watakuwa na shauku zaidi ya kushiriki.

Hata kama huwezi kupitia ombi mara moja, kukiri mapema husaidia kuongeza ushirikiano. Hapa kuna jinsi @tdreyno alijibu ombi la kuvuta kwenye [Middleman](https://github.com/middleman/middleman/pull/1466):

![Ombi la kuvuta la Middleman](/assets/images/building-community/middleman_pr.png)

[Utafiti wa Mozilla uligundua kwamba](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) wachangiaji waliopokea mapitio ya msimbo ndani ya masaa 48 walikuwa na kiwango cha juu cha kurudi na kuchangia tena.

Mazungumzo kuhusu mradi wako yanaweza pia kufanyika katika maeneo mengine mtandaoni, kama Stack Overflow, Twitter, au Reddit. Unaweza kuweka arifa katika baadhi ya maeneo haya ili upate taarifa wakati mtu anapokutana na mradi wako.

### Wape jamii yako mahali pa kukusanyika

Kuna sababu mbili za kuwapa jamii yako mahali pa kukusanyika.

Sababu ya kwanza ni kwao. Wasaidie watu kujua kila mmoja. Watu wenye maslahi sawa bila shaka watataka mahali pa kuzungumza kuhusu hilo. Na wakati mawasiliano ni ya umma na yanapatikana, mtu yeyote anaweza kusoma kumbukumbu za zamani ili kujiweka sawa na kushiriki.

Sababu ya pili ni kwako. Ikiwa hutowapatia watu mahali pa umma pa kuzungumza kuhusu mradi wako, kuna uwezekano watawasiliana nawe moja kwa moja. Katika mwanzo, inaweza kuonekana rahisi kujibu ujumbe wa faragha "hivi mara moja tu". Lakini kwa muda, hasa ikiwa mradi wako unakuwa maarufu, utajisikia uchovu. Jizuie kuwasiliana na watu kuhusu mradi wako kwa faragha. Badala yake, waelekeze kwenye njia ya umma iliyowekwa.

Mawasiliano ya umma yanaweza kuwa rahisi kama kuwaelekeza watu kufungua suala badala ya kukutumia barua pepe moja kwa moja au kutoa maoni kwenye blogu yako. Unaweza pia kuanzisha orodha ya barua, au kuunda akaunti ya Twitter, Slack, au chaneli ya IRC kwa watu kuzungumza kuhusu mradi wako. Au jaribu yote hapo juu!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) huweka masaa ya ofisi kila baada ya wiki mbili kusaidia wanajamii:

> Kops pia ina muda uliowekwa kila baada ya wiki mbili kutoa msaada na mwongozo kwa jamii. Wanaweka kops wamekubali kuweka muda maalum wa kufanya kazi na wapya, kusaidia na PRs, na kujadili vipengele vipya.

Mifano muhimu ya mawasiliano ya umma ni: 1) masuala ya usalama na 2) ukiukaji wa kanuni za tabia. Unapaswa kila wakati kuwa na njia ya watu kuripoti masuala haya kwa faragha. Ikiwa hutaki kutumia barua pepe yako ya kibinafsi, weka anwani ya barua pepe iliyowekwa.

## Kukuza jamii yako

Jamii ni nguvu sana. Nguvu hiyo inaweza kuwa baraka au laana, kulingana na jinsi unavyoiendesha. Kadri jamii ya mradi wako inavyokua, kuna njia za kusaidia kuwa nguvu ya ujenzi, si uharibifu.

### Usivumilie wahusika wabaya

Mradi maarufu wowote bila shaka utavutia watu wanaoharibu, badala ya kusaidia, jamii yako. Wanaweza kuanzisha mijadala isiyo ya lazima, kujadili vipengele vidogo, au kuwanyanyasa wengine.

Fanya bidii yako kupitisha sera ya kutovumilia watu hawa. Ikiwa utaacha bila kudhibiti, watu wabaya watafanya wengine katika jamii yako wajisikie wasumbufu. Wanaweza hata kuondoka.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  Ukweli ni kwamba kuwa na jamii inayoungana mkono ni muhimu. Singeweza kufanya kazi hii bila msaada wa wenzangu, wageni wa kirafiki mtandaoni, na chaneli za IRC zenye mazungumzo. (...) Usikubali chini ya kiwango. Usikubali wahusika wabaya.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["Jinsi ya Kuendesha Mradi wa FOSS"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Mijadala ya kawaida kuhusu vipengele vidogo vya mradi wako inawavuruga wengine, ikiwa ni pamoja na wewe, kutoka kwa kuzingatia kazi muhimu. Watu wapya wanaofika kwenye mradi wako wanaweza kuona mazungumzo haya na wasitake kushiriki.

Unapona tabia mbaya ikitokea kwenye mradi wako, itangaze hadharani. Eleza, kwa sauti nzuri lakini thabiti, kwa nini tabia yao si ya kukubalika. Ikiwa tatizo linaendelea, huenda ukahitaji [kuomba waondoke](../code-of-conduct/#kutekeleza-kanuni-zako-za-maadili). Kanuni yako ya [tabia](../code-of-conduct/) inaweza kuwa mwongozo mzuri kwa mazungumzo haya.

### Wafikie wachangiaji walipo

Nyaraka nzuri tu zinaweza kuwa muhimu zaidi kadri jamii yako inavyokua. Wachangiaji wa kawaida, ambao huenda wasijue mradi wako, wanasoma nyaraka zako ili kupata muktadha wa haraka wanayohitaji.

Katika faili yako ya CONTRIBUTING, eleza wazi kwa wachangiaji wapya jinsi ya kuanza. Huenda ukataka hata kuunda sehemu maalum kwa ajili ya kusudi hili. [Django](https://github.com/django/django), kwa mfano, ina ukurasa maalum wa kuwapokea wachangiaji wapya.

![Ukurasa wa wachangiaji wapya wa Django](/assets/images/building-community/django_new_contributors.png)

Katika foleni yako ya masuala, lebo masuala ambayo yanapatana na aina tofauti za wachangiaji: kwa mfano, [_"wachangiaji wa kwanza tu"_](https://kentcdodds.com/blog/first-timers-only), _"masuala mazuri ya kwanza"_, au _"nyaraka"_. [Lebo hizi](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) hufanya iwe rahisi kwa mtu mpya kwenye mradi wako kuangalia masuala yako na kuanza.

Hatimaye, tumia nyaraka zako kuwafanya watu wajisikie kukaribishwa katika kila hatua ya njia.

Hutawahi kuwasiliana na watu wengi wanaokuja kwenye mradi wako. Huenda kuna michango ambayo hukupata kwa sababu mtu alijisikia kutishwa au hakuwa na wazo la kuanzia. Hata maneno machache ya kirafiki yanaweza kumzuia mtu kuondoka kwenye mradi wako kwa kukata tamaa.

Kwa mfano, hapa kuna jinsi [Rubinius](https://github.com/rubinius/rubinius/) inaanza [mwongozo wake wa kuchangia](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Tunataka kuanza kwa kusema asante kwa kutumia Rubinius. Mradi huu ni kazi ya upendo, na tunathamini sana watumiaji wote wanaokamata makosa, kuboresha utendaji, na kusaidia na nyaraka. Kila mchango ni wa maana, hivyo asante kwa kushiriki. Hiyo ikiwa imesema, hapa kuna miongozo kadhaa tunayoomba ufuate ili tuweze kushughulikia suala lako kwa ufanisi.

### Shiriki umiliki wa mradi wako

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  Viongozi wako watakuwa na maoni tofauti, kama jamii zote zenye afya zinapaswa! Hata hivyo, unahitaji kuchukua hatua ili kuhakikisha kwamba sauti kubwa zaidi haishindwi kila mara kwa kuwachosha watu, na kwamba sauti zisizo maarufu na za watu wachache zinasikika.
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["Nini kinachofanya jamii kuwa nzuri?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Watu wanashiriki kwa furaha katika miradi wanapojisikia kuwa na umiliki. Hiyo haimaanishi unahitaji kuhamasisha maono ya mradi wako au kukubali michango usiyotaka. Lakini kadri unavyowapa wengine sifa, ndivyo watakavyobaki karibu.

Angalia ikiwa unaweza kupata njia za kushiriki umiliki na jamii yako kadri iwezekanavyo. Hapa kuna mawazo kadhaa:

* **Pingamizi la kurekebisha makosa rahisi (yasiyo ya muhimu).** Badala yake, tumia kama fursa za kuajiri wachangiaji wapya, au kufundisha mtu ambaye anataka kuchangia. Inaweza kuonekana kuwa si ya kawaida mwanzoni, lakini uwekezaji wako utalipa kwa muda. Kwa mfano, @michaeljoseph aliomba mchangiaji kuwasilisha ombi la kuvuta kwenye suala la [Cookiecutter](https://github.com/audreyr/cookiecutter) hapa chini, badala ya kulirekebisha mwenyewe.

![Suala la Cookiecutter](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Anzisha faili ya CONTRIBUTORS au AUTHORS katika mradi wako** inayoorodhesha kila mtu ambaye amechangia kwenye mradi wako, kama [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md) inavyofanya.

* Ikiwa una jamii kubwa, **tuma jarida au andika chapisho la blogu** ukishukuru wachangiaji. [Hii Wiki katika Rust](https://this-week-in-rust.org/) na [Shoutouts za Hoodie](http://hood.ie/blog/shoutouts-week-24.html) ni mifano miwili nzuri.

* **Wape kila mchango ruhusa ya kuingia.** @felixge alipata kuwa hii ilifanya watu [kuwa na shauku zaidi ya kusafisha patches zao](https://felixge.de/2013/03/11/the-pull-request-hack.html), na hata alipata watunzaji wapya kwa miradi ambayo hakuwa amefanya kazi nayo kwa muda.

* Ikiwa mradi wako uko GitHub, **hamasisha mradi wako kutoka kwenye akaunti yako binafsi hadi [Shirika](https://help.github.com/articles/creating-a-new-organization-account/)** na ongeza angalau mtunzaji mmoja wa akiba. Mashirika yanafanya iwe rahisi kufanya kazi kwenye miradi na washirikishi wa nje.

Ukweli ni kwamba [miradi mingi ina](https://peerj.com/preprints/1233/) watunzaji mmoja au wawili tu wanaofanya kazi nyingi. Kadri mradi wako unavyokuwa, na kadri jamii yako inavyokuwa kubwa, ndivyo itakuwa rahisi kupata msaada.

Ingawa huenda usipate mtu kila wakati wa kujibu wito, kuweka ishara huko nje kunaongeza uwezekano kwamba watu wengine wataingilia kati. Na kadri unavyoweza kuanza mapema, ndivyo watu wanaweza kusaidia.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Ni katika maslahi yako\] kuajiri wachangiaji wanaofurahia na wana uwezo wa kufanya mambo ambayo huwezi. Je, unafurahia kuandika msimbo, lakini si kujibu masuala? Basi tambua watu hao katika jamii yako ambao wanafanya hivyo na uwaachie.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Jamii za Kukaribisha"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Kutatua migogoro

Katika hatua za awali za mradi wako, kufanya maamuzi makubwa ni rahisi. Unapojisikia kufanya kitu, unakifanya tu.

Kadri mradi wako unavyokuwa maarufu, watu wengi watachukua maslahi katika maamuzi unayofanya. Hata kama huna jamii kubwa ya wachangiaji, ikiwa mradi wako una watumiaji wengi, utapata watu wakijadili maamuzi au kuleta masuala yao wenyewe.

Kwa sehemu kubwa, ikiwa umejenga jamii ya kirafiki, heshimu, na umeandika michakato yako kwa uwazi, jamii yako inapaswa kuwa na uwezo wa kupata suluhu. Lakini wakati mwingine unakutana na tatizo ambalo ni gumu zaidi kushughulikia.

### Weka kiwango cha wema

Wakati jamii yako inakabiliwa na suala gumu, hasira zinaweza kuongezeka. Watu wanaweza kuwa na hasira au kukasirika na kuhamasisha hasira zao kwa wengine, au kwako.

Kazi yako kama mtunza mradi ni kuzuia hali hizi zisipande. Hata kama una maoni thabiti kuhusu mada hiyo, jaribu kuchukua nafasi ya mtunzaji au mwezeshaji, badala ya kuingia kwenye ugumu na kusukuma maoni yako. Ikiwa mtu anakuwa mbaya au anachujikulia mazungumzo, [fanya haraka](../building-community/#usivumilie-wahusika-wabaya) kudumisha mazungumzo ya heshima na yenye tija.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  Kama mtunza mradi, ni muhimu sana kuwa heshimu kwa wachangiaji wako. Mara nyingi wanachukua unachosema kwa kibinafsi.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Kuwa na Heshima au Uondoke"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Watu wengine wanatazamia mwongozo kutoka kwako. Weka mfano mzuri. Unaweza bado kuonyesha kutoridhika, kutokuwa na furaha, au wasiwasi, lakini fanya hivyo kwa utulivu.

Kuweka utulivu sio rahisi, lakini kuonyesha uongozi kunaboresha afya ya jamii yako. Mtandao unakushukuru.

### Zingatia README yako kama katiba

README yako ni [zaidi ya seti ya maelekezo](../starting-a-project/#kuandika-readme). Pia ni mahali pa kuzungumzia malengo yako, maono ya bidhaa, na ramani ya barabara. Ikiwa watu wanazingatia sana kujadili umuhimu wa kipengele fulani, inaweza kusaidia kurejelea README yako na kuzungumza kuhusu maono ya juu ya mradi wako. Kuweka mkazo kwenye README yako pia kunafanya mazungumzo yasihusishwe na mtu binafsi, hivyo unaweza kuwa na mazungumzo yenye tija.

### Zingatia safari, sio mwisho wake

Miradi mingine hutumia mchakato wa kupiga kura kufanya maamuzi makubwa. Ingawa ni ya maana kwa mtazamo wa kwanza, kupiga kura kunasisitiza kufikia "jibu," badala ya kusikiliza na kushughulikia wasiwasi wa kila mmoja.

Kupiga kura kunaweza kuwa kisiasa, ambapo wanajamii wanajisikia shinikizo la kufanya mapendeleo kwa kila mmoja au kupiga kura kwa njia fulani. Si kila mtu anapiga kura, pia, iwe ni [wengi walio watulivu](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority) katika jamii yako, au watumiaji wa sasa ambao hawakujua kura ilikuwa inafanyika.

Wakati mwingine, kupiga kura ni mchujo wa mshindi inayohitajika. Kadri uwezavyo, hata hivyo, zingatia ["kutafuta makubaliano"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) badala ya makubaliano.

Kwa mchakato wa kutafuta mwafaka, wanajamii hujadili masuala makubwa hadi wanapohisi kuwa wamesikilizwa vya kutosha. Wakati masuala madogo pekee yanaposalia, jamii huendelea mbele. "Kutafuta mwafaka" hutambua kuwa jamii huenda isiweze kufikia jibu kamilifu. Badala yake, inatoa kipaumbele kwa kusikiliza na kujadiliana.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Sehemu ya sababu kwa nini mfumo wa kupiga kura haupo kwa Masuala ya Atom ni kwa sababu timu ya Atom haitafuata mfumo wa kupiga kura katika hali zote. Wakati mwingine tunapaswa kuchagua kile tunachohisi ni sahihi hata kama ni kisiasa. (...) Ninachoweza kutoa na kuahidi kufanya...ni kwamba ni kazi yangu kusikiliza jamii.
  <p markdown="1" class="pquote-credit">
— @lee-dohm kwenye mchakato wa maamuzi wa Atom
  </p>
</aside>

Hata kama huenda usifanye mchakato wa kutafuta makubaliano, kama mtunza mradi mzuri, ni muhimu watu wajue unawasikiliza. Kuwafanya watu wengine wajisikie kusikilizwa, na kujitolea kutatua wasiwasi wao, hunaenda mbali katika kupunguza hali nyeti. Kisha, fuata maneno yako kwa vitendo.

Usikimbilie kufanya maamuzi kwa sababu ya kuwa na suluhu. Hakikisha kila mtu anajisikia kusikilizwa na kwamba taarifa zote zimewekwa wazi kabla ya kuhamasisha suluhu.

### Weka mazungumzo ili yalenge hatua

Mazungumzo ni muhimu, lakini kuna tofauti kati ya mazungumzo yenye tija na yasiyo na tija.

Hamasisha mazungumzo kadri yanavyosonga kuelekea suluhu. Ikiwa ni wazi kwamba mazungumzo yanakosa mwelekeo au yanaaanza kutoendanishana na mjadala, mashambulizi yanakuwa ya kibinafsi, au watu wanajadili maelezo madogo, ni wakati wa kuyafunga.

Kuruhusu mazungumzo haya kuendelea sio tu ni mbaya kwa suala lililopo, bali pia ni mbaya kwa afya ya jamii yako. Inatuma ujumbe kwamba aina hizi za mazungumzo zinakubaliwa au hata kuhamasishwa, na inaweza kuwakatisha tamaa watu kutoka kuleta au kutatua masuala ya baadaye.

Kwa kila hoja iliyotolewa na wewe au na wengine, jiulize, _"Hii inatufanya tufikie suluhu vipi?"_

Ikiwa mazungumzo yanaanza kuharibika, waulize kikundi, _"Ni hatua zipi tunapaswa kuchukua sasa?"_ ili kurejesha mazungumzo.

Ikiwa mazungumzo waziwazi hayana mahali pa kwenda, hakuna hatua wazi za kuchukuliwa, au hatua inayofaa tayari imechukuliwa, funga suala na eleza kwa nini umefunga.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Kuongoza uzi wa mazungumzo kuelekea manufaa bila kuwa na shinikizo ni sanaa. Haitafanya kazi tu kuwakumbusha watu wasipoteze muda wao, au kuwauliza wasichapishe isipokuwa wana kitu cha maana kusema. (...) Badala yake, unahitaji kupendekeza masharti ya maendeleo zaidi: wape watu njia, njia ya kufuata inayofikisha matokeo unayotaka, lakini bila kuonekana kama unadikteti tabia.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Chagua mapambano yako kwa busara

Muktadha ni muhimu. Fikiria ni nani anayehusika katika mazungumzo na jinsi wanavyowakilisha jamii nzima.

Je, kila mtu katika jamii anakasirishwa na, au hata kushiriki katika, suala hili? Au ni mtu mmoja tu anayesumbua? Usisahau kuzingatia wanajamii wako kimya, si tu sauti za wazoefu wa kuongea.

Ikiwa suala haliwakilishi mahitaji ya jumla ya jamii yako, huenda unahitaji tu kukiri wasiwasi wa watu wachache. Ikiwa hii ni tatizo linalojirudia bila suluhu wazi, waelekeze kwenye mijadala ya awali kuhusu mada hiyo na uifunge.

### Tambua mchujo wa mshindi wa jamii

Kwa mtazamo mzuri na mawasiliano wazi, hali nyingi ngumu zinaweza kutatuliwa. Hata hivyo, hata katika mazungumzo yenye tija, kunaweza kuwa na tofauti ya maoni kuhusu jinsi ya kuendelea. Katika hali hizi, tambua mtu mmoja au kikundi cha watu wanaoweza kutumikia kama mchujo wa mshindi.

Mchujo wa mshindi inaweza kuwa mtunza mradi mkuu, au inaweza kuwa kikundi kidogo cha watu wanaofanya maamuzi kwa kupiga kura. Kwa matumaini, umeshatambua mchujo wa mshindi na mchakato husika katika faili ya GOVERNANCE kabla ya kuhitaji kuitumia.

Mchujo wa mshindi yako inapaswa kuwa chaguo la mwisho. Masuala yanayogawanya ni fursa kwa jamii yako kukua na kujifunza. Kumbatia fursa hizi na kisha tumia mchakato wa ushirikiano kuhamasisha suluhu popote iwezekanavyo.

## Jamii ndiyo ❤️ ya open source

Jamii zenye afya na zinazostawi zinpea nguvu maelfu ya masaa yanayowekwa kwenye open source kila wiki. Wachangiaji wengi wanataja watu wengine kama sababu ya kufanya kazi - au kutofanya kazi - kwenye open source. Kwa kujifunza jinsi ya kutumia nguvu hiyo kwa njia nzuri, utasaidia mtu huko nje kuwa na uzoefu usiosahaulika wa open source.
