---
lang: sw
title: Mbinu Bora kwa Watunzaji
description: Kufanya maisha yako kuwa rahisi kama mtunzaji wa open source, kutoka kwa kuandika nyaraka hadi kutumia jamii yako.
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## Je, inamaanisha nini kuwa mtunzaji?

Ikiwa unatunza mradi wa open source ambao watu wengi wanatumia, huenda umekumbana na hali ya kwamba unaandika msimbo kidogo na kujibu masuala zaidi.

Katika hatua za awali za mradi, unajaribu mawazo mapya na kufanya maamuzi kulingana na kile unachotaka. Kadri mradi wako unavyoongezeka kwa umaarufu, utagundua kuwa unafanya kazi na watumiaji na wachangiaji wako zaidi.

Kutunza mradi kunahitaji zaidi ya msimbo. Kazi hizi mara nyingi hazitarajiwi, lakini ni muhimu sana kwa mradi unaokua. Tumekusanya njia chache za kufanya maisha yako kuwa rahisi, kutoka kwa kuandika nyaraka hadi kutumia jamii yako.

## Kuandika nyaraka zako

Kuandika mambo ni moja ya mambo muhimu zaidi unayoweza kufanya kama mtunzaji.

Nyaraka sio tu kulezea mawazo yako, lakini pia zinawasaidia watu wengine kuelewa kile unachohitaji au kutarajia, kabla ya kuuliza.

Kuandika mambo kunafanya iwe rahisi kusema hapana wakati kitu hakifai katika upeo wako. Pia inafanya iwe rahisi kwa watu kujiunga na kusaidia. Hujui ni nani anayeweza kuwa anasoma au kutumia mradi wako.

Hata kama hujatumia aya kamili, kuandika vidokezo ni bora kuliko kutokandika kabisa.

Kumbuka kuweka nyaraka zako kuwa za kisasa. Ikiwa huwezi kufanya hivyo kila wakati, futa nyaraka zako za zamani au eleza kuwa zimepitwa na wakati ili wachangiaji wajue kuwa masasisho yanakaribishwa.

### Andika maono ya mradi wako

Anza kwa kuandika malengo ya mradi wako. Yajumuishe kwenye README yako, au tengeneza faili tofauti inayoitwa VISION. Ikiwa kuna nyaraka nyingine zinazoweza kusaidia, kama ramani ya mradi, fanya hizo kuwa za umma pia.

Kuwa na maono wazi, yaliyoandikwa kunakufanya uwe na mwelekeo na kukusaidia kuepuka "kuongezeka kwa upeo" kutokana na michango ya wengine.

Kwa mfano, @lord aligundua ya kwamba kuwa na maono ya mradi kulimsaidia kubaini ni maombi gani ya kupoea kupao mbele. Kama mtunzaji mpya, alijutia kutoshikilia upeo wa mradi wake alipokutana na ombi lake la kwanza la kipengele kwa [Slate](https://github.com/lord/slate).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  Nilishindwa. Sikutia juhudi kuja na suluhisho kamili. Badala ya suluhisho la nusu, ningependa kusema "Sina muda kwa hili sasa, lakini nitaongeza kwenye orodha ya mambo mazuri ya kuwa nayo baadaye."
  <p markdown="1" class="pquote-credit">
— @lord, ["Vidokezo kwa watunzaji wapya wa open source"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### Wasiliana matarajio yako

Kanuni zinaweza kuwa ngumu kuandika. Wakati mwingine unaweza kuhisi kama unawachunguza tabia za watu wengine au kuzamisha furaha yote.

Kwa kuandika na kutekeleza kwa haki, hata hivyo, kanuni nzuri zinawapa watunzaji nguvu. Zinakuzuia usijikute unafanya mambo usiyopenda kufanya.

Watu wengi wanaokutana na mradi wako hawajui chochote kukuhusu au hali zako. Wanaweza kudhani unalipwa kufanya hivyo, hasa ikiwa ni kitu wanachotumia mara kwa mara na kutegemea. Huenda wakati mmoja ulitumia muda mwingi kwenye mradi wako, lakini sasa unashughulika na kazi mpya au mwanafamilia.

Haya yote ni sawa! Hakikisha tu watu wengine wanajua kuhusu hilo.

Ikiwa kusimamia mradi wako ni kwa muda wa sehemu au kwa hiari, kuwa mwaminifu kuhusu muda ulionao. Hii sio sawa na muda unadhani mradi unahitaji, au muda wengine wanataka uweke.

Hapa kuna kanuni chache ambazo ni muhimu kuandika:

* Jinsi mchango unavyopitiwa na kukubaliwa (_Je, wanahitaji majaribio? Kigezo cha suala?_)
* Aina za michango utazokubali (_Je, unataka tu msaada na sehemu fulani ya msimbo wako?_)
* Wakati sahihi wa kufuatilia (_kwa mfano, "Unaweza kutarajia majibu kutoka kwa mtunzaji ndani ya siku 7. Ikiwa hujasikia chochote ndani ya wakati huo, tafadhali ulizia katika laini ya mazungumzo."_)
* Muda gani unatumia kwenye mradi (_kwa mfano, "Tunatumia takriban masaa 5 kwa wiki kwenye mradi huu"_)

[Jekyll](https://github.com/jekyll/jekyll/tree/master/docs), [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules), na [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) ni mifano kadhaa ya miradi yenye kanuni za msingi kwa watunzaji na wachangiaji.

### Weka mawasiliano kuwa ya umma

Usisahau kuandika mwingiliano wako pia. Popote unavyoweza, weka mawasiliano kuhusu mradi wako kuwa ya umma. Ikiwa mtu anajaribu kukutumia ujumbe wa faragha kujadili ombi la kipengele au hitaji la msaada, kwa adabu waelekeze kwenye njia ya mawasiliano ya umma, kama orodha ya barua au tracker ya masuala.

Ikiwa unakutana na watunzaji wengine, au kufanya maamuzi makubwa kwa faragha, andika mazungumzo haya kwa umma, hata kama ni kuweka tu maelezo yako.

Hivyo, mtu yeyote anayejiunga na jamii yako atakuwa na ufikiaji wa taarifa sawa na mtu ambaye amekuwepo kwa miaka.

## Kujifunza kusema hapana

Umeandika mambo. Kwa kawaida, kila mtu angeweza kusoma nyaraka zako, lakini katika ukweli, itabidi uwakumbushie wengine kwamba maarifa haya yapo.

Hata hivyo, kuwa na kila kitu kimeandikwa, kunasaidia kupunguza hali za kibinafsi unapohitaji kutekeleza kanuni zako.

Kusema hapana si furaha, lakini _"Mchango wako hauendani na vigezo vya mradi huu"_ inahisi kuwa na maana kidogo kuliko _"Sipendi mchango wako"_.

Kusema hapana kunatumika kwa hali nyingi utakazokutana nazo kama mtunzaji: maombi ya kipengele ambayo hayafai katika upeo, mtu anayepotosha mazungumzo, kufanya kazi zisizo za lazima kwa wengine.

### Weka mazungumzo kuwa ya kirafiki

Moja ya maeneo muhimu zaidi ambapo utajifunza kusema hapana ni kwenye foleni yako ya masuala na ombi la kuvuta. Kama mtunzaji wa mradi, bila shaka utapokea mapendekezo ambayo hutaki kukubali.

Huenda mchango unabadilisha upeo wa mradi wako au hauendani na maono yako. Huenda wazo ni zuri, lakini utekelezaji ni mbaya.

Bila kujali sababu, inawezekana kushughulikia kwa ustadi michango ambayo haikidhi viwango vya mradi wako.

Ikiwa unapokea mchango usiotaka kukubali, majibu yako ya kwanza yanaweza kuwa kuupuuza au kujaribu kuonyesha hujaona. Kufanya hivyo kunaweza kuumiza hisia za mtu mwingine na hata kumkatisha tamaa mchango mwingine wa uwezekano katika jamii yako.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  Ufumbuzi wa kusaidia miradi mikubwa ya open source ni kuweka masuala yakiendelea. Jaribu kuepuka kuwa na masuala yanayokwama. Ikiwa wewe ni mwandishi wa programu wa iOS unajua jinsi inavyoweza kuwa ngumu kuwasilisha radari. Unaweza kusikia tena baada ya miaka 2, na unashauriwa kujaribu tena na toleo jipya la iOS.
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["Kukuza jamii za open source"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

Usiache mchango usiotakikana wazi kwa sababu unajisikia hatia au unataka kuwa wa huruma. Kadri muda unavyopita, masuala yako na PRs zisizojibiwa zitafanya kufanya kazi kwenye mradi wako kuwa ngumu zaidi na ya kutisha.

Ni bora kufunga mara moja michango unayojua hutaki kukubali. Ikiwa mradi wako tayari unakabiliwa na msongamano mkubwa, @steveklabnik ana mapendekezo ya [jinsi ya kupangilia masuala kwa ufanisi](https://words.steveklabnik.com/how-to-be-an-open-source-gardener).

Pili, kupuuza michango kunaonyesha ishara mbaya kwa jamii yako. Kuchangia kwenye mradi kunaweza kutisha, hasa ikiwa ni mara ya kwanza ya mtu. Hata kama hutaki kukubali mchango wao, tambua mtu anayehusika na kuwashukuru kwa nia yao. Ni sifa kubwa!

Ikiwa hutaki kukubali mchango:

* **Washukuru** kwa mchango wao
* **Eleza kwa nini haifai** katika upeo wa mradi, na toa mapendekezo wazi ya kuboresha, ikiwa una uwezo. Kuwa na huruma, lakini thabiti.
* **Unganisha kwenye nyaraka husika**, ikiwa unayo. Ikiwa unagundua maombi yanayojirudia kwa mambo usiyotaka kukubali, ongeza kwenye nyaraka zako ili kuepuka kujirudia.
* **Funga ombi**

Huhitaji zaidi ya sentensi 1-2 kujibu. Kwa mfano, wakati mtumiaji wa [celery](https://github.com/celery/celery/) aliripoti kosa linalohusiana na Windows, @berkerpeksag [alijibu](https://github.com/celery/celery/issues/3383):

![Picha ya Celery](/assets/images/best-practices/celery.png)

Ikiwa wazo la kusema hapana linakutisha, huenda usiwe peke yako. Kama @jessfraz [alivyosema](https://blog.jessfraz.com/post/the-art-of-closing/):

> Nimezungumza na watunzaji kutoka miradi kadhaa tofauti ya open source, Mesos, Kubernetes, Chromium, na wote wanakubali moja ya sehemu ngumu zaidi za kuwa mtunzaji ni kusema "Hapana" kwa patches usizotaka.

Usijisikie hatia kwa kutotaka kukubali mchango wa mtu. Kanuni ya kwanza ya open source, [kulingana na](https://twitter.com/solomonstre/status/715277134978113536) @shykes: _"Hapana ni ya muda, ndiyo ni milele."_ Wakati wa kuonyesha huruma kwa shauku ya mtu mwingine ni jambo zuri, kukataa mchango si sawa na kukataa mtu anayehusika.

Hatimaye, ikiwa mchango si mzuri vya kutosha, huna wajibu wa kukubali. Kuwa na huruma na kujibu wakati watu wanachangia kwenye mradi wako, lakini kukubali tu mabadiliko ambayo unadhani yataboresha mradi wako. Kadri unavyofanya mazoezi ya kusema hapana, ndivyo inavyokuwa rahisi. Ahadi.

### Kuwa mchangamfu

Ili kupunguza idadi ya michango isiyotakiwa katika hatua ya kwanza, eleza mchakato wa mradi wako wa kuwasilisha na kukubali michango katika mwongozo wako wa kuchangia.

Ikiwa unapata michango mingi ya chini ya ubora, hitaji wachangiaji wafanye kazi kidogo kabla, kwa mfano:

* Kujaza kigezo cha suala au orodha ya ukaguzi
* Kufungua suala kabla ya kuwasilisha PR

Ikiwa hawafuati sheria zako, funga suala mara moja na uelekeze kwenye nyaraka zako.

Ingawa njia hii inaweza kuonekana kuwa si ya huruma mwanzoni, kuwa mchangamfu ni nzuri kwa pande zote. Inapunguza uwezekano wa mtu kuweka masaa mengi ya kazi kwenye PR ambalo hutakubali. Na inafanya kazi yako iwe rahisi kudhibiti.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  Kwa kawaida, eleza kwao na katika faili ya CONTRIBUTING.md jinsi wanavyoweza kupata dalili bora katika siku zijazo kuhusu kile ambacho kitakubaliwa na kisichokubaliwa kabla ya kuanza kazi.
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["Kufunga kwa Huruma Ombi la Kuvuta"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

Wakati mwingine, unaposema hapana, mchangiaji wako wa uwezekano unaweza kukasirika au kukosoa uamuzi wako. Ikiwa tabia yao inakuwa ya uhasama, [chukua hatua za kupunguza hali](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) au hata uwondoe kwenye jamii yako, ikiwa hawataki kushirikiana kwa njia ya kujenga.

### Kukumbatia ufundishaji

Huenda kuna mtu katika jamii yako anayewasilisha mara kwa mara michango ambayo haikidhi viwango vya mradi wako. Inaweza kuwa ngumu kwa pande zote mbili kupitia kukataliwa mara kwa mara.

Ikiwa unaona mtu ana shauku kuhusu mradi wako, lakini anahitaji kidogo ya kusafishwa, kuwa na subira. Eleza kwa uwazi katika kila hali kwa nini michango yao haikidhi matarajio ya mradi. Jaribu kuwaelekeza kwenye kazi rahisi au zisizo na utata, kama suala lililowekwa _"good first issue,"_ ili kuanzia kwa urahisi. Ikiwa una muda, fikiria kuwafundisha kupitia mchango wao wa kwanza, au pata mtu mwingine katika jamii yako ambaye anaweza kuwa tayari kuwafundisha.

## Tumia jamii yako

Huna haja ya kufanya kila kitu mwenyewe. Jamii ya mradi wako ipo kwa sababu! Hata kama bado huna jamii ya wachangiaji hai, ikiwa una watumiaji wengi, waweke kazini.

### Shiriki mzigo

Ikiwa unatafuta wengine kusaidia, anza kwa kuuliza.

Njia moja ya kupata wachangiaji wapya ni wazi [kuweka lebo kwenye masuala ambayo ni rahisi vya kutosha kwa waanzilishi kushughulikia](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub kisha itawasilisha masuala haya katika maeneo mbalimbali kwenye jukwaa, kuongeza mwonekano wao.

Unapowaona wachangiaji wapya wakifanya michango mara kwa mara, tambua kazi yao kwa kuwapea majukumu zaidi. Andika jinsi wengine wanaweza kukua katika nafasi za uongozi ikiwa wanataka.

Kuhamasisha wengine [kushiriki umiliki wa mradi](../building-community/#shiriki-umiliki-wa-mradi-wako) kunaweza kupunguza mzigo wako mwenyewe, kama @lmccart alivyogundua kwenye mradi wake, [p5.js](https://github.com/processing/p5.js).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  Nilikuwa nikisema, "Ndio, mtu yeyote anaweza kushiriki, huwezi kuwa na ujuzi mwingi wa kuandika msingo [...]." Tulikuwa na watu kujiandikisha kuja [katika tukio] na wakati huo nilikuwa nikijiuliza: je, hii ni kweli, kile nilichokuwa nikisema? Kulikuwa na watu 40 watakaokuja, na siwezi kukaa na kila mmoja wao...Lakini watu walikuja pamoja, na ilitimizika. Mara mtu mmoja alipokipata, angeweza kumfundisha jirani yake.
  <p markdown="1" class="pquote-credit">
— @lmccart, ["Je, "open source" Kinamaanisha Nini? Toleo la p5.js"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

Ikiwa unahitaji kuondoka kwenye mradi wako, ama kwa mapumziko au milele, hakuna aibu katika kuwaomba wengine wachukue nafasi yako.

Ikiwa watu wengine wana shauku kuhusu mwelekeo wake, wape ufikiaji wa kuandika au rasmi uhamasishe udhibiti kwa mtu mwingine. Ikiwa mtu ameunda mfano(fork) ya mradi wako na anasimamia kwa ufanisi mahali pengine, fikiria kuunganisha kwenye mfano huo kutoka kwenye mradi wako wa asili. Ni nzuri kwamba watu wengi wanataka mradi wako kuishi!

@progrium [alipata kwamba](https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/) kuandika maono ya mradi wake, [Dokku](https://github.com/dokku/dokku), kumesaidia malengo hayo kuishi hata baada ya yeye kuondoka kwenye mradi:

> Niliandika ukurasa wa wiki unaoelezea kile nilichotaka na kwa nini nilitaka. Kwa sababu fulani ilikuja kama mshangao kwangu kwamba watunzaji walianza kuhamasisha mradi katika mwelekeo huo! Je, ilitokea kwa njia ambayo ningefanya? Sio kila wakati. Lakini bado ilileta mradi karibu na kile nilichokiandika.

### Wacha wengine wajenge suluhu wanazohitaji

Ikiwa mchango wa uwezekano una maoni tofauti kuhusu kile mradi wako unapaswa kufanya, unaweza kutaka kwa adabu kuwahamasisha wafanye kazi kwenye fork yao wenyewe.

Kutengeneza mfano wa mradi ya fork hakuhitaji kuwa jambo baya. Kuweza kunakili na kubadilisha miradi ni moja ya mambo bora kuhusu open source. Kuwaelekeza wanajamii wako kufanya kazi kwenye fork yao wenyewe kunaweza kutoa njia ya ubunifu wanayohitaji, bila kuingiliana na maono ya mradi wako.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  Ninazingatia matumizi ya 80%. Ikiwa wewe ni mmoja wao, tafadhali fork kazi yangu. Sitakosea! Miradi yangu ya umma mara nyingi inakusudia kutatua matatizo ya kawaida; ninajaribu kufanya iwe rahisi kuingia kwa kufork kazi yangu au kuipanua.
  <p markdown="1" class="pquote-credit">
— @geerlingguy, ["Kwa Nini Nafunga PRs"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

Vile vile hutumika kwa mtumiaji ambaye anataka sana suluhu ambayo huna tu kipimo data cha kujenga. Kutoa API na ndoano za kubinafsisha kunaweza kusaidia wengine kukidhi mahitaji yao wenyewe, bila kulazimika kurekebisha chanzo moja kwa moja. @orta [aligundua kuwa](https://artsy.github.io/blog/2016/07/03/handling-big-projects/) programu jalizi za CocoaPods za zilisababisha "baadhi ya mawazo ya kuvutia zaidi":

> Ni vigumu kuepukika kwamba mradi unapokuwa mkubwa, watunzaji wanapaswa kuwa wahafidhina zaidi kuhusu jinsi wanavyoingiza msimbo mpya. Unakuwa mzuri katika kusema "hapana", lakini watu wengi wana mahitaji halali. Kwa hivyo, badala yake unaishia kubadilisha zana yako kuwa jukwaa.

## Lete roboti

Kama vile kuna kazi ambazo watu wengine wanaweza kukusaidia nazo, pia kuna kazi ambazo hakuna mwanadamu anayepaswa kufanya. Roboti ni rafiki yako. Zitumie kufanya maisha yako kama mtunzaji kuwa rahisi.

### Hitaji majaribio na ukaguzi mwingine ili kuboresha ubora wa msimbo yako

Mojawapo ya njia muhimu zaidi unaweza kufanya mradi wako otomatiki ni kwa kuongeza majaribio.

Majaribio huwasaidia wachangiaji kujiamini kuwa hawatavunja chochote. Pia hukurahisishia kukagua na kukubali michango haraka. Kadiri unavyokuwa msikivu zaidi, ndivyo jumuiya yako inavyoweza kuhusika zaidi.

Weka majaribio ya kiotomatiki ambayo yataendeshwa kwa michango yote inayoingia, na uhakikishe kuwa majaribio yako yanaweza kufanyiwa "locally" na wachangiaji kwa urahisi. Inahitaji kwamba michango yote ya misimbo ipite majaribio yako kabla ya kuwasilishwa. Utasaidia kuweka kiwango cha chini kabisa cha ubora kwa mawasilisho yote. [Ukaguzi wa hali unaohitajika](https://help.github.com/articles/about-required-status-checks/) kwenye GitHub inaweza kusaidia kuhakikisha hakuna mabadiliko yanayounganishwa bila majaribio yako kupita.

Ukiongeza majaribio, hakikisha umeeleza jinsi yanavyofanya kazi katika faili yako ya KUCHANGIA.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  Ninaamini kuwa majaribio ni muhimu kwa msimbo zote ambazo watu hufanya kazi. Ikiwa msimbo ulikuwa sahihi kabisa, hautahitaji mabadiliko - tunaandika tu msimbo wakati kuna kitu kibaya, iwe "Inaacha kufanya kazi" au "Haina kipengele fulani-na-vile". Na bila kujali mabadiliko unayofanya, majaribio ni muhimu ili kupata matatizo zozote ambazo unaweza kuanzisha kimakosa.
  <p markdown="1" class="pquote-credit">
— @edunham, ["Rust's Community Automation"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### Tumia zana kurekebisha kazi za kimsingi za urekebishaji kiotomatiki

Habari njema kuhusu kudumisha mradi maarufu ni kwamba watunzaji wengine pengine wamekabiliana na masuala sawa na kuwajengea suluhisho.

Kuna [aina mbalimbali za zana zinazopatikana](https://github.com/showcases/tools-for-open-source) kusaidia kuweka kiotomatiki baadhi ya vipengele vya kazi ya ukarabati. Mifano michache:

* [semantic-release](https://github.com/semantic-release/semantic-release) huweka matoleo yako kiotomatiki
* [mention-bot](https://github.com/facebook/mention-bot) inataja wakaguzi wanaowezekana kwa maombi ya kuvuta
* [Danger](https://github.com/danger/danger) husaidia kufanya ukaguzi wa nambari otomatiki
* [no-response](https://github.com/probot/no-response) hufunga masuala ambapo mwandishi hajajibu ombi la maelezo zaidi
* [dependabot](https://github.com/dependabot) hukagua faili zako za utegemezi kila siku kwa mahitaji ya zamani na hufungua maombi ya mtu binafsi ya kuvuta yoyote inayopata

Kwa ripoti za hitilafu na michango mingine ya kawaida, GitHub ina [Violezo vya Tatizo na Violezo vya Ombi la Kuvuta](https://github.com/blog/2111-issue-and-pull-request-templates), ambayo unaweza kuunda ili kurahisisha mawasiliano. unapokea. @TalAter alitengeneza [Chagua Mwongozo Wako Mwenyewe wa Vituko](https://www.talater.com/open-source-templates/#/) ili kukusaidia kuandika suala lako na violezo vya PR.

Ili kudhibiti arifa zako za barua pepe, unaweza kusanidi [vichujio vya barua pepe](https://github.com/blog/2203-email-updates-about-your-own-activity) ili kupanga kwa kipaumbele.

Ikiwa ungependa kupata ujuzi wa hali ya juu zaidi, miongozo ya mitindo na linters zinaweza kusawazisha michango ya mradi na kuifanya iwe rahisi kukagua na kukubali.

Walakini, ikiwa viwango vyako ni ngumu sana, vinaweza kuongeza vizuizi vya kuchangia. Hakikisha kuwa unaongeza tu sheria za kutosha ili kurahisisha maisha ya kila mtu.

Ikiwa huna uhakika ni zana zipi za kutumia, angalia miradi mingine maarufu hufanya nini, hasa ile iliyo katika mfumo wako wa ikolojia. Kwa mfano, mchakato wa mchango unaonekanaje kwa moduli zingine za Node? Kutumia zana na mbinu zinazofanana pia kutafanya mchakato wako ujulikane zaidi na wachangiaji unaolengwa.

## Ni sawa kupiga pause

Kazi ya open source kwa wakati mmoja ilikuletea furaha. Labda sasa inaanza kukufanya ujisikie kuwa mtu wa kukwepa au mwenye hatia.

Labda unahisi kuzidiwa au hisia inayokua ya hofu unapofikiria juu ya miradi yako. Na wakati huo, maswala na maombi ya kuvuta hukusanyika.

Uchovu wa mwili ni suala la kweli na linaloenea katika kazi ya open source, haswa miongoni mwa watunzaji. Kama mtunzaji, furaha yako ni hitaji lisiloweza kujadiliwa ili kuendelea kuwepo kwa mradi wowote wa open source.

Ingawa inapaswa kwenda bila kusema, pumzika! Hupaswi kusubiri hadi uhisi upweke zaidi ili kuchukua likizo. @brettcannon, msanidi programu mkuu wa Python, aliamua kuchukua [likizo ya mwezi mzima](https://snarky.ca/why-i-took-october-off-from-oss-volunteering/) baada ya miaka 14 ya OSS ya kujitolea kazi.

Kama tu aina nyingine yoyote ya kazi, kuchukua mapumziko ya kawaida kutakufanya upate kuburudishwa, kufurahi, na kuchangamkia kazi yako.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  Katika kudumisha WP-CLI, nimegundua ninahitaji kujifurahisha kwanza, na kuweka mipaka wazi juu ya ushiriki wangu. Salio bora ambalo nimepata ni saa 2-5 kwa wiki, kama sehemu ya ratiba yangu ya kawaida ya kazi. Hii inaweka ushiriki wangu kuwa wa shauku, na kutoka kwa kuhisi kama kazi sana. Kwa sababu ninatanguliza masuala ninayoshughulikia, ninaweza kufanya maendeleo ya mara kwa mara kuhusu kile ninachofikiri ni muhimu zaidi.
  <p markdown="1" class="pquote-credit">
— @danielbachhuber, ["Rambirambi zangu, sasa wewe ni mtunzaji wa mradi maarufu wa programu huria"](https://web.archive.org/web/20220306014037/https://danielbachhuber.com/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

Wakati mwingine, inaweza kuwa vigumu kuchukua pumziko kutoka kwa kazi huria wakati inahisi kama kila mtu anakuhitaji. Watu wanaweza hata kujaribu kukufanya uhisi hatia kwa kuondoka.

Jitahidi kupata usaidizi kwa watumiaji na jumuiya yako ukiwa mbali na mradi. Ikiwa huwezi kupata usaidizi unaohitaji, pumzika hata hivyo. Hakikisha kuwasiliana wakati haupatikani, ili watu wasichanganyikiwe na ukosefu wako wa mwitikio.

Kuchukua mapumziko kunatumika kwa zaidi ya likizo tu, pia. Ikiwa hutaki kufanya kazi huria wikendi au saa za kazi, wasiliana na wengine kuhusu matarajio hayo, ili wajue wasikusumbue.

## Jitunze wewe kwanza!

Kudumisha mradi maarufu kunahitaji ujuzi tofauti kuliko hatua za awali za ukuaji, lakini hakuna manufaa kidogo. Kama mtunzaji, utafanya mazoezi ya uongozi na ujuzi wa kibinafsi katika kiwango ambacho watu wachache watapata uzoefu. Ingawa si rahisi kudhibiti kila wakati, kuweka mipaka iliyo wazi na kuchukua tu yale ambayo unastarehekea kutakusaidia kubaki na furaha, kuburudishwa na kufanikiwa.
