---
lang: ru
title: Запуск опенсорс-проекта
description: Узнайте подробнее о мире опенсорса и подготовьте к запуску собственный проект.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## Опенсорс — что это и зачем?

Итак, вы думаете о запуске своего опенсорс-проекта? Поздравляем! Мир ценит ваше участие. Давайте поговорим о том, что такое опенсорс и почему люди им занимаются.

### Что означает "опенсорс"?

Опенсорс-проект означает, что **кто-угодно может свободного его использовать, изучать, изменять и распространять независимо от цели.** Эти разрешения даются через [опенсорс-лицензию](https://opensource.org/licenses).

Преимущество опенсорса в том, что он снижает барьеры для выбора и сотрудничества, позволяя людям быстро распространять и улучшать проекты. Кроме того, по сравнению с закрытым кодом, он дает пользователям возможность контролировать код. Компания, использующая программное обеспечение (ПО) с открытым исходным кодом, может нанять кого-то для доработки этого ПО, а не полагаться исключительно на решение поставщика с закрытым кодом.

_Свободное ПО_ относится к тем же проектам, что и _опенсорс_. Иногда вы можете встретить комбинации этих [терминов](https://en.wikipedia.org/wiki/Free_and_open-source_software): "Свободное и открытое ПО" (free and open source software FOSS или free, libre, and open source software FLOSS). Слова free и libre здесь означают "свободное", а не ["бесплатное"](#опенсорс--значит-бесплатно).

### Почему люди делают свою работу открытой?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  Одним из самых приятных впечатлений, которое я получил от работы над опенсорсом — это отношения, установившиеся с другими разработчиками, столкнувшимися с такими же проблемами как и я. 
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["Как мне было здорово войти в Open Source"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[Есть много причин](https://ben.balter.com/2015/11/23/why-open-source/) почему человек или организация открывают исходники своего проекта. Вот некоторые из них:

* **Сотрудничество:** В опенсорс-проект может внести изменения любой человек, где бы он ни находился. Например, платформа для упражнений по программированию [Exercism](https://github.com/exercism/) насчитывает 350 контрибьюторов.

* **Адаптация и доработки:** Опенсорс-проекты могут использоваться кем угодно практически для любой цели. Люди могут использовать ваш проект для создания чего-то нового. [WordPress](https://github.com/WordPress), например, стартовал как форк (ответвление) уже существовавшего проекта [b2](https://github.com/WordPress/book/blob/master/Content/Part%201/2-b2-cafelog.md).

* **Прозрачность:** Любой может проверить опенсорс-проект на наличие ошибок и несоответствий. Прозрачность важна даже на государственном уровне. Например, правительство [Болгарии](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) и [США](https://www.cio.gov/2016/08/11/peoples-code.html) законодательно предписали прозрачность для таких отраслей как банковское дело, здравоохранение, и программ безопасности, вроде [Let's Encrypt](https://github.com/letsencrypt).

Опенсорсом может быть не только ПО, но и многое другое: от наборов данных до книг. В разделе [GitHub Explore](https://github.com/explore) можно ознакомится с идеями проектов, которые можно заопенсорсить.

### Опенсорс — значит бесплатно?

Бесплатность опенсорс — это одно из самых больших преимуществ, которое скорее является побочным продуктом его совокупной ценности.

Поскольку [опенсорс-лицензия предполагает](https://opensource.org/osd-annotated), что кто угодно может использовать, модифицировать, и распространять ваш проект почти для любых целей, то в большинстве случаев это означает бесплатность. Потому что, если бы проект стоит денег, то любой мог абсолютно легально скопировать его и тем самым использовать его бесплатно.

Поэтому большинство опенсорс-проектов бесплатны, хотя это свойство не входит в определение само опенсорса. Есть способы оплаты взимания оплаты за пользование опенсорс-проектов косвенным образом через двойное лицензирование или ограничение функциональности, при этом такие проекты по-прежнему будут соответствовать официальному определению опенсорса.

## Стоит ли мне запускать свой опенсорс-проект?

Краткий ответ — да, потому что независимо от результата, запуск собстенного проекта — это отличный способ узнать, как работает опенсорс.

Если вы никогда ранее не запускали подобных проектов, вы можете переживать по поводу того, что скажут люди, и заметит ли кто-нибудь его вообще. Если вам знакомо это ощущение, не беспокойтесь, вы не один такой!

Опенсорс похож на любую другую творческую работу, будь то писательство или рисование. Может быть страшно показывать свою работу всему миру. Но как известно, практика — это путь к совершенству, даже если у вас пока нет своей аудитории.

Если вы ещё не решились, найдите время подумать о ваших возможных целях.

### Постановка целей

Цели помогут вам определиться, над чем работать, от чего отказаться, и где вам понадобится помощь со стороны. Спросите себя: _"зачем мне нужен этот опенсорс-проект?"_.

Единого ответа на этот вопрос не существует. Может быть сразу несколько целей на один проект, или разные проекты с разными целями.

Если ваша единственная цель — показать свою работу, скорее всего вы не нуждаетесь в сторонней помощи, о чём стоит явно можно указать в файле README. С другой стороны, если вы заинтересованы в помощниках, то следует потратить время на написание понятной документации и проявить заботу о новичках.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  Однажды я сделал кастомный UIAlertView для своих нужд... и решил выложить его в опенсорс. Я сделал его более динамическим и опубликовал на GitHub. Я также написал свою первую документацию, объясняющую другим разработчикам, как они могут использовать мою работу в своих проектах. Возможно, ей так никто и не воспользовался из-за её простоты. Но зато получил удовольствие от всего этого процесса. 
  <p markdown="1" class="pquote-credit">
— @mavris, ["Программисты-самоучки: почему опенсорс важен для нас"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

По мере роста проекта ваше сообщество будет нуждаться не только в коде. Ответы в ишью, проверка кода и реклама собственного проекта — всё это важные задачи любого опенсорс-проекта.

Хотя количество времени на непрограммистские задачи зависит от размера и масштаба вашего проекта, вы должны быть готовы решать их сами или найти для этого помощника.

**Если вы работаете в компании, запускающей опенсорс-проект,**, убедитесь заранее, у вас есть внутренние ресурсы для его развития. Вам нужно определить, кто будет отвечать за поддержку проекта после его запуска, и как будете распределять задачи внутри сообщества.

Если вам нужен выделенный бюджет или люди для продвижения, работы и поддержки проекта, обговорите это как можно раньше.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  Когда вы начинаете опенсорс-проект, важно, чтобы процессы управления в организации учитывали вклад и возможности сообщества, образовавшегося вокруг проекта. Не бойтесь вовлекать посторонних людей в работе над основными аспектами проекта, особенно если они активно участвуют. 
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["Хочешь открыть код проекта, не так ли?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Участие в чужих проектах

Если ваша цель — понять как взаимодействовать с другими и как работает опенсорс, рассмотрите возможность участия в уже существующем проекте, который вы используете и любите. Вашим участием может быть что-то простое, вроде исправление опечаток и обновление документации.

Если вы не понимаете, как войти в чужой проект, ознакомьтесь с нашим руководством [Как участвовать в опенсорс-проекте](../how-to-contribute/).

## Запуск собственного опенсорс-проекта

Нет идеального момента, когда нужно открывать исходники своей работы. Вы можете открыть их на стадии идеи, в процессе работы или после нескольких лет закрытости.

В общем случае, открывать исходники можно, когда вы чувствуете себя уверенно настолько, что посторонние люди будут смотреть вашу работу и высказываться о ней.

В каждом проекте вне зависимости от стадии, на которой вы решили открыть исходники, должна быть следующая документация:

* [Опенсорс-лицензию](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Руководство для участников](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [Нормы поведения](../code-of-conduct/)

Эти файлы помогут вам донести ожидания, определить процесс по участию, и защитить законные права всех, включая вас самих. Всё это значительно увеличивает шансы, что всё пойдёт хорошо.

Если ваш проект на GitHub и вы разместите эти файлы в корневой категории с рекомендованными названиями, GitHub распознает их и автоматически отобразит посетителям репозитория.

### Выбор лицензии

Лицензия для открытого исходного кода гарантирует, что другие могут использовать, копировать, изменять и вносить правки в ваш проект без каких-либо последствий. Она также защищает вас от неприятных юридических ситуаций. **Вы должны добавить лицензию при запуске опенсорс-проекта.**

Юридическая работа — не из легких. Но есть хорошие новости: вы можете скопировать существующую лицензию и разместить её в своём репозитории, за одну минуту защитив ваш тяжелый труд.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), и [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) — это самые популярные лицензии, но [есть и другие варианты](https://choosealicense.com).

Когда вы создаёте новый проект на GitHub, вам дается на выбор несколько лицензий. Выбрав опенсорс-лицензию, вы сделаете свой проект открытым.

![Выберете лицензию](/assets/images/starting-a-project/repository-license-picker.png)

Если у вас есть другие вопросы или беспокойства относительно юридических аспектов опенсорса, [мы описали их здесь](../legal/).

### Написание README

Файл README ("прочитай меня") не только рассказывает, как использовать ваш проект, но и объясняет, почему он важен, и что пользователи могут с ним делать.

Постарайтесь ответить в README на следующие вопросы:

* Что делает этот проект?
* Чем этот проект полезен?
* Как начать работать с ним?
* Где получить помощь, если понадобится?

Также можно в README можно дать ответы на другие вопросы, например, как поучаствовать в проекте, каковы его цели, а также рассказать о лицензии и авторстве. Если вы не планируете принимать помощь от других людей, или он ещё не готов для запуска — так и напишите об этом.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  Хорошая документация — это больше пользователей, меньше просьб о помощи, и больше контрибьюторов. (...) Помните, что ваши пользователи — это не вы. Это могут быть люди с опытом, совершенно отличающийся от вашего. 
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Писать так, чтобы ваши слова читали (видео)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Иногда люди откладывают написание README, потому что чувствуют, что проект не завершен, или не хотят, чтобы другие в нём участвовали. Но это как раз хороший повод написать об этом.

Для вдохновения, можете ознакомиться с [руководством "Сделай README"](https://www.makeareadme.com/) от @dguo или взять на вооружение [Шаблон README](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) от @PurpleBooth.

Если вы добавите файл README в корневую директорию проекта, GitHub автоматически заметит его и покажет на главной странице репозитория.

### Написание руководства для участников

Файл CONTRIBUTING говорит вашей аудитории, как стать участником вашего проекта. Например:

* Как сообщить об ошибке (попробуйте использовать [шаблоны для ишью и пул-реквестов](https://github.com/blog/2111-issue-and-pull-request-templates))
* Как предложить реализацию новой функциональности
* Как настроить среду выполнения и запустить тесты

Помимо технических деталей, в файле CONTRIBUTING только приветствуется изложить свои ожидания относительно участия других людей. Например:

* Какого рода участие вы ждёте?
* Ваши планы и видение развития проекта
* Как участники могут (и не могут) связываться с вами

Ваш тёплый дружеский тон и конкретные предложения по участию, вроде написания документации или создания сайта, могут иметь большое значение для привлечения новичков к работе над проектом.

Например, [Active Admin](https://github.com/activeadmin/activeadmin/) начинает [своё руководство по участию](https://github.com/activeadmin/activeadmin/blob/master/CONTRIBUTING.md) с таких слов:

> В первую очередь хотим выразить вам благодарность за то, что подумываете об участии в развитии Active Admin. Именно такие люди как вы делают Active Admin прекрасным инструментом.

На ранних стадиях проекта ваш файл CONTRIBUTING может быть простым. Вы всегда следует объяснить, как сообщать о багах и оформлять ишью, а также описать технические требования к контрибьюторам (например, написание тестов).

Со временем вы можете дополнить его ответами на часто задаваемые вопросы. Благодаря этому меньше людей будут спрашивать вас об одном и том же снова и снова.

Чтобы вам было проще написать файл CONTRIBUTING, ознакомьтесь с [шаблоном руководства по сотрудничеству](https://github.com/nayafia/contributing-template/blob/master/CONTRIBUTING-template.md) от @nayafia или прочтите ["Как создать файл CONTRIBUTING.md"](https://mozillascience.github.io/working-open-workshop/contributing/) от @mozilla.

Поставьте ссылку на файл CONTRIBUTING внутри README, так больше людей увидят его. Если вы [разместите файл CONTRIBUTING.md в корне вашего проекта](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), то GitHub автоматически предложит ознакомиться с ним когда кто-то открывает ишью или отправляет пул-реквест.

![Руководство по сотрудничеству](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Разработка норм поведения

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  Все мы сталкивались с неприятными ситуациями, когда хозяин проекта грубо объяснял что-то или пользователи задавали элементарные вопросы. (...) Норм поведения становится документом, на который легко ссылаться, и который говорит, что ваша команда очень серьезно относится к конструктивному диалогу. 
  <p markdown="1" class="pquote-credit">
— @mlynch, [Делаем опенсорс намного лучше](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

В итоге, нормы поведения определяют базовые правила поведения участников вашего проекта. Это особенно важно, если вы запускаете проект для компании или сообщества. Нормы поведения способствует установлению здорового, конструктивного поведения в сообществе, снижая стресс для вас, как для мейнтейнера проекта.

Подробнее смотрите на странице [Руководство по нормам поведения](../code-of-conduct/).

Помимо описания _каким_ вы хотите видеть поведение участников, нормы поведения также разъясняют, к кому и когда они применяется, и что будет в случае их нарушения.

По аналогии с лицензией, вам не обязательно писать нормы самим, а можно скопировать один из существующих вариантов. [Contributor Covenant](https://contributor-covenant.org/) используется в [более 40.000 опенсорс-проектах](https://www.contributor-covenant.org/adopters), включая Kubernetes, Rails, и Swift. Какие бы нормы вы не выбрали, будьте готовы применить их при необходимости.

Вставьте текст в файл CODE_OF_CONDUCT.md в корне проекта, так его будет проще находить и ссылаться на него, например, из README.

## Название и брендирование вашего проекта

Брендинг — это не только броский логотип и запоминающееся название, но и то, как вы говорите о своём проекте и кому хотите обратиться с ним.

### Выбор правильного названия

Придумайте название, которое легко запоминается и, в идеале, даёт представление о сути проекта. Например:

* [Sentry](https://github.com/getsentry/sentry) (с англ. — караул) — сервис для мониторинга приложения
* [Thin](https://github.com/macournoyer/thin) (с англ. — худой) — быстрый и простой веб-сервер на Ruby

Если вы создаете что-то, опираясь на уже существующий проект, то добавьте его название в виде префикса к своему проекту, — это даст больше деталей о нём. Например [node-fetch](https://github.com/bitinn/node-fetch) реализует `window.fetch` в Node.js.

Выбирайте понятное название проекта прежде всего. Каламбуры могут быть забавными, но подумайте о людях из других культур или опытом, которые могут не понять шутку. Ваши потенциальные пользователи могут быть работниками компаний, которые будут рассказывать о проекте на работе. Не заставляйте их краснеть при этом!

### Конфликт имён

[Проверьте наличие опенсорс-проектов с таким же названием](http://ivantomic.com/projects/ospnc/), особенно если вы используете один и тот же язык или экосистему. Если ваше название совпадёт с популярным существующим проектом, вы можете запутать свою аудиторию.

Если вы планируете завести сайт, твиттер или любую площадку для публикаций, убедитесь, что нужное вам название там свободно. Лучше всего [зарегистрируйте все аккаунты сейчас](https://instantdomainsearch.com/), хотя просто для душевного спокойствия, даже если пока не планируете ими пользоваться.

Убедитесь, что вы не посягаете на торговую марку какой-нибудь компании. В будущем она сможет попросить вас закрыть проект или даже подать в суд на вас. Это неоправданный риск.

Проверьте имя во [всемирной базе брендов WIPO](http://www.wipo.int/branddb/en/), чтобы избежать конфликта по поводу авторских прав. Если вы делаете проект от лица компании, то [юридический отдел может помочь вам с этим](../legal/).

Напоследок, выполнит быстрый поиск в Google по названию вашего проекта. Смогут ли люди по нему легко найти ваш проект? А может быть, по этому запросу появляется что-то нежелательное?

### То, как вы пишите (и кодите) тоже влияет на ваш бренд!

За всю жизнь проекта вы будете много писать: README, руководства, документы сообщества, ответы на вопросы, возможно даже информационные бюллетени и списки рассылки.

Будь то официальная документация или обычное сообщение, стиль письма также является частью бренда проекта. Подумайте о том, в каком свете вы выглядите перед аудиторией, и правильный ли подобрали тон.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Я старался участвовать в каждой теме в списке рассылки и показывать образцовое поведение, быть доброжелательным к людям, серьезно относиться к их проблемам и быть полезным в общем. Через некоторое время люди стали не только задавать вопросы, но и помогать с ответами, и, к моему полному восторгу, они подражали моему стилю.
  <p markdown="1" class="pquote-credit">
— @janl в [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Добрый и вежливый тон создаст приятную атмосферу для новых участников. Следите так же за простотой изложения, так как для многих читателей английский может быть не родным.

Не только слова, что вы пишете, но и стиль кода может стать частью бренда вашего проекта. [Angular](https://angular.io/guide/styleguide) и [jQuery](https://contribute.jquery.org/style-guide/js/) — только два примера проектов со строгими стилями написания кода и рекомендациями.

Нет необходимости составлять руководство по стилю, когда вы только начинаете, возможно вам понравится совмещать в своём проекте разные стили. Но стоит заранее предвидеть, что стиль написания и кода может как привлекать, так и отталкивать людей. На ранних стадиях проекта формируется то, каким в дальнейшем станет ваш проект, и зависит от вас, каким вы хотите его видеть.

## Чеклист перед запуском

Вы готовы открыть свой проект? Вот вам проверочный лист в помощь. Когда отметите все пункты, [откройте ваш проект](https://help.github.com/articles/making-a-private-repository-public/) и похвалите себя.

**Документация**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    В проекте есть файл LICENSE с опенсорс-лицензией 
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    В проекте есть базовая документация (README, CONTRIBUTING, CODE_OF_CONDUCT)
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    Название легко запоминается, даёт представление о сути проекта, не конфликтует с существующими проектами и не посягает на торговые марки. 
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Список ишью актуальный, хорошо организован и помечен ярлыками
  </label>
</div>

**Код**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
  В проекте установлены определённые стили оформления кода и функции/методы/переменны имеют понятные названия
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
  Код хорошо прокомментирован, документируются замыслы и особые случаи. 
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
  В истории коммитов, ишью, пул-реквестах не хранится конфиденциальные данные вроде паролей или другой непубличной информации.
  </label>
</div>

**Люди**

Если вы частное лицо:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  Вы поговорили с юридическим отделом и/или поняли правила интеллектуальной собственности и политику в отношении опенсорса в вашей компании (если вы где-то трудоустроены)
  </label>
</div>

Если вы компания или организация:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
   Вы поговорили с юридическим отделом 
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    У вас есть маркетинговый план для запуска и продвижения проекта 
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
  Кто-то назначен ответственным за взаимодействие с сообществом (отвечать в ишью, проверять и принимать пул-реквесты)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Как минимум два человека имеют административный доступ к проекту
  </label>
</div>

## Вы сделали это!

Поздравляем с открытием исходников вашего первого проекта! Вне зависимости от результата, работа на виду у людей — это подарок для сообщества. Каждый коммит, комментарий и запрос на правку — это возможность учиться и расти для себя и других.
