---
lang: ru
title: Метрики проектов с открытым исходным кодом
description: Принимайте обоснованные решения, чтобы помочь вашему проекту с открытым исходным кодом процветать, измеряя и отслеживая его успех.
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## Зачем что-то измерять?

Данные, при разумном использовании, могут помочь вам принимать лучшие решения в качестве сопровождающего (maintainer) открытого исходного кода.

Имея больше информации, вы можете:

* Понять, как пользователи реагируют на новую функцию
* Выяснить, откуда приходят новые пользователи
* Определить и решить, стоит ли поддерживать новую функциональность
* Оценить популярность вашего проекта
* Понять, как используется ваш проект
* Привлечь инвестиции через спонсорство и гранты

Например, [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) обнаружил, что Google Analytics помогает ему определять приоритеты в работе:

> Homebrew предоставляется бесплатно и управляется исключительно добровольцами в свободное время. В результате у нас нет ресурсов для проведения детальных исследований пользователей Homebrew, чтобы решить, как лучше разработать будущие функции и определить приоритеты текущей работы. Анонимная совокупная аналитика пользователей позволяет нам определять приоритетность фиксов и фич на основе того, как, где и когда люди используют Homebrew.

Популярность — это еще не всё. Все приходят в окрытые проекты по разным причинам. Если ваша цель как сопровождающего открытый исходный код — продемонтсрировать свою работу, быть прозрачным в работе с кодом или просто развлечься, то метрики могут быть для вас не важны.

Если вы _заинтересованы_ в более глубоком понимании своего проекта, читайте дальше, чтобы узнать, как проанализировать деятельность вашего проекта.

## Обнаруживаемость

Прежде чем кто-то сможет воспользоваться вашим проектом или внести в него свой вклад, он должен узнать о его существовании. Спросите себя: _могут ли люди найти этот проект?_

![График трафика](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

Если ваш проект размещён на GitHub, [вы можете посмотреть](https://help.github.com/articles/about-repository-graphs/#traffic), сколько людей попадают в ваш проект и откуда они приходят. На странице вашего проекта нажмите **Insights**, затем **Traffic**. На этой странице вы можете увидеть:

* **Общее количество просмотров страниц:** показывает, сколько раз был просмотрен ваш проект.

* **Общее количество уникальных посетителей:** показывает, сколько человек просмотрело ваш проект.

* **Сайты-источники:** рассказывает о том, откуда пришли посетители. Эта метрика может помочь вам определить, где можно привлечь аудиторию и работают ли ваши усилия по продвижению.

* **Популярный контент:** рассказывает о том, куда заходят посетители вашего проекта, в разбивке по просмотрам страниц и уникальным посетителям.

[GitHub stars](https://help.github.com/articles/about-stars/) также может помочь определить базовый показатель популярности. Хотя звезды GitHub не обязательно коррелируют с загрузками и использованием, они могут сказать вам, сколько людей обращают внимание на вашу работу.

Вы также можете захотеть [отслеживать открываемость в определенных местах](https://opensource.com/business/16/6/pirate-metrics): например, Google PageRank, реферальный трафик с сайта вашего проекта или рефералы с других проектов с открытым исходным кодом или сайтов.

## Использование

Люди находят ваш проект в этой дикой и безумной штуке, которую мы называем Интернетом. В идеале, когда они увидят ваш проект, у них возникнет желание что-то сделать. Второй вопрос, который вы хотите задать, это: _используют ли люди этот проект?_

Если вы используете менеджер пакетов, такой как npm или RubyGems.org, для распространения вашего проекта, вы можете отслеживать скачивания пакета.

Каждый пакетный менеджер может использовать несколько иное определение "скачивания", и скачивания не обязательно коррелируют с установками или использованием, но это даёт некоторую базу для сравнения. Попробуйте использовать [Libraries.io](https://libraries.io/) для отслеживания статистики использования многих популярных менеджеров пакетов.

Если ваш проект находится на GitHub, снова перейдите на страницу **Traffic**. Вы можете использовать [clone graph](https://github.com/blog/1873-clone-graphs), чтобы увидеть, сколько раз ваш проект был клонирован в определенный день, с разбивкой по общему количеству клонирований и уникальным клонирователям.

![График git clone](/assets/images/metrics/clone_graph.png)

Если использование низкое по сравнению с количеством людей, которые находят ваш проект, есть два аспекта, которые следует рассмотреть. Либо:

* Ваш проект плохо конвертирует вашу аудиторию, либо
* Вы привлекаете не ту аудиторию

Например, если ваш проект попадет на первую страницу Hacker News, вы, вероятно, увидите всплеск посещений (трафика), но более низкий коэффициент конверсии, поскольку вы охватите всех пользователей Hacker News. Однако если ваш Ruby-проект будет представлен на конференции Ruby, вы, скорее всего, получите высокий коэффициент конверсии от целевой аудитории.

Попытайтесь понять, откуда приходит ваша аудитория, и попросите других людей оставить отзыв на странице вашего проекта, чтобы выяснить, с какой из этих двух проблем вы столкнулись.

Как только вы узнаете, что люди используют ваш проект, вы можете попытаться выяснить, что они с ним делают. Создают ответвления (fork) вашего кода и добавляют функции? Используют для науки или бизнеса?

## Удержание

Люди находят ваш проект и используют его. Следующий вопрос, который вы захотите задать себе: _участвуют (contribute) ли люди в этом проекте?_

Никогда не рано начинать думать об участниках (contributors). Без участия других людей вы рискуете оказаться в нездоровой ситуации, когда ваш проект _популярен_ (многие используют его), но не _поддерживается_ (не хватает времени сопровождающих (maintainers) для удовлетворения спроса).

Для удержания также необходим [приток новых участников](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2), так как ранее активные участники со временем переходят на другие виды деятельности.

Вот ещё показатели для отслеживания:

* **Общее количество участников и количество правок (commit) на одного участника:** позволяет узнать, сколько у вас участников и кто из них более или менее активен. На GitHub это можно посмотреть в разделе **Insights** -> **Contributors**. В настоящее время этот график учитывает только тех участников, которые сделали правку (commit) в ветку репозитория по умолчанию.

![График участников](/assets/images/metrics/repo_contributors_specific_graph.png)

* **Первоначальные, случайные и повторные участники:** помогает вам отслеживать, привлекаете ли вы новых участников и возвращаются ли они. (Случайные участники - те, у кого мало правок (commit). Будет ли это одна правка, менее пяти или что-то другое - решать вам). Без новых участников сообщество вашего проекта может стать застойным.

* **Количество текущих открытых проблем (issue) и запросов на перенос (pull request):** если эти показатели слишком высоки, вам может понадобиться помощь в устранении проблем и проверке кода.

* **Общее количество проблем (issues) и запросов на перенос (pull request) (включая закрытые):** открытые когда-то проблемы (issues) означают, что ваш проект кому-то достаточно интересен, чтобы он открыл проблему (issue). Если это число увеличивается со временем, это говорит о том, что люди заинтересованы в вашем проекте.

* **Типы вклада (contribution):** например, правки (commit), исправление опечаток или ошибок, или комментирование проблемы (issue).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  Открытый исходный код — это больше, чем просто код. Успешные проекты с открытым исходным кодом включают написание кода и документации вместе с обсуждением этих изменений.
  <p markdown="1" class="pquote-credit">— @arfon, ["Как выглядит Open Source"](https://github.com/blog/2195-the-shape-of-open-source)</p>
</aside>

## Активность сопровождающих

Наконец, вы захотите замкнуть цикл, убедившись, что участники вашего проекта в состоянии справиться с объёмом получаемых вкладов (contributions). Последний вопрос, который вы хотите задать себе, это: _отвечаю ли я (или мы) на запросы нашего сообщества?_

Неотзывчивые сопровождающие становятся узким местом для проектов с открытм кодом. Если кто-то вносит свой вклад, но так и не получает ответа от сопровождающего, он может разочароваться и уйти.

[Исследование компании Mozilla](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) предполагает, что отзывчивость сопровождающих является критическим фактором поощрения повторного участия.

Отслеживайте, сколько времени требуется вам (или другому сопровождающему), чтобы ответить на вклад, будь то проблема (issue) или запрос на перенос (pull request). Для ответа не обязательно предпринимать какие-либо действия. Можно просто сказать: _"Спасибо за ваш вклад! Я рассмотрю его в течение следующей недели."_

Можно также измерять время, необходимое для перехода от одного этапа процесса внесения вклада к другому, например:

* Среднее время, в течение которого проблема (issue) остаётся открытой
* Закрываются ли проблемы (issue) в запросе на перенос (pull request)
* Закрываются ли неактуальные проблемы (issue)
* Среднее время для слияния запроса на перенос (pull request)

## Используйте 📊, чтобы узнать о людях

Понимание метрик поможет вам построить активный, растущий проект с открытым исходным кодом. Даже если вы не отслеживаете каждую метрику на панели инструментов, используйте описанный выше алгоритм действий, чтобы сосредоточить свое внимание на том типе поведения, который поможет вашему проекту процветать.

[CHAOSS](https://chaoss.community/) — это гостеприимное сообщество с открытым исходным кодом, ориентированное на аналитику, показатели и программное обеспечение для здоровья сообщества.
