---
lang: ru
title: Юридические аспекты открытого программного кода
description: Все, что вас когда-либо интересовало о правовой стороне открытого исходного кода, и кое-что, чего вы не знали.
class: legal
order: 10
image: /assets/images/cards/legal.png
related:
  - contribute
  - leadership
---

## Понимание юридических последствий открытого исходного кода

Поделиться своим творчеством со всем миром может быть захватывающим и полезным опытом. Это также может означать множество юридических аспектов, о которых вы даже не подозревали. К счастью, вам не нужно начинать с нуля. Мы позаботились о ваших юридических потребностях. (Прежде чем углубляться, обязательно прочтите наш [отказ от ответственности](/notices/).)

## Почему людей так волнует правовая сторона открытого кода?

Рады, что вы спросили! Когда вы выполняете творческую работу (например, текст, графику или код), эта работа по умолчанию находится под исключительным авторским правом. То есть закон предполагает, что как автор своей работы вы имеете право голоса в отношении того, что другие могут с ней делать.

В общем, это означает, что никто другой не может использовать, копировать, распространять или изменять вашу работу, не подвергаясь риску разбирательства, изъятия или судебного разбирательства.

Однако открытый исходный код — это необычная ситуация, поскольку автор ожидает, что другие будут использовать, изменять и делиться работой. Но поскольку юридически законным по умолчанию по-прежнему остется исключительное авторское право, вам нужна лицензия, в которой явно указаны эти разрешения.

Если вы не примените лицензию для открытого исходного кода, каждый, кто вносит свой вклад в ваш проект, также становится эксклюзивным правообладателем своей работы. Это означает, что никто не может использовать, копировать, распространять или изменять их материалы — и этот «никто» включает вас.

Наконец, ваш проект может иметь зависимости от лицензионных требований, о которых вы не знали. Сообщество вашего проекта или политика вашего работодателя также могут требовать от вашего проекта использования определенных лицензий открытого исходного кода. Мы рассмотрим эти ситуации ниже.

## Открыты ли общедоступные проекты GitHub?

Когда вы [создаете новый проект](https://help.github.com/articles/creating-a-new-repository/) на GitHub, у вас есть возможность сделать репозиторий **приватным** (частным) или **публичным** (общедоступным).

![Создать репозиторий](/assets/images/legal/repo-create-name.png)

**Сделать ваш проект GitHub публичным — это не то же самое, что лицензировать ваш проект**. На общедоступные проекты распространяются [Условия использования GitHub](https://help.github.com/en/github/site-policy/github-terms-of-service#3-owner-of-content-right-to-post-and-license-grants), которые позволяют другим просматривать и делать ответвление (fork) вашего проекта. Но в остальном ваша работа не имеет разрешений.

Если вы хотите, чтобы другие могли использовать, распространять, изменять или вносить свой вклад в ваш проект, вам необходимо включить лицензию открытого исходного кода. Например, кто-то не может законно использовать какую-либо часть вашего проекта GitHub в своем коде, даже если он общедоступен, если вы явно не дадите ему на это право.

## Просто дайте мне ЧтоБыТоНиБыло, что нужно для защиты моего проекта.

Вам повезло, потому что сегодня лицензии открытого исходного кода стандартизированы и просты в использовании. Вы можете скопировать и вставить существующую лицензию прямо в свой проект.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) и [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) — самые популярные лицензии открытого исходного кода, но на выбор есть и другие варианты. Вы можете найти полный текст этих лицензий и инструкции по их использованию на сайте [choosealicense.com](https://choosealicense.com/).

Когда вы создаете новый проект на GitHub, вас [попросят добавить лицензию](https://help.github.com/articles/open-source-licensing/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/benbalter?s=180" class="pquote-avatar" alt="avatar">
Стандартизированная лицензия важна для тех, кто не имеет юридического образования, чтобы точно знать, что они могут и не могут делать с программным обеспечением. Если нет крайней необходимости, избегайте самодеятельности, измененных или нестандартных условий, которые станут препятствием для последующего использования кода.
  <p markdown="1" class="pquote-credit">
— @benbalter, ["Все, что нужно знать государственному прокурору о лицензировании программного обеспечения с открытым исходным кодом"](https://ben.balter.com/2014/10/08/open-source-licensing-for-government-attorneys/)
  </p>
</aside>

## Какая лицензия открытого исходного кода подходит для моего проекта?

Если вы начинаете с чистого листа, трудно ошибиться с [лицензией MIT](https://choosealicense.com/licenses/mit/). Она короткая, очень простая для понимания и позволяет любому делать всё, что угодно, если у него есть копия лицензии и упоминание вашего авторского права. Вы сможете выпустить проект под другой лицензией, если понадобится.

В противном случае выбор правильной лицензии для открытого исходного кода вашего проекта зависит от ваших целей.

Ваш проект, скорее всего, имеет (или будет иметь) **зависимости**. Например, если вы откроете исходный код проекта Node.js, вы, вероятно, будете использовать библиотеки из Node Package Manager (npm). Каждая из этих библиотек, от которых вы зависите, будет иметь собственную лицензию открытого исходного кода. Если каждая из их лицензий является «разрешающей» (дает общедоступное разрешение на использование, изменение и совместное использование без каких-либо условий для последующего лицензирования), вы можете использовать любую лицензию, которую хотите. Общие разрешительные лицензии включают MIT, Apache 2.0, ISC и BSD.

С другой стороны, если какая-либо из лицензий ваших зависимостей является «строгим авторским левом» (strong copyleft) (также дает такие же общедоступные разрешения при условии использования той же лицензии в дальнейшем), тогда ваш проект должен будет использовать ту же лицензию. Общие лицензии со строгим авторским левом включают GPLv2, GPLv3 и AGPLv3.

Вы также можете рассмотреть **сообщества**, которые, как вы надеетесь, будут использовать и вносить свой вклад в ваш проект:

* **Вы хотите, чтобы ваш проект использовался в качестве зависимости другими проектами?** Вероятно, лучше всего использовать самую популярную лицензию в вашем соответствующем сообществе. Например, [MIT](https://choosealicense.com/licenses/mit/) — самая популярная лицензия для [библиотек npm](https://libraries.io/search?platforms=NPM).
* **Вы хотите, чтобы ваш проект понравился крупным предприятиям?** Крупному бизнесу, скорее всего, потребуется явная патентная лицензия от всех участников. В этом случае [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) поможет вам (и им).
* **Вы хотите, чтобы ваш проект привлек участников, которые не хотят, чтобы их вклад использовался в программном обеспечении с закрытым исходным кодом?** [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) или (если они также не хотят участвовать в службах с закрытым исходным кодом) [AGPLv3](https://choosealicense.com/licenses/agpl-3.0/) подойдет.

Ваша **компания** может иметь особые лицензионные требования для проектов с открытым исходным кодом. Например, может потребоваться разрешительная лицензия, чтобы компания могла использовать ваш проект в продукте компании с закрытым исходным кодом. Или ваша компания может потребовать строгую лицензию с авторским левом и дополнительное соглашение с участниками (см. ниже), чтобы только ваша компания и никто другой могли использовать ваш проект в программном обеспечении с закрытым исходным кодом. Или у вашей компании могут быть определенные потребности, связанные со стандартами, социальной ответственностью или прозрачностью, любая из которых может потребовать определенной стратегии лицензирования. Поговорите с [юридическим отделом вашей компании](#что-нужно-знать-юридическому-отделу-моей-компании).

Когда вы создаете новый проект на GitHub, вам предоставляется возможность выбрать лицензию. Включение одной из упомянутых выше лицензий сделает ваш проект на GitHub открытым. Если вы хотите увидеть другие варианты, посетите [choosealicense.com](https://choosealicense.com), чтобы найти подходящую лицензию для своего проекта, даже если это [не программное обеспечение](https://choosealicense.com/non-software/).

## Что, если я хочу изменить лицензию своего проекта?

Большинству проектов не потребуется менять лицензии. Но иногда обстоятельства меняются.

Например, по мере роста вашего проекта он добавляет зависимости или пользователей, или ваша компания меняет стратегии, для любой из которых может потребоваться другая лицензия. Кроме того, если вы пренебрегали лицензированием своего проекта с самого начала, добавление лицензии фактически аналогично изменению лицензий. При добавлении или изменении лицензии на проект необходимо учитывать три основных момента:

**Это сложно.** Определение совместимости и соответствия лицензий, а также обладателей авторских прав может очень быстро стать сложным и запутанным. Переход на новую, но совместимую лицензию для новых выпусков и дополнений отличается от перелицензирования всех существующих дополнений. Привлекайте свою команду юристов при первом намеке на желание сменить лицензию. Даже если у вас есть или вы можете получить разрешение от правообладателей вашего проекта на изменение лицензии, учитывайте влияние этого изменения на других пользователей и участников вашего проекта. Думайте о смене лицензии как об «управленческом событии» для вашего проекта, которое, скорее всего, пройдет гладко при четком общении и консультациях с заинтересованными сторонами вашего проекта. Еще одна причина выбрать и использовать соответствующую лицензию для вашего проекта с самого начала!

**Существующая лицензия вашего проекта.** Если существующая лицензия вашего проекта совместима с лицензией, на которую вы хотите перейти, вы можете просто начать использовать новую лицензию. Это потому, что если лицензия A совместима с лицензией B, вы будете соблюдать условия A, соблюдая условия B (но не обязательно наоборот). Поэтому, если вы в настоящее время используете разрешительную лицензию (например, MIT), вы можете перейти на лицензию с дополнительными условиями, при условии, что вы сохраняете копию лицензии MIT и любые связанные уведомления об авторских правах (т.е. продолжаете соблюдать минимальные условия лицензии MIT). Но если ваша текущая лицензия не разрешающая (например, авторское лево или у вас нет лицензии) и вы не являетесь единственным владельцем авторских прав, вы не можете просто изменить лицензию вашего проекта на MIT. По сути, с разрешающей лицензией правообладатели проекта заранее дали разрешение на изменение лицензий.

**Существующие правообладатели вашего проекта.** Если вы являетесь единственным участником своего проекта, то вы или ваша компания являетесь единственным правообладателем проекта. Вы можете добавить или изменить любую лицензию, которую захотите вы или ваша компания. В противном случае могут быть другие правообладатели, с которыми вам потребуется согласие для изменения лицензий. Кто они? Люди, у которых есть коммиты в вашем проекте, — хорошее место для начала. Но в некоторых случаях авторские права принадлежат работодателям этих людей. В некоторых случаях люди будут вносить только минимальный вклад, но не существует жесткого правила, согласно которому вклады с использованием определенного количества строк кода не подлежат авторскому праву. Что делать? Это зависит. Для относительно небольшого и молодого проекта может оказаться целесообразным убедить всех существующих участников согласиться на изменение лицензии в ишью или пул-реквесте. Для крупных и долгоживущих проектов вам, возможно, придется искать множество участников и даже их наследников. Mozilla потребовались годы (2001-2006), чтобы перелицензировать Firefox, Thunderbird и сопутствующее программное обеспечение.

В качестве альтернативы вы можете попросить участников заранее согласиться (посредством дополнительного соглашения с участниками - см. Ниже) на определенные изменения лицензии при определенных условиях, помимо тех, которые разрешены вашей существующей лицензией с открытым исходным кодом. Это немного меняет сложность изменения лицензий. Вам заранее понадобится дополнительная помощь юристов, и вы все равно захотите четко общаться с заинтересованными сторонами вашего проекта при изменении лицензии.

## Требуется ли для моего проекта дополнительное соглашение с участниками?

Возможно нет. Для подавляющего большинства проектов лицензия для открытого исходного кода неявно служит как входящей (от участников), так и исходящей (для других участников и пользователей) лицензией. Если ваш проект размещен на GitHub, то Условия использования GitHub делают "inbound = outbound" [явным значением по умолчанию](https://help.github.com/en/github/site-policy/github-terms-of-service#6-contributions-under-repository-license).

Дополнительное соглашение с участником, часто называемое лицензионным соглашением участника (CLA), может создавать административную работу для сопровождающих проект. Сколько работы добавляет соглашение, зависит от проекта и реализации. Простое соглашение может требовать, чтобы участники подтвердили одним щелчком мыши, что у них есть права, необходимые для внесения вклада в соответствии с лицензией проекта с открытым исходным кодом. Более сложное соглашение может потребовать юридической проверки и подписи со стороны работодателей участников.

Кроме того, добавление «бумажной работы», которая, по мнению некоторых, является ненужной, трудной для понимания или несправедливой (когда получатель соглашения получает больше прав, чем участники или общественность через лицензию проекта с открытым исходным кодом), дополнительное соглашение с участниками может быть воспринято как недружественное к сообществу проекта.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/bcantrill?s=180" class="pquote-avatar" alt="avatar">
    Мы удалили CLA для Node.js. Это снижает барьер для входа в Node.js, тем самым расширяя базу участников.
  <p markdown="1" class="pquote-credit">
— @bcantrill, ["Расширение сообщества Node.js"](https://www.tritondatacenter.com/blog/broadening-node-js-contributions)
  </p>
</aside>

Вот некоторые ситуации, когда вы можете захотеть рассмотреть вопрос о дополнительном соглашении с участниками для вашего проекта:

* Ваши юристы хотят, чтобы все участники явным образом приняли (подписать, онлайн или офлайн) условия вклада, возможно, потому, что они считают, что самой лицензии с открытым исходным кодом недостаточно (даже если это так!). Если это единственная проблема, должно быть достаточно соглашения с участником, подтверждающего лицензию проекта с открытым исходным кодом. [Лицензионное соглашение с индивидуальным участником jQuery](https://web.archive.org/web/20161013062112/http://contribute.jquery.org/CLA/) является хорошим примером облегченного соглашения с дополнительным участником.
* Вы или ваши юристы хотите, чтобы разработчики доказали, что каждое совершаемое ими действие санкционировано. Требование [Сертификата разработчика](https://developercertificate.org/) — это количество проектов, которые это обеспечивают. Например, сообщество Node.js [использует](https://github.com/nodejs/node/blob/HEAD/CONTRIBUTING.md) DCO [вместо](https://nodejs.org/en/blog/uncategorized/notes-from-the-road/#easier-contribution) их предыдущего CLA. Простым вариантом автоматизации принудительного применения DCO в вашем репозитории является [DCO Probot](https://github.com/probot/dco).
* В вашем проекте используется лицензия с открытым исходным кодом, которая не включает прямую выдачу патента (например, MIT), и вам нужен патент от всех участников, некоторые из которых могут работать в компаниях с большими портфелями патентов, которые могут быть использованы для вашего таргетинга. или других участников и пользователей проекта. [Лицензионное соглашение с индивидуальным участником Apache](https://www.apache.org/licenses/icla.pdf) является часто используемым соглашением с дополнительным участником, в котором выдача патента является копией той, которая содержится в лицензии Apache License 2.0.
* Ваш проект находится под лицензией с авторским левом, но вам также необходимо распространять проприетарную версию проекта. Вам потребуется, чтобы каждый участник назначил вам авторские права или предоставил вам (но не общественности) разрешительную лицензию. [Соглашение с участником MongoDB](https://www.mongodb.com/legal/contributor-agreement) является примером такого типа соглашения.
* Вы думаете, что вашему проекту может потребоваться изменить лицензии в течение его срока службы, и хотите, чтобы участники заранее согласились на такие изменения.

Если вам действительно нужно заключить с вашим проектом дополнительное соглашение с участниками, рассмотрите возможность использования такой интеграции, как [помощник CLA](https://github.com/cla-assistant/cla-assistant), чтобы свести к минимуму отвлечение участников.

## Что нужно знать юридическому отделу моей компании?

Если вы выпускаете проект с открытым исходным кодом в качестве сотрудника компании, во-первых, ваша юридическая группа должна знать, что вы открываете исходный код проекта.

Хорошо это или плохо, пусть они знают, даже если это личный проект. У вас, вероятно, есть «соглашение об интеллектуальной собственности сотрудников» с вашей компанией, которое дает им некоторый контроль над вашими проектами, особенно если они вообще связаны с бизнесом компании или вы используете какие-либо ресурсы компании для разработки проекта. Ваша компания _должна_ легко дать вам разрешение, и, возможно, оно уже было получено в рамках благоприятного для сотрудников соглашения об интеллектуальной собственности или политики компании. В противном случае вы можете вести переговоры (например, объяснить, что ваш проект служит целям профессионального обучения и вашего развития в целях компании) или не работать над своим проектом, пока не найдете лучшую компанию.

**Если вы открываете исходный код проекта своей компании,** обязательно сообщите им об этом. У вашей юридической группы, вероятно, уже есть политика в отношении того, какую лицензию с открытым исходным кодом (и, возможно, дополнительное соглашение с участником) использовать, в зависимости от бизнес-требований и опыта компании в отношении обеспечения соответствия вашего проекта лицензиям зависимостей. Если нет, то вам с ними повезло! Ваша юридическая команда должна быть готова работать с вами, чтобы разобраться в этом вопросе. Некоторые вещи для размышления:

* **Сторонние материалы:** Содержит ли ваш проект зависимости, созданные другими, или иным образом включает или использует чужой код? Если это открытый исходный код, вам необходимо соблюдать лицензии на открытый исходный код материалов. Это начинается с выбора лицензии, которая работает со сторонними лицензиями с открытым исходным кодом (см. Выше). Если ваш проект изменяет или распространяет сторонние материалы с открытым исходным кодом, то ваша юридическая группа также захочет знать, что вы выполняете другие условия сторонних лицензий с открытым исходным кодом, такие как сохранение уведомлений об авторских правах. Если в вашем проекте используется чужой код, не имеющий лицензии с открытым исходным кодом, вам, вероятно, придется попросить сторонних разработчиков [добавить лицензию с открытым исходным кодом](https://choosealicense.com/no-license/#for-users), а если вы не можете его получить, прекратите использовать их код в своем проекте.

* **Коммерческая тайна:** Подумайте, есть ли в проекте что-то, что компания не хочет делать доступным для широкой публики. Если это так, вы можете открыть исходный код остальной части вашего проекта после извлечения материала, который хотите сохранить конфиденциальным.

* **Патенты:** Подает ли ваша компания заявку на патент, открытый исходный код которого ваш проект будет представлять собой [публичное раскрытие](https://en.wikipedia.org/wiki/Public_disclosure)? К сожалению, вас могут попросить подождать (или, возможно, компания пересмотрит мудрость приложения). Если вы ожидаете участия в своем проекте сотрудников компаний с большим портфелем патентов, ваша группа юристов может пожелать, чтобы вы использовали лицензию с явным предоставлением патента от участников (например, Apache 2.0 или GPLv3) или дополнительное соглашение с участником (см. выше).

* **Торговые марки:** Дважды проверьте, что название вашего проекта [не конфликтует с существующими торговыми марками](../starting-a-project/#конфликт-имён). Если вы используете в проекте товарные знаки собственной компании, убедитесь, что это не вызывает конфликтов. [FOSSmarks](http://fossmarks.org/) — это практическое руководство по пониманию товарных знаков в контексте проектов с бесплатным и открытым исходным кодом.

* **Конфиденциальность:** Собирает ли ваш проект данные о пользователях? «Звонит домой» на серверы компании? Ваш юридическая команда может помочь вам в соблюдении политики компании и внешних нормативных требований.

Если вы выпускаете первый проект своей компании с открытым исходным кодом, вышеуказанного более чем достаточно для выполнения (но не волнуйтесь, большинство проектов не должны вызывать серьезных проблем).

В долгосрочной перспективе ваша команда юристов может сделать больше, чтобы помочь компании получить больше от своего участия в проектах с открытым исходным кодом и оставаться в безопасности:

* **Политики участия сотрудников:** Рассмотрите возможность разработки корпоративной политики, определяющей, как ваши сотрудники вносят вклад в проекты с открытым исходным кодом. Четкая политика уменьшит путаницу среди ваших сотрудников и поможет им внести свой вклад в проекты с открытым исходным кодом в интересах компании, будь то в рамках своей работы или в свободное время. Хорошим примером является политика Rackspace [Типовая политика в отношении интеллектуальной собственности и открытого исходного кода](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/vanl?s=180" class="pquote-avatar" alt="avatar">
Предоставление IP-адреса, связанного с патчем, создает базу знаний и репутацию сотрудника. Это показывает, что компания инвестирует в развитие этого сотрудника, и создает ощущение полномочий и автономии. Все эти преимущества также приводят к повышению морального духа и лучшему удержанию сотрудников.  
<p markdown="1" class="pquote-credit">
— @vanl, ["Типовая политика в отношении интеллектуальной собственности и открытого исходного кода"](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/)
  </p>
</aside>

* **Что выпустить:** [(Почти) все](http://tom.preston-werner.com/2011/11/22/open-source-everything.html)? Если ваша юридическая команда понимает и вкладывается в стратегию открытого исходного кода вашей компании, они смогут намного лучше помочь, чем препятствовать вашим усилиям.
* **Соответствие:** Даже если ваша компания не выпускает проекты с открытым исходным кодом, она использует чужое программное обеспечение с открытым исходным кодом. [Осведомленность и процесс](https://www.linuxfoundation.org/blog/blog/why-companies-that-use-open-source-need-a-compliance-program/) могут предотвратить головные боли, задержки продукта и судебные иски.

<aside markdown="1" class="pquote">
Организации должны иметь лицензию и стратегию соответствия, которая подходит как для категорий \["разрешающий", так и "авторское лево"\]. Это начинается с записи условий лицензирования, которые применяются к программному обеспечению с открытым исходным кодом, которое вы используете, включая субкомпоненты и зависимости.
  <p markdown="1" class="pquote-credit">
— Heather Meeker, ["Программное обеспечение с открытым исходным кодом: основы соответствия и передовой опыт"](https://techcrunch.com/2012/12/14/open-source-software-compliance-basics-and-best-practices/)
  </p>
</aside>

* **Патенты:** Ваша компания может пожелать присоединиться к [Открытой сети изобретений](https://www.openinventionnetwork.com/), общему защищенному пулу патентов, чтобы защитить использование участниками крупных проектов с открытым исходным кодом, или изучить другое [альтернативное лицензирование патентов](https://www.eff.org/document/hacking-patent-system-2016).
* **Управление:** Когда имеет смысл передать проект [юридическому лицу за пределами компании](../leadership-and-governance/#нужно-ли-мне-юридическое-лицо-для-поддержки-моего-проекта).
