---
lang: ru
title: Лидерство и управление
description: Растущие проекты с открытым исходным кодом могут выиграть от формализации правил принятия решений.
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## Понимание механизмов управления вашим растущим проектом

Ваш проект растет, люди вовлечены в него, и вы полны решимости поддерживать его. На этом этапе вы, возможно, задаетесь вопросом, как включить постоянных участников проекта в свой рабочий процесс, будь то предоставление кому-то доступа к правкам кода (commit) или модерацию дебатов в сообществе. Если у вас есть вопросы, у нас есть ответы.

## Какие примеры формальных ролей используются в проектах с открытым исходным кодом?

Многие проекты имеют схожую структуру распределения ролей и признания заслуг участников.

Однако что на самом деле означают эти роли, зависит только от вас. Вот несколько типов ролей, которые вы можете узнать:

* **Сопровождающий (maintainer)**
* **Участник (contributor)**
* **Правщик (committer)**

**Для некоторых проектов "сопровождающие"** - это единственные люди в проекте, имеющие доступ к правкам (commit). В других проектах это просто люди, которые указаны в README как сопровождающие.

Сопровождающий не обязательно должен быть тем, кто пишет код для вашего проекта. Это может быть человек, который проделал большую работу по пропаганде вашего проекта или написал документацию, которая сделала проект более доступным для других. Независимо от того, чем он занимается ежедневно, сопровождающий - это человек, который чувствует ответственность за направление развития проекта и стремится его улучшить.

**"Участником" может быть любой**, кто комментирует проблему (issue) или запрос на перенос (pull request), люди, которые добавляют ценность проекту (будь то устранение проблем, написание кода или организация мероприятий), или любой, у кого есть принятый запрос на перенос (возможно, это самое узкое определение участника).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[Для Node.js,\] каждый человек, который появляется, чтобы прокомментировать проблему или прислать код, является членом сообщества проекта. Просто возможность видеть их означает, что они из пользователя превратились в участника.
  <p markdown="1" class="pquote-credit">— @mikeal, ["Здоровый Open Source"](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)</p>
</aside>

**Термин "правщик"** может быть использован для того, чтобы отличить доступ к правкам, который является особым видом ответственности, от других форм вклада.

Хотя вы можете определять роли в проекте как угодно, [рассмотрите возможность использования более широких определений](../how-to-contribute/#что-значит-внести-свой-вклад), чтобы воодушевить людей на большее количество разновидностей вклада. Вы можете использовать лидерские роли для официального признания людей, которые внесли выдающийся вклад в ваш проект, независимо от их технических навыков.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  Вы можете знать меня как "изобретателя" Django... но на самом деле я парень, которого наняли для работы над вещью через год после того, как она уже была сделана. (...) Люди предполагают, что я добился успеха благодаря своим навыкам программирования... но я в лучшем случае средний программист.
  <p markdown="1" class="pquote-credit">— @jacobian, ["PyCon 2015 Keynote" (видео)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)</p>
</aside>

## Как формализовать эти лидерские роли?

Формализация лидерских ролей помогает людям почувствовать свою сопричастность и подсказывает другим членам сообщества, к кому обращаться за помощью.

В небольших проектах назначение лидеров может быть простым - достаточно добавить их имена в README или текстовый файл CONTRIBUTORS.

Для более крупного проекта, если у вас есть веб-сайт, создайте страницу команды или перечислите на ней руководителей проекта. Например, у [Postgres](https://github.com/postgres/postgres/) есть [страница полной команды](https://www.postgresql.org/community/contributors/) с краткими профилями для каждого участника.

Если ваш проект имеет очень активное сообщество участников, вы можете сформировать "ядро" сопровождающих (maintainers) или даже группы людей, которые будут отвечать за различные области проблем (например, безопасность, устранение проблем или поведение сообщества). Позвольте людям самоорганизоваться и стать добровольцами на те роли, которые им больше всего нравятся, а не назначайте их.

<aside markdown="1" class="pquote">
  \[Мы\] дополняем основную команду несколькими "подкомандами". Каждая подкоманда занимается конкретной областью, например, разработкой языка или библиотек. (...) Для обеспечения глобальной координации и сильного, последовательного видения проекта в целом, каждая подгруппа возглавляется одним из членов основной команды.
  <p markdown="1" class="pquote-credit">— [Rust Governance RFC](https://github.com/rust-lang/rfcs/blob/HEAD/text/1068-rust-governance.md)</p>
</aside>

Команды руководителей могут захотеть создать специальный канал (например, на IRC) или регулярно встречаться для обсуждения проекта (например, на Gitter или Google Hangout). Вы даже можете сделать эти встречи публичными, чтобы другие люди могли послушать. Например, [Cucumber-ruby](https://github.com/cucumber/cucumber-ruby)[проводит офисные часы каждую неделю](https://github.com/cucumber/cucumber-ruby/blob/HEAD/CONTRIBUTING.md#talking-with-other-devs).

После того как вы установили руководящие роли, не забудьте задокументировать, как люди могут их получить! Установите четкий процесс того, как кто-то может стать сопровождающим или присоединиться к группе в вашем проекте, и запишите его в файле GOVERNANCE.md.

Такие инструменты, как [Vossibility](https://github.com/icecrime/vossibility-stack), могут помочь вам публично отслеживать, кто вносит (или не вносит) вклад в проект. Документирование этой информации позволяет избежать восприятия сообществом того, что сопровождающие - это клика, которая принимает решения втайне от всех.

Наконец, если ваш проект находится на GitHub, подумайте о переносе проекта из личного аккаунта в Организацию и добавлении хотя бы одного резервного администратора. [GitHub Organizations](https://help.github.com/articles/creating-a-new-organization-account/) облегчают управление разрешениями и несколькими репозиториями и защищают наследие вашего проекта благодаря [общему владению](../building-community/#совместное-владение-вашим-проектом).

## Когда я должен предоставить кому-то доступ на правки (commit)?

Некоторые люди считают, что вы должны предоставлять доступ на правки всем, кто вносит свой вклад. Это может способствовать тому, что больше людей будут чувствовать себя причастными к вашему проекту.

С другой стороны, особенно для больших, более сложных проектов, вы можете захотеть предоставить commit доступ только тем людям, которые продемонстрировали свою приверженность. Не существует единственно правильного способа - делайте то, что вам удобнее всего!

Если ваш проект находится на GitHub, вы можете использовать [защищенные ветки](https://help.github.com/articles/about-protected-branches/), чтобы управлять тем, кто и при каких обстоятельствах может отправлять правки (push) в определенную ветку.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  Каждый раз, когда кто-то отправляет вам запрос на принятие (pull request), дайте ему доступ на правки (commit) к вашему проекту. Хотя поначалу это может показаться невероятно глупым, использование этой стратегии позволит вам раскрыть истинную мощь GitHub. (...) Когда люди получают доступ на правки, они больше не беспокоятся о том, что их патч может остаться незамеченным... что заставляет их приложить гораздо больше усилий.
  <p markdown="1" class="pquote-credit">— @felixge, ["Взлом запроса на перенос (pull request)"](https://felixge.de/2013/03/11/the-pull-request-hack.html)</p>
</aside>

## Какие существуют структуры управления для проектов с открытым исходным кодом?

Существуют три общие структуры управления, связанные с проектами с открытым исходным кодом.

* **BDFL:** (Benevolent dictator for life) - "пожизненный доброжелательный диктатор". При такой структуре один человек (обычно первоначальный автор проекта) имеет право окончательного голоса при принятии всех основных решений по проекту. [Python](https://github.com/python) - классический пример. Небольшие проекты, вероятно, по умолчанию являются BDFL, потому что в них есть только один или два сопровождающих (maintainer). Проект, созданный в компании, также может попасть в категорию BDFL.

* **Меритократия:** (Примечание: термин "меритократия" несет негативные коннотации для некоторых сообществ и имеет [сложную социальную и политическую историю](http://geekfeminism.wikia.com/wiki/Meritocracy).) При меритократии активным участникам проекта (тем, кто демонстрирует "заслуги") отводится формальная роль в принятии решений. Решения обычно принимаются на основе чистого консенсусного голосования. Концепция меритократии была впервые предложена [Apache Foundation](https://www.apache.org/); [все проекты Apache](https://www.apache.org/index.html#projects-list) являются меритократиями. Вклад может быть сделан только людьми, представляющими самих себя, а не компанию.

* **Либеральный вклад:** Согласно модели либерального вклада, наиболее влиятельными признаются люди, которые делают больше всего работы, но это основано на текущей работе, а не на историческом вкладе. Основные решения по проекту принимаются на основе процесса поиска консенсуса (обсуждение основных претензий), а не прямого голосования, и стремятся охватить как можно больше точек зрения сообщества. Популярные примеры проектов, использующих либеральную модель вклада, включают [Node.js](https://foundation.nodejs.org/) и [Rust](https://www.rust-lang.org/).

Какой из них использовать? Это зависит от вас! У каждой модели есть свои преимущества и компромиссы. И хотя поначалу они могут показаться совершенно разными, все три модели имеют больше общего, чем кажется. Если вы заинтересованы в принятии одной из этих моделей, ознакомьтесь с этими шаблонами:

* [шаблон модели BDFL](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [Шаблон модели меритократии](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Либеральная политика Node.js в отношении вклада участников](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## Нужна ли мне документация по управлению, когда я запускаю свой проект?

Не существует подходящего времени для написания документации для вашего проекта, но его гораздо легче определить, когда вы увидите динамику развития вашего сообщества. Самое лучшее (и самое трудное) в управлении открытым исходным кодом - это то, что оно формируется сообществом!

Однако некоторая ранняя документация неизбежно будет способствовать управлению проектом, поэтому начинайте записывать все, что можно. Например, вы можете определить четкие ожидания в отношении поведения или того, как работает ваш процесс привлечения участников, еще на этапе запуска проекта.

Если вы являетесь частью компании, запускающей проект с открытым исходным кодом, стоит провести внутреннее обсуждение перед запуском о том, как ваша компания собирается поддерживать проект и принимать решения по его дальнейшему развитию. Возможно, вы также захотите публично объяснить все особенности того, как ваша компания будет (или не будет!) участвовать в проекте.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
  Для управления проектами на GitHub мы назначаем небольшие команды, которые на самом деле работают над ними в Facebook. Например, React управляется инженером по React.
  <p markdown="1" class="pquote-credit">— @caabernathy, ["Взгляд изнутри на открытый исходный код в Facebook"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)</p>
</aside>

## Что если сотрудники корпорации участвуют в проекте?

Успешные проекты с открытым исходным кодом используются многими людьми и компаниями, и некоторые компании в конечном итоге могут иметь потоки доходов, связанные с проектом. Например, компания может использовать код проекта в качестве одного из компонентов коммерческого предложения услуг.

По мере того как проект получает все более широкое распространение, люди, обладающие опытом в этой области, становятся более востребованными - вы можете быть одним из них! - и иногда будут получать деньги за работу, которую они выполняют в проекте.

Важно относиться к коммерческой деятельности как к норме и как к еще одному источнику энергии для развития. Конечно, платные разработчики не должны получать особое отношение к себе по сравнению с бесплатными; каждый вклад должен оцениваться по его техническим достоинствам. Однако люди должны чувствовать себя комфортно, занимаясь коммерческой деятельностью, и не стесняться приводить свои примеры использования, аргументируя свою позицию в пользу того или иного усовершенствования или функции.

"Коммерческое" полностью совместимо с "открытым исходным кодом". "Коммерческий" означает лишь то, что где-то вовлечены деньги - что программное обеспечение используется в коммерции, что становится все более вероятным по мере того, как проект получает распространение. (Когда программное обеспечение с открытым исходным кодом используется как часть продукта без открытого исходного кода, общий продукт все равно является "проприетарным" программным обеспечением, хотя, как и открытый исходный код, он может использоваться в коммерческих или некоммерческих целях).

Как и любой другой человек, коммерчески мотивированные разработчики приобретают влияние в проекте за счет качества и количества своего вклада. Очевидно, что разработчик, которому платят за его время, может сделать больше, чем тот, кому не платят, но это нормально: оплата - это лишь один из многих возможных факторов, которые могут повлиять на то, как много кто-то делает. Обсуждая проект, сосредоточьтесь на вкладе, а не на внешних факторах, которые позволяют людям делать этот вклад.

## Нужно ли мне юридическое лицо для поддержки моего проекта?

Вам не нужно юридическое лицо для поддержки вашего проекта с открытым исходным кодом, если только вы не работаете с деньгами.

Например, если вы хотите создать коммерческий бизнес, вам нужно будет учредить C Corp или LLC (если вы находитесь в США). Если вы просто выполняете контрактную работу, связанную с вашим проектом с открытым исходным кодом, вы можете принимать деньги как индивидуальный предприниматель или учредить LLC (если вы находитесь в США).

Если вы хотите принимать пожертвования для своего проекта с открытым исходным кодом, вы можете установить кнопку для пожертвований (например, с помощью PayPal или Stripe), но деньги не будут подлежать налогообложению, если вы не являетесь квалифицированной некоммерческой организацией (501c3, если вы находитесь в США).

Многие проекты не хотят заниматься созданием некоммерческой организации, поэтому вместо этого они находят фискального спонсора некоммерческой организации. Фискальный спонсор принимает пожертвования от вашего имени, обычно в обмен на процент от пожертвования. [Software Freedom Conservancy](https://sfconservancy.org/), [Apache Foundation](https://www.apache.org/), [Eclipse Foundation](https://eclipse.org/org/foundation/), [Linux Foundation](https://www.linuxfoundation.org/projects) и [Open Collective](https://opencollective.com/opensource) являются примерами организаций, выступающих в качестве фискальных спонсоров проектов с открытым исходным кодом.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  Наша цель - предоставить инфраструктуру, которую сообщества могут использовать для самоокупаемости, создавая таким образом среду, в которой все - и участники и спонсоры - получают конкретную выгоду.
  <p markdown="1" class="pquote-credit">— @piamancini, ["Выходя за рамки благотворительности"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141)</p>
</aside>

Если ваш проект тесно связан с определенным языком или экосистемой, может существовать и соответствующий фонд программного обеспечения, с которым вы можете работать. Например, [Python Software Foundation](https://www.python.org/psf/) помогает поддерживать [PyPI](https://pypi.org/), менеджер пакетов Python, а [Node.js Foundation](https://foundation.nodejs.org/) помогает поддерживать [Express.js](https://expressjs.com/), фреймворк на основе Node.
