---
lang: ru
title: Как участвовать в опенсорс-проектах
description: Хотите внести свой вклад в опенсорс? Руководство по участию для новичков и не только.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Зачем участвовать в опенсорс-проектах?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Работа над \[freenode\] помогла мне приобрести многие навыки, которые я позже использовал в учебе в университете и в текущей работе. Я думаю, что работа над проектами с открытым исходным кодом помогает мне не меньше, чем самому проекту!
  <p markdown="1" class="pquote-credit">
— @errietta, ["Почему я люблю участвовать в работе над опенсорс-софтом"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Участие в опенсорс-проектах может быть полезным способом изучать, обучать и приобретать опыт практически в любом навыке, который вы можете себе представить.

Зачем люди участвуют в опенсорсе? На то есть множество причин!

### Улучшить используемые проекты

Многие опенсорс-контрибьюторы перед тем, как внести свой вклад в продукт, были обычными его пользователями. Если вы обнаружите баг в используемой вами опенсорс-программе, вы, возможно, захотите заглянуть в её исходный код, чтобы узнать, сможете ли вы исправить его самостоятельно. Если это так, то отправка патча — лучший способ убедиться, что ваши друзья (и вы сами, когда вы обновитесь до следующего релиза) смогут извлечь из него пользу.

### Улучшить существующие навыки

Будь то программирование, дизайн пользовательского интерфейса, графический дизайн, написание текста или организационная работа, если вы ищете практику, для вас найдётся задача в проекте с открытым исходным кодом.

### Познакомиться с людьми с общими интересами

Опенсорс-проекты с теплыми, гостеприимными сообществами заставляют людей возвращаться долгие годы. Многие люди завязывают дружбу на всю жизнь благодаря участию в открытых проектах, будь то встреча друг с другом на конференциях или поздних ночных онлайн-чатах о буррито.

### Найти наставников и научить других

Работа с другими над общим проектом означает, что вам придется объяснять, как вы это делаете, а также просить помощи у других. Акты обучения и преподавания могут быть полезными для всех участников.

### Создать общедоступные проекты, которые помогут вам повысить репутацию (и карьеру)

По определению, вся ваша работа с открытым исходным кодом является общедоступной, это значит, что у вас появляются примеры, которые можно использовать где угодно в качестве демонстрации того, что вы можете делать.

### Изучить навыки работы с людьми

Опенсорс предлагает возможности практиковать лидерские и управленческие навыки, такие как разрешение конфликтов, организация групп людей и определение приоритетов в работе.

### Возможность внести изменения, пусть даже небольшие

Необязательно становиться контрибьютором на протяжении всей жизни, чтобы получать удовольствие от участия в опенсорс-проектах. Вы когда-нибудь видели опечатку на сайте и хотели бы, чтобы кто-нибудь её исправил? В проекте с открытым исходным кодом вы можете это сделать. Опенсорс помогает людям чувствовать себя хозяевами своей жизни и того, как они воспринимают мир, и это само по себе отрадно.

## Что значит внести свой вклад 

Если вы новичок в опенсорсе, процедура участия в нём может быть пугающей. Как найти подходящий проект? Что делать, если вы не умеете программировать? Что если что-то пойдет не так?

Не беспокойтесь! Много чем можно заняться в опенсорс-проекте, и вот несколько подсказок, которые помогут вам определиться, чтобы извлечь максимальную пользу.

### Необязательно помогать кодом

Распространенное заблуждение, касающееся участия в опенсорсе, состоит в том, что вам нужно писать код. Зачастую есть другие части проекта, которыми [наиболее всего пренебрегают или упускают из виду](https://github.com/blog/2195-the-shape-of-open-source). Вы окажете проекту _огромную_ услугу, предложив поработать над ними!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Я известен своей работой над CocoaPods, но большинство людей не знают, что я на самом деле не работаю над самим инструментом CocoaPods. В основном, я занимаюсь документацией и брендингом.
  <p markdown="1" class="pquote-credit">
— @orta, ["Переход на открытый исходный код по умолчанию"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Даже если вам нравится писать код, другие виды помощи — отличный способ поучаствовать в проекте и познакомиться с другими членами сообщества. Налаживание таких отношений даст вам возможность работать над другими частями проекта.

### Нравится планировать мероприятия?

* Организуйте семинары или митапы по проекту, [что и сделал @fzamperin в NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Организуйте конференцию проекта (если она есть)
* Помогите участникам сообщества найти подходящие конференции и подать заявку на доклад

### Нравится дизайнить?

* Переделайте макеты, чтобы повысить удобство использования проекта
* Проведите исследование поведения пользователей, чтобы реорганизовать и улучшить навигацию или меню проекта, [например, как предлагает Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Составьте руководство по стилю оформления, чтобы помочь проекту с соблюдением единообразного визуального дизайна
* Создайте принты для футболок или новый логотип, [как это сделали участники hapi.js](https://github.com/hapijs/contrib/issues/68)

### Нравится писать?

* Напишите и улучшите документацию по проекту
* Создайте папку с примерами по использованию проекта
* Запустите рассылку новостей по проекту или освещайте самое важное из списка рассылки
* Составьте обучающие руководства по проекту, [как это сделали участники PyPA](https://packaging.python.org/)
* Переведите документацию проекта

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Кроме шуток, \[документация\] крайне важна. Документация до сих пор была отличной и была ключевой особенностью Babel. Есть разделы, которые требуют доработки, и даже добавление параграфа здесь или там чрезвычайно приветствуется.
  <p markdown="1" class="pquote-credit">
- @kittens, ["Призыв контрибьюторов"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Нравится организовывать?

* Давайте ссылки на повторяющиеся ишью, предлагайте новые ярлыки для ишью, чтобы они были лучше огранизованы
* Пройдитесь по открытым ишью и предложите закрыть старые, как, [например, сделал @nzakas в ESLint](https://github.com/eslint/eslint/issues/6765)
* Задавайте уточняющие вопросы по недавно открывшимся ишью, чтобы продвинуть обсуждение вперед

### Нравится кодить?

* Найдите открытую проблему для решения, что, [например, @dianjin сделал в Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Спросите, можете ли вы помочь с разработкой новой функциональности
* Автоматизируйте настройку проекта
* Улучшите инструменты и тестирование

### Нравится помогать людям?

* Ответьте на вопросы о проекте, например, на Stack Overflow ([как в этом примере с Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) или Reddit
* Отвечайте на вопросы людей по открытым ишью
* Помогите модерировать доски обсуждений или каналы в чатах

### Нравится ли вам помогать другим кодить?

* Проверяйте код других людей
* Напишите учебные руководства по использованию проекта
* Предложите наставничество другому контрибьютору, [как @ereichert сделал для @bronzdoc в Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Можно работать не только над программными проектами!

Хотя «опенсорс» часто относится к программному обеспечению, вы можете совместно работать практически над чем угодно. Есть книги, рецепты, списки и курсы, которые разрабатываются как опенсорс-проекты.

Например:

* @sindresorhus курирует [список "классных" списков](https://github.com/sindresorhus/awesome)
* @h5bp ведет [список потенциальных вопросов на собеседовании](https://github.com/h5bp/Front-end-Developer-Interview-Questions) для кандидатов в разработчики интерфейсов
* @stuartlynn и @nicole-a-tesla сделали [сборник забавных фактов о тупиках](https://github.com/stuartlynn/puffin_facts)

Даже если вы разработчик программного обеспечения, работа над документацией проекта может помочь вам войти в опенсорс. Зачастую работа над проектами, не связанными с кодом, не так пугает, а процесс совместной работы поможет вам обрести уверенность и опыт.

## Подготовка к новому проекту

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Когда вы просматриваете список ишью, который сбивает вас с толку, дело не только в вас. Эти инструменты требуют большого количества неявных знаний, но люди могут помочь вам сориентироваться в них, вы можете задать им вопросы.
  <p markdown="1" class="pquote-credit">
- @shaunagm, [«Как внести свой вклад в опенсорс»](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Для чего-то большего, чем исправление опечатки, участие в открытом проекте похоже на поход к группе незнакомцев на вечеринке. Если вы начнете говорить о ламах, когда они были увлечены дискуссией о золотых рыбках, они, вероятно, будут смотреть на вас немного странно.

Прежде чем вслепую приступить к своим собственным предложениям, начните с изучения обстановки в сообществе. Это увеличивает шансы на то, что ваши идеи будут замечены и услышаны.

### Анатомия опенсорс-проекта

Каждое сообщество с открытым исходным кодом отличается.

Потратить годы на один открытый проект означает, что вы познакомились с одним открытым проектом. Переходите к другому проекту, и вы можете обнаружить, что терминология, нормы и стили общения совершенно другие.

Тем не менее многие проекты с открытым исходным кодом следуют схожей организационной структуре. Понимание различных ролей сообщества и общего процесса поможет вам быстро сориентироваться в любом новом проекте.

Типичный проект с открытым исходным кодом состоит из следующих типов людей:

* **Автор:** Человек или организация, создавшие проект.
* **Владелец:** Лицо, которое имеет административные права на организацию или репозиторий (не всегда те же самые, что и первоначальный автор).
* **Мейнтейнеры:** Контрибьюторы, которые несут ответственность за формирование видения и управление организационными аспектами проекта (они также могут быть авторами или владельцами проекта).
* **Контрибьюторы:** Все, кто внес свой вклад в проект.
* **Участники сообщества:** Люди, использующие проект. Они могут быть активными в беседах или высказывать свое мнение о направлении проекта.

В более крупных проектах также могут быть подкомитеты или рабочие группы, занимающиеся различными задачами, такими как инструменты, сортировка, модерация сообщества и организация мероприятий. Поищите на сайте проекта или в репозитории "командную" или "организационную" страницу, чтобы найти эту информацию.

У проекта также есть документация. Эти файлы обычно находятся в корне репозитория.

* **LICENSE:** По определению, каждый опенсорс-проект должен иметь [соответствующую лицензию](https://choosealicense.com). Если у проекта нет лицензии, его нельзя причислить к опенсорсу.
* **README:** README — это руководство-инструкция, которая приветствует новых членов сообщества в проекте. В этом файле объясняется назначение и применение проекта.
* **CONTRIBUTING:** В то время как README помогают людям _использовать_ проект, документация по участию помогает людям _вносить_ вклад в проект. В нем объясняется, какие виды помощи необходимы и как устроен процесс. Хотя не у каждого проекта есть файл CONTRIBUTING, его наличие свидетельствует о дружелюбном отношении к участникам.
* **CODE_OF_CONDUCT:** Кодекс поведения устанавливает основные правила поведения участников и помогает создать дружелюбную, гостеприимную атмосферу. Хотя не в каждом проекте есть файл CODE_OF_CONDUCT, его наличие свидетельствует о том, что это хороший проект, в который можно внести свой вклад.
* **Другая документация:** Может быть дополнительная документация, например обучающие материалы, пошаговые руководства или политики управления, особенно для более крупных проектов.

Наконец, в проектах с открытым исходным кодом для организации обсуждения используются следующие инструменты. Чтение архивов даст вам хорошее представление о том, как сообщество думает и работает.

* **Список ишью (issue tracker):** Место, где происходят обсуждения, связанные с проектом.
* **Пул-реквесты (pull requests):** Место, где рассматриваются запросы на изменение кода.
* **Дискуссионные форумы или списки рассылки:** Некоторые проекты могут использовать эти каналы для разговорных тем (например, _"Как мне ..."_ или _"Что вы думаете о ..."_ вместо отчётов об ошибках и внесения предложений с новыми возможностями). Другие используют ишью для всех дискуссий.
* **Синхронный чат-канал:** Некоторые проекты используют чаты (например, Slack или IRC) для спонтанного общения, совместной работы и быстрого обмена информацией.

## Поиск проекта, в котором можно поучаствовать

Теперь, когда вы разобрались, как устроены опенсорс-проекты, пришло время найти проект, в который вы сможете внести свой вклад!

Если вы никогда раньше не имели дела с опенсорсом, прислушайтесь к совету президента США Джона Ф. Кеннеди, который однажды сказал: _«Не спрашивайте, что ваша страна может сделать для вас, спросите, что вы можете сделать для своей страны»_.

Участвовать в опенсорсе могут все, независимо от уровня подготовки. Не ломайте сильно голову над тем, каким будет ваш первый вклад в опенсорс.

Вместо этого подумайте о проектах, которые вы уже используете или собираетесь использовать. Проекты, в которых вы будете активно участвовать, — это те, к которым вы будете возвращаться.

В этих проектах всякий раз, когда вы ловите себя на мысли, что что-то может быть лучше или иначе, действуйте в соответствии со своим инстинктом.

Опенсорс — это не закрытый клуб; им занимаются такие же люди, как вы. «Опенсорс» — это всего лишь причудливый термин для обозначения решаемых мировых проблем.

Можно просмотреть файл README, чтобы найти неработающую ссылку или опечатку. Или вы как новый пользователь заметили, что что-то работает неправильно, либо есть неточность в документации. Вместо игнорирования таких проблем или просьбы к кому-нибудь их исправить, посмотрите, удастся ли вам помочь и тем самым поучаствовать в проекте. В этом как раз и смысл опенсорса!

> [28% случайных вкладов](https://www.igor.pro.br/publica/papers/saner2016.pdf) в опенсорс представляют собой документацию, например, исправление опечатки, переформатирование или перевод.

Если вы ищете существующие ишью, которые можно исправить, то в каждом опенсорс-проекте есть страница `/contribute`, где перечислены ишью, специально предназначенные для начинающих. Перейдите на главную страницу репозитория на GitHub и добавьте в конец URL-адреса `/contribute` (например, [https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

Вы также можете использовать один из следующих ресурсов, чтобы открыть для себя новые проекты и внести свой вклад в них:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)

### Чеклист перед тем, как принять участие

Когда вы нашли проект, в который хотели бы внести свой вклад, бегло осмотрите проект, чтобы убедиться, что он принимает стороннюю помощь. В противном случае ваш упорный труд может остаться незамеченным.

Вот удобный чеклист список, чтобы понять, подходит ли проект для новых контрибьюторов.

**Попадает под определение опенсорса**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Есть ли у него лицензия? Обычно в корне репозитория находится файл LICENSE.
  </label>
</div>

**Проект активно принимает стороннюю помощь**

Посмотрите на коммиты в основной ветке. Узнать это вы можете на главной странице репозитория на GitHub.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Когда был последний коммит?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Сколько контрибьюторов у проекта?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Как часто люди коммитят в репозиторий? (На GitHub выяснить это можно, кликнув по ссылке «Commits» в верхней панели.)
  </label>
</div>

Затем посмотрите на ишью проекта.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Сколько сейчас открытых ишью?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Быстро ли мейнтейнеры реагируют на ишью после того, когда они открываются?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Ведётся ли активное обсуждение ишью?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Есть ли недавно созданные ишью?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Есть ли закрытые ишью? (На странице Issues GitHub-репозитория щелкните на вкладку «Closed», чтобы увидеть закрытые ишью.)
  </label>
</div>

Теперь выясните такую информацию про пул-реквесты проекта.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Сколько сейчас открытых пул-реквестов?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Быстро ли мейнтейнеры реагируют на пул-реквесты после их открытия?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Ведётся ли активное обсуждение пул-реквестов?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Есть ли недавно отправленные пул-реквесты?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Как давно были объединены пул-реквесты? (На странице Pull Request GitHub-репозитория щелкните на вкладку «Closed», чтобы увидеть закрытые пул-реквесты.)
  </label>
</div>

**Проект приветливый**

Дружелюбный и доброжелательный проект свидетельствует о том, что в нём будут с пониманием относиться к новым контрибьюторам.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Отвечают ли охотно мейнтейнеры на вопросы в ишью?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Дружелюбны ли люди в вопросах, на дискуссионном форуме и в чате (например, IRC или Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Проверяются ли пул-реквесты?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Благодарят ли мейнтейнеры людей за их помощь?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Всякий раз, когда вы видите длинное обсуждение, выборочно проверяйте ответы основных разработчиков, которые приходят в конце обсуждения. Подводят ли они конструктивные выводы и предпринимают ли шаги, чтобы довести обсуждение до решения, оставаясь при этом вежливыми? Если вы видите, что идет много разборок, это часто является признаком того, что энергия идет на споры, а не на развитие.
  <p markdown="1" class="pquote-credit">
- @kfogel, [_Создание OSS_](https://prodingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Как сделать вклад

Вы нашли понравившийся проект и уже готовы поучаствовать в нём. Наконец-то! И вот как правильно это сделать.

### Эффективное общение

Независимо от того, поучаствуете ли вы только один раз или же попытаетесь присоединиться к сообществу, совместная работа с другими людьми  — один из самых важных навыков, который вы приобретете, занимаясь опенсорсом.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Как новый контрибьютор\] я быстро понял, что мне нужно задавать вопросы, если я хочу закрыть ишью. Я бегло просмотрел кодовую базу. Как только я немного понял код, я попросил дополнительных указаний. И вуаля! Я смог разобраться с ишью после получения всей необходимой мне информации.
  <p markdown="1" class="pquote-credit">
- @shubheksha, [Очень ухабистое путешествие новичка по миру опенсорса](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Прежде чем открыть ишью, пул-реквест или задать вопрос в чате, запомните эти советы, которые помогут эффективно воплотить ваши идеи в жизнь.

**Дайте контекст.** Помогите другим быстро освоиться. Если вы столкнулись с ошибкой, объясните, что вы пытаетесь сделать и как ее воспроизвести. Если вы предлагаете новую идею, объясните, почему вы думаете, что она будет полезна для проекта (не только для вас!).

> 😇 _"Х не происходит, когда я делаю Y"_
>
> 😢 _"X не работает! Исправьте это."_

**Попробуйте сначала разобраться сами.** Не знать чего-то — это нормально, но покажите, что вы пробовали разобраться. Прежде чем обращаться за помощью, обязательно изучите README-файл проекта, документацию, ишью (открытые или закрытые), список рассылки и поищите ответ в Интернете. Люди оценят, если вы продемонстрируете, что попытались что-то узнать.

> 😇 _"Я не знаю, как реализовать X. Я посмотрел документацию и не нашел никаких упоминаний об этом."_
>
> 😢 _"Как мне сделать X?"_

**Пишите коротко и по делу.** Как и при отправке электронного письма, каждая сторонняя работа, независимо от того, насколько она была простой или полезной, требует чьей-то проверки. Во многих проектах входящих запросов больше, чем людей, готовых помочь. Будьте лаконичны. Так вы увеличите вероятность того, что кто-то сможет вам помочь.

> 😇 _"Я хотел бы написать руководство по API."_
>
> 😢 _"На днях я ехал по шоссе и остановился заправиться, и тогда у меня возникла замечательная идея, чем мы должны заняться, но прежде чем я это объясню, позвольте мне показать вам ..."_

**Ведите все обсуждения публично.** Хотя это заманчиво, не обращайтесь к мейнтейнерам напрямую, если вам не нужно делиться конфиденциальной информацией (например, о проблеме безопасности или серьезном нарушении поведения). Если вы сделаете беседу публичной, больше людей смогут узнать о ней и извлечь из неё пользу. Обсуждения сами по себе могут быть вкладом.

> 😇 _(в качестве комментария) «@-мейнтейнер Привет! Как нам поступить с этим пул-реквестом?»_
>
> 😢 _(по электронной почте) «Привет, извини, что побеспокоил тебя по электронной почте, но мне было интересно, была ли у тебя возможность просмотреть мой PR»_

**Не стесняйтесь задавать вопросы (но будьте терпеливы!).** В какой-то момент каждый был новичком в проекте, и даже опытным контрибьюторам нужно время освоиться, когда они приходят в новый проект. Точно так же мейнтейнеры, давно поддерживающие проект, не всегда знакомы со всеми его частями. Проявите к ним такое же терпение, какое вы бы хотели, чтобы они проявили к вам.

> 😇 _"Спасибо, что разобрались с этой ошибкой. Я последовал вашим предложениям. Вот результат."_
>
> 😢 _"Почему вы не можете решить мою проблему? Разве это не ваш проект?"_

**Уважайте решения сообщества.** Ваши идеи могут отличаться от приоритетов или видения сообщества. Члены сообщества могут высказать свои мнения или отказаться от реализации вашей идеи. Хотя всегда нужно обсуждать и искать компромисс, последнее слово за мейнтейнерами, потому что им в дальнейшем предстоит работать с вашим кодом. Если вы не согласны с их направлением, вы всегда можете работать над собственным ответвлением проекта (форком) или начать собственный проект.

> 😇 _"Я разочарован, что вы не можете поддержать мой вариант использования, но, как вы объяснили, он затрагивает только небольшую часть пользователей, я понимаю почему. Спасибо за внимание."_
>
> 😢 _"Почему вы не поддерживаете мой вариант использования? Это недопустимо!"_

**Главное, держите себя в руках.** Опенсорсом занимаются люди со всего мира. Контекст теряется из-за разных языков, культур, регионов и часовых поясов. Кроме того, письменное общение затрудняет передачу тона или настроения. В таких обсуждениях исходите из благих намерений. Нет ничего плохого в том, чтобы вежливо оттолкнуться от идеи, попросить больше информации или дополнительно прояснить свою позицию. Просто постарайтесь сделать интернет лучше, чем когда вы его нашли.

### Изучение обстановки

Прежде чем что-либо делать, убедитесь, что это больше нигде не обсуждалось. Пройдитесь по README-файлу проекта, ишью (открытые и закрытые), списку рассылки и Stack Overflow. Не тратьте много времени на это, достаточно поискать по нескольким ключевым словам.

Если вы не нашли обсуждение вашей идеи, можно начать действовать. Если проект находится на GitHub, вы, скорее всего, будете общаться, открывая ишью или пул-реквест:

* **Ишью** отлично подходят, чтобы завести беседу или обсуждение
* **Запросы на изменение** предназначены для начала работы над решением.
* **Для легкого общения**, например, уточняющего или практического вопроса, попробуйте задать вопрос в Stack Overflow, IRC, Slack или других чат-каналах, если они есть в проекте

Прежде чем открывать ишью или пул-реквест, ознакомьтесь с руководством по участию (обычно ему посвящен отдельный файл с именем CONTRIBUTING или соответствующий раздел в файле README), чтобы сделать всё правильно. Например, вас могут попросить представить информацию согласно шаблону или потребовать, чтобы вы написали тесты.

Если вы планируете сделать большое изменение, перед этим лучше откройте ишью. Полезно некоторое время понаблюдать за проектом (на GitHub [для этого можно кликнуть по кнопке «Watch»](https://help.github.com/articles/watching-repositories/), чтобы получать уведомления обо всех активностях), а также познакомиться с некоторыми участниками сообщества.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Вы <em>многое</em> узнаете о проекте, который вы активно используете, если "понаблюдаете" за ним на GitHub и просмотрите все ишью и PR.
<p markdown="1" class="pquote-credit">
- @gaearon [о присоединении к проектам](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Открытие ишью

Как правило, следует создать ишью, чтобы:

* Сообщить об ошибке, которую вы не можете исправить самостоятельно
* Обсудить общую тему или идею (например, связанную с сообществом, развитием или политикой проекта)
* Предложить реализовать новую функциональность или другую идею проекта

Советы по общению в ишью:

* **Если видите открытую ишью, которую хотите решить**, прокомментируйте её, чтобы люди знали, что вы занимаетесь ею. Таким образом, снизится вероятность, что кто-то ещё будет работать над ней.
* **Если ишью была открыта давно,** возможно, что она рассматривается в другом месте, либо уже решена, поэтому прокомментируйте её, чтобы подтвердить её актуальность.
* **Если вы открыли ишью, но позже самостоятельно нашли ответ,** прокомментируйте её, чтобы сообщить об этом людям, а затем закройте её. Даже фиксирование такого результата является вкладом в проект.

### Открытие пул-реквеста

Как правило, следует создать пул-реквест, чтобы:

* Сделать незначительное исправление (например, исправить опечатку, неработающую ссылку или очевидную ошибку)
* Начать работать над тем, о чём уже было договорено или что обсуждалось в ишью

Пул-реквест не обязательно должен представлять законченную работу. Обычно лучше открывать пул-реквест на раннем этапе, чтобы люди могли наблюдать за вашим прогрессом или оставлять отзывы о нем. Только в названии такого пул-реквеста укажите "WIP" (от англ. Work in Progress — в процессе выполнения). Всегда позже можно отправить дополнительные коммиты.

Если проект находится на GitHub, выполните следующие шаги, чтобы создать пул-реквест:

* **[Форкните репозиторий](https://guides.github.com/activities/forking/)** и склонируйте его к себе локально. Затем в этом локальном репозитории добавьте оригинальный (upstream) репозиторий. Почаще загружайте изменения из исходного репозитория, чтобы ваш локальный репозиторий оставался в актуальном состоянии, — это снизит вероятность возникновения конфликтов при создании пул-реквеста. (См. более подробные инструкции [здесь](https://help.github.com/articles/syncing-a-fork/).)
* **[Создайте ветку](https://guides.github.com/introduction/flow/)** для ваших правок.
* **Ссылайтесь на любые относящиеся к делу ишью** или подтверждающую документацию в своем PR (например, «Closes #37»).
* **Добавьте скриншоты до и после**, если ваши изменения затрагивают файлы HTML/CSS. Перетащите изображения в текстовую область пул-реквеста.
* **Протестируйте свои изменения!** Например, запустите тесты, если они есть, и при необходимости напишите новые. Даже если тестов нет, проверьте сами, что после ваших изменений всё работает, как и раньше.
* **Соблюдайте стиль написания кода проекта** в меру своих возможностей. Это может быть использование отступов, точек с запятой или комментариев иначе, чем вы привыкли, но мейнтейнерам это упростит слияние вашего пул-реквеста, а другим — облегчит понимание и поддержку в будущем.

Если это ваш первый пул-реквест, ознакомьтесь с сайтом [Make a Pull Request](http://makeapullrequest.com/), который @kentcdodds сделал в виде пошагового видео-руководства. Вы также можете попрактиковаться в создании пул-реквеста в репозитории [First Contributions](https://github.com/Roshanjossey/first-contributions), созданном @Roshanjossey.

## Что будет дальше после принятия участия

Вы сделали это! Поздравляем, вы стали контрибьютором в опенсорс. Надеемся, это будет далеко не первый раз.

После того, как вы отправите вклад, произойдет одно из следующих событий:

### 😭 Вы не получите ответ.

Предполагаем, вы [проверили проект на наличие признаков активности](#чеклист-перед-тем-как-принять-участие) перед тем, как внести свою лепту. Однако даже в активном проекте возможно, что ваш вклад не получит отклика.

Если вы не получили ответа в течение недели, вполне нормально вежливо ответить в той же теме и попросить кого-нибудь проверить вашу работу. Если вы знаете, кто может посмотреть ваш пул-реквест, упомяните его через @ в этой ветке.

**Не** обращайтесь напрямую к этому человеку; помните, что публичное общение жизненно важно для опенсорс-проектов.

Если после вежливого напоминания так никто и не ответил, есть вероятность, что никто и никогда не ответит. Это не самое приятное ощущение, но пусть оно вас не расстраивает. Такое с каждым случалось! Есть множество возможных причин, по которым вам могли не ответить, в том числе личные обстоятельства, на которые вы не можете повлиять. Попробуйте найти другой проект или способ участия. В любом случае, нет смысла тратить время на проект, пока члены его сообщества не проявят должного уровня вовлеченности и отзывчивости.

### 🚧 У вас могут запросить внести изменения.

Зачастую вас могут попросить что-то изменить, это может быть связано с самой идеей или её реализацией.

Когда кто-то запрашивает сделать изменения, относитесь к этому с пониманием и воспринимайте это должным образом. Люди нашли время, чтобы оценить ваш вклад. Открывать PR и бросать его на произвол судьбы — дурной тон. Если вы не знаете, как внести изменения, изучите проблему, а затем обратитесь за помощью, если она вам нужна.

Если у вас больше нет времени работать над проблемой (например, обсуждение длится уже несколько месяцев, а за это время обстоятельства поменялись), сообщите об этом мейнтейнеру, чтобы он не ожидал ответа. Возможно, кто-то другой с радостью завершит начатую вами работу.

### 👎 Ваш вклад не принят.

В итоге ваш вклад будет либо принят, либо нет. Надеюсь, вы потратили не слишком много усилий на него. Если вы не поняли, почему он не был принят, разумно попросить мейнтейнера дать пояснения. В конечном итоге, однако, вам стоит понять и смириться с их решением. Не спорьте и не злитесь по этому поводу. В случае чего вы всегда можете форкнуть репозиторий, чтобы работать над своей собственной версией продукта!

### 🎉 Ваш вклад принят.

Ура! Вы успешно сделали вклад в опенсорс!

## Вы сделали это!

Независимо от того, сделали ли вы свой первый вклад в опенсорс или ищете новые способы сделать это, мы надеемся, что вы вдохновитесь на действия. Даже если ваш вклад был отклонён, не забудьте сказать спасибо, когда мейнтейнер постарался вам помочь. Опенсорс создается такими же людьми, которые создают ишью, отправляют пул-реквест, оставляют комментарии или приветствуют друг друга одновременно.
