---
lang: ru
title: Получение денег за работу над открытым кодом
description: Подкрепите свою работу над открытым кодом, получая финансовую поддержку за ваше время и ваш проект
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Почему некоторые люди ищут финансовую поддержку

Большая часть работы с открытым кодом осуществляется добровольцами. Например, кто-то может столкнуться с ошибкой в используемом им проекте и отправить исправление. А кому-то нравится заниматься проектом в свободное время.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Мне нужно было хобби на неделю перед рождеством (...) У меня под рукой был только домашний компьютер. Я решил написать интерпретатор для нового языка сценариев, о котором думал в последнее время. (...) В качестве рабочего названия я выбрал "питон".
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Программирование на питоне"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Есть много причин, по которым человек не хотел бы получать деньги за свою работу с открытым исходным кодом.

* **Возможно, у них уже есть любимая работа на полный рабочий день,** которая позволяет им вносить свой вклад в разработку открытого исходного кода в свободное время.
* **Им нравится думать об открытом исходном коде как об увлечении** или творческом пути, и они не хотят чувствовать себя финансово обязанными работая над своими проектами.
* **Они получают другие преимущества от участия в разработке открытого исходного кода**, такие как создание своей репутации или портфолио, обучение новым навыкам или чувство близости к сообществу.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Финансовые пожертвования действительно добавляют некоторым людям чувство ответственности. (...) Для нас, в глобально связанном, быстро меняющемся мире, в котором мы живем, важно иметь возможность сказать: «Не сейчас. Я чувствую, что хочу сделать что-то совершенно другое».
  <p markdown="1" class="pquote-credit">
— @alloy, ["Почему мы не принимаем финансовые пожертвования"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Для других, особенно когда сообщество активно пишет код и требуется тратить много времени, получение оплаты за участие в проекте с открытым кодом - единственный способ участвовать, либо потому, что этого требует проект, либо по личным причинам.

Поддержка популярных проектов может стать серьезной обязанностью, занимающей 10 или 20 часов в неделю вместо нескольких часов в месяц.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
Спросите любого сопровождающего проект с открытым кодом, и он расскажет вам, какой объем работы уходит на управление проектом. У вас есть клиенты. Вы решаете для них проблемы. Вы создаете новые функции. Возникает большая потребность в вашем времени.
<p markdown="1" class="pquote-credit">
— @ashedryden, ["Этика неоплачиваемого труда в сообществах открытого кода"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Оплачиваемая работа также позволяет людям из разных слоев общества вносить значимый вклад. Некоторые люди не могут позволить себе тратить неоплачиваемое время на проекты с открытым исходным кодом из-за своего текущего финансового положения, долга, семейных или других обязанностей по уходу. Это означает, что мир никогда не увидит вклада талантливых людей, которые не могут позволить себе добровольно тратить свое время. Это имеет этические последствия, как @ashedryden [описал](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), поскольку выполняемая работа смещена в пользу тех, кто уже имеет преимущества в жизни, которые затем получают дополнительные преимущества на основе их добровольного вклада, в то время как другие, которые не могут быть волонтерами, не получают более поздних возможностей, что усиливает текущий недостаток разнообразия в сообществе открытого исходного кода.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   Сообщества открытых проектов приносят огромные выгоды технологической отрасли, что, в свою очередь, приносит пользу всем отраслям. (...) Однако, если сосредоточиться на этом могут только удачливые и одержимые, то возникает огромный неиспользованный потенциал.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Деньги и открытый код"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Если вам нужна финансовая поддержка, можно рассмотреть два пути. Вы можете финансировать свое собственное время в качестве участника или можете найти организационное финансирование для проекта.

## Финансирование собственного времени

Сегодня многим людям платят за работу над открытым кодом неполный или полный рабочий день. Самый распространенный способ получить деньги за свое время - поговорить со своим работодателем.

Если ваш работодатель действительно использует проект, будет проще обосновать необходимость работы над открытым кодом, но подойдите к делу творчески. Возможно, ваш работодатель не использует этот проект, но он использует питон, а поддержка популярного проекта питон помогает привлечь новых разработчиков питон. Может быть, это в целом делает вашего работодателя более дружелюбным к разработчикам.

Если у вас нет существующего проекта с открытым кодом, над которым вы хотели бы работать, но вы предпочитаете, чтобы ваши текущие результаты работы были с открытым кодом, попросите вашего работодателя открыть код некоторых внутренних программ.

Многие компании разрабатывают программы с открытым кодом, чтобы создать свой бренд и нанять квалифицированных специалистов.

@hueniverse, например, обнаружил финансовые причины [инвестиций Walmart в открытый код](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). А @jamesgpearce обнаружил, что инициативы открытого кода Facebook [изменили](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) кадровую политику:

> Это тесно связано с нашей хакерской культурой и тем, как воспринималась наша организация. Мы спросили наших сотрудников: «Вы знали о программе с открытым исходным кодом Facebook?». Две трети ответили «Да». Половина сказала, что программа положительно повлияла на их решение работать на нас. Это не маргинальные цифры, и я надеюсь, что тенденция сохранится.

Если ваша компания идет по этому пути, важно сохранять четкие границы между общественной и корпоративной деятельностью. В конечном итоге открытый код поддерживает себя за счет вклада людей со всего мира, и это больше, чем любая другая компания или место.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Получать деньги за работу с открытым исходным кодом - редкая и прекрасная возможность, но вы не должны отказываться от своей страсти в процессе. Ваша страсть должна быть причиной, почему компании хотят платить вам.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Если не получается убедить работодателя в важности работы над открытым кодом, можете подумать о поиске нового работодателя, который будет поощрять вклад сотрудников в разработку открытого кода. Ищите компании, которые открыто заявляют о своей приверженности работе с открытым кодом. Например:

* Некоторые компании как [Netflix](https://netflix.github.io/), имеют веб-сайты, которые подчеркивают их участие в открытых проектах
* [Zalando](https://opensource.zalando.com) опубликовали свою [политику участия в открытых проектах](https://opensource.zalando.com/docs/using/contributing/) для работников.

Проекты, инициированные крупной компанией вроде [Go](https://github.com/golang) или [React](https://github.com/facebook/react), также, вероятно, будут нанимать людей для работы с открытым кодом.

В зависимости от ваших личных обстоятельств вы можете попытаться собрать деньги самостоятельно для финансирования своей работы с открытым исходным кодом. Например:

* @gaearon нашёл финансирование для [Redux](https://github.com/reactjs/redux) через [кампанию краудфайндинга на Patreon](https://redux.js.org/)
* @andrewgodwin нашёл финансирование миграции схемы Django [через кампанию на Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django).

Иногда открытые проекты размещают вознаграждение за задачи, над которыми вы могли бы поработать.

* @ConnorChristie получал оплату, [помогая](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol над иж JavaScript библиотекой через [gitcoin.co](https://gitcoin.co/).
* @mamiM сделал перевод на японский @MetaMask за вознаграждение на [Bounties Network](https://explorer.bounties.network/bounty/134).

## Поиск финансирования для вашего проекта

Помимо договоренностей с отдельными разработчиками, иногда проекты собирают деньги от компаний и частных лиц для финансирования текущей работы.

Организационное финансирование может быть направлено на оплату текущим разработчикам, покрытие расходов на ведение проекта (например, плату за хостинг) или инвестирование в новые функции или идеи.

Поскольку популярность открытого исходного кода растет, поиск финансирования для проектов все еще является экспериментальным, но есть несколько общих доступных вариантов.

### Краудфайндинг и спонсоры

Поиск спонсоров хорошо работает, если к вам есть сильный интерес, или у вас есть репутация, или ваш проект очень популярен.
Вот несколько примеров спонсируемых проектов:

* **[webpack](https://github.com/webpack)** привлекает деньги от компаний и частных лиц [through OpenCollective](https://opencollective.com/webpack)
* **[вместе с Ruby](https://rubytogether.org/),** - некоммерческая организация, которая платит за работу над [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), и над другими проектами инфраструктуры Ruby

### Создайте поток доходов

В зависимости от вашего проекта вы можете взимать плату за коммерческую поддержку, варианты размещения или дополнительные функции. Вот несколько примеров:

* **[Sidekiq](https://github.com/mperham/sidekiq)** предлагает платные версии за дополнительную плату
* **[Travis CI](https://github.com/travis-ci)** предлагает платные версии своего продукта
* **[Ghost](https://github.com/TryGhost/Ghost)** - это некоммерческая организация с платными услугами

Некоторые популярные проекты как [npm](https://github.com/npm/npm) и [Docker](https://github.com/docker/docker), даже привлекают венчурные инвестиции для поддержания роста своих проектов.

### Подайте заявку на грант

Some software foundations and companies offer grants for open source work. Sometimes, grants can be paid out to individuals without setting up a legal entity for the project.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** получил [грант поддержки открытого кода Mozilla](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** был профинансирован [приютом открытого кода от Stripe](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** получил грант от [Sloan Foundation](https://sloan.org/programs/digital-technology)
* **[Python Software Foundation](https://www.python.org/psf/grants/)** предлагает гранты на работу, связанную с питоном

Более подробные варианты и тематические исследования вы можете прочитать в [руководстве](https://github.com/nayafia/lemonade-stand) по получению оплаты за работу с открытым кодом от @nayafia. Для разных типов финансирования требуются разные навыки, поэтому определите свои сильные стороны, чтобы выяснить, какой вариант лучше всего подходит для вас.

## Создание аргументов в пользу финансовой поддержки

Независимо от того, является ли ваш проект новой идеей или уже существует много лет, вы должны серьезно подумать, чтобы определить своего целевого спонсора и представить убедительные доводы.

Независимо от того, хотите ли вы оплачивать свое собственное время или собрать средства для проекта, вы должны ответить на следующие вопросы.

### Влияние

Чем полезен этот проект? Почему вашим пользователям или потенциальным пользователям он так нравится? Где он будет через пять лет?

### Притягательность для людей

Постарайтесь собрать доказательства того, что ваш проект значимый, будь то показатели, анекдоты или отзывы. Есть ли какие-нибудь компании или известные люди, использующие ваш проект прямо сейчас? Если нет, то одобрил ли это известный человек?

### Ценность для спонсора

К спонсорам, будь то ваш работодатель или грантодательский фонд, часто обращаются с предложениями. Почему они должны поддерживать именно ваш проект? Какую выгоду они получат лично?

### Использование денежных средств

Чего именно вы добьетесь с предложенным финансированием? Сосредоточьтесь на вехах или результатах проекта, а не на зарплате.

### Как вы получите средства

Есть ли у спонсора какие-либо требования относительно выплаты грантов? Например, вам может потребоваться быть некоммерческой организацией или иметь некоммерческого финансового спонсора. Или, возможно, средства должны быть переданы индивидуальному подрядчику, а не организации. Эти требования различаются в зависимости от спонсора, поэтому не забудьте заранее изучить вопрос.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
В течение многих лет мы были ведущим источником удобных для сайтов иконок, с сообществом более 20 миллионов человек и были представлены на более чем 70 миллионах веб-сайтов, включая сайт Белого дома Whitehouse.gov. (...) Версия 4 была три года назад. С тех пор веб-технологии сильно изменились, и, честно говоря, Font Awesome немного устарел. (...) Вот почему мы представляем Font Awesome 5. Мы модернизируем и переписываем CSS и переделываем каждый значок сверху донизу. Мы говорим о лучшем дизайне, большей согласованности и лучшей читаемости.
<p markdown="1" class="pquote-credit">
— @davegandy, [видео на Kickstarter о Font Awesome](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Экспериментируйте и не сдавайтесь

Собирать деньги непросто, будь то проект с открытым кодом, некоммерческая организация или стартап программного обеспечения, и в большинстве случаев от вас требуется проявить творческий подход. Определив, как вы хотите получать деньги, проведя исследования и поставив себя на место спонсора, вы сможете убедительно обосновать необходимость финансирования.
