---
lang: ru
title: Поиск пользователей для вашего проекта
description: Помогите своему опенсорс-проекту расти, передав его в руки счастливых пользователей.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Распространение информации

Нет правила, согласно которому вы должны продвигать опенсорс-проект при запуске. Есть много веских причин для работы с опенсорсом, которые не имеют ничего общего с популярностью. Вместо того, чтобы надеяться, что люди найдут и воспользуются вашим опенсорсом-проектом, вы следует самому рассказать о своей тяжелой работе!

## Разберитесь в своем послании

Прежде чем приступить к работе по продвижению своего проекта, вам нужно уметь объяснить, для чего он нужен и почему так важен.

Что делает ваш проект особенным или интересным? Почему его создали? Ответив на эти вопросы для себя, вы сможете донести важность вашего проекта до остальных.

Помните, что люди сначала приходят в ваш проекте в качестве пользователей, а затем становятся его контрибьюторами, если проект решает их проблему. Размышляя о послании и ценности вашего проекта, попробуйте взглянуть на них через призму того, что могут захотеть _пользователи и контрибьюторы_.

Например, @robb приводит примеры кода, чтобы четко объяснить, почему его проект [Cartography](https://github.com/robb/Cartography) полезен:

![README-файл Cartography](/assets/images/finding-users/cartography.jpg)

Чтобы глубже погрузиться в послание, ознакомьтесь с упражнением Mozilla [«Personas and Pathways»](https://mozillascience.github.io/working-open-workshop/personas_pathways/) по развитию образов пользователей.

## Помогите людям найти ваш проект и следить за ним

<aside markdown="1" class="pquote">
  В идеале вам понадобится «домашний» URL-адрес, который вы можете рекламировать и давать людям для связи с вашим проектом. Не нужно тратиться на модный шаблон или даже доменное имя, но вашему проекту нужна точка опоры.
  <p markdown="1" class="pquote-credit">
- Питер Купер и Роберт Найман, [«Как рассказать о своем коде»](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/ )
  </p>
</aside>

Людям будет проще найти и запомнить ваш проект, если вы будете направлять их в одно русло.

**Создайте ясные каналы связи для рекламы своей работы.** Аккаунт в Twitter, ссылка на GitHub или канал IRC — это простой способ направить людей на ваш проект. Эти площадки также дают возможность собраться растущему сообществу проекта.

Если вы еще не хотите создавать каналы для своего проекта, продвигайте свой собственный Twitter или GitHub во всех своих начинаниях. Продвижение аккаунта в Twitter или GitHub позволит людям узнать, как с вами связаться или следить за вашей работой. Если вы выступаете на митапе или конференции, расскажите о себе или включите контактную информацию в слайдах.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Ошибка, которую я совершил в те первые дни (...), заключалась в том, что я не создал аккаунт в Твиттере для проекта. Twitter — отличный способ держать людей в курсе событий о проекте, а также постоянно знакомить их с проектом.
  <p markdown="1" class="pquote-credit">
- @nathanmarz, [«История Apache Storm и извлеченные уроки»](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Подумайте о создании сайта для вашего проекта.** Сайт делает ваш проект более дружелюбным и легким для поиска, особенно если он дополнен понятной документацией и обучающими руководствами. Наличие сайта также указывает на активность вашего проекта, заставляя пользователей чувствовать себя более увереннее при его использовании. Добавьте примеры, которые помогут пользователям понять, как использовать ваш проект.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), соавтор Django, сказал, что сайт был _"безусловно самым правильным решением в первые дни Django"_.

Если ваш проект размещён на GitHub, вы можете использовать [GitHub Pages](https://pages.github.com/) при создании сайта. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/) и [Middleman](https://middlemanapp.com/) — только [несколько примеров](https://github.com/showcases/github-pages-examples) отличных, полноценных сайтов.

![Главная страница Vagrant](/assets/images/finding-users/vagrant_homepage.png)

Теперь, когда вы знаете, что рассказать о своём проекте, и вы создали канал для связи, самое время выйти и поговорить с вашими пользователями!

## Ищите пользователей для вашего проекта (онлайн)

Через интернет можно быстро поделиться и распространить информацию. Используя онлайн-каналы, можно выйти на очень широкую аудиторию.

Воспользуйтесь преимуществами существующих онлайн-сообществ и платформ, чтобы охватить свою аудиторию. Если ваш опенсорс-проект представляет собой программу, вы, вероятно, сможете найти заинтересованных пользователей на [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/) или [Quora](https://www.quora.com/). Найдите каналы, где, по вашему мнению, люди получат наибольшую пользу от вашей работы или будут в восторге от неё.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Каждая программа имеет очень узкое применение, которое нужно лишь небольшой части пользователей. Не рассылайте спам как можно большему числу людей. Вместо этого направьте свои усилия на те сообщества, которым будет полезно знать о вашем проекте.
  <p markdown="1" class="pquote-credit">
- @pazdera, [«Маркетинг для опенсорс-проектов»](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Попробуйте рассказать о своём проекте следующими способами:

* **Познакомьтесь с соответствующими опенсорс-проектами и сообществами.** Необязательно всегда напрямую продвигать свой проект. Если проект идеально подходит для специалистов по обработке данных, использующих Python, познакомьтесь с сообществом специалистов по науке о данных на Python. Когда люди будут знакомиться с вами, вы слово за слово можете рассказать о своей работе.
* **Найдите людей, сталкивающихся с проблемой, которую решает ваш проект.** Поищите на соответствующих форумах людей, которые попадают в целевую аудиторию вашего проекта. Отвечайте на их вопросы и найдите тактичный способ (когда это уместно) предложить свой проект в качестве решения.
* **Попросите обратную связь.** Представьте себя и свою работу пользователям, которые сочтет её актуальной и интересной. Чётко обозначьте, кому, по вашему мнению, принесет пользу ваш проект. Попытайтесь закончить предложение: _"Я думаю, что мой проект действительно поможет X, который пытается сделать Y_". Слушайте и отвечайте на отзывы других, а не просто рекламируйте свою работу.

Вообще говоря, сосредоточьтесь на помощи другим, прежде чем просить что-то взамен. Поскольку каждый может легко продвигать проект в интернете, то ваше детище может потеряться в информационном шуме. Чтобы выделиться из толпы, дайте людям понять, кто вы есть, а не только то, чего вы хотите.

Если никто не обращает внимания или не отвечает на вашу первоначальную просьбу, не расстраивайтесь! Запуск большинства проектов — это итеративный процесс, который может занять месяцы или даже годы. Если не удалось добиться ответа с первого раза, попробуйте другую тактику или сначала найдите способы помочь повысить эффективность другим. Продвижение и запуск проекта требует времени и преданности делу.

## Ищите пользователей для вашего проекта (офлайн)

![Публичное выступление](/assets/images/finding-users/public_speaking.jpg)

Офлайн-мероприятия — популярный способ продвижения новых проектов перед публикой. Это отличная возможность привлечь заинтересованных людей и наладить более глубокие человеческие отношения, особенно если вы заинтересованы в привлечении разработчиков.

Если вы [новичок в публичных выступлениях](https://speaking.io/), начните с поиска местного митапа, связанного с языком или экосистемой вашего проекта.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Я очень нервничала перед посещением PyCon. Я выступала с докладом, собиралась познакомиться там только с парочкой людей, ехала на целую неделю. (...) Однако мне не стоило волноваться. PyCon был необычайно классным! (...) Все были невероятно так дружелюбны и общительны, что я едва находила время побыть наедине!
  <p markdown="1" class="pquote-credit">
- @jhamrick, [«Как я научился перестать беспокоиться и полюбить PyCon»](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Если вы никогда раньше не выступали перед публикой, вы можете нервничать, — это совершенно нормально! Помните, что люди собрались, потому что они искренне хотят послушать о вашей работе.

Когда вы пишете доклад, сосредоточьтесь на том, что будет интересно и полезно слушателям. Сохраняйте дружелюбный тон и говорите доступным языком. Улыбайтесь, дышите и получайте удовольствие.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  При подготовке к своему докладу, независимо от его темы, попробуйте представить его как историю, которые вы рассказываете людям.
  <p markdown="1" class="pquote-credit">
- Лена Рейнхард, [«Как подготовить и написать доклад на технической конференции»](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Когда вы будете готовы, подумайте о выступлении на конференции, чтобы прорекламировать собственный проект. Через конференции можно донести свою мысль до большого количества людей, иногда со всего мира.

Ищите конференции, посвященные вашему языку или экосистеме. Перед подачей заявки на доклад, изучите конференцию, чтобы адаптировать доклад для участников и повысить свои шансы к выступлению на конференции. Часто составить представление о своей аудитории можно по докладчикам конференции.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Я очень вежливо написал людям из JSConf и умолял их дать мне возможность выступить на JSConf EU. (...) Я был очень напуган, представляя то, над чем работал шесть месяцев. (...) Всё это время я просто думал: «Боже мой. Что я здесь делаю?».
  <p markdown="1" class="pquote-credit">
- @ry, ["История Node.js" (видео)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Заработайте репутацию

В дополнение к стратегиям, описанным выше, лучший способ побудить людей делиться вашим проектом и вносить в него вклад — это делиться их проектами и вносить в них свой вклад.

Помощь новичкам, обмен ресурсами и содержательный вклад в проекты других людей помогут вам заработать положительную репутацию. Активное участие в опенсорс-сообществе поможет людям понять суть вашей работы и с большей вероятностью обратить внимание на ваш проект и поделится им. Развитие отношений с другими опенсорс-проектами может даже привести к официальному партнерству.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Единственная причина, по которой urllib3 является сегодня самой популярной сторонней библиотекой Python, заключается в том, что люди часто предлагают её использовать в других проектах.
  <p markdown="1" class="pquote-credit">
- @shazow, [«Как сделать так, чтобы ваш опенсорс-проект процветал»](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Никогда не рано и не поздно начать укреплять свою репутацию. Даже если вы уже запустили собственный проект, стремитесь разными способами помогать другим.

Невозможно в одночасье нарастить аудиторию. Чтобы заслужить доверие и уважение окружающих нужно время, а созданию репутации нет конца и края.

## Не останавливайтесь на достигнутом!

Может пройти много времени, прежде чем люди заметят ваш опенсорс-проект. Это нормально! Некоторым из самых популярных сегодня проектов потребовались годы, чтобы достичь высокого уровня активности. Сосредоточьтесь на выстраивании отношений, а не на надежде, что ваш проект внезапно станет популярным. Будьте терпеливы и продолжайте делиться своей работой с теми, кто её ценит.
