---
lang: ru
title: Ваш кодекс поведения
description: Содействуйте здоровому и конструктивному поведению в сообществе, приняв и обеспечив соблюдение кодекса поведения.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Зачем мне нужен кодекс поведения?

Кодекс поведения - это документ, который устанавливает ожидания в отношении поведения участников вашего проекта. Принятие и соблюдение кодекса поведения может помочь создать позитивную социальную атмосферу в вашем сообществе.

Кодексы поведения помогают защитить не только участников, но и вас самих. Если вы поддерживаете проект, вы можете обнаружить, что непродуктивное отношение других участников со временем может привести вас к истощению или недовольству своей работой.

Кодекс поведения дает вам возможность способствовать здоровому и конструктивному поведению в обществе. Проактивность снижает вероятность того, что вы или другие люди устанете от своего проекта, и помогает вам действовать, когда кто-то делает что-то, с чем вы не согласны.

## Установление кодекса поведения

Постарайтесь установить кодекс поведения как можно раньше: в идеале, когда вы впервые создаете свой проект.

Кодекс поведения описывает не только ваши ожидания, но и следующее:

* Где вступает в силу кодекс поведения _(только в отношении issues и pull requests, или действий сообщества, таких как мероприятия?)_
* К кому применяется кодекс поведения _(члены сообщества и сопровождающие (maintainers), а как насчет спонсоров?)_
* Что произойдет, если кто-то нарушит кодекс поведения
* Как можно сообщить о нарушениях

Везде, где можно, используйте прошлые достижения. [Соглашение авторов](https://contributor-covenant.org/) - это готовый кодекс поведения, используется более чем 40 000 проектов с открытым исходным кодом, включая Kubernetes, Rails и Swift.

[Кодекс поведения Django](https://www.djangoproject.com/conduct/) и [Кодекс поведения гражданина](http://citizencodeofconduct.org/) также являются двумя хорошими примерами кодекса поведения.

Поместите файл CODE_OF_CONDUCT в корневой каталог вашего проекта и сделайте его видимым для вашего сообщества, связав его из файла CONTRIBUTING или README.

## Решите, как вы будете обеспечивать соблюдение своего кодекса поведения

<aside markdown="1" class="pquote">
 Кодекс поведения, который не соблюдается (или не может быть соблюден) - хуже, чем отсутствие кодекса поведения вообще: он посылает сигнал о том, что ценности в кодексе поведения на самом деле не важны и не уважаются в вашем сообществе.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

Вы должны объяснить, как будет применяться ваш кодекс поведения, **_прежде чем_** произойдет нарушение. Для этого есть несколько причин:

* Это демонстрирует, что вы серьезно относитесь к действиям, когда это необходимо.

* Ваше сообщество будет более уверено, что жалобы действительно будут рассмотрены.

* Вы убедите свое сообщество, что процесс проверки является справедливым и прозрачным, если они когда-либо обнаружат, что их расследуют на предмет нарушения.

Вы должны предоставить людям возможность в частном порядке (например, на адрес электронной почты) сообщить о нарушении кодекса поведения и объяснить, кто получает это сообщение. Это может быть сопровождающий, группа сопровождающих или рабочая группа по кодексу поведения.

Не забывайте, что кто-то может захотеть сообщить о нарушении в отношении человека, получившего эти сообщения. В этом случае дайте им возможность сообщить о нарушениях кому-то другому. Например, @ctb и @ mr-c [объясняют свой проект](https://github.com/dib-lab/khmer/blob/HEAD/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> О случаях оскорбления, домогательства или иного неприемлемого поведения можно сообщать по электронной почте **khmer-project@idyll.org**, которая отправляется только К. Титусу Брауну и Майклу Р. Крузо. Чтобы сообщить о проблеме, связанной с любым из них, отправьте электронное письмо **Джуди Браун Кларк, доктору философии**, директору по разнообразию Центра изучения эволюции в действии BEACON, Центра науки и технологий NSF.\*

Для вдохновения ознакомьтесь с [руководством по применению](https://www.djangoproject.com/conduct/enforcement-manual/) Django (хотя в зависимости от размера вашего проекта вам может не понадобиться что-то настолько всеобъемлющее).

## Обеспечение соблюдения вашего кодекса поведения

Иногда, несмотря на все ваши усилия, кто-то будет делать что-то, нарушающее этот код. Есть несколько способов справиться с негативным или вредным поведением, когда оно возникает.

### Соберите информацию о ситуации

Относитесь к голосу каждого члена сообщества так же важно, как и к своему собственному. Если вы получили сообщение о том, что кто-то нарушил кодекс поведения, отнеситесь к этому серьезно и расследуйте этот вопрос, даже если он не соответствует вашему собственному опыту общения с этим человеком. Это сигнализирует вашему сообществу, что вы цените их точку зрения и доверяете их мнению.

Рассматриваемый член сообщества может быть рецидивистом, который постоянно заставляет других чувствовать себя некомфортно, или он мог сказать или сделать что-то только один раз. И то, и другое может быть основанием для принятия мер, в зависимости от контекста.

Прежде чем ответить, дайте себе время понять, что произошло. Прочтите прошлые комментарии и разговоры этого человека, чтобы лучше понять, кто он и почему он мог поступить таким образом. Постарайтесь собрать другие точки зрения об этом человеке и его поведении.

<aside markdown = "1" class = "pquote">
  Не ввязывайтесь в споры. Не отвлекайтесь, пытаясь разобраться с чужим поведением, пока вы не закончите разбираться с текущим вопросом. Сосредоточьтесь на том, что вам нужно.
  <p markdown = "1" class = "pquote-credit">
- Стефани Зван, [«Итак, у вас есть политика. Что теперь?»](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Примите соответствующие меры

После сбора и обработки достаточного количества информации вам нужно будет решить, что делать. Обдумывая свои следующие шаги, помните, что ваша цель как модератора - создать безопасную, уважительную среду для совместной работы. Подумайте не только о том, как поступить в рассматриваемой ситуации, но и о том, как ваш ответ повлияет на поведение и ожидания остальной части вашего сообщества в будущем.

Когда кто-то сообщает о нарушении кодекса поведения, это ваша, а не их работа - разбираться с этим. Иногда репортер раскрывает информацию с большим риском для своей карьеры, репутации или физической безопасности. Принуждение их к противостоянию преследователям может поставить репортера в компромиссное положение. Вам следует вести прямое общение с этим человеком, если репортер явно не потребует иного.

Есть несколько способов отреагировать на нарушение кодекса поведения:

* **Сделайте этому человеку публичное предупреждение** и объясните, как его поведение негативно повлияло на других, желательно в том канале, где оно произошло. По возможности, публичная коммуникация сообщает остальной части сообщества о том, что вы серьезно относитесь к кодексу поведения. Будьте добры, но тверды в общении.

* **Наедине поговорите с человеком**, о котором идет речь, и объясните, как его поведение негативно повлияло на других. Вы можете использовать частный канал связи, если ситуация связана с конфиденциальной личной информацией. Если вы общаетесь с кем-то в частном порядке, рекомендуется отправить копию ваших сообщений тем, кто первым сообщил о ситуации, чтобы они знали, что вы приняли меры. Прежде чем отправлять им копию, попросите согласие того, с кем вы переписывались.

Иногда решение не может быть достигнуто. Человек, о котором идет речь, может стать агрессивным или враждебным при столкновении или не изменит своего поведения. В этой ситуации вы можете подумать о более решительных действиях. Например:

* **Отстранить лицо** от участия в проекте с помощью временного запрета на участие в любом аспекте проекта.

* **Забанить навсегда** человека из проекта

К запрету членов нельзя относиться легкомысленно, поскольку это представляет собой постоянное и непримиримое различие точек зрения. Вы должны принимать эти меры только тогда, когда ясно, что решение не может быть достигнуто.

## Ваши обязанности как сопровождающего

Кодекс поведения - это не закон, который применяется произвольно. Вы являетесь исполнителем кодекса поведения и обязаны соблюдать правила, установленные кодексом поведения.

Как сопровождающий, вы устанавливаете правила для своего сообщества и обеспечиваете их соблюдение в соответствии с правилами, изложенными в вашем кодексе поведения. Это означает серьезное отношение к любому сообщению о нарушении кодекса поведения. Репортер должен тщательно и беспристрастно перепроверить свою жалобу. Если вы решите, что поведение, о котором они сообщили, не является нарушением, четко сообщите им об этом и объясните, почему вы не собираетесь принимать меры по этому поводу. Что они будут с этим делать, зависит от них: терпеть поведение, с которым у них возникла проблема, или прекращать участие в жизни сообщества.

Сообщение о поведении, которое _технически_ не нарушает кодекс поведения, может указывать на наличие проблемы в вашем сообществе, и вам следует изучить эту потенциальную проблему и действовать соответствующим образом. Это может включать пересмотр вашего кодекса поведения, чтобы прояснить приемлемое поведение и/или поговорить с человеком, о поведении которого было сообщено, и сообщить ему, что, хотя он и не нарушал кодекс поведения, он выходит за рамки и создаёт дискомфорт другим участникам.

В конце концов, как сопровождающий, вы устанавливаете и обеспечиваете соблюдение стандартов приемлемого поведения. У вас есть возможность формировать общественные ценности проекта, и участники ожидают, что вы будете придерживаться этих ценностей справедливо и беспристрастно.

## Поощряйте поведение, которое вы хотите видеть в мире 🌎

Когда проект кажется враждебным или нежелательным, даже если это всего лишь один человек, поведение которого терпят другие, вы рискуете потерять гораздо больше участников, с некоторыми из которых вы, возможно, даже никогда не встретитесь. Не всегда легко принять или обеспечить соблюдение кодекса поведения, но создание благоприятной атмосферы поможет вашему сообществу расти.
