---
lang: ru
title: Создание дружного сообщества
description: Создание сообщества, которое побуждает людей использовать, вносить свой вклад и распространять ваш проект.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Настройка вашего проекта на успех

Вы запустили свой проект, распространяете информацию, и люди пробуют его. Потрясающе! Как убедить их остаться?

Доброжелательное сообщество — это инвестиция в будущее и репутацию вашего проекта. Если ваш проект только начинает получать сторонний вклад, начните с того, чтобы дать первым участникам положительный опыт, чтобы им хотелось возвращаться.

### Сделайте так, чтобы люди чувствовали себя желанными гостями

Один из способов подумать о сообществе вашего проекта — это то, что @MikeMcQuaid называет [воронкой участников](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Воронка участников](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Создавая свое сообщество, подумайте, как кто-то наверху воронки (потенциальный пользователь) теоретически может добраться до конца вниз (активный сопровождающий). Ваша цель — уменьшить трение на каждом этапе взаимодействия с участником. Когда у людей легкие победы, они будут чувствовать стимул делать больше.

Начните с вашей документации:

* **Облегчите использование вашего проекта для любого желающего.** [Дружественное README](../starting-a-project/#написание-readme) и понятные примеры кода помогут любому, кто заинтересуется вашим проектом, начать работу.
* **Объясните, как участвовать**, используя [руководство для участников](../starting-a-project/#написание-руководства-для-участников) и оперативно отвечая на вопросы (issues).
* **Хорошие первые вопросы (issues)**: чтобы помочь новым участникам начать работу, явно рассмотрите [ярлыки вопросов, которые достаточно просты для начинающих](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). Затем GitHub выведет эти вопросы в различных местах платформы, увеличивая полезный вклад и уменьшая трение пользователей, решающих проблемы, которые слишком сложны для их уровня.

[Обзор открытого исходного кода GitHub за 2017 год](http://opensourcesurvey.org/2017/) показал, что неполная или запутанная документация является самой большой проблемой для пользователей открытого исходного кода. Хорошая документация побуждает людей взаимодействовать с вашим проектом. В конце концов, кто-то откроет вопрос или пул-реквест. Используйте эти взаимодействия как возможности для продвижения их по воронке.

* **Когда кто-то новый попадает в ваш проект, поблагодарите его за проявленный интерес!** Достаточно одного негативного опыта, чтобы кто-то не захотел возвращаться.
* **Будьте отзывчивы.** Если вы не отвечаете на их вопрос в течение месяца, скорее всего, они уже забыли о вашем проекте.
* **Будьте открыты в отношении помощи, которую вы примете.** Многие участники начинают с отчета об ошибке или небольшого исправления. Есть [много способов внести свой вклад](../how-to-contribute/#что-значит-внести-свой-вклад) в проект. Позвольте людям помочь так, как они хотят помочь.
* **Если есть предложение, с которым вы не согласны,** поблагодарите их за идею и [объясните, почему](../best-practices/#научитесь-говорить-нет) она не вписывается в рамки проекта, дав ссылку на соответствующую документацию, если она у вас есть.

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/mikeal?s=180" class = "pquote-avatar" alt = "avatar">
  Некоторым легче внести свой вклад в развитие открытого исходного кода, чем другим. Есть много опасений, что на них будут кричать за то, что они делают что-то неправильно или просто не подходят. (...) Предоставляя участникам возможность вносить свой вклад с очень низким уровнем технической подготовки (документация, разметка веб-контента и т. д.), вы можете значительно сократить эти проблемы.
  <p markdown = "1" class = "pquote-credit">
— @mikeal, [«Расширение базы участников в современном открытом исходном коде»](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Большинство участников открытого исходного кода являются «случайными»: людьми, которые вносят свой вклад в проект лишь от случая к случаю. У случайного участника может не быть времени, чтобы полностью освоить ваш проект, поэтому ваша задача - упростить для него участие.

Поощрение других участников - тоже вложение в себя. Когда вы позволяете своим самым большим поклонникам заниматься тем, чем они увлечены, становится меньше необходимости делать все самостоятельно.

### Документируйте все

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/janl?s=180" class = "pquote-avatar" alt = "avatar">
  Вы когда-нибудь были на (техническом) мероприятии, где вы никого не знали, но все остальные, казалось, собирались группами и болтали, как старые друзья? (...) Теперь представьте, что вы хотите внести свой вклад в проект с открытым исходным кодом, но вы не понимаете, почему и как это происходит.
  <p markdown = "1" class = "pquote-credit">
— @janl, [«Устойчивый открытый исходный код»](https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Когда вы начинаете новый проект, может показаться естественным сохранить конфиденциальность своей работы. Но проекты с открытым исходным кодом процветают, когда вы публично документируете свой процесс.

Когда вы что-то записываете, больше людей могут участвовать на каждом этапе пути. Вы можете получить помощь в том, о чем даже не подозревали.

Запись означает больше, чем просто техническая документация. Каждый раз, когда вы чувствуете желание записать что-то или обсудить свой проект в частном порядке, спросите себя, можете ли вы сделать это публично.

Будьте прозрачны в отношении дорожной карты вашего проекта, типов вкладов, которые вы ищете, того, как оцениваются вклады, или почему вы приняли определенные решения.

Если вы заметили, что несколько пользователей сталкиваются с одной и той же проблемой, задокументируйте ответы в README.

Для встреч рассмотрите возможность публикации заметок или выводов по актуальному вопросу. Отзывы, которые вы получите от такого уровня прозрачности, могут вас удивить.

Документирование всего относится и к вашей работе. Если вы работаете над существенным обновлением своего проекта, поместите его в пул-реквест и отметьте как незавершенное (WIP). Таким образом, другие люди могут почувствовать себя вовлеченными в процесс на ранней стадии.

### Будьте отзывчивы

По мере того, как вы [продвигаете свой проект](../finding-users), люди будут получать от вас обратную связь. У них могут быть вопросы о том, как все работает, или им может потребоваться помощь для начала работы.

Постарайтесь оперативно реагировать, когда кто-то задаёт вопрос, отправляет запрос на перенос или задает вопрос о вашем проекте. Если вы ответите быстро, люди почувствуют себя участниками диалога и будут с большим энтузиазмом участвовать.

Даже если вы не можете сразу просмотреть запрос, заблаговременное признание его поможет повысить вовлеченность. Вот как @tdreyno ответил на пул-реквест в [Middleman](https://github.com/middleman/middleman/pull/1466):

![Пул-ревест Middleman](/assets/images/building-community/middleman_pr.png)

[Исследование Mozilla показало, что](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) участники, чей код проверили в течение 48 часов, чаще возвращались и делали повторный вклад.

Разговоры о вашем проекте также могут происходить в других местах в Интернете, таких как Stack Overflow, Twitter или Reddit. Вы можете настроить уведомления в некоторых из этих мест, чтобы получать их, когда кто-то упоминает ваш проект.

### Дайте вашему сообществу место для собраний

Есть две причины, чтобы дать вашему сообществу место для собраний.

Первая причина для них. Помогите людям узнать друг друга. Люди с общими интересами неизбежно захотят об этом поговорить. А когда общение открыто и доступно, любой может прочитать прошлые архивы, чтобы быть в курсе и начать участвовать.

Вторая причина для вас. Если вы не предоставите людям публичное место для обсуждения вашего проекта, они, скорее всего, свяжутся с вами напрямую. Вначале может показаться достаточно простым ответить на личные сообщения «только один раз». Но со временем, особенно если ваш проект станет популярным, вы почувствуете себя истощенным. Не поддавайтесь искушению поговорить с людьми о своем проекте наедине. Вместо этого направьте их на назначенный общедоступный канал.

Публичное общение может быть таким же простым, как указание людям открыть проблему вместо того, чтобы писать вам напрямую или комментировать ваш блог. Вы также можете настроить список рассылки или создать учетную запись Twitter, Slack или IRC-канал, чтобы люди говорили о вашем проекте. Или попробуйте все вышеперечисленное!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) каждые две недели выделяет рабочие часы, чтобы помочь участникам сообщества:

> Копы также выделяют время раз в две недели, чтобы предложить помощь и руководство сообществу. Сопровождающие Копов согласились выделить время, специально предназначенное для работы с новичками, помощи с PR и обсуждения новых функций.

Заметными исключениями из публичного общения являются: 1) проблемы безопасности и 2) конфиденциальные нарушения кодекса поведения. У вас всегда должна быть возможность сообщить об этих проблемах в частном порядке. Если вы не хотите использовать свою личную электронную почту, создайте специальный адрес электронной почты.

## Развитие вашего сообщества

Сообщества чрезвычайно сильны. Эта сила может быть благословением или проклятием, в зависимости от того, как вы ею владеете. По мере роста сообщества вашего проекта есть способы помочь ему стать силой созидания, а не разрушения.

### Не терпите плохих участников

Любой популярный проект неизбежно привлечет людей, которые скорее вредят, чем помогают вашему сообществу. Они могут начать ненужные споры, спорить о тривиальных особенностях или запугивать других.

Сделайте все возможное, чтобы принять политику нулевой терпимости по отношению к этим типам людей. Если оставить это без внимания, негативные люди создадут дискомфорт другим людям в вашем сообществе. Которые могут даже уйти.

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/okdistribute?s=180" class = "pquote-avatar" alt = "avatar">
  Правда в том, что наличие поддерживающего сообщества является ключевым моментом. Я бы никогда не справилась с этой работой без помощи моих коллег, дружелюбных незнакомцев в Интернете и болтливых каналов IRC. (...) Не соглашайтесь на меньшее. Не соглашайтесь на придурков.
  <p markdown = "1" class = "pquote-credit">
— @okdistribute, [«Как запустить проект с открытым исходным кодом»](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Регулярные дебаты о тривиальных аспектах вашего проекта отвлекают других, в том числе вас, от сосредоточения на важных задачах. Новые люди, которые приходят на ваш проект, могут видеть эти разговоры и не хотят участвовать.

Когда вы видите негативное поведение в своем проекте, объявите об этом публично. Объясните добрым, но твердым тоном, почему их поведение неприемлемо. Если проблема не исчезнет, вам может потребоваться [попросить их уйти](../code-of-conduct/#обеспечение-соблюдения-вашего-кодекса-поведения). Ваш [кодекс поведения](../code-of-conduct/) может быть конструктивным руководством для таких разговоров.

### Познакомьтесь с участниками там, где они есть

Хорошая документация становится только важнее по мере роста вашего сообщества. Случайные участники, которые иначе могут не быть знакомы с вашим проектом, читают вашу документацию, чтобы быстро получить контекст, в котором они нуждаются.

В вашем файле CONTRIBUTING явным образом сообщите новым участникам, как начать работу. Возможно, вы даже захотите создать для этой цели специальный раздел. [Django](https://github.com/django/django), например, имеет специальную целевую страницу, чтобы приветствовать новых участников.

![Страница новых участников Django](/assets/images/building-community/django_new_contributors.png)

В очереди задач пометьте ошибки, которые подходят для разных типов участников: например, [_"только для новичков"_](https://kentcdodds.com/blog/first-timers-only), _"как составить первый вопрос"_, или _"документацию"_. [Эти ярлыки](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) упрощают быстрое сканирование ваших вопросов для новичков в вашем проекте, чтобы начать действовать.

Наконец, используйте свою документацию, чтобы люди чувствовали себя желанными на каждом этапе пути.

Вы никогда не будете взаимодействовать с большинством людей, которые попадают в ваш проект. Могут быть вклады, которые вы не получили, потому что кто-то испугался или не знал, с чего начать. Даже несколько добрых слов могут удержать кого-то от разочарования.

Например, вот как [Rubinius](https://github.com/rubinius/rubinius/) начинает [свое руководство](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Мы хотим начать с того, чтобы поблагодарить вас за использование Rubinius. Этот проект — плод любви, и мы ценим всех пользователей, которые вылавливают ошибки, улучшают производительность и помогают с документацией. Каждый вклад значим, поэтому спасибо за участие. При этом вот несколько рекомендаций, которым мы просим вас следовать, чтобы мы могли успешно решить вашу проблему.

### Совместное владение вашим проектом

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/sagesharp?s=180" class = "pquote-avatar" alt = "avatar">
  У ваших лидеров будут разные мнения, как и должно быть у всех здоровых сообществ! Однако вам необходимо предпринять шаги для обеспечения того, чтобы самый громкий голос не всегда побеждал, утомляя людей, и чтобы были слышны менее заметные голоса и голоса меньшинства.
  <p markdown = "1" class = "pquote-credit">
- @sagesharp, [«Что делает сообщество хорошим?»](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Люди рады вносить свой вклад в проекты, когда они чувствуют свою причастность. Это не значит, что вам нужно изменить видение своего проекта или принимать нежелательные вклады. Но чем больше вы доверяете другим, тем больше они остаются с вами.

Посмотрите, сможете ли вы найти способы как можно больше поделиться собственностью со своим сообществом. Вот несколько идей:

* **Не поддавайтесь исправлению простых (некритических) ошибок.** Вместо этого используйте их как возможности для привлечения новых участников или наставничества тех, кто хотел бы внести свой вклад. Сначала это может показаться неестественным, но со временем ваши вложения окупятся. Например, @michaeljoseph попросил участника отправить пул-реквест по проблеме [Cookiecutter](https://github.com/audreyr/cookiecutter), а не исправлять ее самому.

![Проблема с Cookiecutter](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Запустите файл CONTRIBUTORS или AUTORS в своем проекте**, в котором перечислены все, кто внес свой вклад в ваш проект, как, например, [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md).

* Если у вас большое сообщество, **разошлите информационный бюллетень или напишите сообщение в блоге** с благодарностью участникам. [This Week in Rust](https://this-week-in-rust.org/) от Rust и [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) от Hoodie — два хороших примера.

* **Предоставьте каждому участнику доступ к коммитам.** @felixge обнаружил, что это заставило людей [с большим энтузиазмом оттачивать свои патчи](https://felixge.de/2013/03/11/the-pull-request-hack.html), и он даже нашел новых сопровождающих для проектов, над которыми давно не работал.

* Если ваш проект размещен на GitHub, **переместите его из своей личной учетной записи в [Организацию](https://help.github.com/articles/creating-a-new-organization-account/)** и добавьте хотя бы одного резервного администратора. Организации упрощают работу над проектами с внешними соавторами.

Реальность такова, что [в большинстве проектов есть](https://peerj.com/preprints/1233/) один или два сопровождающих, которые делают большую часть работы. Чем крупнее ваш проект и чем больше ваше сообщество, тем легче найти помощь.

Хотя вы не всегда можете найти кого-то, кто ответит на призыв, подача сигнала увеличивает шансы, что другие люди вмешаются. И чем раньше вы начнете, тем скорее люди смогут помочь.

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/gr2m?s=180" class = "pquote-avatar" alt = "avatar">
  \[В ваших\] интересах набирать участников, которым нравится и которые способны делать то, что вам не нравится. Вам нравится писать код, но вы не любите отвечать на вопросы? Определите людей в вашем сообществе, которые это делают, и дайте им это.
  <p markdown = "1" class = "pquote-credit">
— @gr2m, [«Дружелюбные сообщества»](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Разрешение конфликтов

На ранних стадиях проекта легко принимать важные решения. Когда вы хотите что-то сделать, вы просто делаете это.

По мере того, как ваш проект становится более популярным, все больше людей будут интересоваться вашими решениями. Даже если у вас нет большого сообщества участников, если у вашего проекта много пользователей, вы найдете людей, которые взвешивают решения или поднимают собственные проблемы.

По большей части, если вы создали дружелюбное, уважительное сообщество и открыто задокументировали свои процессы, ваше сообщество должно найти решение. Но иногда вы сталкиваетесь с проблемой, которую немного сложнее решить.

### Установите планку доброты

Когда ваше сообщество борется с трудной проблемой, может подняться накал страстей. Люди могут рассердиться или расстроиться и обидеться друг на друга или на вас.

Ваша задача как сопровождающего — не допустить обострения подобных ситуаций. Даже если у вас есть твердое мнение по теме, постарайтесь занять позицию модератора или фасилитатора, вместо того, чтобы вступать в борьбу и продвигать свои взгляды. Если кто-то ведет себя недоброжелательно или монополизирует беседу, [действуйте немедленно](../building-community/#не-терпите-плохих-участников), чтобы обсуждение было вежливым и продуктивным.

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/kennethreitz?s=180" class = "pquote-avatar" alt = "avatar">
  Сопровождающему проекта, чрезвычайно важно относиться с уважением к своим участникам. Они часто принимают то, что вы говорите, очень близко к сердцу.
  <p markdown = "1" class = "pquote-credit">
— @kennethreitz, [«Будьте сердечны или идите своим путем»](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Другие люди ждут от вас совета. Подавайте хороший пример. Вы по-прежнему можете выражать разочарование, несчастье или беспокойство, но делайте это спокойно.

Сохранять хладнокровие непросто, но демонстрация лидерства улучшает здоровье вашего сообщества. Интернет благодарит вас.

### Относитесь к README как к конституции

Ваш README — это [больше, чем просто набор инструкций](../starting-a-project/#написание-readme). Это также место, где можно поговорить о ваших целях, видении продукта и планах развития. Если люди слишком сосредоточены на обсуждении достоинств той или иной функции, возможно, будет полезно вернуться к README и поговорить о более высоком видении вашего проекта. Сосредоточение внимания на README также обезличивает разговор, поэтому вы можете вести конструктивное обсуждение.

### Сосредоточьтесь на путешествии, а не на пункте назначения

В некоторых проектах для принятия важных решений используется процесс голосования. Хотя на первый взгляд это выглядит разумно, голосование делает упор на поиске «ответа», а не на том, чтобы выслушивать и решать проблемы друг друга.

Голосование может стать политическим, когда участники сообщества чувствуют давление, оказывая друг другу услуги или проголосовав определенным образом. Не все голосуют, будь то [молчаливое большинство](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) в вашем сообществе или пользователи, которые не знали, что проходит голосование.

Иногда голосование является необходимым условием разрешения конфликтов. Однако, насколько вы можете, сделайте упор на [«поиске консенсуса»](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making), а не на консенсусе.

В процессе поиска консенсуса члены сообщества обсуждают основные проблемы до тех пор, пока не почувствуют, что их должным образом выслушали. Когда остаются лишь незначительные проблемы, сообщество движется вперед. «Поиск консенсуса» признает, что сообщество может не прийти к идеальному ответу. Вместо этого он отдает приоритет слушанию и обсуждению.

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/lee-dohm?s=180" class = "pquote-avatar" alt = "avatar">
  Отчасти причина того, что система голосования не применяется для проблем Atom, заключается в том, что команда Atom не собирается следовать системе голосования во всех случаях. Иногда нам приходится выбирать то, что мы считаем правильным, даже если это непопулярно. (...) Что я могу предложить и обещаю сделать... так это то, что моя работа — слушать сообщество.
  <p markdown = "1" class = "pquote-credit">
— @lee-dohm о процессе принятия решений в Atom
  </p>
</aside>

Даже если вы на самом деле не применяете процесс поиска консенсуса, как сопровождающий проекта, важно, чтобы люди знали, что вы их слушаете. Заставить других почувствовать себя услышанными и что вы стараетесь разрешить их проблемы в значительной степени помогает избавиться от деликатных ситуаций. Затем подкрепите свои слова действиями.

Не торопитесь с решением ради разрешения. Убедитесь, что все чувствуют себя услышанными и что вся информация предана гласности, прежде чем переходить к решению.

### Сосредоточьте разговор на действии

Обсуждение важно, но есть разница между продуктивным и непродуктивным разговором.

Поощряйте обсуждение, пока оно активно движется к разрешению. Если ясно, что разговор вялится или уходит не по теме, уколы становятся личными или люди придираются к мелочам, пора его закрыть.

Продолжение этих разговоров плохо не только для решения рассматриваемой проблемы, но и для здоровья вашего сообщества. Он посылает сообщение о том, что такие разговоры разрешены или даже поощряются, и может оттолкнуть людей поднимать или решать будущие проблемы.

С каждым замечанием, сделанным вами или другими, спрашивайте себя: _"Как это приближает нас к решению?"_

Если разговор начинает распадаться, спросите группу: _«Какие шаги мы должны предпринять дальше?»_, чтобы переориентировать разговор.

Если разговор явно никуда не придёт, нет четких действий, которые нужно предпринять, или соответствующие действия уже были предприняты, закройте проблему и объясните, почему вы ее закрыли.

<aside markdown = "1" class = "pquote">
  <img src = "https://avatars.githubusercontent.com/kfogel?s=180" class = "pquote-avatar" alt = "avatar">
  Направлять нить к полезности без навязчивости - это искусство. Не сработает просто увещевать людей перестать тратить свое время или просить их не публиковать сообщения, если у них нет чего-то конструктивного. (...) Вместо этого вы должны предложить условия для дальнейшего прогресса: дать людям маршрут, путь, по которому следует следовать, который приведет к желаемым результатам, но чтобы это не звучало, будто вы диктуете поведение.
  <p markdown = "1" class = "pquote-credit">
— @kfogel, [_Proroduction OSS_](https://produdingoss.com/en/produdingoss.html#common-pitfalls)
  </p>
</aside>

### Выбирайте битвы с умом

Контекст важен. Подумайте, кто участвует в обсуждении и как они представляют остальную часть сообщества.

Все ли в сообществе расстроены или вовлечены в эту проблему? Или это одинокий нарушитель спокойствия? Не забывайте принимать во внимание молчаливых членов вашего сообщества, а не только активные голоса.

Если проблема не отражает более широкие потребности вашего сообщества, возможно, вам просто нужно признать озабоченность нескольких человек. Если это повторяющаяся проблема без четкого решения, укажите на предыдущие обсуждения по этой теме и закройте ветку.

### Определите, кто разрешает конфликты в сообществе

При хорошем отношении и четком общении самые сложные ситуации разрешимы. Однако даже в продуктивной беседе могут просто быть разные мнения о том, как действовать дальше. В этих случаях определите человека или группу людей, которые могут решить проблему.

Решающим фактором может быть основной сопровождающий проекта или небольшая группа людей, которые принимают решение на основе голосования. В идеале вы определили средство разрешения конфликтов и связанный с ним процесс в файле GOVERNANCE, прежде чем вам когда-либо придется его использовать.

Тай-брейк должен быть последним средством. Спорные вопросы - это возможность для вашего сообщества расти и учиться. Воспользуйтесь этими возможностями и используйте совместный процесс, чтобы найти решение везде, где это возможно.

## Сообщество — это ❤️ открытого исходного кода

Здоровые и процветающие сообщества каждую неделю тратят тысячи часов на разработку программного обеспечения с открытым исходным кодом. Многие участники указывают на других людей как на причину работы - или не работы - над открытым исходным кодом. Узнав, как использовать эту силу конструктивно, вы поможете кому-то получить незабываемый опыт работы с открытым исходным кодом.
