---
lang: ru
title: Хорошие практики для мейнтейнеров
description: Облегчение вашей жизни в качестве мейнтейнера опенсорс-проекта — от документирования процессов до привлечения вашего сообщества.
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## Что значит быть мейнтейнером?

Если вы поддерживаете опенсорс-проект, которым пользуется множество людей, возможно, вы заметили, что стали меньше писать код и больше отвечать на ишью.

На ранних стадиях проекта вы экспериментируете с новыми идеями и принимаете решения, основываясь на собственных предпочтениях. По мере роста популярности вашего проекта вы будете больше работать со своими пользователями и контрибьюторами.

Для поддержки проекта требуется нечто большее, чем просто код. Эти задачи часто бывают неожиданными, но они не менее важны для растущего проекта. Мы собрали несколько способов облегчить вашу жизнь — от документирования процессов до привлечения вашего сообщества.

## Документирование процессов

Как мейнтейнеру вам предстоит много писать, — это одна из наиболее главных ваших задач.

Документация не только проясняет вашу голову, но и помогает другим людям понять, что вам нужно или чего вы ждете, еще до того, как они спросят.

На письме легче сказать «нет», когда что-то не вписывается в рамки проекта. Это также поможет людям присоединиться и помочь вам. Ведь никогда не знаешь, кто может интересоваться или использовать ваш проект.

Даже если вы не собираетесь писать много текста, наброска с основными тезисами будет вполне достаточно, по крайней мере это лучше, чем ничего.

Не забывайте обновлять документацию. Если не всегда получается это сделать, удалите устаревшую документацию или укажите, что она устарела, таким образом участники могут помочь с этим.

### Запишите видение проекта

Начните с составления целей вашего проекта. Добавьте их в свой README или создайте отдельный файл с именем VISION. Если есть другая похожая информация, которая может помочь, например план развития (дорожная карта) проекта, то также сделайте их общедоступными.

Наличие четкого и задокументированной концепции проекта поможет вам сосредоточиться на главном и избежать «неконтролируемого роста проекта» от участия других людей.

Например, @lord обнаружил, что видение проекта помогло ему понять правильно расставить приоритеты. Как новый мейнтейнер, он сожалел, что не проследил за расползанием границ проекта, когда получил свой первый запрос на реализацию новой функциональности в [Slate](https://github.com/lord/slate).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  Я не справился. Я не приложил достаточно усилий, чтобы найти полное решение. Вместо половинчатого решения мне нужно было бы сказать: «У меня сейчас нет на это времени, но я добавлю его в список пожеланий».
  <p markdown="1" class="pquote-credit">
- @lord, [«Советы новым опенсорс-мейнтейнерам»](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### Сообщите о своих ожиданиях

Написание правил может утомлять вас. Иногда вам может показаться, что вы следите за поведением других людей или убиваете все веселье.

Однако справедливое выполнение хорошо составленных правил расширяют возможности мейнтейнеров. Это избавит вас от вовлечения в малоприятные дела.

Большинство людей, сталкивающиеся с вашим проектом, ничего не знают о вас или ваших обстоятельствах. Они могут предположить, что вам платят за работу над проектом, особенно если они его регулярно используют и полагаются на него. Может быть, когда-то вы уделили много времени своему проекту, но теперь заняты новой работой или семейными занятиями.

Всё это абсолютно нормально! Только дайте знать об этом другим людям.

Если вы занимаетесь проектом нерегулярно или на добровольных началах, честно признайте, сколько у вас есть времени. Не стоит путать имеющиеся у вас время и время, которое, по вашему мнению, требуется для проекта или от вас ожидают другие.

Вот несколько правил, которые стоит установить:

* Как рассматривается и принимается вклад (_Нужно ли написать тесты? Шаблон ишью?_)
* Типы вкладов, которые вы принимаете (_Вам нужна помощь только с определенной частью вашего кода?_)
* Когда следует предпринять последующие действия (_например, «Вы можете ожидать ответа от мейнтейнера в течение 7 дней. Если после этого времени вы не получили ответ, не стесняйтесь поднимать тему»._)
* Сколько времени вы тратите на проект (_например, «Мы тратим на этот проект всего около 5 часов в неделю»_)

[Jekyll](https://github.com/jekyll/jekyll/tree/master/docs), [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules) и [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) — это лишь несколько примеров проектов с основными правилами для мейнтейнеров и контрибьюторов.

### Поддерживайте публичность обсуждений

Не забывайте также фиксировать свои беседы. Там, где это возможно, делитесь информацией о своем проекте публично. Если кто-то пытается связаться с вами напрямую, чтобы обсудить реализацию новой функциональности или получить помощь, вежливо направьте его на общедоступный канал связи, такой как список рассылки или ишью.

Если вы встречаетесь с другими мейнтейнерами или принимаете важное решение в частном порядке, записывайте всё, даже если это просто публикация ваших заметок.

Таким образом, любой, кто присоединится к вашему сообществу, будет иметь доступ к той же информации, что и тот, кто был там годами.

## Научитесь говорить «нет»

Вы всё записали. В идеальном мире все бы прочитали документацию, но вот только в реальности вам придется напоминать людям об её существовании.

Однако ссылка на письменные объяснения поможет обезличить ситуации, когда нужно обеспечить соблюдение правил.

Также сам отказ следует сделать как можно менее личным, например, вместо  _«Мне не нравится ваш вклад»_ намного лучше написать _«Ваш вклад не соответствует критериям этого проекта»_.

Отказывать применимо во многих ситуациях, с которыми вы столкнетесь как мейнтейнер, например, когда кто-то просит реализовать новую функциональность, которая не вписывается в проект, или мешает обсуждению, либо выполняет ненужную для других работу.

### Поддерживайте дружескую беседу

Как правило, в ишью и пул-реквестах вы будете практиковаться отказывать людям. Как мейнтейнер проекта, вы неизбежно будете получать ненужные предложения.

Возможно вклад сильно меняет суть проекта или не соответствует вашему видению. Может идея хорошая, но реализация оставляет желать лучшего.

Независимо от причины, нужно с пониманием относится к предлагаемым изменениям, которые не соответствуют стандартам вашего проекта.

Если видите вклад, который не собираетесь принимать, первой реакцией может быть проигнорировать его или притвориться, что его нет. Однако это может обидеть автора, и даже демотивировать потенциальных контрибьюторов.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  Ключ к поддержке крупномасштабных опенсорс-проектов — это постоянное решение ишью. Старайтесь избегать простаивания ишью. Если вы iOS-разработчик, вы знаете, как может быть неприятно отправлять сообщение об ошибке в баг-трекер Apple. Вам могут ответить спустя 2 года, и предложат повторить всё сначала, только используя последнюю версию iOS.
  <p markdown="1" class="pquote-credit">
- @KrauseFx, [«Масштабирование опенсорс-сообществ»](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

Не оставляйте ненужным вклад открытым из-за чувства вины или вежливости. Со временем все оставшиеся без ответа ишью и PR только усложнят и замедлят вашу работу над проектом.

Если вы понимаете, что не сможете принять вклад, лучше сразу его закройте. Если в вашем проекте уже накопилось большое количество нерассмотренных заявок, у @steveklabnik есть предложения по [эффективной сортировке ишью](https://words.steveklabnik.com/how-to-be-an-open-source-gardener).

Кроме того, игнорирование вкладов оказывает отрицательное воздействие на ваше сообщество. Участие в проекте может быть пугающим, особенно в первый раз. Даже если вы не собираетесь принимать вклад, поблагодарите его автора за проявленный интерес. Это большой комплимент!

Если вы не хотите принимать вклад:

* **Поблагодарите автора** за работу
* **Объясните, почему он вписывается** в рамки проекта, и, если можете, подготовьте четкие предложения по улучшению. Будьте добрым, но строгим.
* **Прикрепите ссылку на соответствующую документацию**, если она у вас есть. Если вы замечаете повторяющиеся нежелательные пул-реквесты, напишите об этом в документации.
* **Закройте пул-реквест**

Для ответа достаточно будет 1-2 предложений. Например, когда пользователь [celery](https://github.com/celery/celery/) сообщил об ошибке, связанной с Windows, @berkerpeksag [ответил](https://github.com/celery/celery/issues/3383):

![Скриншот из Celery](/assets/images/best-practices/celery.png)

Если мысль о том, чтобы сказать «нет», пугает вас, вы не одиноки. Как [выразился](https://blog.jessfraz.com/post/the-art-of-closing/) @jessfraz:

> Я разговаривал с мейнтейнерами из нескольких различных опенсорс-проектов, Mesos, Kubernetes, Chromium, и все они согласны с тем, что одна из самых сложных частей работы мейнтейнера — это отказаться от ненужных патчей.

Не чувствуйте себя виноватым из-за того, что не хотите принимать чей-то вклад. Первое правило опенсорса, [согласно](https://twitter.com/solomonstre/status/715277134978113536) @shykes: _«Нет — временно, да — навсегда»._ Сочувствовать энтузиазму другого человека - это хорошо, отказываться от его вклада — не значит отвергать его автора.

В конечном итоге, если вклад недостаточно хорош, вы не обязаны его принимать. Будьте добры и отзывчивы, когда люди вносят свой вклад в ваш проект, но принимайте только те изменения, которые, по вашему мнению, сделают ваш проект лучше. Чем чаще вы будете говорить «нет», тем легче будет это получаться. Обещаю.

### Будьте инициативным(ой)

Прежде всего, чтобы уменьшить количество нежелательных вкладов, распишите процесс отправки и принятия вкладов в своем руководстве по участию вашего проекта.

Если вам приходят слишком много некачественных вкладов, потребуйте от контрибьюторов выполнить ряд условий, например:

* Заполнить шаблон/контрольный список для в ишью или пул-реквесте
* Открыть ишью перед отправкой пул-реквеста

Если люди не соблюдают ваши правила, немедленно закройте ишью и укажите им на предварительные требования.

Поначалу такой подход может показаться суровым, но на самом деле проактивность полезна для обеих сторон. Это снижает вероятность того, что кто-то потратит впустую много часов работы на ненужный для вас пул-реквест. А ещё для вас снизится нагрузка.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  По-хорошему, в файле CONTRIBUTING.md объясните людям, как они могут получить в будущем лучшее представление о том, что будет или не будет принято, до того, как они начнут работу.
  <p markdown="1" class="pquote-credit">
- @MikeMcQuaid, [«Любезно завершающие запросы на включение»](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

Иногда, когда вы говорите «нет», потенциальный контрибьютор может расстроиться или раскритиковать ваше решение. Если его поведение становится враждебным, [примите меры, чтобы разрядить ситуацию](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) или даже удалите его из вашего сообщества, если он не готов к конструктивному сотрудничеству.

### Примите наставничество

Возможно, кто-то из вашего сообщества регулярно отправляет вклады, не соответствующие стандартам вашего проекта. Не только автор, но мейнтейнер может быть разочарован, если постоянно приходится отказывать в принятии вклада.

Если вы видите, что кто-то с энтузиазмом подходит к вашему проекту, но его работа требует доработки, будьте терпеливы. Четко объясните в каждой ситуации, почему их вклад не соответствует ожиданиям проекта. Попробуйте предложить людям более легкую или менее расплывчатую задачу, например, ишью с ярлыком _"good first issue"_, чтобы набраться опыта и попробовать себя. Если у вас есть время, подумайте о наставничестве в их первом вкладе, или найдите кого-нибудь в вашем сообществе, кто согласился стать ментором.

## Используйте силу сообщества

Необязательно все делать самому. Сообщество вашего проекта существует не просто так! Даже если у вас еще нет активных контрибьюторов, но зато есть много пользователей, попробуйте привлечь их.

### Распределите рабочую нагрузку

Если вы ищете, кто мог бы помочь, начните с расспросов.

Один из способов привлечь новых контрибьюторов — [добавить ярлык на те ишью, которые достаточно просты для начинающих](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). Затем GitHub будет отображать их в различных местах сайта, делая тем самым их более заметными.

Когда вы видите, что новые контрибьюторы неоднократно вносят свой вклад, признайте их работу, предложив больше ответственности. Задокументируйте, как люди могут занять руководящие роли, если захотят.

Побуждение других [разделить владение проектом](../building-community/#совместное-владение-вашим-проектом) может значительно снизить вашу нагрузку, как обнаружила @lmccart в своем проекте [p5.js](https://github.com/processing/p5.js).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  Я говорила: «Да, любой может поучаствовать, не обязательно обладать большим опытом программирования [...]». У нас были люди, которые записывались, чтобы прийти [на мероприятие], и тогда я по-настоящему задумалась: справлюсь ли с я этим? Собирается прийти 40 человек, и я не могу сидеть с каждым из них... Но люди собрались вместе, и вроде всё прошло хорошо. Как только один человек понимал что-то, он мог научить своего соседа.
  <p markdown="1" class="pquote-credit">
- @lmccart, [«Что вообще означает «опенсорс»? P5.js Edition»](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

Если вам нужно отойти от проекта, будь то сделать перерыв или навсегда покинуть его, нет ничего постыдного в том, чтобы попросить кого-то другого взять на себя ваши обязанности.

Если другие люди полны энтузиазма относительно направления развития проекта, предоставьте им доступ к отправке коммитов или официально передайте контроль кому-то другому. Если кто-то форкнул ваш проект и начал активно заниматься его копией, подумайте о том, чтобы указать ссылку на него в уже вашем (оригинальном) проекте. Здорово, что так много людей хотят, чтобы ваш проект продолжал развиваться!

@progrium [обнаружил, что](https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/) документирование видения его проекта [Dokku](https://github.com/dokku/dokku) помогло достичь этих целей даже после того, как он ушел из проекта:

> Я написал вики-страницу с описанием того, что я хотел сделать и почему. Почему-то для меня стало неожиданностью, что мейнтейнеры начали двигать проект в этом направлении! Всё происходило именно так, как я хотел? Не всегда. Но все же приблизило проект к тому, что я написал.

### Позвольте другим создавать нужные им решения

Если потенциальный контрибьютор придерживается другого мнения, что должен делать ваш проект, вы можете мягко подтолкнуть его к работе над собственным форком.

Не следует воспринимать копии проекта чем-то плохим. Возможность копировать и изменять проекты — одна из лучших особенностей опенсорса. Содействие членов вашего сообщества к работе над собственным форком может дать им необходимую творческую отдушину, без ущерба вашему проекту.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  Я стремлюсь к покрытию 80% потребностей. Если вы один из единорогов, пожалуйста, ответвите мою работу. Я не обижусь! Мои публичные проекты почти всегда предназначены для решения самых распространенных проблем; я стараюсь сделать так, чтобы было легче углубиться, либо путём форка моей работы, либо расширив её.
  <p markdown="1" class="pquote-credit">
- @geerlingguy, [«Почему я закрываю пул-реквесты](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

То же самое относится к пользователю, которому действительно нужно решение, но для создания которого у вас просто нет ресурсов. Предлагая API-интерфейсы и хуки для кастомизации, можно помочь другим пользователям решить их задачи без необходимости напрямую изменять исходный код. @orta [обнаружил, что](https://artsy.github.io/blog/2016/07/03/handling-big-projects/) поощрение плагинов для CocoaPods привело к «некоторым из самых интересных идей»:

> Почти неизбежно, что когда проект становится большим, мейнтейнеры должны стать более консервативными касательно нового кода. Вы научитесь отказывать, несмотря, что у многих людей есть разумные причины. Так что в итоге вы превращаете свой инструмент в платформу.

## Задействуйте роботов

Подобно тому, как есть задачи, с которыми вам могут помочь другие люди, так и есть задачи, которые не должен выполнять ни один человек. Роботы — ваши друзья. Используйте их, чтобы облегчить себе жизнь в качестве мейнтейнера.

### Требуйте тесты и другие проверки для улучшения качества кода

Один из наиболее важных способов автоматизации проекта — это написание тестов.

Тесты помогают участникам чувствовать себя уверенно в том, что в результате новых изменений ничего не было сломано. Они также облегчают рассмотрение и принятие вкладов. Чем активнее вы будете реагировать, тем более заинтересованным может быть ваше сообщество.

Настройте автотесты, которые будут запускаться на всех входящих вкладов, и убедитесь, что они могут быть выполнены контрибьюторами локально. Требуйте, чтобы весь код от контрибьюторов проходил тесты, до того, как они отправлять сам вклад. Вы поможете установить минимальный стандарт качества для всех отправляемых вкладов. [Обязательные проверки статуса](https://help.github.com/articles/about-required-status-checks/) на GitHub помогут проследить за тем, что никакие изменения не будут объединены без прохождения тестов.

Если вы добавляете тесты, обязательно объясните, как они работают в файле CONTRIBUTING.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  Я считаю, что тесты необходимы для всего кода, над которым работают люди. Если бы код был полностью и совершенно правильным, он не нуждался бы в изменениях — мы пишем код только тогда, когда с ним что-то не так, например, обнаружен баг или отсутствует нереализованная функциональность. И независимо от того, какие изменения вы вносите, тесты необходимы для выявления любых регрессий, которые вы можете случайно допустить.
  <p markdown="1" class="pquote-credit">
- @edunham, [«Автоматизация сообщества Rust»](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### Используйте инструменты для автоматизации основных задач сопровождения

Что хорошо в поддержке популярного проекта, так это то, что другие мейнтейнеры, вероятно, сталкивались с аналогичными проблемами и решили их.

Существует [множество инструментов](https://github.com/showcases/tools-for-open-source), которые помогают автоматизировать некоторые аспекты работ по сопровождению. Несколько примеров:

* [semantic-release](https://github.com/semantic-release/semantic-release) автоматизирует ваши релизы
* [mention-bot](https://github.com/facebook/mention-bot) упоминает потенциальных ревьюеров для пул-реквеста
* [Danger](https://github.com/danger/danger) помогает автоматизировать проверку кода
* [no-response](https://github.com/probot/no-response) закрывает ишью, если автор не предоставил дополнительную информацию
* [dependabot](https://github.com/dependabot) ежедневно следует за актуальностью зависимостей, и если находит что-то новое, то открывает отдельные пул-реквесты

Для сообщений об ошибках и других общих проблем на GitHub есть [шаблоны для ишью и пул-реквеста](https://github.com/blog/2111-issue-and-pull-request-templates), которые можно создать для упрощения взаимодействия с сообществом. @TalAter создал [руководство Choose Your Own Adventure](https://www.talater.com/open-source-templates/#/), чтобы помочь вам написать собственные шаблоны ишью и пул-реквеста.

Для управления уведомлениями по электронной почте вы можете настроить [фильтры электронной почты](https://github.com/blog/2203-email-updates-about-your-own-activity), чтобы отсортировать их по приоритету.

Если вы хотите ещё немного продвинуться, руководства по стилю и линтеры помогут стандартизировать вклады в проект и упростить их просмотр и принятие.

Однако, если ваши стандарты слишком сложные, они могут увеличить препятствия на пути к участию. Убедитесь, что вы добавляете только необходимые правила, чтобы облегчить всем жизнь.

Если вы не знаете, какие инструменты использовать, посмотрите на опыт других популярных проектов, особенно в вашей экосистеме. Например, как выглядит процесс участия в других модулей Node? Использование похожих инструментов и подходов также сделает ваш процесс более знакомым для потенциальных контрибьюторов.

## Взять паузу — это нормально

Когда-то опенсорс-работа приносила вам радость. А возможно теперь вы начинаете чувствовать себя виноватым или не идите на контакт.

Возможно, вы чувствуете себя разбитым или вас не покидает растущее чувство страха, когда думаете о своих проектах. А между тем ишью и пул-реквесты накапливаются.

Выгорание — реальная и распространенная проблема при работе над опенсорсом, особенно среди мейнтейнеов. Ваше счастье как мейнтейнера — непреложное условие для выживания любого опенсорс-проекта.

Хотя это само собой разумеется, но делайте перерыв! Не нужно ждать, пока вы почувствуете выгорание, чтобы взять отпуск. @brettcannon, разработчик ядра Python, решил взять [отпуск на месяц](https://snarky.ca/why-i-took-october-off-from-oss-volunteering/) после 14 лет волонтерской работы в опенсорсе.

Как и любой другой вид работы, регулярные перерывы позволяют вам оставаться бодрым, счастливым и увлечённым своей работой.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  Поддерживая WP-CLI, я обнаружил, что мне нужно сначала сделать себя счастливым, и установить четкие границы своего участия. Наилучший баланс, который я нашел, — это 2-5 часов в неделю из моего обычного рабочего графика. Таким образом я остаюсь увлечённым и не слишком перенапрягаюсь. Поскольку я расставляю приоритеты в ишью, над которыми работаю, я могу регулярно добиваться прогресса в том, что считаю наиболее важным.
  <p markdown="1" class="pquote-credit">
- @danielbachhuber, [«Мои соболезнования, теперь вы поддерживаете популярный опенсорс-проект»](https://runcommand.io/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

Иногда бывает трудно сделать перерыв в опенсорс-работе, когда кажется, что вы нужны всем. Люди могут даже попытаться заставить вас почувствовать себя виноватым за то, что вы временно отошли от дел.

Постарайтесь найти поддержку для своих пользователей и сообщества на время вашего отсутствия в проекте. Если вы не можете найти необходимую поддержку, всё равно возьмите паузу. Но обязательно предупредите людей об вашем отпуске, чтобы их не смущало отсутствие вашей реакции.

Перерывы относятся не только к отпуску. Если вы не хотите заниматься опенсорсом по выходным или в рабочее время, сообщите об этом людям, чтобы они знали, что вас не надо беспокоить.

## Береги себя в первую очередь!

Поддержка популярного проекта требует иных навыков, чем на ранних этапах развития, но это не уменьшает пользу описанных выше советов. Как мейнтейнер, вы будете практиковать лидерские и личные навыки на таком уровне, который мало кому удаётся испытать. Хотя управлять проектом не всегда легко, выстраивание чётких границ и адекватная оценка своих сил помогут вам оставаться счастливыми, бодрыми и продуктивными.
