---
lang: pt
title: Mantendo o Equilíbrio para Mantenedores de Código Aberto
description: Dicas para o autocuidado e evitar o esgotamento como mantenedor.
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

Com o crescimento de popularidade de projetos código aberto, se torna importante definir limites para te ajudar a equilibrar se manter motivado e produtivo ao longo do tempo.

Para obter insights sobre as experiências dos mantenedores e suas estratégias para encontrar equilíbrio, realizamos uma oficina com 40 membros da <a href="http://maintainers.github.com/">Comunidade de Mantenedores</a>, permitindo-nos aprender com suas experiências pessoais de esgotamento em código aberto e as práticas que os ajudaram a manter o equilíbrio em seu trabalho. É aqui que o conceito de ecologia pessoal entra em jogo.

Então, o que é a ecologia pessoal? Conforme <a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance%2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">descrito pelo Instituto de Liderança Rockwood</a>, envolve "<strong>manter o equilíbrio, o ritmo e a eficiência para sustentar nossa energia ao longo de uma vida</strong>." Isso moldou nossas conversas, ajudando os mantenedores a reconhecerem suas ações e contribuições como partes de um ecossistema maior que evolui ao longo do tempo. O esgotamento, uma síndrome resultante do estresse crônico no local de trabalho, conforme [definido pela OMS](https://icd.who.int/browse11/l-m/en#/http://id.who.int/icd/entity/129180281), não é incomum entre mantenedores. Isso frequentemente leva a uma perda de motivação, incapacidade de se concentrar e falta de empatia pelos colaboradores e comunidade com os quais você trabalha.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  Eu não conseguia me concentrar ou começar uma tarefa. Eu tinha uma falta de empatia pelos usuários.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, mantenedor do servidor de streaming ao vivo Owncast, sobre o impacto do esgotamento em seu trabalho de código aberto
  </p>
</aside>

Ao abraçar o conceito de ecologia pessoal, os mantenedores podem evitar o esgotamento de forma proativa, priorizar o autocuidado e manter um senso de equilíbrio para fazer o seu melhor trabalho.

## Dicas de Autocuidado e Prevenção do Esgotamento como Mantenedor:

### Identifique suas motivações para trabalhar em código aberto

Dedique um tempo para refletir sobre quais aspectos da manutenção em código aberto o energizam. Compreender suas motivações pode ajudá-lo a priorizar o trabalho de uma maneira que o mantenha envolvido e pronto para novos desafios. Seja o retorno positivo dos usuários, a alegria de colaborar e socializar com a comunidade ou a satisfação de mergulhar no código, reconhecer suas motivações pode ajudar a direcionar o seu foco.

### Reflita sobre o que causa desequilíbrio e estresse

É importante entender o que nos leva ao esgotamento. Aqui estão alguns temas comuns que encontramos entre mantenedores de código aberto:

* **Falta de feedback positivo:** Os usuários tendem a entrar em contato quando têm uma reclamação. Se tudo funciona bem, tendem a ficar em silêncio. Pode ser desanimador ver uma crescente lista de problemas sem o feedback positivo mostrando como suas contribuições fazem a diferença.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  Às vezes, parece um pouco como gritar no vazio e acho que o feedback realmente me energiza. Temos muitos usuários felizes, mas silenciosos.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>, mantenedor do Apache Arrow
  </p>
</aside>

* **Não dizer 'não':** Pode ser fácil assumir mais responsabilidades do que se deveria em um projeto de código aberto. Seja de usuários, colaboradores ou outros mantenedores, nem sempre podemos corresponder às expectativas deles.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
  Percebi que estava assumindo mais do que deveria e tendo que fazer o trabalho de várias pessoas, como comumente é feito em FOSS.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>, mantenedor do Termux, sobre o que causa o esgotamento em seu trabalho
  </p>
</aside>

* **Trabalhar sozinho:** Ser um mantenedor pode ser incrivelmente solitário. Mesmo se você trabalha com um grupo de mantenedores, os últimos anos têm sido difíceis para reunir equipes distribuídas pessoalmente.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  Especialmente desde a COVID e o trabalho em casa, é mais difícil nunca ver ninguém ou falar com ninguém.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, mantenedor do servidor de streaming ao vivo Owncast, sobre o impacto do esgotamento em seu trabalho de código aberto
  </p>
</aside>

* **Falta de tempo ou recursos:** Isso é especialmente verdade para mantenedores voluntários que têm que sacrificar seu tempo livre para trabalhar em um projeto.

<aside markdown="1" class="pquote">
  [Eu gostaria de ter] mais apoio financeiro, para que eu possa me concentrar no trabalho de código aberto sem esgotar minhas economias e sabendo que terei que fazer muitos contratos para compensar depois.
  <p markdown="1" class="pquote-credit">
— mantenedor de código aberto
  </p>
</aside>

* **Demandas conflitantes:** O código aberto é cheio de grupos com diferentes motivações, o que pode ser difícil de navegar. Se você é pago para fazer código aberto, os interesses de seu empregador às vezes podem entrar em conflito com a comunidade.

<aside markdown="1" class="pquote">
  Com código aberto pago, conflito entre o foco do empregador e o que é melhor para a comunidade.
  <p markdown="1" class="pquote-credit">
— mantenedor de código aberto
  </p>
</aside>

### Fique atento aos sinais de esgotamento

Você consegue manter seu ritmo por 10 semanas? 10 meses? 10 anos?

Existem ferramentas como a [Lista de Verificação de Esgotamento](https://governingopen.com/resources/signs-of-burnout-checklist.html) de [@shaunagm](https://github.com/shaunagm) que podem ajudá-lo a refletir sobre seu ritmo atual e ver se há ajustes que você pode fazer. Alguns mantenedores também usam tecnologia vestível para acompanhar métricas como qualidade do sono e variabilidade da frequência cardíaca (ambas ligadas ao estresse).

<aside markdown="1" class="pquote">
 Sou um grande defensor de dispositivos vestíveis de qualidade. Com a ciência por trás deles, você pode entender como poderia ter se saído melhor e como atingir um estado ideal do que deseja fazer.
  <p markdown="1" class="pquote-credit">
— mantenedor de código aberto
  </p>
</aside>

### O que você precisa para continuar sustentando a si mesmo e à sua comunidade?

Isso será diferente para cada mantenedor e mudará dependendo de sua fase de vida e outros fatores externos. Mas aqui estão alguns temas que ouvimos:

* **Conte com a comunidade:** Delegação e encontrar colaboradores podem aliviar a carga de trabalho. Ter vários pontos de contato para um projeto pode ajudar você a tirar uma folga sem preocupações. Conecte-se com outros mantenedores e a comunidade em geral – em grupos como a [Comunidade de Mantenedores](http://maintainers.github.com/). Isso pode ser uma ótima fonte de apoio mútuo e aprendizado.

  Você também pode procurar maneiras de se envolver com a comunidade de usuários, para ouvir regularmente feedback e entender o impacto de seu trabalho de código aberto.

* **Explore o financiamento:** Esteja você procurando um dinheiro extra para pizza ou tentando se dedicar integralmente ao código aberto, há muitos recursos disponíveis! Como primeiro passo, considere ativar [Patrocinadores do GitHub](https://github.com/sponsors) para permitir que outros patrocinem seu trabalho de código aberto. Se você está pensando em dar o salto para o tempo integral, inscreva-se para a próxima rodada do [GitHub Accelerator](http://accelerator.github.com/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
 Participei de um podcast há algum tempo e estávamos conversando sobre manutenção de código aberto e sustentabilidade. Descobri que mesmo um pequeno número de pessoas apoiando meu trabalho no GitHub me ajudou a tomar uma decisão rápida de não ficar na frente de um jogo, mas sim fazer uma pequena contribuição ao código aberto.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>, mantenedor do EmberJS
  </p>
</aside>

* **Use ferramentas:** Explore ferramentas como [GitHub Copilot](https://github.com/features/copilot/) e [GitHub Actions](https://github.com/features/actions/) para automatizar tarefas mundanas e liberar tempo para contribuições mais significativas.

<aside markdown="1" class="pquote">
 Use o [Copilot](https://github.com/features/copilot/) para as coisas chatas - faça as coisas divertidas
  <p markdown="1" class="pquote-credit">
— mantenedor de código aberto
  </p>
</aside>

* **Descanse e recarregue:** Reserve tempo para seus hobbies e interesses fora do código aberto. Tire os fins de semana para relaxar e rejuvenescer - e ajuste seu [status do GitHub](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status) para refletir sua disponibilidade! Uma boa noite de sono pode fazer uma grande diferença em sua capacidade de manter seus esforços a longo prazo.

  Se você encontrar certos aspectos de seu projeto particularmente agradáveis, tente estruturar seu trabalho de forma que você possa experimentá-los ao longo do dia.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class "pquote-avatar" alt="avatar">
 Estou encontrando mais oportunidade para espalhar 'momentos de criatividade' no meio do dia, em vez de tentar desligar à noite.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>, mantenedor do Nuxt
  </p>
</aside>

* **Estabeleça limites:** Você não pode dizer sim para todos os pedidos. Isso pode ser tão simples quanto dizer: "Não consigo fazer isso agora e não tenho planos de fazê-lo no futuro" ou listar o que você tem interesse em fazer e o que não tem no README. Por exemplo, você pode dizer: "Só aceito solicitações de pull que tenham razões claras para sua criação" ou "Só reviso problemas em todas as quintas-feiras, das 18h às 19h." Isso estabelece expectativas para os outros e fornece algo a que você pode se referir em outros momentos para ajudar a reduzir as demandas de colaboradores ou usuários sobre o seu tempo.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
Para confiar de forma significativa em outras pessoas nesses aspectos, você não pode ser alguém que diz sim para todos os pedidos. Ao fazer isso, você não mantém limites, profissionais ou pessoais, e não será um colega confiável.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>, mantenedor do Homebrew em [Dizer Não](https://mikemcquaid.com/saying-no/)
  </p>
</aside>

  Aprenda a ser firme em desligar comportamentos tóxicos e interações negativas. Não há problema em não dar energia a coisas com as quais você não se importa.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
Meu software é gratuito, mas meu tempo e atenção não são.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>, mantenedor do Leaflet
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
Não é segredo que a manutenção de código aberto tem seus lados negros, e um deles é ter que interagir às vezes com pessoas bastante ingratas, arrogantes ou abertamente tóxicas. À medida que a popularidade de um projeto aumenta, aumenta também a frequência desse tipo de interação, aumentando o fardo dos mantenedores e se tornando possivelmente um fator de risco significativo para o esgotamento do mantenedor.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/foosel">@foosel</a>, mantenedor do Octoprint em [Como lidar com pessoas tóxicas](https://www.youtube.com/watch?v=7lIpP3GEyXs)
  </p>
</aside>

Lembre-se, a ecologia pessoal é uma prática contínua que evoluirá à medida que você avança em sua jornada de código aberto. Ao priorizar o autocuidado e manter um senso de equilíbrio, você pode contribuir para a comunidade de código aberto de forma eficaz e sustentável, garantindo tanto o seu bem-estar quanto o sucesso de seus projetos a longo prazo.

## Recursos Adicionais

* [Comunidade de Mantenedores](http://maintainers.github.com/)
* [O contrato social do código aberto](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg
* [Como lidar com pessoas tóxicas](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Arte da Liderança Rockwood](https://rockwoodleadership.org/art-of-leadership/)
* [Dizer Não](hhttps://mikemcquaid.com/saying-no/), Mike McQuaid
* [Governança do Código Aberto](https://governingopen.com/)
* A agenda do workshop foi adaptada a partir da série [Movement Building from Home](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/) da Mozilla.

## Contribuidores

Muito obrigado a todos os mantenedores que compartilharam suas experiências e dicas conosco para este guia!

Este guia foi escrito por [@abbycabs](https://github.com/abbycabs) com contribuições de:

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious) + muitos outros!
