---
lang: pt
title: Encontrando Usuários para Seu Projeto
description: Ajude seu projeto open source a crescer, colocando-o nas mãos de usuários felizes.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Espalhando a palavra

Não há uma regra que diga que você deve promover um projeto open source quando iniciar. Existem inúmeras razões para trabalhar em um projeto open source que não tem nada a ver com popularidade. Em vez de esperar que os outros encontrem e usem seu projeto open source, você pode divulgar o seu trabalho duro!

## Descubra sua mensagem

Antes de iniciar realmente o trabalho de promoção de seu projeto, você deve ser capaz de explicar o que ele faz e porque é importante.

O que faz o seu projeto diferente ou interessante? Porque o criou? Responder essas perguntas para você mesmo irá lhe ajudar a comunicar o significado de seu projeto.

Lembre-se de que as pessoas se involvem como usuários e eventualmente tornam-se contribuidores, porque seu projeto resolveu um problema deles. Ao pensar sobre a mensagem e o valor de seu projeto, tente visualizá-los através da lente do que os _usuários e colaboradores_ podem desejar.

Por exemplo, @robb usa exemplos de código para comunicar claramente porque o projeto dele, [Cartography](https://github.com/robb/Cartography), é útil:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Para um mergulho mais profundo nas mensagens, confira o exercício para desenvolvimento de personas de usuário da Mozilla: ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/).

## Ajudando pessoas a encontrar e seguir seu projeto

<aside markdown="1" class="pquote">
  Você precisa idealmente de uma única URL "home" que possa promover e direcionar as pessoas em relação ao seu projeto. Você não precisa usar um template sofisticado ou até mesmo um nome de domínio, mas seu projeto precisa de um ponto focal.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Ajude as pessoas a encontrar e lembrar de seu projeto apontando-as para um único namespace.

**Tenha um canal claro para promover seu trabalho.** Um usuário do Twitter, uma URL do GitHub ou um canal do IRC são jeitos fáceis de direcionar as pessoas para seu projeto. Esses canais também dão à sua crescente comunidade um lugar para se reunir.

Se você não deseja configurar canais para seu projeto ainda, atualize sua própria conta do Twitter ou do GitHub em qualquer coisa que você fizer. Atualizando seu canais do Twitter ou GitHub irá deixar as pessoas cientes de como contatar ou seguir o seu trabalho. Se você palestrar em um meetup ou evento, certifique-se de que suas informações de contato estão incluídas em sua biografia ou slides.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Um erro que cometi no passado (...) foi não criar uma conta do Twitter para o projeto. O Twitter é uma ótima maneira de manter as pessoas atualizadas sobre o projeto, assim como constantemente expõe elas ao projeto.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Considere criar um website para seu projeto.** Um website torna seu projeto mais amigável e fácil de navegar, especialmente quando está emparelhando com uma documentação clara e tutoriais. Ter um website também sugere que seu projeto está ativo, o que fará com que o público se sinta mais à vontade para usá-lo. Disponibilize exemplos para dar as pessoas ideias de como usar o seu projeto.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), co-criador do Django, disse que um website foi _"de longe a melhor coisa que fizemos com Django no início"_.

Se seu projeto está hospedado no GitHub, você pode utilizar as [GitHub Pages](https://pages.github.com/) para fácilmente criar um website. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), e [Middleman](https://middlemanapp.com/) são [alguns exemplos](https://github.com/showcases/github-pages-examples) de websites excelentes e abrangentes.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Agora que você tem uma mensagem para seu projeto, e uma maneira fácil das pessoa o acharem, vamo lá falar com seu público!

## Vá para onde o público do seu projeto está (online)

Divulgação online é uma boa maneira de compartilhar e espalhar a palavra rapidamente. Usando canais online, você tem o potencial de atingir um público muito amplo.

Tome vantagem de comunidades e plataformas online existentes para atingir seu público. Se seu projeto open source é um projeto de software, você, provavelmente, pode encontrar seu público no [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), ou [Quora](https://www.quora.com/). Encontre os canais que você acha que as pessoas irão se beneficiar mais ou se excitar com o seu trabalho.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Cada programa tem funções muito específicas que somente uma fração dos usuários irá achar útil. Não dispare spam para o maior número de pessoas possível. Em vez disso, direcione seus esforços para as comunidades que se beneficiarão com o conhecimento do seu projeto.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](http://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Veja se você pode encontrar maneiras de compartilhar seu projeto de maneiras relevantes:

* **Conheça projetos e comunidades open source relevantes.** Às vezes, você não precisa promover o seu projeto diretamente. Se seu projeto é perfeito para cientistas de dados que usam Python, conheça a comunidade de ciência de dados do Python. À medida que as pessoas o conhecerem, oportunidades de falar sobre e compartilhar seu trabalho surgirão naturalmente.
* **Encontre pessoas passando pelos problemas que seu projeto resolve.** Procure em fóruns relacionados as pessoas que se enquadram no público-alvo de seu projeto. Responda as questões deles e encontre uma maneira sutil, quando apropriado, de sugerir seu projeto como solução.
* **Peça feedback.** Introduza você mesmo e seu trabalho para uma audiência que o acharia relevante e interessante. Seja especifico sobre quem você acha que se beneficiaria com seu projeto. Tente completar a sentença:  _"Eu acho que meu projeto realmente ajudaria X, que está tentando fazer Y_". Ouça e responda os feedbacks dos outros, em vez de simplesmente promover seu trabalho.

De um modo geral, foque em ajudar os outros antes de pedir coisas em troca. Como qualquer pessoa pode facilmente promover um projeto online, haverá muito ruído. Para se destacar da multidão, dê às pessoas um contexto para quem você e não apenas para o que você quer.

Se ninguém prestar atenção ou responder seu trabalho inicial, não desanime! A maioria dos lançamentos de projetos é um processo iterativo que pode levar meses ou anos. Se você não obtiver resposta na primeira vez, tente uma tática diferente, ou busque por caminhos que agreguem valor para os trabalhos dos outros primeiro. Promover e lançar seu projeto leva tempo e dedicação.

## Vá para onde o público do seu projeto está (offline)

![Falar em público](/assets/images/finding-users/public_speaking.jpg)

Eventos offline são uma maneira popular de promover novos projetos para o público. Eles são uma ótima maneira de alcançar um público engajado e de construir relações humanas profundas, especialmente se você está interessado em encontrar desenvolvedores.

Se você é [novato na fala em público](http://speaking.io/), comece encontrando um meetup local que se relaciona com a linguagem ou com o ecossistema de seu projeto.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Eu estava bem nervosa em ir à PyCon. Eu estava dando uma palestra, ia apenas conhecer umas pessoas lá, estava indo para uma semana inteira. (...) Eu não deveria ter me preocupado, no entanto. A Pycon foi fenomenalmente incrível! (...) Todo mundo era incrivelmente simpático e extrovertido, tanto que eu raramente encontrava tempo para não falar com as pessoas!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Se você nunca falou em um evento antes, é prefeitamente normal se sentir nervoso(a)! Lembre-se que seu público está lá porque ele querem genuinamente ouvir sobre seu trabalho.

Quando escrever sua fala, foque no que seu público irá achar interessante e irá obter valor. Mantenha sua linguagem amigável e acessível. Sorria, respire, e divirta-se.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Quando você começa a escrever sua palestra, não ligar para qual é o seu tópico pode ajudar, se você enxegar sua palestra como uma história que você conta para as pessoas.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Quando se sentir pronto(a), considere falar em uma conferência para promover seu projeto. Conferências podem ajudar você a alcançar mais pessoas, as vezes de todos os lugares do mundo.

Procure por conferências que são específicas para a sua linguagem ou ecossistema. Antes de submeter sua palestra, pesquise sobre a conferência para adaptar sua palestra para os participantes e aumentar suas chances de ser aceito(a) para falar na conferência. Muitas vezes você pode ter uma noção do seu público olhando para os palestrantes da conferência.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Eu escrevi muito bem ao pessoal da JSConf e implorei a eles para que me dessem um espaço onde eu poderia apresenta-lo na JSConf EU. (...) Eu estava extremamente assustada, apresentando essa coisa que estive trabalhando por seis meses. (...) Durante todo o tempo eu só pensava, meu Deus. O que estou fazendo aqui?
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Construa uma reputação

Além das estratégias descritas acima, a melhor forma de convidar pessoas para compartilhar e contribuir para seu projete é compartilhar e contribuir para os projetos delas.

Ajudar os recém-chegadors, compartilhar recursos, e fazer contribuições conscientes para os projetos dos outros o ajudará a construir uma reputação positiva. Ser um membro ativo na comunidade open source ajudará as pessoas a terem contexto sobre o seu trabalho e aumentará a probabilidade delas prestarem atenção e compartilharem seu projeto. Desenvolver relacionamentos com os outros projetos open source pode até levar a parcerias oficiais.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  A única razão para urllib3 ser a biblioteca Python de terceiro mais popular atualmente é porque faz parte da [requests](https://github.com/requests/requests).
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Nunca é cedo demais ou tarde demais para iniciar a construir sua reputação. Mesmo que você já tenha lançado seu próprio projeto, continue procurando por formas de ajudar os outros.

Não há uma solução instantânea para a construção de uma audiência. Ganhar a confiança e o respeito dos outros leva tempo, e a construção de sua reputação nunca acaba.

## Continue assim!

Pode levar um longo tempo antes das pessoas notarem seu projeto open source. Está tudo bem! Alguns dos projetos mais populares hoje levaram anos para atingir os níveis mais altos de atividade. Concentre-se em construir relacionamentos em vez de esperar que seu projeto espontâneamente ganhe popularidade. Seja paciente, e mantenha-se compartilhando seu trabalho com aqueles que o apreciam.
