---
lang: pl
title: Jak przyczynić się do Open Source
description: Chciałbyś przyczynić się do open source? Przewodnik po wkładach typu open source, dla nowicjuszy i weteranów.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Po co przyczyniać się do open source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Working on \[freenode\] helped me earn many of the skills I later used for my studies in university and my actual job. I think working on open source projects helps me as much as it helps the project!
  </i>
  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Wkład w open source może być satysfakcjonującym sposobem uczenia się oraz nauczania i budowania doświadczenia w prawie każdej umiejętności, jaką możesz sobie wyobrazić.

Dlaczego ludzie przyczyniają się do open source? Z wielu powodów!

### Ulepsz oprogramowanie, na którym możesz polegać

Wielu współpracowników open source zaczyna od bycia użytkownikami oprogramowania, do którego następnie wnoszą swój wkład. Gdy znajdziesz błąd w używanym przez ciebie oprogramowaniu open source, możesz zajrzeć do źródła, aby sprawdzić, czy możesz go naprawić samodzielnie. Jeśli tak jest, to dodanie poprawki jest najlepszym sposobem, aby zapewnić, że twoi znajomi (i ty, kiedy zaktualizujesz do następnej wersji) będą mogli z niej skorzystać.

### Rozwiń swoje umiejętności

Niezależnie od tego, czy chodzi o programowanie, projektowanie interfejsu użytkownika, projektowanie graficzne, pisanie czy organizowanie, jeśli szukasz praktyki, to znajdziesz odpowiednie zadanie w projekcie open source.

### Poznawaj ludzi, którzy mają podobne zainteresowania

Projekty open source z ciepłymi, przyjaznymi społecznościami sprawiają, że ludzie wracają na lata. Wiele osób nawiązuje przyjaźnie na całe życie poprzez udział w otwartym kodzie źródłowym, bez względu na to, czy spotykają się na konferencjach, czy późno w nocy na czatach internetowych o burritos.

### Znajdź mentorów i ucz innych

Praca z innymi przy wspólnym projekcie oznacza, że musisz wyjaśnić, jak coś robisz, a także poprosić o pomoc innych ludzi. Działania związane z uczeniem się i nauczaniem mogą być satysfakcjonującym zajęciem dla wszystkich zaangażowanych osób.

### Twórz publiczne artefakty, które pomogą ci zdobyć reputację (i karierę)

Z definicji cała twoja praca z otwartym kodem źródłowym jest publiczna, co oznacza, że masz darmowe przykłady do pokazania w dowolnym miejscu jako demonstrację tego, co potrafisz zrobić.

### Rozwiń swoje zdolności interpersonalne

Open source oferuje możliwość ćwiczenia umiejętności przywódczych i zarządczych, takich jak rozwiązywanie konfliktów, organizowanie zespołów i ustalanie priorytetów pracy.

### Daje to możliwość wprowadzania zmian, nawet tych małych

Nie musisz stać się dożywotnim uczestnikiem, aby cieszyć się uczestnictwem w otwartym oprogramowaniu. Czy widziałeś kiedyś literówkę na stronie i żałowałeś, że ktoś to nie naprawił? W projekcie open source możesz to zrobić. Open source pomaga ludziom odczuwać poczucie kontroli w ich życiu i doświadczaniu świata, a to samo w sobie jest satysfakcjonujące.

## Co to znaczy przyczynić się

Jeśli jesteś nowym współpracownikiem typu open source, proces może być zastraszający. Jak znaleźć odpowiedni projekt? Co jeśli nie wiesz, jak programować? Co jeśli coś pójdzie nie tak?

Nie martwić się! Istnieje wiele sposobów na zaangażowanie się w projekt open source, a kilka wskazówek pomoże ci w pełni wykorzystać swoje doświadczenie.

### Nie musisz przekazywać kodu

Powszechnym błędnym przekonaniem na temat przyczyniania się do open source jest to, że musisz wnieść kod. W rzeczywistości często inne części projektu są [najbardziej zaniedbywane lub pomijane](https://github.com/blog/2195-the-shape-of-open-source). Zrobisz projektowi _wielką_ przysługę, oferując swój wkład w taką część projektu!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  <i>
  I’ve been renowned for my work on CocoaPods, but most people don’t know that I actually don’t do any real work on the CocoaPods tool itself. My time on the project is mostly spent doing things like documentation and working on branding.
  </i>
  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Nawet jeśli lubisz pisać kod, inne rodzaje wkładów to świetny sposób na zaangażowanie się w projekt i poznanie innych członków społeczności. Budowanie tych relacji da ci możliwość pracy nad innymi częściami projektu.

### Czy lubisz planować wydarzenia?

* Organizuj warsztaty lub spotkania dotyczące projektu, [jak @fzamperin dla NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Zorganizuj konferencję projektu (jeśli taką mają)
* Pomóż członkom społeczności znaleźć odpowiednie konferencje i przesłać propozycje wystąpień

### Czy lubisz projektować?

* Przebuduj strukturę interfejsu, aby poprawić użyteczność projektu
* Przeprowadź badania użytkowników w celu reorganizacji i dopracowania nawigacji lub menu projektu, [jak sugeruje Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Przygotuj przewodnik po stylu, aby projekt miał spójny wygląd
* Twórz grafiki na koszulki lub nowe logo, tak jak zrobili to autorzy [hapi.js](https://github.com/hapijs/contrib/issues/68)

### Lubisz pisać?

* Napisz i popraw dokumentację projektu
* Wybierz folder z przykładami pokazującymi, w jaki sposób projekt jest używany
* Rozpocznij biuletyn dotyczący projektu lub wybieraj najważniejsze informacje z listy mailingowej
* Napisz tutoriale do projektu [jak zrobili to autorzy PyPA](https://packaging.python.org/)
* Napisz tłumaczenie dokumentacji projektu

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Seriously, \[documentation\] is mega-important. The documentation so far has been great and has been a killer feature of Babel. There are sections that could certainly use some work and even the addition of a paragraph here or there is extremely appreciated.
  </i>
  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Czy lubisz organizować?

* Twórz łącza do duplikatów problemów i sugeruj ich nowe etykiety, aby utrzymać porządek
* Przejrzyj otwarte problemy i zasugeruj zamknięcie starych, [jak @nzakas zrobił dla ESLint](https://github.com/eslint/eslint/issues/6765)
* Zadaj pytania wyjaśniające na temat ostatnio otwartych zagadnień, aby popchnąć dyskusję do przodu

### Czy lubisz kodować?

* Znajdź otwarty problem do rozwiązania [jak @dianjin zrobił dla Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Zapytaj, czy możesz pomóc napisać nową funkcjonalność
* Zautomatyzuj konfigurację projektu
* Ulepsz narzędzia używane w projekcie i testy

### Czy lubisz pomagać ludziom?

* Odpowiedz na pytania dotyczące projektu na przykład na Stack Overflow ([jak ten przykład Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) lub Reddit
* Odpowiedz na pytania dotyczące otwartych problemów
* Pomóż moderować fora dyskusyjne lub kanały rozmów

### Czy lubisz pomagać innym kodować?

* Przejrzyj kod zgłoszeń od innych osób
* Napisz tutoriale dotyczące sposobu wykorzystania projektu
* Oferta mentorowania innego autora [jak @ereichert zrobił dla @bronzdoc na Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Nie musisz tylko pracować nad projektami oprogramowania!

Podczas gdy „open source” często odnosi się do oprogramowania, możesz współpracować nad praktycznie wszystkim. Istnieją książki, przepisy kulinarne, listy i klasy opracowywane jako projekty typu open source.

Na przykład:

* @sindresorhus przygotowuje [listę „niesamowitych” list](https://github.com/sindresorhus/awesome)
* @h5bp utrzymuje [listę potencjalnych pytań do rozmowy kwalifikacyjnej](https://github.com/h5bp/Front-end-Developer-Interview-Questions) dla kandydatów na programistów front-end
* @stuartlynn a @nicole-a-tesla stworzyła [zbiór zabawnych faktów na temat maskonurów](https://github.com/stuartlynn/puffin_facts)

Nawet jeśli jesteś programistą, praca nad projektem dokumentacji może pomóc w rozpoczęciu pracy w środowisku open source. Praca z projektami niewymagającymi kodu jest często mniej zastraszająca, a proces współpracy zwiększy twoje zaufanie i doświadczenie.

## Orientacja na nowy projekt

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  <i>
  If you go to an issue tracker and things seem confusing, it's not just you. These tools require a lot of implicit knowledge, but people can help you navigate it and you can ask them questions.
  </i>
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

W przypadku czegoś więcej niż poprawa literówek, udział w open source jest jak podchodzenie do grupy nieznajomych na imprezie. Jeśli zaczniesz mówić o lamach, gdy byli głęboko w dyskusji na temat złotych rybek, prawdopodobnie spojrzą na ciebie trochę dziwnie.

Zanim wskoczysz na ślepo z własnymi sugestiami, zacznij od nauki wybadywania terenu. Takie postępowanie zwiększa szanse, że twoje pomysły zostaną zauważone i usłyszane.

### Anatomia projektu open source

Każda społeczność open source jest inna.

Spędzanie lat na jednym projekcie typu open source oznacza, że znasz jeden projekt typu open source. Przejdź do innego projektu, a może się okazać, że słownictwo, normy i style komunikacji są zupełnie inne.

To powiedziawszy, wiele projektów open source ma podobną strukturę organizacyjną. Zrozumienie różnych ról społeczności i ogólnego procesu pomoże ci szybko zorientować się w każdym nowym projekcie.

Typowy projekt open source ma następujące typy osób:

* **Autor:** Osoba lub organizacja, która utworzyła projekt
* **Właściciel:** Osoba / osoby posiadające uprawnienia administracyjne do organizacji lub repozytorium (nie zawsze taki sam jak oryginalny autor)
* **Opiekunowie:** Współtwórcy odpowiedzialni za kierowanie wizją i zarządzanie aspektami organizacyjnymi projektu (mogą być także autorami lub właścicielami projektu).
* **Współtwórcy:** Każdy, kto wniósł coś do projektu
* **Członkowie społeczności:** Ludzie, którzy korzystają z projektu. Mogą być aktywni w rozmowach lub wyrażać swoją opinię na temat kierunków projektu

Większe projekty mogą również obejmować podkomitety lub grupy robocze zajmujące się różnymi zadaniami, takimi jak narzędzia projektowe, segregacja, moderacja społeczności i organizacja wydarzeń. Na stronie internetowej projektu można znaleźć stronę „zespołu” lub w repozytorium dokumentacji dotyczącej zarządzania, aby znaleźć te informacje.

Projekt ma również dokumentację. Te pliki są zwykle wymienione na najwyższym poziomie repozytorium.

* **LICENSE:** Z definicji każdy projekt typu open source musi posiadać [licencję typu open source](https://choosealicense.com). Jeśli projekt nie ma licencji, to nie jest open source.
* **README:** Plik README to instrukcja obsługi, która wita nowych członków społeczności w projekcie. Wyjaśnia, dlaczego projekt jest użyteczny i jak zacząć.
* **CONTRIBUTING:** Podczas gdy pliki README pomagają ludziom _użytkować_ projekt, udostępnianie dokumentów pomaga ludziom _komponować_ w projekcie. Wyjaśnia, jakie rodzaje wkładów są potrzebne i jak działa proces. Chociaż nie każdy projekt ma plik CONTRIBUTING, jego obecność sygnalizuje, że jest to przyjazny projekt, do którego można wnieść swój wkład.
* **CODE_OF_CONDUCT:** tworzeniu przyjaznego i przyjaznego środowiska. Chociaż nie każdy projekt ma plik CODE_OF_CONDUCT, jego obecność sygnalizuje, że jest to przyjazny projekt, do którego można wnieść swój wkład.
* **Other documentation:** Może istnieć dodatkowa dokumentacja, taka jak samouczki, instrukcje lub zasady zarządzania, szczególnie w przypadku większych projektów.

Wreszcie, projekty open source wykorzystują następujące narzędzia do organizowania dyskusji. Czytanie archiwów daje dobry obraz tego, jak społeczność myśli i działa.

* **Issue tracker:** Gdzie ludzie omawiają kwestie związane z projektem.
* **Pull requests:** Gdzie ludzie omawiają i sprawdzają zmiany, które są w toku.
* **Discussion forums or mailing lists:** Niektóre projekty mogą wykorzystywać te kanały do prowadzenia wątków konwersacyjnych (na przykład _„Jak mam ...”_ lub _„Co sądzisz o ...”_ zamiast raportów o błędach lub propozycji funkcji). Inni używają narzędzia do śledzenia problemów do wszystkich rozmów.
* **Synchronous chat channel:** Niektóre projekty wykorzystują kanały czatu (takie jak Slack lub IRC) do swobodnej rozmowy, współpracy i szybkiej wymiany.

## Znalezienie projektu, do którego można wnieść swój wkład

Teraz, gdy już zorientowałeś się, jak działają projekty typu open source, nadszedł czas, aby znaleźć projekt, do którego możesz wnieść swój wkład!

Jeśli nigdy wcześniej nie uczestniczyłeś w tworzeniu oprogramowania typu open source, skorzystaj z porady Prezydenta Stanów Zjednoczonych Johna F. Kennedy'ego, który powiedział kiedyś, _"Ask not what your country can do for you - ask what you can do for your country."_

Wkład w open source ma miejsce na wszystkich poziomach, w różnych projektach. Nie musisz się zastanawiać, jaki dokładnie będzie twój pierwszy wkład ani jak będzie wyglądał.

Zamiast tego zacznij od przemyślenia projektów, z których już korzystasz lub z których chcesz skorzystać. Projekty, w których aktywnie uczestniczysz, to te, do których wracasz.

W ramach tych projektów, ilekroć przyłapiesz się na myśleniu, że coś może być lepsze lub inne, działaj instynktownie.

Open source nie jest ekskluzywnym klubem; zrobili to ludzie tacy jak ty. „Open source” to tylko wymyślny termin na traktowanie problemów świata jako możliwych do rozwiązania.

Możesz zeskanować plik README i znaleźć uszkodzony link lub literówkę. Lub jesteś nowym użytkownikiem i zauważyłeś, że coś jest zepsute lub problem, który Twoim zdaniem powinien naprawdę znajdować się w dokumentacji. Zamiast ignorować i przejść dalej lub poprosić kogoś o naprawę, sprawdź, czy możesz pomóc, wprowadzając. Właśnie o to chodzi w open source!

> [28% of casualowych kontrybucji](https://www.igor.pro.br/publica/papers/saner2016.pdf) open source to dokumentacja, na przykład poprawka literówki, formatowanie lub pisanie tłumaczenia.

Jeśli szukasz istniejących problemów, które możesz naprawić, każdy projekt open source ma stronę `/contribute`, która podkreśla problemy przyjazne dla początkujących, z którymi możesz zacząć. Przejdź do strony głównej repozytorium w serwisie GitHub i dodaj `/contribute` na końcu adresu URL (na przykład [`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

Możesz także skorzystać z jednego z następujących zasobów, aby pomóc ci odkryć nowe projekty i wnieść swój wkład:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)

### Lista kontrolna przed wniesieniem wkładu

Po znalezieniu projektu, do którego chcesz się przyłączyć, wykonaj szybki skan, aby upewnić się, że projekt nadaje się do przyjmowania wkładów. W przeciwnym razie twoja ciężka praca może nigdy nie uzyskać odpowiedzi.

Oto przydatna lista kontrolna do oceny, czy projekt jest dobry dla nowych autorów.

**Spełnia definicję open source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Czy ma licencję? Zwykle w katalogu głównym repozytorium znajduje się plik o nazwie LICENSE.
  </label>
</div>

**Projekt aktywnie przyjmuje wkłady**

Spójrz na działanie zatwierdzania w gałęzi master. Na GitHub możesz zobaczyć te informacje na stronie głównej repozytorium.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Kiedy były ostatnie commit-y?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Ilu współautorów ma projekt?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Jak często ludzie się w to angażują? (Możesz znaleźć te informacje w GitHub, klikając "Commits" na górnym pasku).
  </label>
</div>

Następnie spójrz na issues projektu.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Ile jest otwartych spraw (issues)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Czy opiekunowie szybko reagują na nowo utworzone problemy?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Czy kwestie są aktywnie omawiane?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Czy problemy są aktualne?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Czy problemy są zamykane? (W serwisie GitHub na stronie "Issues" kliknij "closed", aby wyświetlić zamknięte problemy).
  </label>
</div>

Teraz wykonaj te same kroki dla PR (pull requests) projektu.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Ile jest otwartych żądań ściągnięcia (tzw. pull request)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Czy opiekunowie szybko reagują na nowo utworzone PR (pull request)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Czy pull request są aktywnie omawiane?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Czy PR są aktualne?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Jak niedawno zostały scalone jakiekolwiek PR? (W GitHub w zakładkę "Pull Requests" kliknij "closed", aby zobaczyć zamknięte PR).
  </label>
</div>

**Projekt jest otwarty na nowych autorów**

Projekt przyjazny i gościnny sygnalizuje, że będą otwarci na nowych autorów.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Czy opiekunowie udzielają pomocnych odpowiedzi na pytania dotyczące problemów?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Czy ludzie są przyjaźni w Issues, na forum dyskusyjnym czy na czacie (np. IRC lub Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Czy PR są sprawdzane?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Czy opiekunowie dziękują ludziom za ich wkład?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Whenever you see a long thread, spot check responses from core developers coming late in the thread. Are they summarizing constructively, and taking steps to bring the thread to a decision while remaining polite? If you see a lot of flame wars going on, that's often a sign that energy is going into argument instead of into development.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Jak przesłać kontrybucję

Znalazłeś projekt, który ci się podoba i jesteś gotowy, aby wnieść swój wkład. Wreszcie! Oto, w jaki sposób uzyskać odpowiedni wkład we właściwy sposób.

### Skuteczna komunikacja

Niezależnie od tego, czy jesteś jednorazowym współpracownikiem, czy próbujesz dołączyć do społeczności, praca z innymi jest jedną z najważniejszych umiejętności, które rozwiniesz w środowisku open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[As a new contributor,\] I quickly realized I had to ask questions if I wanted to be able to close the issue. I skimmed through the code base. Once I had some sense of what was going on, I asked for more direction. And voilà! I was able to solve the issue after getting all the relevant details I needed.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Zanim otworzysz issue, pull request lub zadasz pytanie na czacie, pamiętaj o tych punktach, aby pomóc skutecznie zrozumieć twoje pomysły.

**Podaj kontekst.** Pomóż innym szybko wgryźć się w temat. Jeśli napotkasz błąd, wyjaśnij, co próbujesz zrobić i jak go odtworzyć. Jeśli sugerujesz nowy pomysł, wyjaśnij, dlaczego uważasz, że byłby przydatny dla projektu (nie tylko dla ciebie!).

> 😇 _"X doesn't happen when I do Y"_
>
> 😢 _"X is broken! Please fix it."_

**Odrób swoją pracę domową wcześniej.** To w porządku, jeśli wszystkiego nie wiesz, ale pokazałeś, że próbowałeś. Zanim poprosisz o pomoc, koniecznie sprawdź README projektu, dokumentację, problemy (otwarte lub zamknięte), listę mailingową i wyszukaj w Internecie odpowiedź. Ludzie docenią, gdy pokażesz, że próbujesz się uczyć.

> 😇 _"I'm not sure how to implement X. I checked the help docs and didn't find any mentions."_
>
> 😢 _"How do I X?"_

**Requesty powinny być krótkie i bezpośrednie.** Podobnie jak wysyłanie wiadomości e-mail, każdy wkład, bez względu na to, jak prosty lub pomocny, wymaga oceny innej osoby. Wiele projektów ma więcej przychodzących próśb niż ludzi dostępnych do pomocy. Bądź zwięzły. Zwiększysz szansę, że ktoś będzie mógł ci pomóc.

> 😇 _"I'd like to write an API tutorial."_
>
> 😢 _"I was driving down the highway the other day and stopped for gas, and then I had this amazing idea for something we should be doing, but before I explain that, let me show you..."_

**Trzymaj całą komunikację publiczną.** Chociaż jest to kuszące, nie kontaktuj się prywatnie z opiekunami, chyba że musisz udostępniać poufne informacje (takie jak problem z bezpieczeństwem lub poważne naruszenie zasad postępowania). Gdy udostępnisz rozmowę publicznie, więcej osób może się uczyć i korzystać z wymiany zdań. Dyskusje mogą być same w sobie wkładem.

> 😇 _(as a comment) "@-maintainer Hi there! How should we proceed on this PR?"_
>
> 😢 _(as an email) "Hey there, sorry to bother you over email, but I was wondering if you've had a chance to review my PR"_

**Można zadawać pytania (ale bądź cierpliwy!).** W pewnym momencie wszyscy byli nowi w projekcie, a nawet doświadczeni współpracownicy muszą przyspieszyć, gdy patrzą na nowy projekt. Z tego samego powodu, nawet wieloletni opiekunowie nie zawsze znają każdą część projektu. Pokaż im tę samą cierpliwość, którą chciałbyś, aby ci pokazali.

> 😇 _"Thanks for looking into this error. I followed your suggestions. Here's the output."_
>
> 😢 _"Why can't you fix my problem? Isn't this your project?"_

**Szanuj decyzje społeczności.** Twoje pomysły mogą różnić się od priorytetów lub wizji społeczności. Mogą oni oferować informacje zwrotne lub zdecydować o nie realizowaniu Twojego pomysłu. Podczas gdy powinieneś dyskutować i szukać kompromisu, opiekunowie muszą żyć z twoją decyzją dłużej niż ty. Jeśli nie zgadzasz się z ich kierunkiem, zawsze możesz pracować nad własnym forkiem lub rozpocząć własny projekt.

> 😇 _"I'm disappointed you can't support my use case, but as you've explained it only affects a minor portion of users, I understand why. Thanks for listening."_
>
> 😢 _"Why won't you support my use case? This is unacceptable!"_

**Przede wszystkim zachowaj klasę.** Open source składa się ze współpracowników z całego świata. Kontekst gubi się w różnych językach, kulturach, regionach geograficznych i strefach czasowych. Ponadto pisemna komunikacja utrudnia przekazanie tonu lub nastroju. Przyjmij dobre intencje w tych rozmowach. Dobrze jest grzecznie odepchnąć pomysł, poprosić o więcej kontekstu lub wyjaśnić swoje stanowisko. Po prostu spróbuj zostawić Internet w lepszym miejscu niż wtedy, gdy go znalazłeś.

### Zbieranie kontekstu

Zanim cokolwiek zrobisz, szybko sprawdź, czy twój pomysł nie został omówiony w innym miejscu. Przejrzyj README projektu, problemy (otwarte i zamknięte), listę mailingową i przepełnienie stosu. Nie musisz spędzać godzin na przeglądaniu wszystkiego, ale szybkie poszukiwanie kilku kluczowych haseł to długa droga.

Jeśli nie możesz znaleźć swojego pomysłu w innym miejscu, możesz zrobić krok. Jeśli projekt jest w serwisie GitHub, prawdopodobnie komunikujesz się, otwierając problem lub wysyłając żądanie:

* **Issues** są jak rozpoczęcie rozmowy lub dyskusji
* **Pull requests** są rozpoczęciem pracy nad rozwiązaniem
* **Aby uzyskać lekką komunikację,** takie jak pytanie wyjaśniające lub poradnik, spróbuj zadać pytanie Stack Overflow, IRC, Slacka lub innych kanałów komunikacyjnych, jeśli projekt takie ma

Zanim otworzysz problem lub pull request, sprawdź dokumenty wspierające projekt (zwykle plik o nazwie CONTRIBUTING lub w README), aby sprawdzić, czy musisz dołączyć coś konkretnego. Na przykład projekt może wymagać przestrzegania szablonu lub użycia testów.

Jeśli chcesz wnieść znaczący wkład, otwórz problem, który chcesz rozwiązać, zanim zaczniesz nad nim pracować. Przydatne jest obserwowanie projektu przez jakiś czas (na GitHub, [możesz kliknąć "Watch"](https://help.github.com/articles/watching-repositories/) aby otrzymywać powiadomienia o wszystkich rozmowach) i poznać członków społeczności przed podjęciem pracy, która może nie zostać zaakceptowana.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  You'll learn <em>a lot</em> from taking a single project you actively use, "watching" it on GitHub and reading every issue and PR.
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Otwieranie issue

Zazwyczaj powinieneś otworzyć problem w następujących sytuacjach:

* Zgłoś błąd, którego nie możesz rozwiązać samodzielnie
* Omów temat lub pomysł na wysokim poziomie (na przykład społeczność, wizja lub zasady)
* Zaproponuj nową funkcję lub inny pomysł na projekt

Wskazówki dotyczące komunikowania się w issue:

* **Jeśli widzisz otwarty problem, który chcesz rozwiązać,** skomentuj ten problem, aby inni wiedzieli, że nad nim pracujesz. W ten sposób ludzie są mniej skłonni do powielania twojej pracy.
* **Jeśli jakiś problem został otwarty jakiś czas temu,** możliwe, że problem został przedyskutowany gdzieś indziej lub został już rozwiązany, więc skomentuj, aby poprosić o potwierdzenie przed rozpoczęciem pracy.
* **Jeśli otworzyłeś problem, ale sam później zorientowałeś się,** skomentuj problem, aby dać innym znać, a następnie zamknij problem. Nawet udokumentowanie tego wyniku stanowi wkład w projekt.

### Otwieranie pull request

Zwykle należy otworzyć pull request w następujących sytuacjach:

* Prześlij trywialne poprawki (na przykład literówka, zepsuty link lub oczywisty błąd)
* Rozpocznij pracę nad wkładem, o który zostałeś już poproszony lub który już omawiałeś w numerze

Pull request nie musi reprezentować ukończonej pracy. Zwykle lepiej jest wcześniej otworzyć pull request, aby inni mogli obserwować twoje postępy lub udzielać informacji zwrotnych. Po prostu zaznacz go jako „WIP” (Work in Progress) w temacie. Zawsze możesz później dodać więcej commitów.

Jeśli projekt znajduje się na GitHub, oto jak przesłać pull request:

* **[Fork repozytorium](https://guides.github.com/activities/forking/)** i jego klon lokalnie. Podłącz swoje lokalne repozytorium do oryginalnego„upstream”, dodając je jako remote. Pobieraj zmiany z „upstream” często, abyś był na bieżąco, aby po stworzeniu pull requesta konflikty w kodzie były mniej prawdopodobne. (Zobacz bardziej szczegółowe instrukcje [tutaj](https://help.github.com/articles/syncing-a-fork/).)
* **[Stworzenie brancha](https://guides.github.com/introduction/flow/)** dla swoich zmian.
* **Odniesienie się do wszelkich istotnych issues** lub dokumentacja uzupełniająca w twoim PR (na przykład, "Closes #37.")
* **Dołączenie zrzutów ekranu przed i po** jeśli zmiany zawierają różnice w HTML / CSS. Przeciągnij i upuść obrazy w treści pull requesta.
* **Sprawdzenie swoich zmian!** Uruchom istniejące testy w stosunku do twoich zmian, i w razie potrzeby utwórz nowe. Niezależnie od tego, czy testy istnieją, czy nie, upewnij się, że zmiany nie psują istniejącego projektu.
* **Wkład w styl projektu** najlepiej jak potrafisz. Może to oznaczać stosowanie wcięć, średników lub komentarzy inaczej niż w swoim własnym repozytorium, co ułatwia opiekunowi scalenie, innym zrozumienie i utrzymanie w przyszłości.

Jeśli to twój pierwszy pull request, sprawdź [Make a Pull Request](http://makeapullrequest.com/), które @kentcdodds utworzone jako instruktażowy samouczek wideo. Możesz także przećwiczyć składanie pull request w repozytorium [First Contributions](https://github.com/Roshanjossey/first-contributions), stworzonym przez @Roshanjossey.

## Co dzieje się po przesłaniu wkładu

Zrobiłeś to! Gratulujemy zostania współpracownikiem typu open source. Mamy nadzieję, że to pierwszy z wielu twoich wkładów.

Po przesłaniu wkładu nastąpi jedna z następujących sytuacji:

### 😭 Nie dostaniesz odpowiedzi.

Mam nadzieję, że [sprawdziłeś projekt pod kątem oznak aktywności](../how-to-contribute/#lista-kontrolna-przed-wniesieniem-wkładu) przed wniesieniem wkładu. Jednak nawet w przypadku aktywnego projektu możliwe jest, że twój wkład nie uzyska odpowiedzi.

Jeśli nie otrzymałeś odpowiedzi od ponad tygodnia, możesz grzecznie odpowiedzieć w tym samym wątku, prosząc kogoś o recenzję. Jeśli znasz właściwą osobę do sprawdzenia swojego wkładu, możesz @-mentionować ją w tym wątku.

**Nie** docieraj do tej osoby prywatnie; pamiętaj, że komunikacja publiczna jest niezbędna w projektach typu open source.

Jeśli uprzejmie kogoś zapytasz i nadal nikt nie zareaguje, możliwe, że nikt nigdy nie odpowie. To nie jest to zbyt miłe uczucie, ale nie zniechęcaj się. Zdarzyło się wszystkim! Istnieje wiele możliwych powodów, dla których nie otrzymałeś odpowiedzi, w tym okoliczności osobiste, które mogą być poza twoją kontrolą. Spróbuj znaleźć inny projekt lub sposób na wniesienie wkładu. Jeśli tak, to dobry powód, aby nie poświęcać zbyt wiele czasu na wkład, zanim inni członkowie społeczności nie będą zaangażowani i nie będą reagować.

### 🚧 Ktoś prosi o zmianę Twojego wkładu.

Często zdarza się, że będziesz proszony o wprowadzenie zmian do twojego wkładu, niezależnie od tego, czy jest to opinia na temat zakresu twojego pomysłu, czy zmiany w kodzie.

Gdy ktoś prosi o zmiany, bądź responsywny. Sprawdzili twój wkład. Otwarcie PR i odejście to zła forma. Jeśli nie wiesz, jak wprowadzić zmiany, zbadaj problem, a następnie poproś o pomoc, jeśli jej potrzebujesz.

Jeśli nie masz czasu na pracę nad problemem (na przykład, jeśli rozmowa trwa od miesięcy, a twoja sytuacja uległa zmianie), powiadom opiekuna, aby nie oczekiwał odpowiedzi. Ktoś inny może być szczęśliwy, aby przejąć ten problem.

### 👎 Twój wkład nie zostanie zaakceptowany.

Twój wkład może, ale nie musi, zostać ostatecznie zaakceptowany. Mam nadzieję, że nie włożyłeś już w to zbyt wiele pracy. Jeśli nie masz pewności, dlaczego nie zostało to zaakceptowane, całkowicie uzasadnione jest poproszenie opiekuna o opinie i wyjaśnienia. Ostatecznie jednak musisz uszanować, że to jest ich decyzja. Nie kłóć się ani nie bądź wrogi. Jeśli się nie zgadzasz, możesz zawsze zrobić forka i pracować nad własną wersją!

### 🎉 Twój wkład zostanie zaakceptowany.

Hooray! Udało ci się wnieść wkład typu open source!

## Zrobiłeś to!

Niezależnie od tego, czy właśnie wniósłeś swój pierwszy wkład typu open source, czy szukasz nowych sposobów, mamy nadzieję, że zainspirujesz się do działania. Nawet jeśli twój wkład nie został zaakceptowany, nie zapomnij podziękować, gdy opiekun wkłada wysiłek, aby ci pomóc. Oprogramowanie typu open source jest tworzone przez osoby takie jak ty: jeden problem, żądanie ściągnięcia, komentarz lub piątka na raz.
