---
lang: pl
title: Jak znaleźć użytkowników dla twojego projektu
description: Rozwijaj projekt open source, przekazując go w ręce odpowiednich użytkowników.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Rozpowszechnianie informacji

Nie ma reguły, która mówi, że musisz promować swój projekt open source podczas jego wypuszczania. Istnieje wiele satysfakcjonujących powodów do pracy w open source, które nie mają nic wspólnego z popularnością. Zamiast liczyć na to, że inni znajdą i wykorzystają twój projekt open source, lepiej jest rozpowszechnić informacje o swojej ciężkiej pracy!

## Zastanów się nad komunikatem

Przed rozpoczęciem faktycznej pracy nad promocją projektu powinieneś być w stanie wyjaśnić, co robi i dlaczego ma on znaczenie.

Co sprawia, że twój projekt jest inny lub interesujący? Dlaczego go stworzyłeś? Odpowiedzi na te pytania pomogą ci przekazać informację dlaczego twój projekt może być przydatny dla innych.

Pamiętaj, że ludzie angażują się jako użytkownicy i ostatecznie stają się współpracownikami, ponieważ twój projekt rozwiązuje dla nich dany problem. Gdy myślisz o przesłaniu i wartości projektu, spróbuj spojrzeć na niego z perspektywy potencjalnych użytkowników i współpracowników.

Na przykład @robb używa przykładów kodu, aby jasno przekazać, dlaczego jego projekt [Cartography](https://github.com/robb/Cartography) jest przydatny:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Aby zagłębić się w tworzenie odpowiednich komunikatów, sprawdź artykuł Mozilli ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/), o personach użytkowników.

## Pomóż ludziom znaleźć i śledzić twój projekt

<aside markdown="1" class="pquote">
  You ideally need a single "home" URL that you can promote and point people to in relation to your project. You don't need to splash out on a fancy template or even a domain name, but your project needs a focal point.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Pomóż innym znaleźć i zapamiętać twój projekt, poprzez utworzenie odpowiedniej nazwy firmowej która będzie reprezentować cały projekt.

**Znajdź odpowiednie miejsce do promowania swojej pracy.** Twitter, GitHub URL lub kanał IRC to łatwy sposób promowania twojego projektu. Te miejsca pozwolą także na zbieranie się rosnącej społeczności twojego projektu.

Jeśli nie chcesz jeszcze zakładać takich punktów dla swojego projektu, promuj go na swoim własnym koncie Twitter lub GitHub. Promowanie swojego projektu na Twitterze lub GitHub pozwoli ludziom wiedzieć, jak się z tobą skontaktować lub śledzić twoją pracę. Jeśli przemawiasz na spotkaniu lub wydarzeniu, upewnij się, że twoje dane kontaktowe znajdują się w prezentacji.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  <i>
  A mistake I made in those early days (...) was not starting a Twitter account for the project. Twitter's a great way to keep people up to date about a project as well as constantly expose people to the project.
  </i>
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Rozważ utworzenie strony internetowej dla swojego projektu.** Strona internetowa sprawia, że projekt jest łatwiejszy w obsłudze i łatwiejszy w nawigacji, szczególnie gdy jest połączony z przejrzystą dokumentacją i samouczkami. Posiadanie strony internetowej sugeruje również, że twój projekt jest aktywny, co sprawi, że twoi odbiorcy poczują się bardziej komfortowo z niego korzystając. Podawaj przykłady użycia, aby ludzie wiedzieli, jak korzystać z twojego projektu.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), współtwórca Django powiedział, że strona internetowa była _"zdecydowanie najlepszą rzeczą, jaką zrobiliśmy dla Django we wczesnych dniach projektu"_.

Jeśli Twój projekt jest hostowany na GitHub, możesz użyć [GitHub Pages](https://pages.github.com/) aby łatwo stworzyć stronę internetową. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), oraz [Middleman](https://middlemanapp.com/) to [kilka przykładów](https://github.com/showcases/github-pages-examples) doskonałych, kompleksowych stron internetowych.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Teraz, gdy już masz odpowiedni komunikat dla swojego projektu oraz miejsce w którym możesz go promować, chodźmy porozmawiać z publicznością!

## Idź tam, gdzie znajdziesz odbiorców twojego projektu (online)

Internetowy zasięg to świetny sposób na szybkie udostępnianie i rozpowszechnianie treści. Korzystając z kanałów online, możesz dotrzeć do bardzo szerokiego grona odbiorców.

Skorzystaj z istniejących społeczności i platform internetowych, aby dotrzeć do odbiorców. Jeśli twój projekt open source jest projektem oprogramowania, prawdopodobnie znajdziesz odbiorców [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), lub [Quora](https://www.quora.com/). Znajdź kanały, w których twoim zdaniem ludzie najbardziej skorzystają lub będą podekscytowani twoją pracą.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Each program has very specific functions that only a fraction of users will find useful. Don't spam as many people as possible. Instead, target your efforts to communities that will benefit from knowing about your project.
  </i>
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Określ odpowiednie sposoby na udostępnienie swojego projektu:

* **Poznaj odpowiednie projekty i społeczności opensource.** Czasami nie musisz bezpośrednio promować swojego projektu. Jeśli twój projekt jest idealny dla programistów zajmujących się danymi, którzy używają Pythona, poznaj społeczności data science w Pythonie. Gdy ludzie cię poznają, pojawią się naturalne okazje do rozmowy i dzielenia się twoją pracą.
* **Znajdź osoby, które mają jakiś problem którego rozwiązaniem może być twój projekt** Przeszukuj powiązane fora osób, które należą do grupy docelowej twojego projektu. Odpowiedz na ich pytania i znajdź taktowny sposób, w stosownych przypadkach, aby zaproponować swój projekt jako rozwiązanie.
* **Poproś o opinię.** Przedstaw siebie i swoją pracę publiczności, która uznałaby ją za przydatną i interesującą. Sprecyzuj, kto według ciebie skorzystałby na twoim projekcie. Spróbuj dokończyć zdanie: _"Myślę, że mój projekt naprawdę pomógłby X, który próbuje zrobić Y"_. Słuchaj opinii innych i odpowiadaj na nie, zamiast po prostu promować swoją pracę.

Ogólnie rzecz biorąc, skup się na pomaganiu innym, zanim poprosisz o coś w zamian. Ponieważ każdy może z łatwością promować projekt online, ale by wyróżnić się z tłumu, daj ludziom kontekst, kim jesteś, a nie tylko to, czego chcesz.

Jeśli nikt nie zwraca uwagi lub nie reaguje na twoje pierwsze działania, nie zniechęcaj się! Większość wprowadzeń projektów jest procesem iteracyjnym, który może potrwać miesiące lub lata. Jeśli nie otrzymasz odpowiedzi za pierwszym razem, wypróbuj inną taktykę lub poszukaj sposobów, aby w pierwszej kolejności zwiększyć wartość pracy innych. Promowanie i uruchomienie projektu wymaga czasu i poświęcenia.

## Idź tam, gdzie są odbiorcy dla twojego projektu (offline)

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

Wydarzenia offline są popularnym sposobem promowania nowych projektów wśród odbiorców. To świetny sposób na dotarcie do zaangażowanej publiczności i budowanie głębszych kontaktów międzyludzkich, szczególnie jeśli chcesz dotrzeć do programistów.

Jeśli jesteś [nowy w wystąpieniach publicznych](https://speaking.io/), zacznij od znalezienia lokalnego spotkania związanego z językiem lub ekosystemem powiązanym z twoim projektem.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  <i>
  I was pretty nervous about going to PyCon. I was giving a talk, I was only going to know a couple of people there, I was going for an entire week. (...) I shouldn't have worried, though. PyCon was phenomenally awesome! (...) Everyone was incredibly friendly and outgoing, so much that I rarely found time not to talk to people!
  </i>
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Jeśli nigdy wcześniej nie rozmawiałeś na żadnym wydarzeniu, to zupełnie normalne, że się denerwujesz! Pamiętaj, że twoi odbiorcy są tam, ponieważ naprawdę chcą usłyszeć o twojej pracy.

Pisząc swoje przemówienie, skup się na tym, co zainteresuje twoją publiczność i czerp z niej wartość. Twój język powinien być przyjazny i przystępny. Uśmiechnij się, oddychaj i baw się dobrze.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  <i>
  When you start writing your talk, no matter what your topic is, it can help if you see your talk as a story that you tell people.
  </i>
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Kiedy będziesz gotowy, przemów na konferencji, aby przedstawić swój projekt. Konferencje mogą pomóc ci dotrzeć do większej liczby odbiorców, czasem z całego świata.

Szukaj konferencji specyficznych dla twojego języka lub ekosystemu. Przed przesłaniem swojego przemówienia zapoznaj się z konferencją, aby dostosować ją do uczestników i zwiększyć swoje szanse na przyjęcie na przemówienie. Często możesz poznać odbiorców, patrząc na prelegentów konferencji.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  <i>
  I wrote very nicely to the JSConf people and begged them to give me a slot where I could present it at JSConf EU. (...) I was extremely scared, presenting this thing that I had been working on for six months. (...) The whole time I was just thinking, oh my God. What am I doing here?
  </i>
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Zbuduj reputację

Oprócz strategii przedstawionych powyżej, najlepszym sposobem zapraszania ludzi do udziału w twoim projekcie jest branie udziału w ich projektach.

Pomaganie nowicjuszom, dzielenie się zasobami i merytoryczny wkład w projekty innych osób pomoże ci zbudować pozytywną reputację. Bycie aktywnym członkiem społeczności open source pomoże ludziom mieć kontekst dla twojej pracy i będzie bardziej prawdopodobne, że zwrócą uwagę i podzielą się twoim projektem. Rozwijanie relacji z innymi projektami typu open source może nawet prowadzić do oficjalnych partnerstw.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  <i>
  The only reason urllib3 is the most popular third-party Python library today is because it's part of requests.
  </i>
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Nigdy nie jest za wcześnie ani za późno, aby zacząć budować swoją reputację. Nawet jeśli już uruchomiłeś własny projekt, nadal szukaj sposobów, aby pomóc innym.

Nie ma jednodniowego rozwiązania dla budowania widowni. Zdobycie zaufania i szacunku innych wymaga czasu, a budowanie reputacji nigdy się nie kończy.

## Tak trzymaj!

Może minąć dużo czasu, zanim ludzie zauważą twój projekt open source. W porządku! Niektóre z najbardziej popularnych projektów zajęły lata, aby osiągnąć wysoki poziom aktywności. Skoncentruj się na budowaniu relacji, zamiast mieć nadzieję, że twój projekt spontanicznie zyska popularność. Bądź cierpliwy i dziel się swoją pracą z tymi, którzy ją doceniają.
