---
lang: pl
title: Twój kodeks postępowania
description: Promowanie przyjaznych i konstruktywnych zachowań poprzez przyjęcie i egzekwowanie kodeksu postępowania.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Dlaczego potrzebuję kodeksu postępowania?

Kodeks postępowania to dokument, który określa oczekiwania dotyczące zachowania uczestników projektu. Przyjęcie i egzekwowanie kodeksu postępowania może pomóc stworzyć pozytywną atmosferę wśród społeczności.

Kodeksy postępowania chronią nie tylko uczestników, ale i ciebie. Jeśli utrzymujesz projekt, może się okazać, że nieproduktywne postawy innych uczestników mogą z czasem powodować wyczerpanie lub niezadowolenie z pracy.

Kodeks postępowania umożliwia ci przyjazne i konstruktywne zachowania wśród społeczności projektu. Aktywne podejście zmniejsza prawdopodobieństwo zmęczenia się swoim projektem i pomaga podejmować działania, gdy ktoś robi coś, z czym się nie zgadzasz.

## Ustanowienie kodeksu postępowania

Postaraj się ustalić kodeks postępowania tak wcześnie, jak to możliwe: najlepiej na samym początku projektu.

Oprócz przekazywania swoich oczekiwań kodeks postępowania opisuje następujące kwestie:

* Gdzie obowiązuje kodeks postępowania _(tylko w przypadku problemów i pull requestów lub przy różnych wydarzeniach społeczności)_
* Do kogo odnosi się kodeks postępowania _(członków społeczności i opiekunów, ale także na przykład sponsorów)_
* Co się stanie, jeśli ktoś naruszy kodeks postępowania
* Jak ktoś może zgłaszać naruszenia

Gdziekolwiek możesz, skorzystaj z istniejących szablonów. [Przymierze współautorów](https://contributor-covenant.org/) to rozwijany kodeks postępowania używany przez ponad 40 000 projektów open source, w tym Kubernetes, Rails i Swift.

[Kodeks postępowania Django](https://www.djangoproject.com/conduct/) oraz [Kodeks postępowania obywatelskiego](https://web.archive.org/web/20200330154000/http://citizencodeofconduct.org/) to także dwa przykłady dobrych kodeksów postępowania.

Umieść plik CODE_OF_CONDUCT w katalogu głównym projektu i uczyń go widocznym dla społeczności, łącząc go z plikiem CONTRIBUTING  lub README.

## Zdecyduj, jak będziesz egzekwować swój kodeks postępowania

<aside markdown="1" class="pquote">
  A code of conduct that isn't (or can't be) enforced is worse than no code of conduct at all: it sends the message that the values in the code of conduct aren't actually important or respected in your community.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

Musisz wyjaśnić, w jaki sposób Twój kodeks postępowania będzie egzekwowany **_zanim_** nastąpi naruszenie. Istnieje kilka powodów, dla których warto to zrobić:

* To pokazuje, że poważnie podchodzisz do działania, gdy jest to potrzebne.

* Twoja społeczność poczuje się bardziej pewnie, że skargi faktycznie zostaną rozpatrzone.

* Zapewnisz swoją społeczność, że proces sprawdzania jest uczciwy i przejrzysty, jeśli kiedykolwiek zostaną sprawdzeni pod kątem naruszenia.

Powinieneś dać ludziom poufny sposób (np. Adres e-mail), do zgłoszenia naruszenia zasad postępowania i wyjaśnić, kto otrzyma to zgłoszenie. Może to być opiekun, grupa opiekunów lub grupa robocza ds. Kodeksu postępowania.

Nie zapominaj, że ktoś może chcieć zgłosić naruszenie dotyczące osoby, która je otrzyma. W takim przypadku daj im możliwość zgłaszania naruszeń komuś innemu. Na przykład tak jak, @ctb oraz @mr-c [tłumaczą w swoim projekcie](https://github.com/dib-lab/khmer/blob/HEAD/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Przypadki obraźliwych, nękających lub w inny sposób niedopuszczalnych zachowań można zgłaszać, wysyłając wiadomość e-mail na adres **khmer-project@idyll.org**, który jest wysyłany tylko do C. Titusa Browna i Michaela R. Crusoe. Aby zgłosić problem dotyczący któregokolwiek z nich, wyślij wiadomość e-mail **dr Judi Brown Clarke** dyrektor ds. Różnorodności w Centrum Badań nad Ewolucją w Działaniu BEACON, Centrum Nauki i Technologii NSF.*

Możesz zainspirować się także [instrukcją egzekwowania Django](https://www.djangoproject.com/conduct/enforcement-manual/) (chociaż możesz nie potrzebować czegoś tak kompleksowego, w zależności od wielkości twojego projektu).

## Egzekwowanie twojego kodeksu postępowania

Czasami, pomimo twoich starań, ktoś zrobi coś, co narusza ten kodeks. Istnieje kilka sposobów przeciwdziałania negatywnym lub szkodliwym zachowaniom.

### Zbierz informacje o sytuacji

Traktuj głos każdego członka społeczności tak samo ważny jak własny. Jeśli otrzymasz zgłoszenie, że ktoś naruszył kodeks postępowania, podejmij się go na poważnie i zbadaj sprawę, nawet jeśli naruszenie nie pasuje do twoich doświadczeń z tą osobą. Takie postępowanie sygnalizuje społeczności, że cenisz ich perspektywę i ufasz ich osądowi.

Członek społeczności, o którym mowa, może wieloktrotnie sprawiać, że inni członkowie czują się niekomfortowo lub zrobić to tylko jeden raz. Oba mogą być podstawą do podjęcia działania, w zależności od kontekstu.

Zanim odpowiesz, daj sobie czas na zrozumienie, co się stało. Przeczytaj wcześniejsze komentarze i rozmowy tej osoby, aby lepiej zrozumieć, kim ona jest i dlaczego mogła postąpić w taki sposób. Spróbuj zebrać inne niż własne opinie na temat tej osoby i jej zachowania.

<aside markdown="1" class="pquote">
  Don’t get pulled into an argument. Don’t get sidetracked into dealing with someone else’s behavior before you’ve finished dealing with the matter at hand. Focus on what you need.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Podejmij odpowiednie działania

Po zebraniu i przetworzeniu wystarczających informacji musisz zdecydować, co robić. Rozważając kolejne kroki, pamiętaj, że twoim celem jako moderatora jest promowanie bezpiecznego, pełnego szacunku i współpracy środowiska. Zastanów się nie tylko, jak poradzić sobie z daną sytuacją, ale także, w jaki sposób twoja reakcja wpłynie na dalsze zachowania i oczekiwania twojej społeczności.

Gdy ktoś zgłosi naruszenie kodeksu postępowania, to twoim obowiązkiem jest wyjaśnić sprawę. Czasami osoba zgłaszająca ujawnia informacje z dużym ryzykiem dla ich kariery, reputacji lub bezpieczeństwa fizycznego. Zmuszenie ich do konfrontacji z napastnikiem może postawić osobę zgłaszającą w kompromitującej sytuacji. Należy komunikować się bezpośrednio z daną osobą, chyba że osoba zgłaszająca wyraźnie zażąda inaczej.

Istnieje kilka sposobów reagowania na naruszenie kodeksu postępowania:

* **Daj osobie, o której mowa, publiczne ostrzeżenie** i wyjaśnij, w jaki sposób ich zachowanie wpłynęło negatywnie na innych, najlepiej w kanale, w którym miało miejsce. Tam, gdzie to możliwe, komunikacja publiczna przekazuje reszcie społeczności, że poważnie podchodzisz do kodeksu postępowania. Bądź miły, ale stanowczy w swojej komunikacji.

* **Prywatnie skontaktuj się z osobą** w celu wyjaśnienia, w jaki sposób ich zachowanie wpłynęło negatywnie na innych. Możesz skorzystać z prywatnego kanału komunikacji, jeśli sytuacja dotyczy poufnych danych osobowych. Jeśli komunikujesz się z kimś prywatnie, dobrym pomysłem jest skontaktowanie się z osobami, które jako pierwsze zgłosiły sytuację, aby wiedziały, że podjąłeś działania. Poproś osobę zgłaszającą o zgodę o ujawnienie jej przed wysłaniem wiadomości.

Czasami nie można osiągnąć rozwiązania. Dana osoba może stać się agresywna lub wroga, gdy zostanie skonfrontowana lub nie zmieni swojego zachowania. W tej sytuacji możesz rozważyć podjęcie silniejszych działań. Na przykład:

* **Zawieś osobę** w kwestii projektu, egzekwowane przez tymczasowy zakaz uczestnictwa w jakimkolwiek aspekcie projektu

* **Trwale zbanuj** tę osobę w projekcie

Zbanowanych członków nie należy lekceważyć, stanowią trwałą i niemożliwą do pogodzenia różnicę perspektyw. Powinieneś podjąć te środki tylko wtedy, gdy jest jasne, że nie można osiągnąć rozwiązania.

## Twoje obowiązki jako opiekuna

Kodeks postępowania nie jest prawem egzekwowanym arbitralnie. Jesteś podmiotem egzekwującym kodeks postępowania i twoim obowiązkiem jest przestrzegać zasad ustanowionych w tym kodeksie postępowania.

Jako opiekun ustalasz wytyczne dla swojej społeczności i egzekwujesz je zgodnie z zasadami określonymi w kodeksie postępowania. Oznacza to poważne potraktowanie każdego zgłoszenia naruszenia kodeksu postępowania. Zgłaszającemu należy się dokładna i rzetelna ocena jego skargi. Jeśli stwierdzisz, że zgłoszone przez nich zachowanie nie stanowi naruszenia, przekaż im to jasno i wyjaśnij, dlaczego nie zamierzasz podjąć działań w związku z tym. To, co zrobią z tym, zależy od nich: tolerować zachowanie, z którym mieli problem, lub przestać uczestniczyć w społeczności.

Zgłoszenie zachowania, które nie narusza kodeksu postępowania, może nadal wskazywać na problem w twojej społeczności i powinieneś zbadać ten potencjalny problem i podjąć odpowiednie działania. Może to obejmować rewizję twojego kodeksu postępowania w celu wyjaśnienia dopuszczalnego zachowania i / lub rozmowę z osobą, której zachowanie zostało zgłoszone i poinformowanie ich, że chociaż nie naruszyli kodeksu postępowania, omijają granicę oczekiwań i sprawiają, że uczestnicy czują się niekomfortowo.

W końcu, jako opiekun, ustalasz i egzekwujesz standardy dotyczące akceptowalnego zachowania. Masz możliwość kształtowania wartości społeczności w ramach projektu, a uczestnicy oczekują, że egzekwujesz te wartości w uczciwy i zrównoważony sposób.

## Zachęcaj do zachowań, które chcesz zobaczyć na świecie 🌎

Kiedy projekt wydaje się wrogi lub niechciany, nawet jeśli jest to tylko jedna osoba, której zachowanie jest tolerowane przez innych, ryzykujesz utratą znacznie większej liczby współpracowników, a niektórzy nigdy nie dołączą do społeczności twojego projektu. Przyjęcie lub egzekwowanie kodeksu postępowania nie zawsze jest łatwe, ale promowanie przyjaznego środowiska pomoże twojej społeczności w rozwoju.
