---
lang: pl
title: Budowanie przyjaznych społeczności
description: Zbuduj społeczność, która zachęca ludzi do korzystania, przyczyniania się i ewangelizacji twojego projektu.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Przygotowywanie projektu do sukcesu

Uruchomiłeś swój projekt, rozpowszechniasz informacje, a ludzie to sprawdzają. Niesamowite! Jak możesz ich zatrzymać na dłużej?

Przyjazna społeczność to inwestycja w przyszłość i reputację twojego projektu. Jeśli Twój projekt dopiero zaczyna widzieć swój pierwszy wkład, zacznij od dawania wczesnym współpracownikom pozytywnych wrażeń i ułatw im powrót.

### Spraw, by ludzie czuli się mile widziani

Jednym ze sposobów myślenia o społeczności twojego projektu jest to, co @MikeMcQuaid nazywa [ścieżką współtwórcy](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Tworząc społeczność, zastanów się, jak teoretycznie osoba na górze ścieżki (potencjalny użytkownik) może zejść na dół (aktywny opiekun). Twoim celem jest zmniejszenie tarcia na każdym etapie korzystania z pomocy. Kiedy ludzie mają łatwe wygrane, będą czuć się zachęcani do robienia więcej.

Zacznij od dokumentacji:

* **Ułatw innym korzystanie z Twojego projektu.** [Przyjazny README](../starting-a-project/#pisanie-readme) jasne przykłady kodu ułatwią rozpoczęcie pracy każdemu, kto wyląduje na Twoim projekcie.
* **Wyjaśnij, jak wnieść wkład**, używając [twój plik CONTRIBUTING](../starting-a-project/#pisanie-swoich-wytycznych) i aktualizując swoje issues.
* **Dobre pierwsze issues**: Aby pomóc nowym autorom w rozpoczęciu pracy, rozważ wyraźnie [problemy z etykietowaniem, które są na tyle proste, że początkujący mogą je rozwiązać](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub wyświetli te problemy w różnych miejscach na platformie, zwiększając użyteczny wkład i zmniejszając tarcie ze strony użytkowników zajmujących się problemami, które są zbyt trudne dla ich poziomu.

[Ankieta GitHuba 2017 Open Source](http://opensourcesurvey.org/2017/) wykazała, że niekompletna lub myląca dokumentacja jest największym problemem dla użytkowników open source. Dobra dokumentacja zachęca ludzi do interakcji z Twoim projektem. W końcu ktoś otworzy problem lub wyciągnie prośbę. Użyj tych interakcji jako okazji do przeniesienia ich w dół ścieżki.

* **Gdy ktoś nowy wyląduje w twoim projekcie, podziękuj mu za zainteresowanie!** Wystarczy jedno negatywne doświadczenie, aby ktoś już nie chciał wracać.
* **Reaguj szybko.** Jeśli nie odpowiesz na ich problem przez miesiąc, są duże szanse, że zapomnną o twoim projekcie.
* **Miej otwarty umysł na typy wkładów, które akceptujesz.** Wielu autorów zaczyna od zgłoszenia błędu lub drobnej poprawki. Istnieje [wiele sposobów na wniesienie wkładu](../how-to-contribute/#co-to-znaczy-przyczynić-się) do projektu. Pozwól ludziom pomóc, jak chcą pomóc.
* **Jeśli masz wkład, z którym się nie zgadzasz,** podziękuj im za pomysł i [wyjaśnij dlaczego](../best-practices/#naucz-się-mówić-nie) to nie pasuje do zakresu projektu, zawierając link do odpowiedniej dokumentacji.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Contributing to open source is easier for some than others. There's a lot of fear of being yelled at for not doing something right or just not fitting in. (...) By giving contributors a place to contribute with very low technical proficiency (documentation, web content markdown, etc) you can greatly reduce those concerns.
  </i>
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Większość współpracowników open source to „przypadkowi współpracownicy”: ludzie, którzy przyczyniają się do projektu tylko sporadycznie. Przypadkowy współpracownik może nie mieć czasu, aby w pełni przyspieszyć Twój projekt, więc Twoim zadaniem jest ułatwienie im wnoszenia wkładu.

Zachęcanie innych współpracowników to także inwestycja w ciebie. Gdy umożliwisz swoim największym fanom bieganie z pracą, którą są podekscytowani, zmniejszysz presję, aby robić wszystko sam.

### Wszystko dokumentuj

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Have you ever been to a (tech-) event where you didn't know anyone, but everyone else seemed to stand in groups and chat like old friends? (...) Now imagine you want to contribute to an open source project, but you don't see why or how this is happening.
  </i>
  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Kiedy zaczynasz nowy projekt, naturalne może być zachowanie prywatności w pracy. Ale projekty open source kwitną, gdy dokumentujesz proces publicznie.

Kiedy spisujesz rzeczy, więcej osób może brać udział na każdym etapie. Możesz uzyskać pomoc dotyczącą czegoś, o czym nawet nie wiedziałeś, że potrzebujesz.

Zapisywanie rzeczy to coś więcej niż dokumentacja techniczna. Za każdym razem, gdy poczujesz potrzebę coś zapisać lub prywatnie przedyskutować swój projekt, zadaj sobie pytanie, czy możesz to upublicznić.

Zachowaj przejrzystość na temat planu projektu, rodzajów wkładów, których szukasz, sposobu ich sprawdzania lub powodów, dla których podjąłeś określone decyzje.

Jeśli zauważysz, że wielu użytkowników napotyka ten sam problem, udokumentuj odpowiedzi w pliku README.

W przypadku spotkań rozważ opublikowanie swoich notatek lub treści w odpowiednim wydaniu. Uzyskane informacje zwrotne mogą Cię zaskoczyć.

Dokumentowanie wszystkiego dotyczy także wykonywanej pracy. Jeśli pracujesz nad istotną aktualizacją projektu, prześlij ją do pull requesta i oznacz jako trwającą (WIP). W ten sposób inne osoby mogą wcześnie poczuć się zaangażowane w ten proces.

### Bądź responsywny

Gdy [promujesz swój projekt](../finding-users/), ludzie będą mieli dla ciebie opinie. Mogą mieć pytania dotyczące sposobu działania lub potrzebują pomocy na początku.

Postaraj się reagować, gdy ktoś zgłosi problem, prześle pull request lub zadaje pytanie o Twój projekt. Gdy odpowiesz szybko, ludzie poczują, że są częścią dialogu i będą bardziej entuzjastycznie nastawieni do uczestnictwa w projekcie.

Nawet jeśli nie możesz natychmiast przejrzeć żądania, jego wcześniejsze potwierdzenie pomaga zwiększyć zaangażowanie. Oto jak @tdreyno odpowiedział na pull request na [Middleman](https://github.com/middleman/middleman/pull/1466):

![Middleman pull request](/assets/images/building-community/middleman_pr.png)

[Badanie Mozilli wykazało, że](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) autorzy, którzy otrzymali recenzje kodu w ciągu 48 godzin, uzyskali znacznie wyższą stopę zwrotu i powtarzalny wkład.

Rozmowy na temat Twojego projektu mogą odbywać się również w innych miejscach w Internecie, takich jak Stack Overflow, Twitter lub Reddit. Możesz skonfigurować powiadomienia w niektórych z tych miejsc, aby otrzymywać powiadomienia, gdy ktoś wspomina o Twoim projekcie.

### Daj społeczności możliwość gromadzenia się

Istnieją dwa powody, aby dać społeczności możliwość gromadzenia się.

Pierwszy powód jest dla nich. Pomóż ludziom się poznać. Ludzie o wspólnych zainteresowaniach będą chcieli o tym porozmawiać. A gdy komunikacja jest publiczna i dostępna, każdy może czytać archiwa, aby zapoznać się z projektem i wziąć w nim udział.

Drugi powód jest dla ciebie. Jeśli nie dasz ludziom publicznego miejsca na rozmowę o twoim projekcie, prawdopodobnie skontaktują się z tobą bezpośrednio. Na początku może wydawać się dość łatwe odpowiadanie na prywatne wiadomości „tylko raz”. Ale z czasem, szczególnie jeśli twój projekt stanie się popularny, poczujesz się wyczerpany. Oprzyj się pokusie prywatnego komunikowania się z ludźmi na temat twojego projektu. Zamiast tego skieruj ich do wyznaczonego kanału publicznego.

Komunikacja publiczna może być tak prosta, jak nakłanianie ludzi do otwarcia problemu zamiast bezpośredniego wysyłania e-maili lub komentowania na blogu. Możesz także skonfigurować listę mailingową lub utworzyć konto na Twitterze, Slack lub kanał IRC, aby ludzie mogli rozmawiać o twoim projekcie. Lub wypróbuj wszystkie powyższe!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) co drugi tydzień przeznacza godziny urzędowania, aby pomóc członkom społeczności:

> Kops also has time set aside every other week to offer help and guidance to the community. Kops maintainers have agreed to set aside time specifically dedicated to working with newcomers, helping with PRs, and discussing new features.

Ważnymi wyjątkami od komunikacji publicznej są: 1) kwestie bezpieczeństwa i 2) poufny kodeks postępowania. Zawsze powinieneś mieć możliwość zgłaszania tych problemów prywatnie. Jeśli nie chcesz korzystać z osobistego adresu e-mail, skonfiguruj dedykowany adres e-mail.

## Rozwijanie społeczności

Społeczności są niezwykle potężne. Ta moc może być błogosławieństwem lub przekleństwem, w zależności od tego, jak ją władasz. Gdy społeczność twojego projektu rośnie, istnieją sposoby, aby pomócjej stać się siłą kontruktywną, a nie destruktywną.

### Nie toleruj złych aktorów

Każdy popularny projekt nieuchronnie przyciągnie ludzi, którzy bardziej szkodzą niż pomagają twojej społeczności. Mogą rozpocząć niepotrzebne debaty, spierać się o trywialne funkcje lub zastraszać innych.

Staraj się przyjąć politykę zerowej tolerancji dla tego rodzaju ludzi. Jeśli takie zachowanie pozostanie niezauważone, negatywni ludzie sprawią, że inni ludzie w Twojej społeczności będą czuć się niekomfortowo. Mogą nawet odejść.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  <i>
  The truth is that having a supportive community is key. I'd never be able to do this work without the help of my colleagues, friendly internet strangers, and chatty IRC channels. (...) Don't settle for less. Don't settle for assholes.
  </i>
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Regularne debaty na temat trywialnych aspektów projektu odwracają uwagę innych, w tym ciebie, od koncentrowania się na ważnych zadaniach. Nowe osoby, które przybędą do Twojego projektu, mogą zobaczyć te rozmowy i nie chcą brać w nich udziału.

Kiedy zobaczysz negatywne zachowanie w twoim projekcie, wywołaj to publicznie. Wyjaśnij, życzliwym, ale zdecydowanym tonem, dlaczego ich zachowanie jest nie do przyjęcia. Jeśli problem będzie się powtarzał, być może będziesz musiał [poprosić ich o odejście](https://github.com/mbiesiad/opensource.guide/blob/pl/_articles/code-of-conduct.md/#enforcing-your-code-of-conduct). Twój [kodeks postępowania](../code-of-conduct/) może być konstruktywnym przewodnikiem dla tych rozmów.

### Poznaj współpracowników tam, gdzie są

Dobra dokumentacja staje się coraz ważniejsza w miarę rozwoju społeczności. Przypadkowi współpracownicy, którzy w innym przypadku mogliby nie znać Twojego projektu, czytają dokumentację, aby szybko uzyskać potrzebny im kontekst.

W swoim pliku CONTRIBUTING wyraźnie powiedz nowym autorom, jak zacząć. Możesz nawet utworzyć specjalną sekcję do tego celu. [Django](https://github.com/django/django), na przykład, ma specjalną stronę docelową, aby powitać nowych autorów.

![Django new contributors page](/assets/images/building-community/django_new_contributors.png)

W twojej kolejce issue, oznacz błędy, które są odpowiednie dla różnych typów autorów: na przykład, [_"first timers only"_](https://kentcdodds.com/blog/first-timers-only), _"good first issue"_, or _"documentation"_. [These labels](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) ułatw komuś nowemu w swoim projekcie szybkie skanowanie problemów i rozpoczęcie pracy.

Na koniec skorzystaj z dokumentacji, aby ludzie czuli się mile widziani na każdym etapie.

Nigdy nie będziesz wchodzić w interakcje z większością ludzi, którzy wylądują na twoim projekcie. Mogą istnieć kontrybucje, których nie otrzymałeś, ponieważ ktoś czuł się zastraszony lub nie wiedział, od czego zacząć. Nawet kilka miłych słów może zniechęcić kogoś do opuszczenia projektu.

Na przykład oto jak [Rubinius](https://github.com/rubinius/rubinius/) zaczyna [jego pomocny przewodnik](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> We want to start off by saying thank you for using Rubinius. This project is a labor of love, and we appreciate all of the users that catch bugs, make performance improvements, and help with documentation. Every contribution is meaningful, so thank you for participating. That being said, here are a few guidelines that we ask you to follow so we can successfully address your issue.

### Udostępnij własność swojego projektu

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Your leaders will have different opinions, as all healthy communities should! However, you need to take steps to ensure the loudest voice doesn't always win by tiring people out, and that less prominent and minority voices are heard.
  </i>
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Ludzie są podekscytowani, że mogą uczestniczyć w projektach, kiedy mają poczucie własności. Nie oznacza to, że musisz zmienić wizję swojego projektu lub zaakceptować wkład, którego nie chcesz. Ale im więcej dajesz uznania innym, tym bardziej będą się trzymać.

Sprawdź, czy możesz w jak największym stopniu znaleźć sposób na dzielenie się własnością ze społecznością. Oto kilka pomysłów:

* **Odporne na naprawianie łatwych (niekrytycznych) błędów.** Zamiast tego wykorzystaj je jako okazję do rekrutacji nowych współpracowników lub mentora dla kogoś, kto chciałby się przyłączyć. Na początku może się to wydawać nienaturalne, ale z czasem inwestycja się zwróci. Na przykład @michaeljoseph poprosił współpracownika o przesłanie żądania ściągnięcia w sprawie [Cookiecutter](https://github.com/audreyr/cookiecutter) poniżej, zamiast samemu go naprawić.

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Uruchom plik CONTRIBUTORS lub AUTHORS w swoim projekcie** zawiera listę wszystkich, którzy przyczynili się do twojego projektu, takich jak [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md).

* Jeśli masz sporą społeczność, **wyślij biuletyn lub napisz post na blogu** dziękując autorom. Rusta [This Week in Rust](https://this-week-in-rust.org/) i Hoodie'ego [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) są dwoma dobrymi przykładami

* **Daj dostęp każdemu współautorowi.** @felixge stwierdził, że to sprawiło, że ludzie są [bardziej podekscytowani dopracowywaniem swoich łat](https://felixge.de/2013/03/11/the-pull-request-hack.html), a nawet znalazł nowych opiekunów dla projektów, nad którymi on od jakiegoś czasu nie pracował.

* Jeśli Twój projekt jest w serwisie GitHub, **przenieś swój projekt z konta osobistego do [Organizacji](https://help.github.com/articles/creating-a-new-organization-account/)** i dodaj co najmniej jednego administratora kopii zapasowych. Organizacje ułatwiają pracę nad projektami z zewnętrznymi współpracownikami.

Rzeczywistość jest taka, że [większość projektów ma tylko](https://peerj.com/preprints/1233/) jednego lub dwóch opiekunów, którzy wykonują większość pracy. Im większy projekt i większa społeczność, tym łatwiej jest znaleźć pomoc.

Chociaż nie zawsze możesz znaleźć kogoś, kto odbierze połączenie, wysłanie sygnału zwiększa szanse na pojawienie się innych osób. Im wcześniej zaczniesz, tym szybciej ludzie mogą pomóc.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  <i>
  \[It's in your\] best interest to recruit contributors who enjoy and who are capable of doing the things that you are not. Do you enjoy coding, but not answering issues? Then identify those individuals in your community who do and let them have it.
  </i>
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Rozwiązywanie konfliktów

Na wczesnych etapach projektu podejmowanie poważnych decyzji jest łatwe. Kiedy chcesz coś zrobić, po prostu to zrób.

W miarę jak Twój projekt staje się coraz bardziej popularny, więcej osób będzie zainteresowanych podejmowanymi przez ciebie decyzjami. Nawet jeśli nie masz dużej społeczności współpracowników, jeśli Twój projekt ma wielu użytkowników, znajdziesz osoby rozważające decyzje lub podejmujące własne problemy.

W większości przypadków, jeśli kultywujesz przyjazną, pełną szacunku społeczność i otwarcie dokumentujesz swoje procesy, twoja społeczność powinna być w stanie znaleźć rozwiązanie. Ale czasami napotykasz problem, który jest nieco trudniejszy do rozwiązania.

### Ustaw poprzeczkę życzliwości

Gdy Twoja społeczność zmaga się z trudnym problemem, temperament może wzrosnąć. Ludzie mogą się złościć lub sfrustrować i wyładowywać się na sobie nawzajem lub na tobie.

Twoim zadaniem jako opiekuna jest zapobieganie eskalacji tych sytuacji. Nawet jeśli masz silną opinię na ten temat, spróbuj zająć stanowisko moderatora lub facylitatora, zamiast wskakiwać do walki i forsować swoje poglądy. Jeśli ktoś jest nieuprzejmy lub monopolizuje rozmowę, [działaj natychmiast](https://github.com/mbiesiad/opensource.guide/blob/pl/_articles/building-community.md/#dont-tolerate-bad-actors) aby dyskusje były spokojne i owocne.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  <i>
  As a project maintainer, it's extremely important to be respectful to your contributors. They often take what you say very personally.
  </i>
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Inne osoby szukają u ciebie wskazówek. Stanów dobry przykład. Nadal możesz wyrażać rozczarowanie, nieszczęście lub troskę, ale rób to spokojnie.

Utrzymanie spokoju nie jest łatwe, ale wykazanie się przywództwem poprawia zdrowie społeczności. Internet dziękuje.

### Traktuj swój plik README jak konstytucję

Twój plik README to [więcej niż tylko zestaw instrukcji](../starting-a-project/#pisanie-readme). To także miejsce, w którym można porozmawiać o swoich celach, wizji produktu i mapie drogowej. Jeśli ludzie nadmiernie skupiają się na debacie na temat zalet konkretnej funkcji, pomocne może być ponowne przejrzenie pliku README i omówienie wyższej wizji projektu. Skupienie się na README powoduje również depersonalizację rozmowy, dzięki czemu możesz prowadzić konstruktywną dyskusję.

### Skoncentruj się na podróży, a nie na celu

Niektóre projekty wykorzystują proces głosowania do podejmowania ważnych decyzji. Na pierwszy rzut oka to jest rozsądne, ale głosowanie kładzie nacisk na dotarcie do „odpowiedzi”, a nie na wzajemnym słuchaniu i rozwiązywaniu problemów.

Głosowanie może mieć charakter polityczny, w którym członkowie społeczności czują się zmuszeni do wzajemnego wyświadczania przysług lub głosowania w określony sposób. Nie wszyscy też głosują, czy też jest to [cicha większość](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) w Twojej społeczności lub obecni użytkownicy, którzy nie wiedzieli, że głosowanie ma miejsce.

Czasami głosowanie jest niezbędnym czynnikiem rozstrzygającym. Jednak w miarę możliwości podkreślaj ["szukanie konsensusu"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) zamiast konsensusu.

W ramach procesu poszukiwania konsensusu członkowie społeczności omawiają główne obawy, dopóki nie poczują, że zostali odpowiednio wysłuchani. Gdy pozostaną tylko drobne obawy, społeczność idzie naprzód. „Poszukiwanie konsensusu” potwierdza, że społeczność może nie być w stanie znaleźć idealnej odpowiedzi. Zamiast tego priorytetem jest słuchanie i dyskusja.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Part of the reason why a voting system doesn't exist for Atom Issues is because the Atom team isn't going to follow a voting system in all cases. Sometimes we have to choose what we feel is right even if it is unpopular. (...) What I can offer and pledge to do...is that it is my job to listen to the community.
  </i>
  <p markdown="1" class="pquote-credit">
— @lee-dohm on Atom's decision making process
  </p>
</aside>

Nawet jeśli tak naprawdę nie przyjmujesz procesu poszukiwania konsensusu, jako opiekun projektu ważne jest, aby ludzie wiedzieli, że słuchasz. Sprawienie, by inni poczuli się wysłuchani i zobowiązanie się do rozwiązania ich obaw, znacznie przyczynia się do rozproszenia wrażliwych sytuacji. Następnie postępuj zgodnie ze swoimi słowami za pomocą działań.

Nie spiesz się z decyzją. Upewnij się, że wszyscy czują się wysłuchani i że wszystkie informacje zostały upublicznione przed przejściem do rozwiązania.

### Skoncentruj rozmowę na działaniu

Dyskusja jest ważna, ale istnieje różnica między produktywnymi i nieproduktywnymi rozmowami.

Zachęcaj do dyskusji, o ile aktywnie dąży ona do rozwiązania problemu. Jeśli jest oczywiste, że rozmowa gubi się lub odchodzi od tematu, dźgnięcia stają się osobiste lub ludzie kłócą się o drobne szczegóły, nadszedł czas, aby ją zamknąć.

Zezwolenie na kontynuowanie tych rozmów jest nie tylko szkodliwe dla omawianego problemu, ale także niekorzystne dla Twojej społeczności. Wysyła wiadomość, że tego rodzaju rozmowy są dozwolone, a nawet zachęcane, i może zniechęcać ludzi do podnoszenia lub rozwiązywania przyszłych problemów.

W każdym punkcie przedstawionym przez ciebie lub przez innych zadawaj sobie pytanie: _"W jaki sposób zbliża nas to do rozwiązania?"_

Jeśli rozmowa zaczyna się rozwiązywać, zapytaj grupę: _"Jakie kroki powinniśmy podjąć w następnej kolejności?"_, aby ponownie skoncentrować rozmowę.

Jeśli rozmowa najwyraźniej nigdzie się nie kończy, nie ma wyraźnych działań do wykonania lub podjęto już odpowiednie działanie, zamknij problem i wyjaśnij, dlaczego go zamknąłeś.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  <i>
  Guiding a thread toward usefulness without being pushy is an art. It won't work to simply admonish people to stop wasting their time, or to ask them not to post unless they have something constructive to say. (...) Instead, you have to suggest conditions for further progress: give people a route, a path to follow that leads to the results you want, yet without sounding like you're dictating conduct.
  </i>
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Mądrze wybieraj swoje bitwy

Kontekst jest ważny. Zastanów się, kto jest zaangażowany w dyskusję i jak reprezentuje resztę społeczności.

Czy wszyscy w społeczności są zaniepokojeni, czy nawet zaangażowani w ten problem? A może samotny problemator? Nie zapomnij wziąć pod uwagę swoich cichych członków społeczności, a nie tylko aktywnych głosów.

Jeśli problem nie odzwierciedla szerszych potrzeb Twojej społeczności, być może będziesz musiał uznać obawy kilku osób. Jeśli jest to powtarzający się problem bez jednoznacznego rozwiązania, wskaż je na poprzednich dyskusjach na ten temat i zamknij wątek.

### Zidentyfikuj remis społeczności

Przy dobrym nastawieniu i jasnej komunikacji najtrudniejsze sytuacje można rozwiązać. Jednak nawet w produktywnej rozmowie może istnieć różnica w opiniach co do sposobu postępowania. W takich przypadkach określ osobę lub grupę osób, które mogą służyć jako rozstrzygające.

Tiebreaker może być głównym opiekunem projektu lub może być małą grupą ludzi, którzy podejmują decyzję na podstawie głosowania. Idealnie byłoby, gdybyś zidentyfikował program rozstrzygający i powiązany proces w pliku GOVERNANCE, zanim będziesz musiał go użyć.

Twój remis powinien być ostatecznością. Problemy dzielące są szansą dla Twojej społeczności na rozwój i naukę. Wykorzystaj te możliwości i wykorzystaj proces współpracy, aby w miarę możliwości przejść do rozwiązania.

## Społeczność jest ❤️ open source

Zdrowe, dobrze prosperujące społeczności napędzają tysiące godzin wkładanych w open source każdego tygodnia. Wielu współautorów wskazuje inne osoby jako powód do pracy - lub nie - nad otwartym oprogramowaniem. Ucząc się, jak konstruktywnie wykorzystać tę moc, pomożesz komuś, aby doświadczył niezapomnianych wrażeń open source.
