---
lang: nl
title: Hoe u kunt bijdragen aan Open Source
description: Wil je bijdragen aan open source? Een gids voor het maken van open source-bijdragen, voor beginners en veteranen.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Waarom bijdragen aan open source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Door aan \[freenode\] te werken, heb ik veel van de vaardigheden verworven die ik later gebruikte voor mijn studie aan de universiteit en mijn huidige baan. Ik denk dat werken aan open source-projecten mij net zo goed helpt als het project!
  
  _Working on \[freenode\] helped me earn many of the skills I later used for my studies in university and my actual job. I think working on open source projects helps me as much as it helps the project!_
  <p markdown="1" class="pquote-credit">
— @errietta, ["Waarom ik graag bijdraag aan open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Bijdragen aan open source kan een lonende manier zijn om te leren, les te geven en ervaring op te doen met vrijwel elke vaardigheid die je maar kunt bedenken.

Waarom dragen mensen bij aan open source? Redenen genoeg!

### Verbeter de software waarop u vertrouwt

Veel open source-bijdragers beginnen door gebruikers te zijn van software waaraan ze bijdragen. Als je een bug vindt in open source-software die je gebruikt, wil je misschien naar de bron kijken om te zien of je deze zelf kunt patchen. Als dat het geval is, is het bijdragen van de patch de beste manier om ervoor te zorgen dat uw vrienden (en uzelf wanneer u een update naar de volgende release uitvoert) hiervan kunnen profiteren.

### Verbeter bestaande vaardigheden

Of het nu gaat om codering, ontwerp van gebruikersinterface, grafisch ontwerp, schrijven of organiseren, als u op zoek bent naar oefening, is er een taak voor u in een open source-project.

### Ontmoet mensen die geïnteresseerd zijn in soortgelijke dingen

Open source-projecten met warme, gastvrije gemeenschappen zorgen ervoor dat mensen jarenlang terug blijven komen. Veel mensen vormen vriendschappen voor het leven door deel te nemen aan open source, of ze nu elkaar tegenkomen op conferenties of 's avonds laat online chats over burrito's.

### Vind mentoren en leer anderen

Als je met anderen aan een gedeeld project werkt, moet je uitleggen hoe je de dingen doet, en ook andere mensen om hulp vragen. Het leren en onderwijzen kan voor alle betrokkenen een bevredigende activiteit zijn.

### Bouw openbare artefacten waarmee u een reputatie (en een carrière) kunt opbouwen

Al uw open source-werk is per definitie openbaar, wat betekent dat u gratis voorbeelden krijgt die u overal mee naartoe kunt nemen als demonstratie van wat u kunt doen.

### Leer de vaardigheden van mensen

Open source biedt mogelijkheden om leiderschaps- en managementvaardigheden te oefenen, zoals het oplossen van conflicten, het organiseren van teams van mensen en het prioriteren van werk.

### Het geeft kracht om veranderingen aan te brengen, zelfs kleine

U hoeft geen levenslange donateur te worden om te genieten van deelname aan open source. Heb je ooit een typefout op een website gezien en zou je willen dat iemand het zou repareren? Bij een open source-project kunt u precies dat doen. Open source helpt mensen keuzevrijheid te voelen over hun leven en hoe zij de wereld ervaren, en dat is op zichzelf al verheugend.

## Wat het betekent om bij te dragen

Als u een nieuwe open source-bijdrager bent, kan het proces intimiderend zijn. Hoe vind je het juiste project? Wat als u niet weet hoe u moet coderen? Wat als er iets mis gaat?

Geen zorgen! Er zijn allerlei manieren om betrokken te raken bij een open source-project, en een paar tips zullen u helpen het meeste uit uw ervaring te halen.

### U hoeft geen code bij te dragen

Een veel voorkomende misvatting over bijdragen aan open source is dat je code moet bijdragen. In feite zijn het vaak de andere delen van een project die [het meest worden verwaarloosd of over het hoofd gezien](https://github.com/blog/2195-the-shape-of-open-source). Je doet het project een _grote_ gunst door aan te bieden mee te werken met dit soort bijdragen!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Ik sta bekend om mijn werk aan CocoaPods, maar de meeste mensen weten niet dat ik eigenlijk geen echt werk aan de CocoaPods-tool zelf doe. Mijn tijd aan het project besteed ik voornamelijk aan zaken als documentatie en branding.
  
  _I’ve been renowned for my work on CocoaPods, but most people don’t know that I actually don’t do any real work on the CocoaPods tool itself. My time on the project is mostly spent doing things like documentation and working on branding._
  
  <p markdown="1" class="pquote-credit">
— @orta, ["Standaard naar OSS gaan"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Zelfs als je graag code schrijft, zijn andere soorten bijdragen een geweldige manier om bij een project betrokken te raken en andere leden van de gemeenschap te ontmoeten. Door die relaties op te bouwen, krijg je de kans om aan andere delen van het project te werken.

### Houd je van het plannen van evenementen?

* Organiseer workshops of meetups over het project, [zoals @fzamperin deed voor NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Organiseer de conferentie van het project (als ze er een hebben)
* Help leden van de gemeenschap de juiste conferenties te vinden en presenteer voorstellen om te spreken

### Houd je van ontwerpen?

* Herstructureer lay-outs om de bruikbaarheid van het project te verbeteren
* Voer gebruikersonderzoek uit om de navigatie of menu's van het project te reorganiseren en te verfijnen [zoals Drupal suggereert](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Stel een stijlgids samen om het project te helpen een consistent visueel ontwerp te hebben
* Maak kunst voor t-shirts of een nieuw logo, [zoals de bijdragers van hapi.js deden](https://github.com/hapijs/contrib/issues/68)

### Vind je het leuk om te schrijven?

* Schrijf en verbeter de projectdocumentatie
* Beheer een map met voorbeelden die laten zien hoe het project wordt gebruikt
* Start een nieuwsbrief voor het project of cureer hoogtepunten uit de mailinglijst
* Schrijf tutorials voor het project, [zoals de bijdragers van PyPA](https://packaging.python.org/)
* Schrijf een vertaling voor de documentatie van het project

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Serieus, \[documentatie\] is enorm belangrijk. De documentatie tot nu toe was geweldig en was een geweldige eigenschap van Babel. Er zijn secties die zeker wat werk kunnen gebruiken en zelfs de toevoeging van een alinea hier of daar wordt enorm gewaardeerd.
  
  _Seriously, \[documentation\] is mega-important. The documentation so far has been great and has been a killer feature of Babel. There are sections that could certainly use some work and even the addition of a paragraph here or there is extremely appreciated._
  
  <p markdown="1" class="pquote-credit">
— @kittens, ["Roep bijdragers op"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Houd je van organiseren?

* Link naar dubbele problemen en stel nieuwe labels voor om alles georganiseerd te houden
* Doorloop openstaande issues en stel voor om oude te sluiten, [zoals @nzakas deed voor ESLint](https://github.com/eslint/eslint/issues/6765)
* Stel verhelderende vragen over recent geopende kwesties om de discussie vooruit te helpen

### Vind je het leuk om te coderen?

* Zoek een openstaand probleem om aan te pakken, [zoals @dianjin deed voor Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Vraag of u kunt helpen bij het schrijven van een nieuwe functie
* Automatiseer het opzetten van projecten
* Verbeter tooling en testen

### Vind je het leuk om mensen te helpen?

* Beantwoord vragen over het project op bijvoorbeeld Stack Overflow ([zoals dit Postgres-voorbeeld] (https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) of Reddit
* Beantwoord vragen voor mensen over openstaande kwesties
* Help de discussieborden of gesprekskanalen te modereren

### Vind je het leuk om anderen te helpen bij het coderen?

* Beoordeel code inzendingen van andere mensen
* Schrijf tutorials over hoe een project kan worden gebruikt
* Aanbieding om een andere bijdrager te begeleiden, [zoals @ereichert deed voor @bronzdoc op Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### U hoeft niet alleen aan softwareprojecten te werken!

Hoewel "open source" vaak verwijst naar software, kunt u aan vrijwel alles samenwerken. Er zijn boeken, recepten, lijsten en klassen die worden ontwikkeld als open source-projecten.

Bijvoorbeeld:

* @sindresorhus beheert een [lijst met "geweldige" lijsten](https://github.com/sindresorhus/awesome)
* @h5bp houdt een [lijst met potentiële interviewvragen](https://github.com/h5bp/Front-end-Developer-Interview-Questions) bij voor front-end ontwikkelaarskandidaten
* @stuartlynn en @nicole-a-tesla hebben een [verzameling leuke weetjes over papegaaiduikers](https://github.com/stuartlynn/puffin_facts) gemaakt

Zelfs als u een softwareontwikkelaar bent, kan het werken aan een documentatieproject u helpen aan de slag te gaan in open source. Het is vaak minder intimiderend om aan projecten te werken waarbij geen code wordt gebruikt, en het samenwerkingsproces zal uw vertrouwen en ervaring vergroten.

## Je oriënteren op een nieuw project

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Als je naar een issue-tracker gaat en de dingen verwarrend lijken, ben jij het niet alleen. Deze tools vereisen veel impliciete kennis, maar mensen kunnen je helpen er doorheen te navigeren en je kunt ze vragen stellen.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["Hoe u kunt bijdragen aan Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Voor meer dan een typefout is bijdragen aan open source net zoiets als naar een groep vreemden lopen op een feestje. Als je over lama's begint te praten, terwijl ze diep in een discussie over goudvissen zaten, zullen ze je waarschijnlijk een beetje vreemd aankijken.

Voordat u blindelings met uw eigen suggesties begint, moet u eerst leren hoe u de kamer moet lezen. Hierdoor vergroot u de kans dat uw ideeën worden opgemerkt en gehoord.

### Anatomie van een open source-project

Elke open source-community is anders.

Jarenlang aan één open source-project besteden, betekent dat je één open source-project hebt leren kennen. Ga naar een ander project en je zult misschien ontdekken dat de woordenschat, normen en communicatiestijlen totaal verschillend zijn.

Dat gezegd hebbende, veel open source-projecten volgen een vergelijkbare organisatiestructuur. Als u de verschillende rollen van de gemeenschap en het algehele proces begrijpt, kunt u zich snel op elk nieuw project oriënteren.

Een typisch open source-project heeft de volgende soorten mensen:

* **Auteur:** De persoon/personen of organisatie die het project heeft gemaakt
* **Eigenaar:** De persoon/personen die het administratieve eigendom hebben over de organisatie of opslagplaats (niet altijd dezelfde als de oorspronkelijke auteur)
* **Beheerders:** medewerkers die verantwoordelijk zijn voor het aansturen van de visie en het managen van de organisatorische aspecten van het project (ze kunnen ook auteurs of eigenaren van het project zijn.)
* **Bijdragers:** Iedereen die iets heeft bijgedragen aan het project
* **Communityleden:** Mensen die het project gebruiken. Ze kunnen actief zijn in gesprekken of hun mening geven over de richting van het project

Grotere projecten kunnen ook subcommissies of werkgroepen hebben die zich richten op verschillende taken, zoals tooling, triage, community-moderatie en het organiseren van evenementen. Kijk op de website van een project voor een "team"-pagina of in de repository voor bestuursdocumentatie om deze informatie te vinden.

Een project heeft ook documentatie. Deze bestanden worden meestal op het hoogste niveau van een repository vermeld.

* **LICENSE:** Per definitie moet elk open source project een [open source licentie](https://choosealicense.com) hebben. Als het project geen licentie heeft, is het geen open source.
* **README:** De README is de instructiehandleiding die nieuwe gemeenschapsleden verwelkomt bij het project. Het legt uit waarom het project nuttig is en hoe u ermee kunt beginnen.
* **CONTRIBUTORS:** Terwijl README's mensen helpen het project te _gebruiken_, helpen bijdragende documenten mensen _bij te dragen_ aan het project. Het legt uit welke soorten bijdragen nodig zijn en hoe het proces werkt. Hoewel niet elk project een CONTRIBUTING-bestand heeft, geeft de aanwezigheid ervan aan dat dit een welkom project is om aan bij te dragen.
* **CODE_OF_CONDUCT:** De gedragscode stelt basisregels vast voor het bijbehorende gedrag van deelnemers en helpt om een ​​vriendelijke, gastvrije omgeving mogelijk te maken. Hoewel niet elk project een CODE_OF_CONDUCT-bestand heeft, geeft de aanwezigheid ervan aan dat dit een welkom project is om aan bij te dragen.
* **Andere documentatie:** Er kan aanvullende documentatie zijn, zoals tutorials, walkthroughs of governance-beleid, vooral bij grotere projecten.

Ten slotte gebruiken open source-projecten de volgende tools om discussies te organiseren. Als je de archieven doorleest, krijg je een goed beeld van hoe de gemeenschap denkt en werkt.

* **Issue tracker:** waar mensen problemen bespreken die verband houden met het project.
* **Pull-verzoeken:** waar mensen wijzigingen bespreken en beoordelen die aan de gang zijn.
* **Discussieforums of mailinglijsten** Sommige projecten kunnen deze kanalen gebruiken voor gespreksonderwerpen (bijvoorbeeld _"Hoe kan ik ..."_ of _"Waar denk je aan ..."_ in plaats van bugs rapporten of functieverzoeken). Anderen gebruiken de issue tracker voor alle gesprekken.
* **Synchroon chatkanaal:** Sommige projecten gebruiken chatkanalen (zoals Slack of IRC) voor informele gesprekken, samenwerking en snelle uitwisselingen.

## Een project vinden om aan bij te dragen

Nu je weet hoe open source-projecten werken, is het tijd om een ​​project te vinden waaraan je kunt bijdragen!

Als je nog nooit eerder hebt bijgedragen aan open source, neem dan wat advies in van de Amerikaanse president John F. Kennedy, die ooit zei: _"Vraag niet wat uw land voor u kan doen - vraag wat u voor uw land kunt doen."_

Bijdragen aan open source gebeurt op alle niveaus, over projecten heen. U hoeft niet te veel na te denken over wat uw eerste bijdrage precies zal zijn, of hoe deze eruit zal zien.

Begin in plaats daarvan met nadenken over de projecten die u al gebruikt of wilt gebruiken. De projecten waaraan u actief bijdraagt, zijn de projecten waar u naar terugkeert.

Wanneer je binnen die projecten merkt dat je denkt dat iets beter of anders kan, handel dan naar je instinct.

Open source is geen exclusieve club; het is gemaakt door mensen zoals jij. "Open source" is gewoon een mooie term om de problemen van de wereld als herstelbaar te behandelen.

U kunt een README lezen en een incorrecte link of typefout vinden. Of je bent een nieuwe gebruiker en je hebt gemerkt dat er iets kapot is, of een probleem waarvan je denkt dat het echt in de documentatie zou moeten staan. In plaats van het te negeren en verder te gaan, of iemand anders te vragen om het op te lossen, kijk of je kunt helpen door mee te doen. Dat is waar het bij open source om draait!

> [28% van de losse bijdragen](https://www.igor.pro.br/publica/papers/saner2016.pdf) aan open source zijn documentatie, zoals een typefout, herformattering of het schrijven van een vertaling.

Als u op zoek bent naar bestaande problemen die u kunt oplossen, heeft elk open source-project een '/ contribute'-pagina die beginnersvriendelijke problemen belicht waarmee u kunt beginnen. Navigeer naar de hoofdpagina van de repository op GitHub en voeg '/ contribute' toe aan het einde van de URL (bijvoorbeeld [`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

U kunt ook een van de volgende bronnen gebruiken om u te helpen bij het ontdekken van en bijdragen aan nieuwe projecten:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)

### Een checklist voordat u bijdraagt

Als je een project hebt gevonden waaraan je zou willen bijdragen, doe dan een snelle scan om er zeker van te zijn dat het project geschikt is om bijdragen te accepteren. Anders krijgt uw harde werk misschien nooit een reactie.

Hier is een handige checklist om te evalueren of een project goed is voor nieuwe bijdragers.

**Voldoet aan de definitie van open source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Heeft het een licentie? Gewoonlijk is er een bestand met de naam LICENSE in de root van de repository.
  </label>
</div>

**Project accepteert actief bijdragen**

Kijk naar de commit-activiteit op de main branch. Op GitHub kun je deze informatie zien op de startpagina van een repository.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Wanneer was de laatste commit?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Hoeveel bijdragers heeft het project?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Hoe vaak commiten mensen? (Op GitHub kun je dit vinden door op "Commits" in de bovenste balk te klikken.)
  </label>
</div>

Next, look at the project's issues.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Hoeveel openstaande issues zijn er?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Reageren beheerders snel op issues wanneer ze worden geopend?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Is er een actieve discussie over de issues?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Zijn de issues recent?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Worden problemen gesloten? (Klik op GitHub op het tabblad "closed" op de pagina Issues om gesloten problemen te zien.)
  </label>
</div>

Doe nu hetzelfde voor de pull-verzoeken van het project.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Hoeveel openstaande pull-aanvragen zijn er?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Reageren beheerders snel op pull-verzoeken wanneer ze worden geopend?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Is er actieve discussie over de pull-aanvragen?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Zijn de pull-aanvragen recent?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Hoe recent zijn pull-verzoeken samengevoegd? (Klik op GitHub op het tabblad "closed" op de pagina Pull Requests om gesloten PR's te zien.)
  </label>
</div>

**Project is gastvrij**

Een project dat vriendelijk en gastvrij is, geeft aan dat ze ontvankelijk zullen zijn voor nieuwe bijdragers.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Reageren de beheerders behulpzaam op vragen in problemen?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Zijn mensen vriendelijk in de problemen, het discussieforum en de chat (bijvoorbeeld IRC of Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Worden pull-aanvragen beoordeeld?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Bedanken onderhouders mensen voor hun bijdragen?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Elke keer dat je een lange thread ziet, controleer dan de reacties van kernontwikkelaars die laat in de thread komen. Vatten ze constructief samen en ondernemen ze stappen om de rode draad tot een beslissing te brengen terwijl ze beleefd blijven? Als je veel vlammenoorlogen ziet plaatsvinden, is dat vaak een teken dat energie in discussie gaat in plaats van in ontwikkeling.
  
  _Whenever you see a long thread, spot check responses from core developers coming late in the thread. Are they summarizing constructively, and taking steps to bring the thread to a decision while remaining polite? If you see a lot of flame wars going on, that's often a sign that energy is going into argument instead of into development._
  
  <p markdown="1" class="pquote-credit">
— @kfogel, [_OSS Produceren_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Hoe u een bijdrage kunt indienen

Je hebt een project gevonden dat je leuk vindt en je bent klaar om een bijdrage te leveren. Tenslotte! Hier leest u hoe u uw bijdrage op de juiste manier krijgt.

### Effectief communiceren

Of je nu een eenmalige bijdrage levert of probeert lid te worden van een community, samenwerken met anderen is een van de belangrijkste vaardigheden die je in open source zult ontwikkelen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Als nieuwe bijdrager\] realiseerde ik me al snel dat ik vragen moest stellen als ik het probleem wilde sluiten. Ik bladerde door de codebasis. Toen ik eenmaal een idee had van wat er aan de hand was, vroeg ik om meer richting. En voilà! Ik kon het probleem oplossen nadat ik alle relevante details had gekregen die ik nodig had.
  
  _\[As a new contributor,\] I quickly realized I had to ask questions if I wanted to be able to close the issue. I skimmed through the code base. Once I had some sense of what was going on, I asked for more direction. And voilà! I was able to solve the issue after getting all the relevant details I needed._
  
  <p markdown="1" class="pquote-credit">
— @shubheksha, [Een hobbelige reis voor beginners door de wereld van open source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Houd deze punten in gedachten voordat u een probleem of pull-aanvraag opent of een vraag stelt in de chat, zodat uw ideeën effectief overkomen.

**Geef context.** Help anderen om snel aan de slag te gaan. Als u een fout tegenkomt, leg dan uit wat u probeert te doen en hoe u deze kunt reproduceren. Als je een nieuw idee voorstelt, leg dan uit waarom je denkt dat het nuttig zou zijn voor het project (niet alleen voor jou!).

> 😇 _"X gebeurt niet wanneer ik Y doe"_
>
> 😢 _"X is kapot! Los het probleem op."_

**Maak van tevoren je huiswerk.** Het is oké om dingen niet te weten, maar laat zien dat je het geprobeerd hebt. Voordat u om hulp vraagt, moet u de README, documentatie, problemen (open of gesloten), mailinglijst van een project raadplegen en op internet naar een antwoord zoeken. Mensen zullen het waarderen als je laat zien dat je probeert te leren.

> 😇 _"Ik weet niet zeker hoe ik X moet implementeren. Ik heb de helpdocumenten gecontroleerd en geen vermeldingen gevonden."_
>
> 😢 _"Hoe kan ik X?"_

**Houd verzoeken kort en direct.** Net als bij het verzenden van een e-mail, vereist elke bijdrage, hoe eenvoudig of nuttig ook, de beoordeling van iemand anders. Veel projecten hebben meer inkomende verzoeken dan mensen die beschikbaar zijn om te helpen. Wees beknopt. Je vergroot de kans dat iemand je kan helpen.

> 😇 _"Ik zou graag een API-tutorial willen schrijven."_
>
> 😢 _"Ik reed onlangs over de snelweg en stopte om te tanken, en toen had ik een geweldig idee voor iets dat we zouden moeten doen, maar voordat ik dat uitleg, wil ik je laten zien ..."_

**Houd alle communicatie openbaar.** Hoewel het verleidelijk is, moet u niet privé contact opnemen met beheerders, tenzij u gevoelige informatie moet delen (zoals een beveiligingsprobleem of een ernstige schending van het gedrag). Als u het gesprek openbaar houdt, kunnen meer mensen leren en profiteren van uw uitwisseling. Discussies kunnen op zichzelf bijdragen zijn.

> 😇 _(als commentaar) "@-maintainer Hallo! Hoe gaan we verder met deze PR?"_
>
> 😢 _(als e-mail) "Hallo, sorry dat ik je stoor via e-mail, maar ik vroeg me af of je de kans hebt gehad om mijn PR te herzien"_

**Het is oké om vragen te stellen (maar wees geduldig!).** Iedereen was op een gegeven moment nieuw in het project en zelfs ervaren bijdragers moeten op de hoogte zijn als ze naar een nieuw project kijken. Op dezelfde manier zijn zelfs langdurige beheerders niet altijd bekend met elk onderdeel van het project. Toon ze hetzelfde geduld dat je zou willen dat ze je tonen.

> 😇 _"Bedankt voor het onderzoeken van deze fout. Ik heb uw suggesties gevolgd. Hier is de uitvoer."_
>
> 😢 _"Waarom kun je mijn probleem niet oplossen? Is dit niet jouw project?"_

**Respecteer gemeenschapsbeslissingen.** Uw ideeën kunnen verschillen van de prioriteiten of visie van de gemeenschap. Ze kunnen feedback geven of besluiten uw idee niet na te streven. Terwijl u moet discussiëren en zoeken naar een compromis, moeten beheerders langer met uw beslissing leven dan u wilt. Als je het niet eens bent met hun richting, kun je altijd aan je eigen vork werken of je eigen project starten.

> 😇 _"Ik ben teleurgesteld dat je mijn use case niet kunt ondersteunen, maar zoals je hebt uitgelegd, heeft het slechts invloed op een klein deel van de gebruikers, ik begrijp waarom. Bedankt voor het luisteren."_
>
> 😢 _"Waarom steun je mijn use case niet? Dit is onaanvaardbaar!"_

**Houd het vooral netjes.** Open source bestaat uit medewerkers van over de hele wereld. Context gaat verloren in talen, culturen, geografische gebieden en tijdzones. Bovendien maakt schriftelijke communicatie het moeilijker om een ​​toon of stemming over te brengen. Ga in deze gesprekken uit van goede bedoelingen. Het is prima om beleefd terug te komen op een idee, om meer context te vragen of je standpunt verder te verduidelijken. Probeer gewoon het internet op een betere plek achter te laten dan toen u het vond.

### Context verzamelen

Voordat u iets doet, controleert u eerst of uw idee nergens anders is besproken. Bekijk de README, problemen (open en gesloten), mailinglijst en Stack Overflow van het project. Je hoeft geen uren te besteden aan het doornemen van alles, maar een snelle zoektocht naar een paar sleutelbegrippen gaat ver.

Als u uw idee nergens anders kunt vinden, bent u klaar om een ​​stap te zetten. Als het project op GitHub staat, communiceer je waarschijnlijk door een issue of pull request te openen:

* **Problemen/Issues** zijn als het starten van een gesprek of discussie
* **Pull-aanvragen** zijn bedoeld om aan een oplossing te beginnen
* **Voor eenvoudige communicatie**, zoals een verhelderende of how-to-vraag, kunt u vragen stellen op Stack Overflow, IRC, Slack of andere chatkanalen, als het project er een heeft

Voordat je een issue of pull request opent, controleer je de bijdragende documenten van het project (meestal een bestand genaamd CONTRIBUTING, of in de README), om te zien of je iets specifieks moet opnemen. Ze kunnen u bijvoorbeeld vragen een sjabloon te volgen, of eisen dat u tests gebruikt.

Als je een substantiële bijdrage wilt leveren, open dan een vraagstuk voordat je eraan gaat werken. Het is handig om het project een tijdje te bekijken (op GitHub, [u kunt op "Bekijken" klikken](https://help.github.com/articles/watching-repositories/) om op de hoogte te worden gehouden van alle gesprekken), en ken de leden van de gemeenschap voordat u werk gaat doen dat misschien niet wordt geaccepteerd.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Je leert <em>veel</em> door een enkel project te nemen dat je actief gebruikt, het op GitHub te "bekijken" en elk nummer en PR te lezen.
  
  _You'll learn <em>a lot</em> from taking a single project you actively use, "watching" it on GitHub and reading every issue and PR._
  
<p markdown="1" class="pquote-credit">
— @gaearon [over deelname aan projecten](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Een issue openen

U zou gewoonlijk een probleem (_issue_) moeten openen in de volgende situaties:

* Meld een fout die u niet zelf kunt oplossen
* Bespreek een onderwerp of idee op hoog niveau (bijvoorbeeld gemeenschap, visie of beleid)
* Stel een nieuwe functie of ander projectidee voor

Tips voor het communiceren over problemen:

* **Als u een openstaand probleem ziet dat u wilt aanpakken,** geef dan commentaar op het probleem om mensen te laten weten dat u ermee bezig bent. Op die manier is de kans kleiner dat mensen uw werk dupliceren.
* **Als een probleem een tijdje geleden is geopend,** is het mogelijk dat het ergens anders wordt aangepakt of al is opgelost, dus reageer om bevestiging te vragen voordat u aan het werk gaat.
* **Als je een probleem hebt geopend, maar het antwoord later zelf hebt bedacht,** geef dan commentaar op het probleem om mensen dit te laten weten en sluit het probleem vervolgens. Zelfs het documenteren van die uitkomst is een bijdrage aan het project.

### Een pull-verzoek openen

U moet gewoonlijk een pull-aanvraag openen in de volgende situaties:

* Voer triviale reparaties in (bijvoorbeeld een typefout, een verbroken link of een duidelijke fout)
* Ga aan de slag met een bijdrage waar al om is gevraagd, of die je al hebt besproken in een issue

Een pull-verzoek hoeft niet het voltooide werk te vertegenwoordigen. Het is meestal beter om vroegtijdig een pull-verzoek te openen, zodat anderen uw voortgang kunnen bekijken of feedback kunnen geven. Markeer het gewoon als een "WIP" (Work in Progress) in de onderwerpregel. Je kunt later altijd meer commits toevoegen.

Als het project op GitHub staat, kun je als volgt een pull-aanvraag indienen:

* **[Fork the repository](https://guides.github.com/activities/forking/)** en kloon het lokaal. Verbind uw locale met de originele "upstream" repository door deze toe te voegen als een remote. Haal vaak wijzigingen van "upstream" binnen, zodat u up-to-date blijft, zodat wanneer u uw pull-verzoek indient, samenvoegingsconflicten minder waarschijnlijk zijn. (Zie meer gedetailleerde instructies [hier](https://help.github.com/articles/syncing-a-fork/).)
* **[Maak een branch aan](https://guides.github.com/introduction/flow/)** voor uw bewerkingen.
* **Verwijs naar relevante problemen (_issues_)** of ondersteunende documentatie in uw PR (bijvoorbeeld 'Closes #37'.)
* **Voeg schermafbeeldingen toe van de voor en na** als uw wijzigingen verschillen in HTML / CSS bevatten. Sleep de afbeeldingen naar de hoofdtekst van uw pull-aanvraag.
* **Test uw wijzigingen!** Voer uw wijzigingen uit met bestaande tests als deze bestaan ​​en maak nieuwe aan als dat nodig is. Of er tests bestaan ​​of niet, zorg ervoor dat uw wijzigingen het bestaande project niet verstoren.
* **Draag zo goed mogelijk bij in de stijl van het project**. Dit kan betekenen dat u inspringingen, puntkomma's of commentaren anders moet gebruiken dan in uw eigen repository, maar het maakt het gemakkelijker voor de onderhouder om samen te voegen, zodat anderen het begrijpen en onderhouden in de toekomst.

Als dit je eerste pull-verzoek is, bekijk dan [Maak een  Pull Request](http://makeapullrequest.com/), dat @kentcdodds heeft gemaakt als een walkthrough video-tutorial. Je kunt ook oefenen met het maken van een pull-verzoek in de [First Contributions](https://github.com/Roshanjossey/first-contributions) repo, gemaakt door @Roshanjossey.

## Wat gebeurt er nadat u een bijdrage heeft ingeleverd?

Je hebt het gedaan! Gefeliciteerd met het worden van een open source-bijdrager. We hopen dat dit de eerste van vele is.

Nadat u een bijdrage heeft ingeleverd, gebeurt een van de volgende zaken:

### 😭 U krijgt geen antwoord.

Hopelijk heb je [het project gecontroleerd op tekenen van een checklist voordat je bijdraagt](#een-checklist-voordat-u-bijdraagt) voordat je een bijdrage levert. Zelfs bij een actief project is het echter mogelijk dat uw bijdrage geen reactie krijgt.

Als je al meer dan een week geen reactie hebt gekregen, is het redelijk om beleefd te reageren in dezelfde thread en iemand om een ​​recensie te vragen. Als u de naam kent van de juiste persoon om uw bijdrage te beoordelen, kunt u deze @-vermelding in die thread.

**Reik niet** privé naar die persoon; Onthoud dat openbare communicatie essentieel is voor open source-projecten.

Als je een beleefde hobbel maakt en nog steeds niemand reageert, is het mogelijk dat niemand ooit zal reageren. Het is geen geweldig gevoel, maar laat dat je niet ontmoedigen. Het is iedereen overkomen! Er zijn veel mogelijke redenen waarom u geen reactie heeft gekregen, waaronder persoonlijke omstandigheden waar u mogelijk geen controle over heeft. Probeer een ander project of een andere manier te vinden om bij te dragen. Dit is in ieder geval een goede reden om niet te veel tijd te investeren in het leveren van een bijdrage voordat andere leden van de gemeenschap betrokken en responsief zijn.

### 🚧 Iemand vraagt ​​om wijzigingen in uw bijdrage.

Het komt vaak voor dat u wordt gevraagd om wijzigingen aan te brengen in uw bijdrage, of dat nu feedback is over de reikwijdte van uw idee of wijzigingen in uw code.

Reageer als iemand om veranderingen vraagt. Ze hebben de tijd genomen om uw bijdrage te herzien. Een PR openen en weglopen is een slechte vorm. Als u niet weet hoe u wijzigingen moet aanbrengen, onderzoek dan het probleem en vraag indien nodig om hulp.

Als je geen tijd meer hebt om aan de kwestie te werken (bijvoorbeeld als het gesprek al maanden aan de gang is en je omstandigheden zijn veranderd), laat het de beheerder dan weten, zodat hij geen reactie verwacht. Iemand anders neemt het misschien graag over.

### 👎 Uw bijdrage wordt niet geaccepteerd.

Uw bijdrage kan uiteindelijk wel of niet worden geaccepteerd. Hopelijk heb je er niet al te veel werk in gestoken. Als u niet zeker weet waarom het niet werd geaccepteerd, is het volkomen redelijk om de beheerder om feedback en opheldering te vragen. Uiteindelijk moet u echter respecteren dat dit hun beslissing is. Maak geen ruzie en word niet vijandig. Je bent altijd welkom om te fork en aan je eigen versie te werken als je het niet eens bent!

### 🎉 Uw bijdrage wordt geaccepteerd.

Hoera! Je hebt met succes een open source bijdrage geleverd!

## Je hebt het gedaan!

Of je nu net je eerste open source-bijdrage hebt geleverd of op zoek bent naar nieuwe manieren om bij te dragen, we hopen dat je geïnspireerd bent om actie te ondernemen. Zelfs als uw bijdrage niet werd geaccepteerd, vergeet dan niet te bedanken wanneer een onderhouder moeite heeft gedaan om u te helpen. Open source wordt gemaakt door mensen zoals jij: één probleem, pull-verzoek, opmerking of high-five tegelijk.
