---
lang: nl
title: Betaald worden voor open source-werk
description: Ondersteun uw werk in open source door financiële steun te krijgen voor uw tijd of uw project.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Waarom sommige mensen financiële steun zoeken

Veel van het open source-werk wordt op vrijwillige basis aangeboden. Iemand kan bijvoorbeeld een bug tegenkomen in een project dat ze gebruiken en een snelle oplossing indienen, of ze kunnen in hun vrije tijd graag aan een open source-project sleutelen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
  Ik was op zoek naar een "hobby" programmeerproject dat me doordeweeks rond Kerstmis bezig zou houden. (...) Ik had een homecomputer, en verder niet veel. Ik besloot een tolk te schrijven voor de nieuwe scripttaal waar ik de laatste tijd aan had gedacht. (...) Ik koos Python als werktitel.

  _I was looking for a "hobby" programming project that would keep me occupied during the week around Christmas. (...) I had a home computer, and not much else on my hands. I decided to write an interpreter for the new scripting language I had been thinking about lately. (...) I chose Python as a working title._

  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Python programmeren"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Er zijn veel redenen waarom iemand niet zou willen worden betaald voor zijn open source-werk.

* **Ze hebben misschien al een fulltime baan waar ze van houden,** waardoor ze in hun vrije tijd kunnen bijdragen aan open source.
* **Ze vinden open source graag een hobby** of een creatieve ontsnapping en willen zich niet financieel verplicht voelen om aan hun projecten te werken.
* **Ze profiteren van andere voordelen door bij te dragen aan open source,** zoals het opbouwen van hun reputatie of portfolio, het leren van een nieuwe vaardigheid of het gevoel dichter bij een gemeenschap te zijn.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Financiële donaties voegen voor sommigen een gevoel van verantwoordelijkheid toe. (...) Het is belangrijk voor ons, in de wereldwijd verbonden, snelle wereld waarin we leven, om te kunnen zeggen "niet nu, ik heb zin om iets heel anders te doen".

  _Financial donations do add a feeling of responsibility, for some. (...) It's important for us, in the globally connected, fast-paced world we live in, to be able to say "not now, I feel like doing something completely different"._

  <p markdown="1" class="pquote-credit">
— @alloy, ["Waarom we geen donaties accepteren"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Voor anderen, vooral wanneer bijdragen doorlopend zijn of veel tijd vergen, is betaald krijgen om bij te dragen aan open source de enige manier waarop ze kunnen deelnemen, hetzij omdat het project dit vereist, hetzij om persoonlijke redenen.

Het onderhouden van populaire projecten kan een aanzienlijke verantwoordelijkheid zijn, die 10 of 20 uur per week in beslag neemt in plaats van een paar uur per maand.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Vraag het aan een willekeurige open source projectbeheerder, en zij zullen u vertellen over de realiteit van de hoeveelheid werk die nodig is om een project te beheren. Je hebt klanten. U lost problemen voor hen op. U creëert nieuwe functies. Dit wordt een echte tijdrovende bezigheid.

  _Ask any open source project maintainer, and they will tell you about the reality of the amount of work that goes into managing a project. You have clients. You are fixing issues for them. You are creating new features. This becomes a real demand on your time._

  <p markdown="1" class="pquote-credit">
— @ashedryden, ["De ethiek van onbetaalde arbeid en de OSS-gemeenschap"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Betaald werk stelt mensen uit verschillende rangen en standen ook in staat om een zinvolle bijdrage te leveren. Sommige mensen kunnen het zich niet veroorloven om onbetaalde tijd aan open source-projecten te besteden, op basis van hun huidige financiële positie, schulden, familie- of andere zorgverplichtingen. Dat betekent dat de wereld nooit bijdragen ziet van getalenteerde mensen die het zich niet kunnen veroorloven om vrijwilligerswerk te doen. Dit heeft ethische implicaties, zoals @ashedryden [heeft beschreven](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), aangezien werk dat wordt gedaan, bevooroordeeld ten gunste van degenen die al voordelen in het leven hebben, die vervolgens extra voordelen krijgen op basis van hun vrijwilligersbijdragen, terwijl anderen die niet in staat zijn om vrijwilligerswerk te doen, later geen kansen krijgen, wat het huidige gebrek aan diversiteit in de open source versterkt gemeenschap.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
  OSS levert enorme voordelen op voor de technologische industrie, wat op zijn beurt voordelen betekent voor alle industrieën. (...) Als de enige mensen die zich erop kunnen concentreren de gelukkigen en geobsedeerd zijn, dan is er een enorm onbenut potentieel.

   _OSS yields massive benefits to the technology industry, which, in turn, means benefits to all industries. (...) However, if the only people who can focus on it are the lucky and the obsessed, then there's a huge untapped potential._

  <p markdown="1" class="pquote-credit">
— @isaacs, ["Geld en Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Als u op zoek bent naar financiële ondersteuning, zijn er twee manieren om te overwegen. U kunt uw eigen tijd als donateur financieren, of u kunt organisatorische financiering voor het project vinden.

## Je eigen tijd financieren

Tegenwoordig worden veel mensen betaald om part- of fulltime aan open source te werken. De meest gebruikelijke manier om voor uw tijd betaald te worden, is door met uw werkgever te praten.

Het is gemakkelijker om een pleidooi te houden voor open source-werk als je werkgever het project ook daadwerkelijk gebruikt, maar wees creatief met je pitch. Misschien gebruikt je werkgever het project niet, maar ze gebruiken Python, en het onderhouden van een populair Python-project helpt nieuwe Python-ontwikkelaars aan te trekken. Misschien zorgt het ervoor dat uw werkgever er in het algemeen ontwikkelaarvriendelijker uitziet.

Als je geen bestaand open source-project hebt waaraan je zou willen werken, maar liever hebt dat je huidige werkoutput open source is, pleit er dan voor dat je werkgever een deel van hun interne software open source maakt.

Veel bedrijven ontwikkelen open source-programma's om hun merk op te bouwen en talent van hoge kwaliteit te werven.

@hueniverse ontdekte bijvoorbeeld dat er financiële redenen waren om [Walmart's investering in open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). En @jamesgpearce ontdekte dat het open source-programma van Facebook [een verschil maakte](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) bij het werven van:

> Het sluit nauw aan bij onze hackercultuur en hoe onze organisatie werd gezien. We vroegen onze medewerkers: "Was u op de hoogte van het open source softwareprogramma op Facebook?". Twee derde zei "Ja". De helft zei dat het programma een positieve bijdrage leverde aan hun beslissing om voor ons te werken. Dit zijn geen marginale cijfers, en naar ik hoop, een trend die zich voortzet.

Als uw bedrijf deze weg inslaat, is het belangrijk om de grenzen tussen gemeenschap en bedrijfsactiviteiten duidelijk te houden. Uiteindelijk houdt open source zichzelf in stand door bijdragen van mensen over de hele wereld, en dat is groter dan welk bedrijf of locatie dan ook.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Betaald worden om aan open source te werken is een zeldzame en geweldige kans, maar je zou je passie in het proces niet moeten opgeven. Uw passie zou moeten zijn waarom bedrijven u willen betalen.

  _Getting paid to work on open source is a rare and wonderful opportunity, but you should not have to give up your passion in the process. Your passion should be why companies want to pay you._

  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Wazige lijnen"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Als u uw huidige werkgever niet kunt overtuigen om prioriteit te geven aan open source-werk, overweeg dan om een nieuwe werkgever te zoeken die werknemersbijdragen aan open source aanmoedigt. Zoek naar bedrijven die hun toewijding aan open source-werk expliciet maken. Bijvoorbeeld:

* Sommige bedrijven, zoals [Netflix](https://netflix.github.io/), hebben websites die hun betrokkenheid bij open source benadrukken
* [Zalando](https://opensource.zalando.com) publiceerde zijn [open source bijdragebeleid](https://opensource.zalando.com/docs/using/contributing/) voor werknemers

Projecten die zijn ontstaan ​​bij een groot bedrijf, zoals [Go](https://github.com/golang) of [React](https://github.com/facebook/react), zullen waarschijnlijk ook mensen in dienst hebben om aan te werken open source.

Afhankelijk van uw persoonlijke omstandigheden kunt u proberen om zelfstandig geld in te zamelen om uw open source-werk te financieren. Bijvoorbeeld:

* @Homebrew (and [many other maintainers and organizations](https://github.com/sponsors/community)) fund their work through [GitHub Sponsors](https://github.com/sponsors)
* @gaearon financierde zijn werk op [Redux](https://github.com/reactjs/redux) via een [Patreon crowdfunding-campagne](https://redux.js.org/)
* @andrewgodwin gefinancierd werk aan Django-schemamigraties [via een Kickstarter-campagne](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

Ten slotte geven open source-projecten soms premies voor problemen waarmee u zou kunnen helpen.

* @ConnorChristie kon betaald worden voor [helpen](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol werken aan hun JavaScript-bibliotheek [via een premie op gitcoin](https://gitcoin.co/).
* @mamiM deed Japanse vertalingen voor @MetaMask nadat de [kwestie werd gefinancierd op Bounties Network](https://explorer.bounties.network/bounty/134).

## Financiering vinden voor uw project

Naast regelingen voor individuele bijdragers, halen projecten soms geld op bij bedrijven, individuen of anderen om lopende werkzaamheden te financieren.

Organisatorische financiering kan gaan naar het betalen van huidige bijdragers, het dekken van de kosten van het uitvoeren van het project (zoals hostingvergoedingen) of het investeren in nieuwe functies of ideeën.

Naarmate de populariteit van open source toeneemt, is het vinden van financiering voor projecten nog experimenteel, maar er zijn een paar veelvoorkomende opties beschikbaar.

### Zamel geld in voor je werk door middel van crowdfundingcampagnes of sponsoring

Het vinden van sponsoring werkt goed als je al een sterk publiek of een sterke reputatie hebt, of als je project erg populair is.
Enkele voorbeelden van gesponsorde projecten zijn:

* **[webpack](https://github.com/webpack)** zamelt geld in bij bedrijven en particulieren [via OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** een non-profitorganisatie die betaalt voor werk aan [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), en andere Ruby-infrastructuurprojecten

### Creëer een inkomstenstroom

Afhankelijk van uw project kunt u mogelijk kosten in rekening brengen voor commerciële ondersteuning, gehoste opties of extra functies. Enkele voorbeelden zijn:

* **[Sidekiq](https://github.com/mperham/sidekiq)** biedt betaalde versies voor extra ondersteuning
* **[Travis CI](https://github.com/travis-ci)** biedt betaalde versies van zijn product
* **[Ghost](https://github.com/TryGhost/Ghost)** is een non-profitorganisatie met een betaalde beheerde service

Sommige populaire projecten, zoals [npm](https://github.com/npm/cli) en [Docker](https://github.com/docker/docker), halen zelfs risicokapitaal op om de groei van hun bedrijf te ondersteunen.

### Subsidie ​​aanvragen

Sommige softwarestichtingen en bedrijven bieden beurzen aan voor open source-werk. Soms kunnen subsidies worden uitbetaald aan individuen zonder een juridische entiteit voor het project op te richten.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** ontving een subsidie ​​van [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** werk werd gefinancierd door [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** heeft een subsidie ​​ontvangen van de [Sloan Foundation](https://sloan.org/programs/digital-technology)
* De **[Python Software Foundation](https://www.python.org/psf/grants/)** biedt beurzen aan voor Python-gerelateerd werk

Voor meer gedetailleerde opties en casestudy's, @nayafia [schreef een gids](https://github.com/nayafia/lemonade-stand) om betaald te worden voor open source werk. Verschillende soorten financiering vereisen verschillende vaardigheden, dus overweeg uw sterke punten om erachter te komen welke optie voor u het beste werkt.

## Het bouwen van een case voor financiële steun

Of uw project nu een nieuw idee is of al jaren bestaat, u moet verwachten dat u veel aandacht besteedt aan het identificeren van uw beoogde financier en het maken van een overtuigende zaak.

Of je nu voor je eigen tijd wilt betalen of geld wilt inzamelen voor een project, je zou de volgende vragen moeten kunnen beantwoorden.

### Gevolg

Waarom is dit project nuttig? Waarom vinden uw (potentiële) gebruikers het zo leuk? Waar zal het zijn over vijf jaar?

### Tractie

Probeer bewijs te verzamelen dat uw project ertoe doet, of het nu gaat om statistieken, anekdotes of getuigenissen. Zijn er op dit moment bedrijven of opmerkelijke mensen die uw project gebruiken? Zo nee, heeft een vooraanstaand persoon het onderschreven?

### Waarde voor financier

Financiers, of het nu uw werkgever of een stichting is, worden vaak benaderd met kansen. Waarom zouden ze uw project beter ondersteunen dan elke andere mogelijkheid? Hoe profiteren ze persoonlijk?

### Gebruik van fondsen

Wat gaat u precies bereiken met de voorgestelde financiering? Concentreer u op mijlpalen of resultaten van projecten in plaats van een salaris te betalen.

### Hoe u het geld ontvangt

Heeft de financier enige vereisten met betrekking tot uitbetaling? U moet bijvoorbeeld een non-profitorganisatie zijn of een fiscale sponsor hebben. Of misschien moet het geld aan een individuele aannemer worden gegeven in plaats van aan een organisatie. Deze vereisten variëren tussen financiers, dus zorg ervoor dat u van tevoren uw onderzoek doet.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  We zijn al jaren de toonaangevende bron van websitevriendelijke pictogrammen, met een community van meer dan 20 miljoen mensen en zijn te zien op meer dan 70 miljoen websites, waaronder Whitehouse.gov. (...) Versie 4 bestond drie jaar geleden. Webtechnologie is sindsdien veel veranderd, en eerlijk gezegd is Font Awesome een beetje muf geworden. (...) Daarom introduceren we Font Awesome 5. We moderniseren en herschrijven de CSS en herontwerpen elk pictogram van boven naar beneden. We hebben het over een beter ontwerp, betere consistentie en betere leesbaarheid.

  _For years, we've been the leading resource of website friendly icons, with a community of over 20 million people and been featured on over 70 million websites, including Whitehouse.gov. (...) Version 4 was three years ago. Web tech's changed a lot since then, and frankly, Font Awesome's gotten a bit stale. (...) That's why we're introducing Font Awesome 5. We're modernizing and rewriting the CSS and redesigning every icon from top to bottom. We're talking better design, better consistency, and better readability._

  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Experimenteer en geef niet op

Geld inzamelen is niet eenvoudig, of je nu een open source-project, een non-profitorganisatie of een software-startup bent, en in de meeste gevallen moet je creatief zijn. Door vast te stellen hoe u betaald wilt worden, onderzoek te doen en uzelf in de schoenen van uw financier te verplaatsen, kunt u een overtuigende zaak voor financiering opbouwen.
