---
lang: nl
title: Gebruikers zoeken voor uw project
description: Help uw open source-project te groeien door het in handen te krijgen van tevreden gebruikers.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Het woord verspreiden

Er is geen regel die zegt dat u een open source-project moet promoten wanneer u start. Er zijn veel goede redenen om in open source te werken die niets met populariteit te maken hebben. In plaats van te hopen dat anderen uw open source-project zullen vinden en gebruiken, moet u het woord over uw harde werk verspreiden!

## Zoek uit wat je bericht is

Voordat u begint met het eigenlijke werk van het promoten van uw project, moet u kunnen uitleggen wat het doet en waarom het ertoe doet.

Wat maakt uw project anders of interessant? Waarom heb je het gemaakt? Door deze vragen voor uzelf te beantwoorden, kunt u de betekenis van uw project overbrengen.

Onthoud dat mensen erbij betrokken raken als gebruikers en uiteindelijk bijdragen worden, omdat uw project een probleem voor hen oplost. Terwijl je nadenkt over de boodschap en waarde van je project, probeer ze dan te bekijken door de lens van wat _gebruikers en bijdragers_ zouden kunnen willen.

@robb gebruikt bijvoorbeeld codevoorbeelden om duidelijk te communiceren waarom zijn project,[Cartography](https://github.com/robb/Cartography), nuttig is:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Voor een diepere duik in berichten, bekijk Mozilla's ["Persona's en paden"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) oefening voor het ontwikkelen van gebruikerspersonages.

## Help mensen uw project te vinden en te volgen

<aside markdown="1" class="pquote">
  U hebt idealiter een enkele "home"-URL nodig die u kunt promoten en waarnaar u mensen kunt verwijzen met betrekking tot uw project. U hoeft niet te spetteren op een mooie sjabloon of zelfs een domeinnaam, maar uw project heeft een centraal punt nodig.

  _You ideally need a single "home" URL that you can promote and point people to in relation to your project. You don't need to splash out on a fancy template or even a domain name, but your project needs a focal point._

  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["Hoe u het woord over uw code kunt verspreiden"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Help mensen uw project te vinden en te onthouden door ze naar een enkele naamruimte te verwijzen.

**Zorg voor een duidelijk handvat om uw werk te promoten.** Een Twitter-account, GitHub-URL of IRC-kanaal is een gemakkelijke manier om mensen naar uw project te verwijzen. Deze verkooppunten geven ook de groeiende gemeenschap van uw project een plek om samen te komen.

Als u nog geen verkooppunten voor uw project wilt opzetten, promoot dan uw eigen Twitter- of GitHub-account bij alles wat u doet. Door je Twitter- of GitHub-account te promoten, kunnen mensen weten hoe ze contact met je kunnen opnemen of je werk kunnen volgen. Als je op een bijeenkomst of evenement spreekt, zorg er dan voor dat je contactgegevens in je biografie of dia's staan.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Een fout die ik in die vroege dagen maakte (...) was dat ik geen Twitter-account voor het project startte. Twitter is een geweldige manier om mensen op de hoogte te houden van een project en om mensen constant aan het project bloot te stellen.

  _A mistake I made in those early days (...) was not starting a Twitter account for the project. Twitter's a great way to keep people up to date about a project as well as constantly expose people to the project._

  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["Geschiedenis van Apache Storm en geleerde lessen"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Overweeg om een website voor uw project te maken.** Een website maakt uw project vriendelijker en gemakkelijker te navigeren, vooral als deze is gekoppeld aan duidelijke documentatie en tutorials. Het hebben van een website suggereert ook dat uw project actief is, waardoor uw publiek zich er prettiger bij voelt. Geef voorbeelden om mensen ideeën te geven voor het gebruik van uw project.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), mede-maker van Django, zei dat een website _"verreweg het beste was wat we vroeger met Django deden"_.

Als uw project op GitHub wordt gehost, kunt u [GitHub Pages](https://pages.github.com/) gebruiken om eenvoudig een website te maken. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), en [Middleman](https://middlemanapp.com/) zijn [een paar voorbeelden](https://github.com/showcases/github-pages-examples) van uitstekende, uitgebreide websites.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Nu u een bericht voor uw project heeft en mensen uw project gemakkelijk kunnen vinden, gaan we naar buiten en praten met uw publiek!

## Ga waar het publiek van uw project is (online)

Online bereik is een geweldige manier om snel te delen en het woord te verspreiden. Door online kanalen te gebruiken, heb je de potentie om een zeer breed publiek te bereiken.

Profiteer van bestaande online communities en platforms om uw publiek te bereiken. Als uw open source-project een softwareproject is, kunt u uw publiek waarschijnlijk vinden op [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), of [Quora](https://www.quora.com/). Vind de kanalen waarvan u denkt dat mensen er het meeste baat bij hebben of enthousiast zijn over uw werk.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Elk programma heeft zeer specifieke functies die slechts een fractie van de gebruikers nuttig zullen vinden. Spam niet zoveel mogelijk mensen. Richt uw inspanningen in plaats daarvan op gemeenschappen die baat hebben bij kennis van uw project.

  _Each program has very specific functions that only a fraction of users will find useful. Don't spam as many people as possible. Instead, target your efforts to communities that will benefit from knowing about your project._

  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing voor open source-projecten"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Kijk of u manieren kunt vinden om uw project op relevante manieren te delen:

* **Maak kennis met relevante open source-projecten en communities.** Soms hoeft u uw project niet rechtstreeks te promoten. Als je project perfect is voor datawetenschappers die Python gebruiken, maak dan kennis met de data science-community van Python. Als mensen je leren kennen, ontstaan ​​er natuurlijke mogelijkheden om over je werk te praten en het te delen.
* **Vind mensen die het probleem ondervinden dat uw project oplost.** Doorzoek gerelateerde forums voor mensen die tot de doelgroep van uw project behoren. Beantwoord hun vraag en zoek, indien nodig, een tactvolle manier om uw project als oplossing voor te stellen.
* **Vraag om feedback.** Stel uzelf en uw werk voor aan een publiek dat het relevant en interessant zou vinden. Wees specifiek over wie u denkt dat baat zou hebben bij uw project. Probeer de zin af te maken: _"Ik denk dat mijn project X echt zou helpen, die Y proberen te doen_". Luister en reageer op de feedback van anderen, in plaats van simpelweg uw werk te promoten.

Richt u in het algemeen op het helpen van anderen voordat u in ruil daarvoor dingen vraagt. Omdat iedereen gemakkelijk een project online kan promoten, zal er veel concurrentie zijn. Om u te onderscheiden van de massa, geeft u mensen context voor wie u bent en niet alleen wat u wilt.

Als niemand op uw eerste berichten let of reageert, raak dan niet ontmoedigd! De meeste projectlanceringen zijn een iteratief proces dat maanden of jaren kan duren. Als je de eerste keer geen reactie krijgt, probeer dan een andere tactiek of zoek eerst naar manieren om waarde toe te voegen aan het werk van anderen. Het promoten en lanceren van uw project kost tijd en toewijding.

## Ga waar het publiek van uw project is (offline)

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

Offline evenementen zijn een populaire manier om nieuwe projecten onder het publiek te promoten. Ze zijn een geweldige manier om een betrokken publiek te bereiken en diepere menselijke connecties op te bouwen, vooral als je ontwikkelaars wilt bereiken.

Als je [nieuw bent bij spreken in het openbaar](https://speaking.io/), begin dan met het vinden van een lokale bijeenkomst die gerelateerd is aan de taal of het ecosysteem van je project.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Ik was behoorlijk zenuwachtig om naar PyCon te gaan. Ik hield een lezing, ik zou daar maar een paar mensen leren kennen, ik ging een hele week. (...) Ik had me echter geen zorgen moeten maken. PyCon was fenomenaal geweldig! (...) Iedereen was ongelooflijk vriendelijk en extravert, zo erg dat ik zelden tijd vond om niet met mensen te praten!

  _I was pretty nervous about going to PyCon. I was giving a talk, I was only going to know a couple of people there, I was going for an entire week. (...) I shouldn't have worried, though. PyCon was phenomenally awesome! (...) Everyone was incredibly friendly and outgoing, so much that I rarely found time not to talk to people!_

  <p markdown="1" class="pquote-credit">
— @jhamrick, ["Hoe ik heb geleerd om te stoppen met piekeren en van PyCon te houden"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Als je nog nooit op een evenement hebt gesproken, is het volkomen normaal om nerveus te zijn! Onthoud dat uw publiek er is omdat ze oprecht over uw werk willen horen.

Concentreer u tijdens het schrijven van uw lezing op wat uw publiek interessant zal vinden en waar ze waarde uit kunnen halen. Houd uw taal vriendelijk en benaderbaar. Glimlach, adem en heb plezier.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Wanneer u begint met het schrijven van uw lezing, ongeacht wat uw onderwerp is, kan het helpen als u uw lezing ziet als een verhaal dat u aan mensen vertelt.

  _When you start writing your talk, no matter what your topic is, it can help if you see your talk as a story that you tell people._

  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["Hoe u een Tech Conferentie Lezing voorbereidt en schrijft"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Als u zich er klaar voor voelt, overweeg dan om op een conferentie te spreken om uw project te promoten. Conferenties kunnen u helpen meer mensen te bereiken, soms van over de hele wereld.

Zoek naar conferenties die specifiek zijn voor uw taal of ecosysteem. Voordat u uw toespraak indient, moet u de conferentie onderzoeken om uw lezing af te stemmen op de aanwezigen en uw kansen te vergroten om geaccepteerd te worden op de conferentie. U kunt vaak een idee krijgen van uw publiek door naar de sprekers van een conferentie te kijken.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Ik schreef heel vriendelijk naar de JSConf-mensen en smeekte hen om me een slot te geven waar ik het op JSConf EU kon presenteren. (...) Ik was enorm bang toen ik dit ding presenteerde waar ik al een half jaar aan werkte. (...) De hele tijd dacht ik alleen maar: oh mijn God. Wat doe ik hier?

  _I wrote very nicely to the JSConf people and begged them to give me a slot where I could present it at JSConf EU. (...) I was extremely scared, presenting this thing that I had been working on for six months. (...) The whole time I was just thinking, oh my God. What am I doing here?_

  <p markdown="1" class="pquote-credit">
— @ry, ["Historie van Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Bouw een reputatie op

Naast de hierboven beschreven strategieën, is de beste manier om mensen uit te nodigen om te delen en bij te dragen aan uw project, het delen van en bijdragen aan hun projecten.

Door nieuwkomers te helpen, middelen te delen en doordachte bijdragen te leveren aan de projecten van anderen, kunt u een positieve reputatie opbouwen. Door een actief lid te zijn van de open source-gemeenschap, zullen mensen context voor uw werk hebben en zullen ze eerder aandacht besteden aan en uw project delen. Het ontwikkelen van relaties met andere open source-projecten kan zelfs leiden tot officiële partnerschappen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  De enige reden waarom urllib3 tegenwoordig de populairste Python-bibliotheek van derden is, is omdat het deel uitmaakt van verzoeken.

  _The only reason urllib3 is the most popular third-party Python library today is because it's part of requests._

  <p markdown="1" class="pquote-credit">
— @shazow, ["Hoe u uw open source-project kunt laten floreren"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Het is nooit te vroeg of te laat om uw reputatie op te bouwen. Zelfs als u uw eigen project al hebt gelanceerd, blijf zoeken naar manieren om anderen te helpen.

Er is geen oplossing van de ene op de andere dag om een publiek op te bouwen. Het vertrouwen en respect van anderen winnen kost tijd, en het opbouwen van uw reputatie houdt nooit op.

## Keep at it!

Het kan lang duren voordat mensen uw open source-project opmerken. Dat is goed! Enkele van de meest populaire projecten van vandaag hebben jaren geduurd om een hoog activiteitsniveau te bereiken. Concentreer u op het opbouwen van relaties in plaats van te hopen dat uw project spontaan populair zal worden. Wees geduldig en blijf uw werk delen met degenen die het op prijs stellen.
